/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dokka.maven;

import java.io.File;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.util.DefaultFileSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dokka.maven.AbstractDokkaMojo;
import org.jetbrains.dokka.maven.DokkaMojoKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\bH\u0002J\b\u0010\u0019\u001a\u00020\bH\u0014R\u0010\u0010\u0003\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0002X\u0083D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u0004\u0018\u00010\b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u0004\u0018\u00010\b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u0004\u0018\u00010\u000b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u0004\u0018\u00010\b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u00138\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/dokka/maven/DokkaJavadocJarMojo;", "Lorg/jetbrains/dokka/maven/AbstractDokkaMojo;", "()V", "archive", "Lorg/apache/maven/archiver/MavenArchiveConfiguration;", "attach", "", "classifier", "", "finalName", "jarArchiver", "Lorg/codehaus/plexus/archiver/jar/JarArchiver;", "jarOutputDirectory", "outputDir", "getOutputDir", "()Ljava/lang/String;", "setOutputDir", "(Ljava/lang/String;)V", "projectHelper", "Lorg/apache/maven/project/MavenProjectHelper;", "execute", "", "generateArchive", "Ljava/io/File;", "jarFileName", "getOutDir", "runner-maven-plugin"})
@Mojo(name="javadocJar", defaultPhase=LifecyclePhase.PRE_SITE, requiresDependencyResolution=ResolutionScope.COMPILE, requiresProject=true, threadSafe=true)
@SourceDebugExtension(value={"SMAP\nDokkaMojo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DokkaMojo.kt\norg/jetbrains/dokka/maven/DokkaJavadocJarMojo\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,616:1\n1#2:617\n*E\n"})
public final class DokkaJavadocJarMojo
extends AbstractDokkaMojo {
    @Parameter(defaultValue="${project.basedir}/target/dokkaJavadocJar", required=true)
    @NotNull
    private String outputDir = "";
    @Parameter(property="project.build.directory")
    @Nullable
    private String jarOutputDirectory;
    @Parameter(property="project.build.finalName")
    @Nullable
    private String finalName;
    @Parameter(property="attach", defaultValue="true")
    private final boolean attach;
    @Parameter
    @NotNull
    private final MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    @Parameter(property="maven.javadoc.classifier", defaultValue="javadoc", required=true)
    @Nullable
    private String classifier;
    @Component
    @Nullable
    private MavenProjectHelper projectHelper;
    @Component(role=Archiver.class, hint="jar")
    @Nullable
    private JarArchiver jarArchiver;

    public DokkaJavadocJarMojo() {
        super(CollectionsKt.listOf((Object)DokkaMojoKt.access$getJavadocDependency$p()));
    }

    @NotNull
    public final String getOutputDir() {
        return this.outputDir;
    }

    public final void setOutputDir(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.outputDir = string;
    }

    @Override
    @NotNull
    protected String getOutDir() {
        return this.outputDir;
    }

    @Override
    public void execute() {
        block2: {
            super.execute();
            if (!new File(this.outputDir).exists()) {
                this.getLog().warn((CharSequence)"No javadoc generated so no javadoc jar will be generated");
                return;
            }
            File outputFile = this.generateArchive(this.finalName + '-' + this.classifier + ".jar");
            if (!this.attach) break block2;
            MavenProjectHelper mavenProjectHelper = this.projectHelper;
            if (mavenProjectHelper != null) {
                mavenProjectHelper.attachArtifact(this.getMavenProject(), "javadoc", this.classifier, outputFile);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final File generateArchive(String jarFileName) {
        void $this$generateArchive_u24lambda_u240;
        DefaultFileSet defaultFileSet;
        File javadocJar = new File(this.jarOutputDirectory, jarFileName);
        MavenArchiver archiver = new MavenArchiver();
        archiver.setArchiver(this.jarArchiver);
        archiver.setOutputFile(javadocJar);
        DefaultFileSet defaultFileSet2 = defaultFileSet = new DefaultFileSet();
        JarArchiver jarArchiver = archiver.getArchiver();
        boolean bl = false;
        $this$generateArchive_u24lambda_u240.setDirectory(new File(this.outputDir));
        jarArchiver.addFileSet((FileSet)defaultFileSet);
        this.archive.setAddMavenDescriptor(false);
        archiver.createArchive(this.getSession(), this.getMavenProject(), this.archive);
        return javadocJar;
    }
}

