/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions.impl;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.extensions.impl.BeanExtensionPoint;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.extensions.impl.InterfaceExtensionPoint;
import com.intellij.openapi.extensions.impl.UndefinedPluginDescriptor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExtensionsAreaImpl
implements ExtensionsArea {
    private static final Logger LOG = Logger.getInstance(ExtensionsAreaImpl.class);
    private static final boolean DEBUG_REGISTRATION = Boolean.FALSE;
    private final ComponentManager myComponentManager;
    private final Map<String, ExtensionPointImpl<?>> myExtensionPoints;
    private final Map<String, Throwable> myEPTraces;

    public ExtensionsAreaImpl(@NotNull ComponentManager componentManager) {
        if (componentManager == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(0);
        }
        this.myExtensionPoints = ContainerUtil.newConcurrentMap();
        this.myEPTraces = DEBUG_REGISTRATION ? new THashMap() : null;
        this.myComponentManager = componentManager;
    }

    public final void notifyAreaReplaced(@Nullable ExtensionsAreaImpl newArea) {
        THashSet<String> processedEPs = new THashSet<String>();
        for (ExtensionPointImpl<?> point : this.myExtensionPoints.values()) {
            point.notifyAreaReplaced(this);
            processedEPs.add(point.getName());
        }
        if (newArea == null) {
            return;
        }
        for (ExtensionPointImpl<?> point : newArea.myExtensionPoints.values()) {
            if (processedEPs.contains(point.getName())) continue;
            point.notifyAreaReplaced(this);
        }
    }

    public void registerExtensionPoints(@NotNull PluginDescriptor pluginDescriptor, @NotNull List<Element> extensionPointElements, @NotNull ComponentManager componentManager) {
        if (pluginDescriptor == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(1);
        }
        if (extensionPointElements == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(2);
        }
        if (componentManager == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(3);
        }
        for (Element element : extensionPointElements) {
            this.registerExtensionPoint(pluginDescriptor, element, componentManager);
        }
    }

    private void registerExtensionPoint(@NotNull PluginDescriptor pluginDescriptor, @NotNull Element extensionPointElement, @NotNull ComponentManager componentManager) {
        if (pluginDescriptor == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(4);
        }
        if (extensionPointElement == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(5);
        }
        if (componentManager == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(6);
        }
        String pointName = this.getExtensionPointName(extensionPointElement, pluginDescriptor);
        String beanClassName = extensionPointElement.getAttributeValue("beanClass");
        String interfaceClassName = extensionPointElement.getAttributeValue("interface");
        if (beanClassName == null && interfaceClassName == null) {
            throw this.myComponentManager.createError("Neither 'beanClass' nor 'interface' attribute is specified for extension point '" + pointName + "' in '" + pluginDescriptor + "' plugin", pluginDescriptor.getPluginId());
        }
        if (beanClassName != null && interfaceClassName != null) {
            throw this.myComponentManager.createError("Both 'beanClass' and 'interface' attributes are specified for extension point '" + pointName + "' in '" + pluginDescriptor + "' plugin", pluginDescriptor.getPluginId());
        }
        boolean dynamic = Boolean.parseBoolean(extensionPointElement.getAttributeValue("dynamic"));
        ExtensionPointImpl point = interfaceClassName == null ? new BeanExtensionPoint(pointName, beanClassName, componentManager, pluginDescriptor, dynamic) : new InterfaceExtensionPoint(pointName, interfaceClassName, componentManager, pluginDescriptor, dynamic);
        this.registerExtensionPoint(point);
    }

    @NotNull
    public String getExtensionPointName(@NotNull Element extensionPointElement, @NotNull PluginDescriptor pluginDescriptor) {
        String pointName;
        if (extensionPointElement == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(7);
        }
        if (pluginDescriptor == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(8);
        }
        if ((pointName = extensionPointElement.getAttributeValue("qualifiedName")) == null) {
            String name = extensionPointElement.getAttributeValue("name");
            if (name == null) {
                throw this.myComponentManager.createError("'name' attribute not specified for extension point in '" + pluginDescriptor + "' plugin", pluginDescriptor.getPluginId());
            }
            assert (pluginDescriptor.getPluginId() != null);
            pointName = pluginDescriptor.getPluginId().getIdString() + '.' + name;
        }
        String string2 = pointName;
        if (string2 == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(9);
        }
        return string2;
    }

    @NotNull
    public static String extractPointName(@NotNull Element extensionElement, @Nullable String ns) {
        String epName;
        if (extensionElement == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(16);
        }
        if ((epName = extensionElement.getAttributeValue("point")) == null) {
            if (ns == null) {
                Namespace namespace = extensionElement.getNamespace();
                epName = namespace.getURI() + '.' + extensionElement.getName();
            } else {
                epName = ns + '.' + extensionElement.getName();
            }
        }
        String string2 = epName;
        if (string2 == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(17);
        }
        return string2;
    }

    @Override
    public void registerExtensionPoint(@NotNull @NonNls String extensionPointName, @NotNull String extensionPointBeanClass, @NotNull ExtensionPoint.Kind kind) {
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(18);
        }
        if (extensionPointBeanClass == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(19);
        }
        if (kind == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(20);
        }
        this.doRegisterExtensionPoint(extensionPointName, extensionPointBeanClass, kind);
    }

    void doRegisterExtensionPoint(@NotNull String extensionPointName, @NotNull String extensionPointBeanClass, @NotNull ExtensionPoint.Kind kind) {
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(25);
        }
        if (extensionPointBeanClass == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(26);
        }
        if (kind == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(27);
        }
        UndefinedPluginDescriptor pluginDescriptor = new UndefinedPluginDescriptor();
        ExtensionPointImpl point = kind == ExtensionPoint.Kind.INTERFACE ? new InterfaceExtensionPoint(extensionPointName, extensionPointBeanClass, this.myComponentManager, pluginDescriptor, false) : new BeanExtensionPoint(extensionPointName, extensionPointBeanClass, this.myComponentManager, pluginDescriptor, false);
        this.registerExtensionPoint(point);
    }

    @Nullable
    private static PluginId id(@NotNull PluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(33);
        }
        return descriptor2 instanceof UndefinedPluginDescriptor ? null : descriptor2.getPluginId();
    }

    private void checkThatPointNotDuplicated(@NotNull String pointName, @NotNull PluginDescriptor pluginDescriptor) {
        if (pointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(34);
        }
        if (pluginDescriptor == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(35);
        }
        if (!this.hasExtensionPoint(pointName)) {
            return;
        }
        PluginId id1 = ExtensionsAreaImpl.id(((ExtensionPointImpl)this.getExtensionPoint(pointName)).getDescriptor());
        PluginId id2 = ExtensionsAreaImpl.id(pluginDescriptor);
        String message2 = "Duplicate registration for EP '" + pointName + "': first in " + id1 + ", second in " + id2;
        if (DEBUG_REGISTRATION) {
            LOG.error(message2, this.myEPTraces.get(pointName));
        }
        throw this.myComponentManager.createError(message2, pluginDescriptor.getPluginId());
    }

    private void registerExtensionPoint(@NotNull ExtensionPointImpl<?> point) {
        if (point == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(36);
        }
        String name = point.getName();
        this.checkThatPointNotDuplicated(name, point.getDescriptor());
        this.myExtensionPoints.put(name, point);
        if (DEBUG_REGISTRATION) {
            this.myEPTraces.put(name, new Throwable("Original registration for " + name));
        }
    }

    @NotNull
    public <T> ExtensionPointImpl<T> getExtensionPoint(@NotNull String extensionPointName) {
        ExtensionPointImpl<?> extensionPoint;
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(37);
        }
        if ((extensionPoint = this.myExtensionPoints.get(extensionPointName)) == null) {
            throw new IllegalArgumentException("Missing extension point: " + extensionPointName + " in container " + this.myComponentManager);
        }
        ExtensionPointImpl<?> extensionPointImpl = extensionPoint;
        if (extensionPointImpl == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(38);
        }
        return extensionPointImpl;
    }

    @ApiStatus.Internal
    public boolean registerExtensions(@NotNull String pointName, @NotNull List<? extends Element> extensions, @NotNull PluginDescriptor pluginDescriptor, @NotNull ComponentManager componentManager, boolean notifyListeners) {
        ExtensionPointImpl<?> point;
        if (pointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(39);
        }
        if (extensions == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(40);
        }
        if (pluginDescriptor == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(41);
        }
        if (componentManager == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(42);
        }
        if ((point = this.myExtensionPoints.get(pointName)) == null) {
            return false;
        }
        if (point.myComponentManager != componentManager) {
            LOG.error("The same point on different levels (pointName=" + pointName + ")");
        }
        point.registerExtensions(extensions, pluginDescriptor, componentManager, notifyListeners);
        return true;
    }

    @Override
    @Nullable
    public <T> ExtensionPoint<T> getExtensionPointIfRegistered(@NotNull String extensionPointName) {
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(43);
        }
        ExtensionPointImpl<?> extensionPoint = this.myExtensionPoints.get(extensionPointName);
        return extensionPoint;
    }

    @Override
    @NotNull
    public <T> ExtensionPoint<T> getExtensionPoint(@NotNull ExtensionPointName<T> extensionPointName) {
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(44);
        }
        ExtensionPoint extensionPoint = this.getExtensionPoint(extensionPointName.getName());
        if (extensionPoint == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(45);
        }
        return extensionPoint;
    }

    @Override
    public boolean hasExtensionPoint(@NotNull String extensionPointName) {
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(49);
        }
        return this.myExtensionPoints.containsKey(extensionPointName);
    }

    @Override
    public boolean hasExtensionPoint(@NotNull ExtensionPointName<?> extensionPointName) {
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(50);
        }
        return this.hasExtensionPoint(extensionPointName.getName());
    }

    public String toString() {
        return this.myComponentManager.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 17: 
            case 38: 
            case 45: 
            case 46: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 17: 
            case 38: 
            case 45: 
            case 46: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentManager";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 10: 
            case 13: 
            case 30: 
            case 32: 
            case 35: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPointElements";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPointElement";
                break;
            }
            case 9: 
            case 17: 
            case 38: 
            case 45: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/extensions/impl/ExtensionsAreaImpl";
                break;
            }
            case 11: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionElement";
                break;
            }
            case 12: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPoint";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "points";
                break;
            }
            case 18: 
            case 25: 
            case 37: 
            case 43: 
            case 44: 
            case 48: 
            case 49: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPointName";
                break;
            }
            case 19: 
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPointBeanClass";
                break;
            }
            case 20: 
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionClass";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 34: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointName";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensions";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/extensions/impl/ExtensionsAreaImpl";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionPointName";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "extractPointName";
                break;
            }
            case 38: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionPoint";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionPoints";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensionPoints";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensionPoint";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getExtensionPointName";
                break;
            }
            case 9: 
            case 17: 
            case 38: 
            case 45: 
            case 46: {
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "registerExtension";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "extensionsRegistered";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "extractPointName";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "doRegisterExtensionPoint";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "registerPoint";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "registerFakeBeanPoint";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "id";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "checkThatPointNotDuplicated";
                break;
            }
            case 37: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getExtensionPoint";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensions";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getExtensionPointIfRegistered";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "findExtensionByClass";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "unregisterExtensionPoint";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "hasExtensionPoint";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 9: 
            case 17: 
            case 38: 
            case 45: 
            case 46: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

