/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import gnu.trove.TIntHashSet;
import java.util.AbstractSet;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class CompactVirtualFileSet
extends AbstractSet<VirtualFile> {
    private final Set<VirtualFile> weirdFiles;
    private TIntHashSet idSet;
    private BitSet fileIds;
    private boolean frozen;

    public CompactVirtualFileSet() {
        this.weirdFiles = new THashSet<VirtualFile>();
    }

    public CompactVirtualFileSet(@NotNull Collection<? extends VirtualFile> files2) {
        if (files2 == null) {
            CompactVirtualFileSet.$$$reportNull$$$0(0);
        }
        this.weirdFiles = new THashSet<VirtualFile>();
        this.addAll(files2);
    }

    @Override
    public boolean contains(Object file2) {
        if (file2 instanceof VirtualFileWithId) {
            BitSet ids = this.fileIds;
            int id = ((VirtualFileWithId)file2).getId();
            if (ids != null) {
                return ids.get(id);
            }
            TIntHashSet idSet = this.idSet;
            if (idSet != null) {
                return idSet.contains(id);
            }
        }
        return this.weirdFiles.contains(file2);
    }

    @Override
    public boolean add(@NotNull VirtualFile file2) {
        boolean added;
        if (file2 == null) {
            CompactVirtualFileSet.$$$reportNull$$$0(1);
        }
        if (this.frozen) {
            throw new UnsupportedOperationException();
        }
        if (file2 instanceof VirtualFileWithId) {
            int id = ((VirtualFileWithId)((Object)file2)).getId();
            BitSet ids = this.fileIds;
            TIntHashSet idSet = this.idSet;
            if (ids != null) {
                added = !ids.get(id);
                ids.set(id);
            } else if (idSet != null) {
                added = idSet.add(id);
                if (idSet.size() > 1000) {
                    this.fileIds = new BitSet();
                    idSet.forEach((int i) -> {
                        this.fileIds.set(i);
                        return true;
                    });
                    this.idSet = null;
                }
            } else {
                added = this.weirdFiles.add(file2);
                if (this.weirdFiles.size() > 10) {
                    this.idSet = idSet = new TIntHashSet(this.weirdFiles.size());
                    Iterator<VirtualFile> iterator2 = this.weirdFiles.iterator();
                    while (iterator2.hasNext()) {
                        VirtualFile wf = iterator2.next();
                        if (!(wf instanceof VirtualFileWithId)) continue;
                        int i2 = ((VirtualFileWithId)((Object)wf)).getId();
                        idSet.add(i2);
                        iterator2.remove();
                    }
                }
            }
        } else {
            added = this.weirdFiles.add(file2);
        }
        return added;
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    public void freeze() {
        this.frozen = true;
    }

    @Override
    public int size() {
        BitSet ids = this.fileIds;
        TIntHashSet idSet = this.idSet;
        return (ids == null ? 0 : ids.cardinality()) + (idSet == null ? 0 : idSet.size()) + this.weirdFiles.size();
    }

    @Override
    @NotNull
    public Iterator<VirtualFile> iterator() {
        BitSet ids = this.fileIds;
        TIntHashSet idSet = this.idSet;
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        Iterator idsIterator = ids == null ? Collections.emptyIterator() : ContainerUtil.mapIterator(ids.stream().iterator(), id -> virtualFileManager.findFileById((int)id));
        Iterator idSetIterator = idSet == null ? Collections.emptyIterator() : ContainerUtil.mapIterator(idSet.iterator(), id -> virtualFileManager.findFileById(id));
        Iterator<VirtualFile> weirdFileIterator = this.weirdFiles.iterator();
        Iterator<VirtualFile> iterator2 = ContainerUtil.filterIterator(ContainerUtil.concatIterators(idsIterator, idSetIterator, weirdFileIterator), Objects::nonNull);
        if (iterator2 == null) {
            CompactVirtualFileSet.$$$reportNull$$$0(3);
        }
        return iterator2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/CompactVirtualFileSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/CompactVirtualFileSet";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "iterator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 3: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

