/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.impl.FrozenDocument;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.smartPointers.SelfElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerEx;
import com.intellij.psi.impl.smartPointers.SmartPointerTracker;
import com.intellij.psi.impl.smartPointers.SmartPsiElementPointerImpl;
import com.intellij.psi.impl.smartPointers.SmartPsiFileRangePointerImpl;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.reference.SoftReference;
import java.lang.ref.Reference;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SmartPointerManagerImpl
extends SmartPointerManager {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl");
    private final Project myProject;
    private final Key<SmartPointerTracker> POINTERS_KEY;
    private final PsiDocumentManagerBase myPsiDocManager;
    private static final Key<Reference<SmartPsiElementPointerImpl<?>>> CACHED_SMART_POINTER_KEY = Key.create("CACHED_SMART_POINTER_KEY");

    public SmartPointerManagerImpl(@NotNull Project project) {
        if (project == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myPsiDocManager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance(project);
        this.POINTERS_KEY = Key.create("SMART_POINTERS " + (project.isDefault() ? "default" : Integer.valueOf(project.hashCode())));
    }

    @NotNull
    private static String anonymize(@NotNull Project project) {
        if (project == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(1);
        }
        String string2 = (project.isDisposed() ? "(Disposed)" : "") + (project.isDefault() ? "(Default)" : "") + project.hashCode();
        if (string2 == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(2);
        }
        return string2;
    }

    public void fastenBelts(@NotNull VirtualFile file2) {
        SmartPointerTracker pointers;
        if (file2 == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(3);
        }
        if ((pointers = this.getTracker(file2)) != null) {
            pointers.fastenBelts(this);
        }
    }

    @Override
    @NotNull
    public <E extends PsiElement> SmartPsiElementPointer<E> createSmartPsiElementPointer(@NotNull E element) {
        if (element == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiFile containingFile = element.getContainingFile();
        SmartPsiElementPointer<E> smartPsiElementPointer = this.createSmartPsiElementPointer(element, containingFile);
        if (smartPsiElementPointer == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(5);
        }
        return smartPsiElementPointer;
    }

    @Override
    @NotNull
    public <E extends PsiElement> SmartPsiElementPointer<E> createSmartPsiElementPointer(@NotNull E element, PsiFile containingFile) {
        if (element == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(6);
        }
        SmartPsiElementPointer<E> smartPsiElementPointer = this.createSmartPsiElementPointer(element, containingFile, false);
        if (smartPsiElementPointer == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(7);
        }
        return smartPsiElementPointer;
    }

    @NotNull
    public <E extends PsiElement> SmartPsiElementPointer<E> createSmartPsiElementPointer(@NotNull E element, PsiFile containingFile, boolean forInjected) {
        if (element == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(8);
        }
        SmartPointerManagerImpl.ensureValid(element, containingFile);
        SmartPointerTracker.processQueue();
        this.ensureMyProject(containingFile != null ? containingFile.getProject() : element.getProject());
        SmartPsiElementPointerImpl<E> pointer = SmartPointerManagerImpl.getCachedPointer(element);
        if (!(pointer == null || pointer.getElementInfo() instanceof SelfElementInfo && ((SelfElementInfo)pointer.getElementInfo()).isForInjected() != forInjected || pointer.incrementAndGetReferenceCount(1) <= 0)) {
            SmartPsiElementPointerImpl<E> smartPsiElementPointerImpl = pointer;
            if (smartPsiElementPointerImpl == null) {
                SmartPointerManagerImpl.$$$reportNull$$$0(9);
            }
            return smartPsiElementPointerImpl;
        }
        pointer = new SmartPsiElementPointerImpl<E>(this, element, containingFile, forInjected);
        if (containingFile != null) {
            this.trackPointer(pointer, containingFile.getViewProvider().getVirtualFile());
        }
        element.putUserData(CACHED_SMART_POINTER_KEY, new SoftReference<SmartPsiElementPointerImpl<E>>(pointer));
        SmartPsiElementPointerImpl<E> smartPsiElementPointerImpl = pointer;
        if (smartPsiElementPointerImpl == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(10);
        }
        return smartPsiElementPointerImpl;
    }

    private void ensureMyProject(@NotNull Project project) {
        if (project == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(11);
        }
        if (project != this.myProject) {
            throw new IllegalArgumentException("Element from alien project: " + SmartPointerManagerImpl.anonymize(project) + " expected: " + SmartPointerManagerImpl.anonymize(this.myProject));
        }
    }

    private static void ensureValid(@NotNull PsiElement element, @Nullable PsiFile containingFile) {
        boolean valid;
        if (element == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(12);
        }
        boolean bl = valid = containingFile != null ? containingFile.isValid() : element.isValid();
        if (!valid) {
            PsiUtilCore.ensureValid(element);
            if (containingFile != null && !containingFile.isValid()) {
                throw new PsiInvalidElementAccessException((PsiElement)containingFile, "Element " + element.getClass() + "(" + element.getLanguage() + ") claims to be valid but returns invalid containing file ");
            }
        }
    }

    private static <E extends PsiElement> SmartPsiElementPointerImpl<E> getCachedPointer(@NotNull E element) {
        Object cachedElement;
        Reference<SmartPsiElementPointerImpl<?>> data2;
        SmartPsiElementPointerImpl<?> cachedPointer;
        if (element == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(13);
        }
        if ((cachedPointer = SoftReference.dereference(data2 = element.getUserData(CACHED_SMART_POINTER_KEY))) != null && (cachedElement = cachedPointer.getElement()) != element) {
            return null;
        }
        return cachedPointer;
    }

    @Override
    @NotNull
    public SmartPsiFileRange createSmartPsiFileRangePointer(@NotNull PsiFile file2, @NotNull TextRange range) {
        if (file2 == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(14);
        }
        if (range == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(15);
        }
        SmartPsiFileRange smartPsiFileRange = this.createSmartPsiFileRangePointer(file2, range, false);
        if (smartPsiFileRange == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(16);
        }
        return smartPsiFileRange;
    }

    @NotNull
    public SmartPsiFileRange createSmartPsiFileRangePointer(@NotNull PsiFile file2, @NotNull TextRange range, boolean forInjected) {
        if (file2 == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(17);
        }
        if (range == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(18);
        }
        PsiUtilCore.ensureValid(file2);
        SmartPointerTracker.processQueue();
        SmartPsiFileRangePointerImpl pointer = new SmartPsiFileRangePointerImpl(this, file2, ProperTextRange.create(range), forInjected);
        this.trackPointer(pointer, file2.getViewProvider().getVirtualFile());
        SmartPsiFileRangePointerImpl smartPsiFileRangePointerImpl = pointer;
        if (smartPsiFileRangePointerImpl == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(19);
        }
        return smartPsiFileRangePointerImpl;
    }

    private <E extends PsiElement> void trackPointer(@NotNull SmartPsiElementPointerImpl<E> pointer, @NotNull VirtualFile containingFile) {
        SmartPointerTracker pointers;
        SmartPointerElementInfo info;
        if (pointer == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(20);
        }
        if (containingFile == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(21);
        }
        if (!((info = pointer.getElementInfo()) instanceof SelfElementInfo)) {
            return;
        }
        SmartPointerTracker.PointerReference reference = new SmartPointerTracker.PointerReference(pointer, containingFile, this.POINTERS_KEY);
        do {
            if ((pointers = this.getTracker(containingFile)) != null) continue;
            pointers = containingFile.putUserDataIfAbsent(this.POINTERS_KEY, new SmartPointerTracker());
        } while (!pointers.addReference(reference, pointer));
    }

    @Override
    public void removePointer(@NotNull SmartPsiElementPointer pointer) {
        if (pointer == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(22);
        }
        if (!(pointer instanceof SmartPsiElementPointerImpl) || this.myProject.isDisposed()) {
            return;
        }
        this.ensureMyProject(pointer.getProject());
        int refCount = ((SmartPsiElementPointerImpl)pointer).incrementAndGetReferenceCount(-1);
        if (refCount == -1) {
            LOG.error("Double smart pointer removal");
            return;
        }
        if (refCount == 0) {
            PsiElement element = ((SmartPointerEx)pointer).getCachedElement();
            if (element != null) {
                element.putUserData(CACHED_SMART_POINTER_KEY, null);
            }
            SmartPointerElementInfo info = ((SmartPsiElementPointerImpl)pointer).getElementInfo();
            info.cleanup();
            SmartPointerTracker.PointerReference reference = ((SmartPsiElementPointerImpl)pointer).pointerReference;
            if (reference != null) {
                if (reference.get() != pointer) {
                    throw new IllegalStateException("Reference points to " + reference.get());
                }
                if (reference.key != this.POINTERS_KEY) {
                    throw new IllegalStateException("Reference from wrong project: " + reference.key + " vs " + this.POINTERS_KEY);
                }
                SmartPointerTracker pointers = this.getTracker(reference.file);
                if (pointers != null) {
                    pointers.removeReference(reference);
                }
            }
        }
    }

    @Nullable
    SmartPointerTracker getTracker(@NotNull VirtualFile containingFile) {
        if (containingFile == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(23);
        }
        return containingFile.getUserData(this.POINTERS_KEY);
    }

    public int getPointersNumber(@NotNull PsiFile containingFile) {
        VirtualFile file2;
        SmartPointerTracker pointers;
        if (containingFile == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(24);
        }
        return (pointers = this.getTracker(file2 = containingFile.getViewProvider().getVirtualFile())) == null ? 0 : pointers.getSize();
    }

    @Override
    public boolean pointToTheSameElement(@NotNull SmartPsiElementPointer pointer1, @NotNull SmartPsiElementPointer pointer2) {
        if (pointer1 == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(25);
        }
        if (pointer2 == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(26);
        }
        return SmartPsiElementPointerImpl.pointsToTheSameElementAs(pointer1, pointer2);
    }

    public void updatePointers(@NotNull Document document, @NotNull FrozenDocument frozen, @NotNull List<? extends DocumentEvent> events) {
        VirtualFile file2;
        SmartPointerTracker list2;
        if (document == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(27);
        }
        if (frozen == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(28);
        }
        if (events == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(29);
        }
        SmartPointerTracker smartPointerTracker = list2 = (file2 = FileDocumentManager.getInstance().getFile(document)) == null ? null : this.getTracker(file2);
        if (list2 != null) {
            list2.updateMarkers(frozen, events);
        }
    }

    public void updatePointerTargetsAfterReparse(@NotNull VirtualFile file2) {
        SmartPointerTracker list2;
        if (file2 == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(30);
        }
        if ((list2 = this.getTracker(file2)) != null) {
            list2.updatePointerTargetsAfterReparse();
        }
    }

    @NotNull
    Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(31);
        }
        return project;
    }

    @NotNull
    PsiDocumentManagerBase getPsiDocumentManager() {
        PsiDocumentManagerBase psiDocumentManagerBase = this.myPsiDocManager;
        if (psiDocumentManagerBase == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(32);
        }
        return psiDocumentManagerBase;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 16: 
            case 19: 
            case 31: 
            case 32: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 16: 
            case 19: 
            case 31: 
            case 32: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 16: 
            case 19: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl";
                break;
            }
            case 3: 
            case 14: 
            case 17: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointer";
                break;
            }
            case 21: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointer1";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointer2";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frozen";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "anonymize";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createSmartPsiElementPointer";
                break;
            }
            case 16: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createSmartPsiFileRangePointer";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiDocumentManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "anonymize";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 16: 
            case 19: 
            case 31: 
            case 32: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fastenBelts";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createSmartPsiElementPointer";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "ensureMyProject";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "ensureValid";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getCachedPointer";
                break;
            }
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createSmartPsiFileRangePointer";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "trackPointer";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "removePointer";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getTracker";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getPointersNumber";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "pointToTheSameElement";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "updatePointers";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "updatePointerTargetsAfterReparse";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 16: 
            case 19: 
            case 31: 
            case 32: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

