/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.StaticGetter;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.DisposableWrapperList;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.EventListener;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EventDispatcher<T extends EventListener> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.EventDispatcher");
    private T myMulticaster;
    private final DisposableWrapperList<T> myListeners;
    @NotNull
    private final Class<T> myListenerClass;
    @Nullable
    private final Map<String, Object> myMethodReturnValues;

    @NotNull
    public static <T extends EventListener> EventDispatcher<T> create(@NotNull Class<T> listenerClass) {
        if (listenerClass == null) {
            EventDispatcher.$$$reportNull$$$0(0);
        }
        return new EventDispatcher<T>(listenerClass, null);
    }

    private EventDispatcher(@NotNull Class<T> listenerClass, @Nullable Map<String, Object> methodReturnValues) {
        if (listenerClass == null) {
            EventDispatcher.$$$reportNull$$$0(5);
        }
        this.myListeners = new DisposableWrapperList();
        this.myListenerClass = listenerClass;
        this.myMethodReturnValues = methodReturnValues;
    }

    @NotNull
    static <T> T createMulticaster(@NotNull Class<T> listenerClass, final @Nullable Map<String, Object> methodReturnValues, final Getter<? extends Iterable<T>> listeners) {
        if (listenerClass == null) {
            EventDispatcher.$$$reportNull$$$0(6);
        }
        LOG.assertTrue(listenerClass.isInterface(), "listenerClass must be an interface");
        InvocationHandler handler2 = new InvocationHandler(){

            @Override
            @NonNls
            public Object invoke(Object proxy2, Method method, Object[] args2) {
                String methodName = method.getName();
                if (method.getDeclaringClass().getName().equals("java.lang.Object")) {
                    return EventDispatcher.handleObjectMethod(proxy2, args2, methodName);
                }
                if (methodReturnValues != null && methodReturnValues.containsKey(methodName)) {
                    return methodReturnValues.get(methodName);
                }
                EventDispatcher.dispatchVoidMethod((Iterable)listeners.get(), method, args2);
                return null;
            }
        };
        Object object = Proxy.newProxyInstance(listenerClass.getClassLoader(), new Class[]{listenerClass}, handler2);
        if (object == null) {
            EventDispatcher.$$$reportNull$$$0(7);
        }
        return (T)object;
    }

    @Nullable
    public static Object handleObjectMethod(Object proxy2, Object[] args2, String methodName) {
        if (methodName.equals("toString")) {
            return "Multicaster";
        }
        if (methodName.equals("hashCode")) {
            return System.identityHashCode(proxy2);
        }
        if (methodName.equals("equals")) {
            return proxy2 == args2[0] ? Boolean.TRUE : Boolean.FALSE;
        }
        LOG.error("Incorrect Object's method invoked for proxy:" + methodName);
        return null;
    }

    @NotNull
    public T getMulticaster() {
        Object multicaster = this.myMulticaster;
        if (multicaster == null) {
            this.myMulticaster = multicaster = (EventListener)EventDispatcher.createMulticaster(this.myListenerClass, this.myMethodReturnValues, new StaticGetter<DisposableWrapperList<T>>(this.myListeners));
        }
        T t = multicaster;
        if (t == null) {
            EventDispatcher.$$$reportNull$$$0(8);
        }
        return t;
    }

    private static <T> void dispatchVoidMethod(@NotNull Iterable<? extends T> listeners, @NotNull Method method, Object[] args2) {
        if (listeners == null) {
            EventDispatcher.$$$reportNull$$$0(9);
        }
        if (method == null) {
            EventDispatcher.$$$reportNull$$$0(10);
        }
        method.setAccessible(true);
        for (T listener : listeners) {
            try {
                method.invoke(listener, args2);
            }
            catch (AbstractMethodError abstractMethodError) {
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                Throwable cause = e.getCause();
                ExceptionUtil.rethrowUnchecked(cause);
                if (cause instanceof AbstractMethodError) continue;
                LOG.error(cause);
            }
        }
    }

    public void addListener(@NotNull T listener) {
        if (listener == null) {
            EventDispatcher.$$$reportNull$$$0(11);
        }
        this.myListeners.add(listener);
    }

    public void removeListener(@NotNull T listener) {
        if (listener == null) {
            EventDispatcher.$$$reportNull$$$0(14);
        }
        this.myListeners.remove(listener);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 15: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listenerClass";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodReturnValues";
                break;
            }
            case 7: 
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/EventDispatcher";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listeners";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 11: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/EventDispatcher";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createMulticaster";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getMulticaster";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getListeners";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "assertNonVoidMethodReturnValuesAreDeclared";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createMulticaster";
                break;
            }
            case 7: 
            case 8: 
            case 15: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "dispatchVoidMethod";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "neuterMultiCasterWhilePerformanceTestIsRunningUntil";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 7: 
            case 8: 
            case 15: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

