/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.resolve.SupertypeUtilsKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.resolve.transformers.FirAbstractTreeTransformer;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirCompositeScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirDeclaredMemberScopeProviderKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirMemberTypeParameterScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirNestedClassifierScope;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.visitors.CompositeTransformResult;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J$\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0002H\u0004J'\u0010\u0012\u001a\u0002H\u0013\"\u0004\b\u0000\u0010\u00132\u000e\b\u0004\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0015H\u0084\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016J\f\u0010\u0017\u001a\u00020\u0018*\u00020\u0019H\u0004R\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirAbstractTreeTransformerWithSuperTypes;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirAbstractTreeTransformer;", "", "phase", "Lorg/jetbrains/kotlin/fir/declarations/FirResolvePhase;", "reversedScopePriority", "", "(Lorg/jetbrains/kotlin/fir/declarations/FirResolvePhase;Z)V", "towerScope", "Lorg/jetbrains/kotlin/fir/scopes/impl/FirCompositeScope;", "getTowerScope", "()Lorg/jetbrains/kotlin/fir/scopes/impl/FirCompositeScope;", "resolveNestedClassesSupertypes", "Lorg/jetbrains/kotlin/fir/visitors/CompositeTransformResult;", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "firClass", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "data", "withScopeCleanup", "T", "l", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "addTypeParametersScope", "", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "resolve"})
public abstract class FirAbstractTreeTransformerWithSuperTypes
extends FirAbstractTreeTransformer {
    @NotNull
    private final FirCompositeScope towerScope;

    @NotNull
    protected final FirCompositeScope getTowerScope() {
        return this.towerScope;
    }

    protected final <T> T withScopeCleanup(@NotNull Function0<? extends T> l) {
        int $i$f$withScopeCleanup = 0;
        Intrinsics.checkNotNullParameter(l, "l");
        int sizeBefore = this.towerScope.getScopes().size();
        T result2 = l.invoke();
        int size = this.towerScope.getScopes().size();
        boolean bl = size >= sizeBefore;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string2 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        this.towerScope.dropLastScopes(size - sizeBefore);
        return result2;
    }

    @NotNull
    protected final CompositeTransformResult<FirStatement> resolveNestedClassesSupertypes(@NotNull FirClass<?> firClass, @Nullable Void data2) {
        Object object;
        FirScope firScope;
        boolean bl;
        boolean bl2;
        Intrinsics.checkNotNullParameter(firClass, "firClass");
        FirAbstractTreeTransformerWithSuperTypes this_$iv = this;
        boolean $i$f$withScopeCleanup = false;
        int sizeBefore$iv = this_$iv.towerScope.getScopes().size();
        boolean bl3 = false;
        List<ConeClassLikeType> superTypes2 = CollectionsKt.asReversed(SupertypeUtilsKt.lookupSuperTypes$default(firClass, false, true, this.getSession(), null, 16, null));
        for (ConeClassLikeType superType : superTypes2) {
            if (FirSymbolProviderKt.getNestedClassifierScope(this.getSession(), superType.getLookupTag()) == null) continue;
            bl2 = false;
            bl = false;
            FirScope it = firScope;
            boolean bl4 = false;
            this.getTowerScope().addScope(it);
        }
        if (firClass instanceof FirRegularClass) {
            this.addTypeParametersScope((FirMemberDeclaration)((Object)firClass));
            FirRegularClass companionObject = ((FirRegularClass)firClass).getCompanionObject();
            if (companionObject != null) {
                FirNestedClassifierScope firNestedClassifierScope = FirDeclaredMemberScopeProviderKt.nestedClassifierScope(companionObject);
                if (firNestedClassifierScope != null) {
                    object = firNestedClassifierScope;
                    firScope = this.getTowerScope();
                    bl2 = false;
                    bl = false;
                    FirScope p1 = (FirScope)object;
                    boolean bl5 = false;
                    ((FirCompositeScope)firScope).addScope(p1);
                }
            }
        }
        FirNestedClassifierScope firNestedClassifierScope = FirDeclaredMemberScopeProviderKt.nestedClassifierScope(firClass);
        if (firNestedClassifierScope != null) {
            FirNestedClassifierScope firNestedClassifierScope2 = firNestedClassifierScope;
            object = this.getTowerScope();
            boolean bl6 = false;
            bl2 = false;
            FirScope p1 = firNestedClassifierScope2;
            boolean bl7 = false;
            ((FirCompositeScope)object).addScope(p1);
        }
        CompositeTransformResult<FirElement> result$iv = this.transformElement((FirElement)firClass, data2);
        int size$iv = this_$iv.towerScope.getScopes().size();
        boolean bl8 = size$iv >= sizeBefore$iv;
        boolean bl9 = false;
        boolean bl10 = false;
        if (_Assertions.ENABLED && !bl8) {
            boolean bl11 = false;
            String string2 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        this_$iv.towerScope.dropLastScopes(size$iv - sizeBefore$iv);
        return result$iv;
    }

    protected final void addTypeParametersScope(@NotNull FirMemberDeclaration $this$addTypeParametersScope) {
        Intrinsics.checkNotNullParameter($this$addTypeParametersScope, "$this$addTypeParametersScope");
        Collection collection = $this$addTypeParametersScope.getTypeParameters();
        boolean bl = false;
        if (!collection.isEmpty()) {
            this.towerScope.addScope(new FirMemberTypeParameterScope($this$addTypeParametersScope));
        }
    }

    public FirAbstractTreeTransformerWithSuperTypes(@NotNull FirResolvePhase phase, boolean reversedScopePriority) {
        Intrinsics.checkNotNullParameter((Object)phase, "phase");
        super(phase);
        boolean bl = false;
        this.towerScope = new FirCompositeScope(new ArrayList(), reversedScopePriority);
    }
}

