/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.callTranslator;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.translate.callTranslator.CallInfoExtensionsKt;
import org.jetbrains.kotlin.js.translate.callTranslator.VariableAccessCase;
import org.jetbrains.kotlin.js.translate.callTranslator.VariableAccessInfo;
import org.jetbrains.kotlin.js.translate.callTranslator.VariableCallCasesKt;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.reference.ReferenceTranslator;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0003\u001a\u00020\u0004*\u00020\u0005H\u0014\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/js/translate/callTranslator/SuperPropertyAccessCase;", "Lorg/jetbrains/kotlin/js/translate/callTranslator/VariableAccessCase;", "()V", "dispatchReceiver", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "Lorg/jetbrains/kotlin/js/translate/callTranslator/VariableAccessInfo;", "js.translator"})
public final class SuperPropertyAccessCase
extends VariableAccessCase {
    public static final SuperPropertyAccessCase INSTANCE;

    @Override
    @NotNull
    protected JsExpression dispatchReceiver(@NotNull VariableAccessInfo $this$dispatchReceiver) {
        JsInvocation jsInvocation;
        Intrinsics.checkNotNullParameter($this$dispatchReceiver, "$this$dispatchReceiver");
        JsStringLiteral variableName = new JsStringLiteral(CallInfoExtensionsKt.getVariableName($this$dispatchReceiver).getIdent());
        CallableDescriptor descriptor2 = $this$dispatchReceiver.getResolvedCall().getResultingDescriptor();
        if (descriptor2 instanceof PropertyDescriptor && TranslationUtils.shouldAccessViaFunctions(descriptor2)) {
            CallableDescriptor accessor = CallInfoExtensionsKt.getAccessDescriptorIfNeeded($this$dispatchReceiver);
            JsExpression jsExpression = ReferenceTranslator.translateAsValueReference(((PropertyDescriptor)descriptor2).getContainingDeclaration(), $this$dispatchReceiver.getContext());
            Intrinsics.checkNotNullExpressionValue(jsExpression, "ReferenceTranslator.tran\u2026ningDeclaration, context)");
            JsExpression containingRef = jsExpression;
            JsNameRef jsNameRef = JsAstUtils.pureFqn(Namer.getPrototypeName(), containingRef);
            Intrinsics.checkNotNullExpressionValue(jsNameRef, "pureFqn(Namer.getPrototypeName(), containingRef)");
            JsNameRef prototype = jsNameRef;
            JsNameRef jsNameRef2 = Namer.getFunctionCallRef(JsAstUtils.pureFqn($this$dispatchReceiver.getContext().getNameForDescriptor(accessor), (JsExpression)prototype));
            Intrinsics.checkNotNullExpressionValue(jsNameRef2, "Namer.getFunctionCallRef\u2026or(accessor), prototype))");
            JsNameRef funRef = jsNameRef2;
            JsExpression jsExpression2 = $this$dispatchReceiver.getDispatchReceiver();
            Intrinsics.checkNotNull(jsExpression2);
            List arguments2 = CollectionsKt.plus((Collection)CollectionsKt.listOf(jsExpression2), (Iterable)VariableCallCasesKt.access$getAdditionalArguments$p($this$dispatchReceiver));
            Collection $this$toTypedArray$iv = arguments2;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            JsExpression[] jsExpressionArray = thisCollection$iv.toArray(new JsExpression[0]);
            if (jsExpressionArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            jsInvocation = new JsInvocation((JsExpression)funRef, Arrays.copyOf(jsExpressionArray, jsExpressionArray.length));
        } else {
            JsExpression jsExpression;
            if (CallInfoExtensionsKt.isGetAccess($this$dispatchReceiver)) {
                Namer namer = $this$dispatchReceiver.getContext().namer();
                Intrinsics.checkNotNullExpressionValue(namer, "context.namer()");
                jsExpression = namer.getCallGetProperty();
            } else {
                Namer namer = $this$dispatchReceiver.getContext().namer();
                Intrinsics.checkNotNullExpressionValue(namer, "context.namer()");
                jsExpression = namer.getCallSetProperty();
            }
            Intrinsics.checkNotNullExpressionValue(jsExpression, "if (isGetAccess()) conte\u2026t.namer().callSetProperty");
            JsExpression callExpr = jsExpression;
            JsExpression[] jsExpressionArray = new JsExpression[3];
            JsExpression jsExpression3 = $this$dispatchReceiver.getDispatchReceiver();
            Intrinsics.checkNotNull(jsExpression3);
            jsExpressionArray[0] = jsExpression3;
            JsExpression jsExpression4 = JsAstUtils.prototypeOf(CallInfoExtensionsKt.getCalleeOwner($this$dispatchReceiver));
            Intrinsics.checkNotNullExpressionValue(jsExpression4, "JsAstUtils.prototypeOf(calleeOwner)");
            jsExpressionArray[1] = jsExpression4;
            jsExpressionArray[2] = variableName;
            List arguments3 = CollectionsKt.plus((Collection)CollectionsKt.listOf(jsExpressionArray), (Iterable)VariableCallCasesKt.access$getAdditionalArguments$p($this$dispatchReceiver));
            Collection $this$toTypedArray$iv = arguments3;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            JsExpression[] jsExpressionArray2 = thisCollection$iv.toArray(new JsExpression[0]);
            if (jsExpressionArray2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            jsInvocation = new JsInvocation(callExpr, Arrays.copyOf(jsExpressionArray2, jsExpressionArray2.length));
        }
        return jsInvocation;
    }

    private SuperPropertyAccessCase() {
    }

    static {
        SuperPropertyAccessCase superPropertyAccessCase;
        INSTANCE = superPropertyAccessCase = new SuperPropertyAccessCase();
    }
}

