/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.stubs.KotlinClassOrObjectStub;
import org.jetbrains.kotlin.psi.stubs.KotlinObjectStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtObjectElementType;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J5\u0010\u000b\u001a\u0002H\f\"\u0004\b\u0000\u0010\f\"\u0004\b\u0001\u0010\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u0002H\r0\u000f2\u0006\u0010\u0010\u001a\u0002H\rH\u0016\u00a2\u0006\u0002\u0010\u0011J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00000\u0013H\u0016J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\b\u0010\u0018\u001a\u0004\u0018\u00010\u0015J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u001cJ\u0012\u0010\u001e\u001a\u00020\u00152\b\b\u0001\u0010\u001f\u001a\u00020\u0017H\u0016R\u0016\u0010\b\u001a\u0004\u0018\u00010\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "node", "Lcom/intellij/lang/ASTNode;", "(Lcom/intellij/lang/ASTNode;)V", "stub", "Lorg/jetbrains/kotlin/psi/stubs/KotlinObjectStub;", "(Lorg/jetbrains/kotlin/psi/stubs/KotlinObjectStub;)V", "_stub", "get_stub", "()Lorg/jetbrains/kotlin/psi/stubs/KotlinObjectStub;", "accept", "R", "D", "visitor", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "data", "(Lorg/jetbrains/kotlin/psi/KtVisitor;Ljava/lang/Object;)Ljava/lang/Object;", "getCompanionObjects", "", "getIdentifyingElement", "Lcom/intellij/psi/PsiElement;", "getName", "", "getObjectKeyword", "getTextOffset", "", "isCompanion", "", "isObjectLiteral", "setName", "name", "psi"})
public final class KtObjectDeclaration
extends KtClassOrObject {
    private final KotlinObjectStub get_stub() {
        KotlinClassOrObjectStub kotlinClassOrObjectStub = (KotlinClassOrObjectStub)this.getStub();
        if (!(kotlinClassOrObjectStub instanceof KotlinObjectStub)) {
            kotlinClassOrObjectStub = null;
        }
        return (KotlinObjectStub)kotlinClassOrObjectStub;
    }

    @Override
    @Nullable
    public String getName() {
        String string2 = super.getName();
        if (string2 != null) {
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String it = string3;
            boolean bl3 = false;
            return it;
        }
        if (this.isCompanion() && !this.isTopLevel()) {
            return SpecialNames.DEFAULT_NAME_FOR_COMPANION_OBJECT.toString();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public PsiElement setName(@NonNls @NotNull String name) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter(name, "name");
        if (this.getNameIdentifier() == null) {
            void var3_3;
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue(project, "project");
            KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
            PsiElement psiElement2 = psiFactory.createIdentifier(name);
            PsiElement psiElement3 = this.getObjectKeyword();
            Intrinsics.checkNotNull(psiElement3);
            PsiElement result2 = this.addAfter(psiElement2, psiElement3);
            PsiElement psiElement4 = psiFactory.createWhiteSpace();
            PsiElement psiElement5 = this.getObjectKeyword();
            Intrinsics.checkNotNull(psiElement5);
            this.addAfter(psiElement4, psiElement5);
            psiElement = var3_3;
        } else {
            psiElement = super.setName(name);
        }
        Intrinsics.checkNotNullExpressionValue(psiElement, "if (nameIdentifier == nu\u2026r.setName(name)\n        }");
        return psiElement;
    }

    public final boolean isCompanion() {
        KotlinObjectStub kotlinObjectStub = this.get_stub();
        return kotlinObjectStub != null ? kotlinObjectStub.isCompanion() : this.hasModifier(KtTokens.COMPANION_KEYWORD);
    }

    @Override
    public int getTextOffset() {
        int n;
        Object object = this.getNameIdentifier();
        if (object != null && (object = object.getTextRange()) != null) {
            n = ((TextRange)object).getStartOffset();
        } else {
            PsiElement psiElement = this.getObjectKeyword();
            Intrinsics.checkNotNull(psiElement);
            TextRange textRange = psiElement.getTextRange();
            Intrinsics.checkNotNullExpressionValue(textRange, "getObjectKeyword()!!.textRange");
            n = textRange.getStartOffset();
        }
        return n;
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data2) {
        Intrinsics.checkNotNullParameter(visitor2, "visitor");
        return visitor2.visitObjectDeclaration(this, data2);
    }

    public final boolean isObjectLiteral() {
        KotlinObjectStub kotlinObjectStub = this.get_stub();
        return kotlinObjectStub != null ? kotlinObjectStub.isObjectLiteral() : this.getParent() instanceof KtObjectLiteralExpression;
    }

    @Nullable
    public final PsiElement getObjectKeyword() {
        return this.findChildByType(KtTokens.OBJECT_KEYWORD);
    }

    @Override
    @Nullable
    public PsiElement getIdentifyingElement() {
        return this.getObjectKeyword();
    }

    @Override
    @NotNull
    public List<KtObjectDeclaration> getCompanionObjects() {
        return CollectionsKt.emptyList();
    }

    public KtObjectDeclaration(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter(node, "node");
        super(node);
    }

    public KtObjectDeclaration(@NotNull KotlinObjectStub stub) {
        Intrinsics.checkNotNullParameter(stub, "stub");
        KotlinClassOrObjectStub kotlinClassOrObjectStub = stub;
        KtObjectElementType ktObjectElementType = KtStubElementTypes.OBJECT_DECLARATION;
        Intrinsics.checkNotNullExpressionValue(ktObjectElementType, "KtStubElementTypes.OBJECT_DECLARATION");
        super(kotlinClassOrObjectStub, (IStubElementType)ktObjectElementType);
    }
}

