/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import gnu.trove.TObjectIntHashMap;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class SimpleStringPersistentEnumerator {
    @NotNull
    private final Path myFile;
    @NotNull
    private final TObjectIntHashMap<String> myState;

    public SimpleStringPersistentEnumerator(@NotNull Path file2) {
        if (file2 == null) {
            SimpleStringPersistentEnumerator.$$$reportNull$$$0(0);
        }
        this.myFile = file2;
        this.myState = new TObjectIntHashMap();
        this.readStorageFromDisk();
    }

    public synchronized short enumerate(@Nullable String value2) {
        if (this.myState.containsKey(value2)) {
            return (short)this.myState.get(value2);
        }
        int n = this.myState.size() + 1;
        assert (n <= Short.MAX_VALUE) : "Number of indices exceeded: " + n;
        this.myState.put(value2, n);
        this.writeStorageToDisk();
        return (short)n;
    }

    private synchronized void readStorageFromDisk() {
        try {
            TObjectIntHashMap<String> nameToIdRegistry = new TObjectIntHashMap<String>();
            List<String> lines = Files.readAllLines(this.myFile, Charset.defaultCharset());
            for (int i = 0; i < lines.size(); ++i) {
                String name2 = lines.get(i);
                nameToIdRegistry.put(name2, i + 1);
            }
            this.myState.ensureCapacity(nameToIdRegistry.size());
            nameToIdRegistry.forEachEntry((name, index2) -> {
                this.myState.put((String)name, index2);
                return true;
            });
        }
        catch (IOException e) {
            this.myState.clear();
            this.writeStorageToDisk();
        }
    }

    private void writeStorageToDisk() {
        try {
            String[] names2 = new String[this.myState.size()];
            this.myState.forEachEntry((key, value2) -> {
                names2[value2 - 1] = key;
                return true;
            });
            Files.createDirectories(this.myFile.getParent(), new FileAttribute[0]);
            Files.write(this.myFile, Arrays.asList(names2), Charset.defaultCharset(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/io/SimpleStringPersistentEnumerator", "<init>"));
    }
}

