/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.resolve.transformers.SupertypeComputationSession;
import org.jetbrains.kotlin.fir.resolve.transformers.SupertypeComputationStatus;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.visitors.FirDefaultTransformer;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0014\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0002J\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u001a\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u00122\b\u0010\u0017\u001a\u0004\u0018\u00010\u0002H\u0014J)\u0010\u001a\u001a\u0002H\u001b\"\b\b\u0000\u0010\u001b*\u00020\u001c2\u0006\u0010\u001d\u001a\u0002H\u001b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0002\u0010\u001eJ\u001a\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010\"\u001a\u00020\u00142\u0006\u0010#\u001a\u00020$2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010%\u001a\u00020\u00122\u0006\u0010&\u001a\u00020'2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirApplySupertypesTransformer;", "Lorg/jetbrains/kotlin/fir/visitors/FirDefaultTransformer;", "", "supertypeComputationSession", "Lorg/jetbrains/kotlin/fir/resolve/transformers/SupertypeComputationSession;", "(Lorg/jetbrains/kotlin/fir/resolve/transformers/SupertypeComputationSession;)V", "applyResolvedSupertypesToClass", "", "firClass", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "getResolvedSupertypeRefs", "", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "classLikeDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "needReplacePhase", "", "firDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "transformAnonymousObject", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "anonymousObject", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousObject;", "data", "transformDeclarationContent", "declaration", "transformElement", "E", "Lorg/jetbrains/kotlin/fir/FirElement;", "element", "(Lorg/jetbrains/kotlin/fir/FirElement;Ljava/lang/Object;)Lorg/jetbrains/kotlin/fir/FirElement;", "transformFile", "file", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "transformRegularClass", "regularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "transformTypeAlias", "typeAlias", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "resolve"})
public class FirApplySupertypesTransformer
extends FirDefaultTransformer<Object> {
    @NotNull
    private final SupertypeComputationSession supertypeComputationSession;

    public FirApplySupertypesTransformer(@NotNull SupertypeComputationSession supertypeComputationSession) {
        Intrinsics.checkNotNullParameter(supertypeComputationSession, "supertypeComputationSession");
        this.supertypeComputationSession = supertypeComputationSession;
    }

    @Override
    @NotNull
    public <E extends FirElement> E transformElement(@NotNull E element, @Nullable Object data2) {
        Intrinsics.checkNotNullParameter(element, "element");
        return element;
    }

    protected boolean needReplacePhase(@NotNull FirDeclaration firDeclaration) {
        Intrinsics.checkNotNullParameter(firDeclaration, "firDeclaration");
        return FirResolvePhase.SUPER_TYPES.compareTo((Enum)firDeclaration.getResolvePhase()) > 0;
    }

    @NotNull
    protected FirDeclaration transformDeclarationContent(@NotNull FirDeclaration declaration2, @Nullable Object data2) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        return (FirDeclaration)declaration2.transformChildren(this, null);
    }

    @Override
    @NotNull
    public FirDeclaration transformFile(@NotNull FirFile file2, @Nullable Object data2) {
        Intrinsics.checkNotNullParameter(file2, "file");
        if (this.needReplacePhase(file2)) {
            file2.replaceResolvePhase(FirResolvePhase.SUPER_TYPES);
        }
        return (FirFile)this.transformDeclarationContent(file2, null);
    }

    @Override
    @NotNull
    public FirStatement transformRegularClass(@NotNull FirRegularClass regularClass, @Nullable Object data2) {
        Intrinsics.checkNotNullParameter(regularClass, "regularClass");
        this.applyResolvedSupertypesToClass(regularClass);
        return (FirRegularClass)this.transformDeclarationContent(regularClass, null);
    }

    private final void applyResolvedSupertypesToClass(FirClass<?> firClass) {
        boolean bl;
        block5: {
            Iterable $this$any$iv = firClass.getSuperTypeRefs();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FirTypeRef it = (FirTypeRef)element$iv;
                    boolean bl2 = false;
                    if (!(!(it instanceof FirResolvedTypeRef))) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            List<FirResolvedTypeRef> supertypeRefs = this.getResolvedSupertypeRefs((FirClassLikeDeclaration)firClass);
            firClass.replaceSuperTypeRefs(supertypeRefs);
        }
        if (this.needReplacePhase(firClass)) {
            firClass.replaceResolvePhase(FirResolvePhase.SUPER_TYPES);
        }
    }

    @Override
    @NotNull
    public FirStatement transformAnonymousObject(@NotNull FirAnonymousObject anonymousObject, @Nullable Object data2) {
        Intrinsics.checkNotNullParameter(anonymousObject, "anonymousObject");
        this.applyResolvedSupertypesToClass(anonymousObject);
        return super.transformAnonymousObject(anonymousObject, data2);
    }

    private final List<FirResolvedTypeRef> getResolvedSupertypeRefs(FirClassLikeDeclaration<?> classLikeDeclaration) {
        SupertypeComputationStatus status2 = this.supertypeComputationSession.getSupertypesComputationStatus(classLikeDeclaration);
        boolean bl = status2 instanceof SupertypeComputationStatus.Computed;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "Unexpected status at FirApplySupertypesTransformer: " + status2 + " for " + classLikeDeclaration.getSymbol().getClassId();
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        return ((SupertypeComputationStatus.Computed)status2).getSupertypeRefs();
    }

    @Override
    @NotNull
    public FirDeclaration transformTypeAlias(@NotNull FirTypeAlias typeAlias, @Nullable Object data2) {
        Intrinsics.checkNotNullParameter(typeAlias, "typeAlias");
        if (typeAlias.getExpandedTypeRef() instanceof FirResolvedTypeRef) {
            if (this.needReplacePhase(typeAlias)) {
                typeAlias.replaceResolvePhase(FirResolvePhase.SUPER_TYPES);
            }
            return typeAlias;
        }
        List<FirResolvedTypeRef> supertypeRefs = this.getResolvedSupertypeRefs(typeAlias);
        boolean bl = supertypeRefs.size() == 1;
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Expected single supertypeRefs, but found " + supertypeRefs.size() + " in " + typeAlias.getSymbol().getClassId();
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        typeAlias.replaceExpandedTypeRef(supertypeRefs.get(0));
        if (this.needReplacePhase(typeAlias)) {
            typeAlias.replaceResolvePhase(FirResolvePhase.SUPER_TYPES);
        }
        return typeAlias;
    }
}

