/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.transformers.irToJs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.BaseIrElementToJsNodeTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.IrElementToJsExpressionTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.IrElementToJsStatementTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsAstUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsCodeKt;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.SwitchOptimizer;
import org.jetbrains.kotlin.ir.backend.js.utils.JsGenerationContext;
import org.jetbrains.kotlin.ir.backend.js.utils.JsGenerationContextKt;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrReturnableBlock;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrReturnTargetSymbol;
import org.jetbrains.kotlin.ir.symbols.IrReturnableBlockSymbol;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsCatch;
import org.jetbrains.kotlin.js.backend.ast.JsContinue;
import org.jetbrains.kotlin.js.backend.ast.JsDoWhile;
import org.jetbrains.kotlin.js.backend.ast.JsEmpty;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsLabel;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsTry;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.JsWhile;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003H\u0016J\u0018\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u0014\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0011\u001a\u00020\u0003H\u0016J\u0018\u0010!\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\"2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010#\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020$2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010%\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020&2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010'\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020(2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010)\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020*2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010+\u001a\u00020\u00022\u0006\u0010,\u001a\u00020-2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010.\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020/2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u00100\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u0002012\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u00102\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u0002032\u0006\u0010\b\u001a\u00020\u0003H\u0016J(\u00104\u001a\u00020\u0002*\u00020\u001c2\u0006\u0010\b\u001a\u00020\u00032\u0012\u00105\u001a\u000e\u0012\u0004\u0012\u000207\u0012\u0004\u0012\u00020\u000206H\u0002\u00a8\u00068"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/IrElementToJsStatementTransformer;", "Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/BaseIrElementToJsNodeTransformer;", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "Lorg/jetbrains/kotlin/ir/backend/js/utils/JsGenerationContext;", "()V", "visitBlock", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrBlock;", "context", "visitBlockBody", "body", "Lorg/jetbrains/kotlin/ir/expressions/IrBlockBody;", "visitBreak", "jump", "Lorg/jetbrains/kotlin/ir/expressions/IrBreak;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "data", "visitComposite", "Lorg/jetbrains/kotlin/ir/expressions/IrComposite;", "visitContinue", "Lorg/jetbrains/kotlin/ir/expressions/IrContinue;", "visitDelegatingConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "visitDoWhileLoop", "loop", "Lorg/jetbrains/kotlin/ir/expressions/IrDoWhileLoop;", "visitExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "visitFunction", "Lorg/jetbrains/kotlin/js/backend/ast/JsEmpty;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "visitInstanceInitializerCall", "Lorg/jetbrains/kotlin/ir/expressions/IrInstanceInitializerCall;", "visitReturn", "Lorg/jetbrains/kotlin/ir/expressions/IrReturn;", "visitSetField", "Lorg/jetbrains/kotlin/ir/expressions/IrSetField;", "visitSetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrSetValue;", "visitThrow", "Lorg/jetbrains/kotlin/ir/expressions/IrThrow;", "visitTry", "aTry", "Lorg/jetbrains/kotlin/ir/expressions/IrTry;", "visitVariable", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "visitWhen", "Lorg/jetbrains/kotlin/ir/expressions/IrWhen;", "visitWhileLoop", "Lorg/jetbrains/kotlin/ir/expressions/IrWhileLoop;", "maybeOptimizeIntoSwitch", "transformer", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "backend.js"})
public final class IrElementToJsStatementTransformer
implements BaseIrElementToJsNodeTransformer<JsStatement, JsGenerationContext> {
    @Override
    @NotNull
    public JsEmpty visitFunction(@NotNull IrFunction declaration2, @NotNull JsGenerationContext data2) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(data2, "data");
        JsEmpty jsEmpty = JsEmpty.INSTANCE;
        boolean bl = false;
        boolean bl2 = false;
        JsEmpty it = jsEmpty;
        boolean bl3 = false;
        boolean bl4 = Intrinsics.areEqual(declaration2.getOrigin(), JsIrBackendContext.Companion.getCallableClosureOrigin());
        boolean bl5 = false;
        if (_Assertions.ENABLED && !bl4) {
            boolean bl6 = false;
            String string2 = "The only possible Function Declaration is one composed in Callable Reference Lowering";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        return jsEmpty;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public JsStatement visitBlockBody(@NotNull IrBlockBody body2, @NotNull JsGenerationContext context2) {
        Collection<JsStatement> collection;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(body2, "body");
        Intrinsics.checkNotNullParameter(context2, "context");
        Iterable $this$map$iv = body2.getStatements();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrStatement irStatement = (IrStatement)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            JsStatement jsStatement = (JsStatement)it.accept(this, context2);
            collection.add(jsStatement);
        }
        collection = (List)destination$iv$iv;
        List list2 = collection;
        return new JsBlock(list2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public JsStatement visitBlock(@NotNull IrBlock expression2, @NotNull JsGenerationContext context2) {
        JsName label;
        Collection<JsStatement> collection;
        void $this$mapTo$iv$iv;
        Object object;
        JsGenerationContext jsGenerationContext;
        IrReturnableBlock irReturnableBlock;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        IrReturnableBlock irReturnableBlock2 = irReturnableBlock = expression2 instanceof IrReturnableBlock ? (IrReturnableBlock)expression2 : null;
        if (irReturnableBlock == null) {
            jsGenerationContext = context2;
        } else {
            IrFunctionSymbol irFunctionSymbol = irReturnableBlock.getInlineFunctionSymbol();
            if (irFunctionSymbol == null) {
                jsGenerationContext = context2;
            } else {
                object = irFunctionSymbol;
                boolean bl = false;
                boolean bl2 = false;
                Object it = object;
                boolean bl3 = false;
                JsGenerationContext jsGenerationContext2 = context2.newFile(IrUtilsKt.getFile(it.getOwner()), context2.getCurrentFunction(), context2.getLocalNames());
                jsGenerationContext = jsGenerationContext2 == null ? context2 : jsGenerationContext2;
            }
        }
        JsGenerationContext newContext = jsGenerationContext;
        Iterable $this$map$iv = expression2.getStatements();
        boolean $i$f$map = false;
        object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrStatement irStatement = (IrStatement)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            JsStatement jsStatement = (JsStatement)it.accept(this, newContext);
            collection.add(jsStatement);
        }
        collection = (List)destination$iv$iv;
        List list2 = collection;
        JsBlock block = new JsBlock(list2);
        if (expression2 instanceof IrReturnableBlock && (label = context2.getNameForReturnableBlock((IrReturnableBlock)expression2)) != null) {
            return new JsLabel(label, block);
        }
        return block;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public JsStatement visitComposite(@NotNull IrComposite expression2, @NotNull JsGenerationContext context2) {
        Collection<JsStatement> collection;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        Iterable $this$map$iv = expression2.getStatements();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrStatement irStatement = (IrStatement)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            JsStatement jsStatement = (JsStatement)it.accept(this, context2);
            collection.add(jsStatement);
        }
        collection = (List)destination$iv$iv;
        List list2 = collection;
        return new JsBlock(list2);
    }

    @Override
    @NotNull
    public JsStatement visitExpression(@NotNull IrExpression expression2, @NotNull JsGenerationContext context2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        JsStatement jsStatement = ((JsExpression)expression2.accept(new IrElementToJsExpressionTransformer(), context2)).makeStmt();
        Intrinsics.checkNotNullExpressionValue(jsStatement, "expression.accept(IrElem\u2026er(), context).makeStmt()");
        return jsStatement;
    }

    @Override
    @NotNull
    public JsStatement visitBreak(@NotNull IrBreak jump, @NotNull JsGenerationContext context2) {
        JsNameRef jsNameRef;
        Intrinsics.checkNotNullParameter(jump, "jump");
        Intrinsics.checkNotNullParameter(context2, "context");
        JsName jsName = context2.getNameForLoop(jump.getLoop());
        if (jsName == null) {
            jsNameRef = null;
        } else {
            JsNameRef jsNameRef2;
            JsName jsName2 = jsName;
            boolean bl = false;
            boolean bl2 = false;
            JsName it = jsName2;
            boolean bl3 = false;
            jsNameRef = jsNameRef2 = new JsNameRef(it);
        }
        JsNameRef jsNameRef3 = jsNameRef;
        return (JsStatement)JsAstUtilsKt.withSource((JsNode)new JsBreak(jsNameRef3), jump, context2);
    }

    @Override
    @NotNull
    public JsStatement visitContinue(@NotNull IrContinue jump, @NotNull JsGenerationContext context2) {
        JsNameRef jsNameRef;
        Intrinsics.checkNotNullParameter(jump, "jump");
        Intrinsics.checkNotNullParameter(context2, "context");
        JsName jsName = context2.getNameForLoop(jump.getLoop());
        if (jsName == null) {
            jsNameRef = null;
        } else {
            JsNameRef jsNameRef2;
            JsName jsName2 = jsName;
            boolean bl = false;
            boolean bl2 = false;
            JsName it = jsName2;
            boolean bl3 = false;
            jsNameRef = jsNameRef2 = new JsNameRef(it);
        }
        JsNameRef jsNameRef3 = jsNameRef;
        return (JsStatement)JsAstUtilsKt.withSource((JsNode)new JsContinue(jsNameRef3), jump, context2);
    }

    private final JsStatement maybeOptimizeIntoSwitch(IrExpression $this$maybeOptimizeIntoSwitch, JsGenerationContext context2, Function1<? super JsExpression, ? extends JsStatement> transformer2) {
        Function1 stmtTransformer2;
        JsStatement jsStatement;
        if ($this$maybeOptimizeIntoSwitch instanceof IrWhen && (jsStatement = new SwitchOptimizer(context2, stmtTransformer2 = (Function1)new Function1<JsStatement, JsStatement>(transformer2){
            final /* synthetic */ Function1<JsExpression, JsStatement> $transformer;
            {
                this.$transformer = $transformer;
                super(1);
            }

            @NotNull
            public final JsStatement invoke(@NotNull JsStatement stmt) {
                Intrinsics.checkNotNullParameter(stmt, "stmt");
                JsExpression jsExpression = ((JsExpressionStatement)stmt).getExpression();
                Intrinsics.checkNotNullExpressionValue(jsExpression, "stmt as JsExpressionStatement).expression");
                return this.$transformer.invoke(jsExpression);
            }
        }).tryOptimize((IrWhen)$this$maybeOptimizeIntoSwitch)) != null) {
            JsStatement jsStatement2 = jsStatement;
            boolean bl = false;
            boolean bl2 = false;
            JsStatement it = jsStatement2;
            boolean bl3 = false;
            return it;
        }
        return transformer2.invoke((JsExpression)$this$maybeOptimizeIntoSwitch.accept(new IrElementToJsExpressionTransformer(), context2));
    }

    @Override
    @NotNull
    public JsStatement visitSetField(@NotNull IrSetField expression2, @NotNull JsGenerationContext context2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        JsName fieldName = context2.getNameForField((IrField)expression2.getSymbol().getOwner());
        IrElementToJsExpressionTransformer expressionTransformer = new IrElementToJsExpressionTransformer();
        IrExpression irExpression = expression2.getReceiver();
        JsNameRef dest = new JsNameRef(fieldName, irExpression == null ? null : (JsExpression)irExpression.accept(expressionTransformer, context2));
        return this.maybeOptimizeIntoSwitch(expression2.getValue(), context2, (Function1<? super JsExpression, ? extends JsStatement>)new Function1<JsExpression, JsStatement>(dest, expression2, context2){
            final /* synthetic */ JsNameRef $dest;
            final /* synthetic */ IrSetField $expression;
            final /* synthetic */ JsGenerationContext $context;
            {
                this.$dest = $dest;
                this.$expression = $expression;
                this.$context = $context;
                super(1);
            }

            @NotNull
            public final JsStatement invoke(@NotNull JsExpression it) {
                Intrinsics.checkNotNullParameter(it, "it");
                JsStatement jsStatement = ((JsBinaryOperation)JsAstUtilsKt.withSource((JsNode)JsAstUtilsKt.jsAssignment(this.$dest, it), this.$expression, this.$context)).makeStmt();
                Intrinsics.checkNotNullExpressionValue(jsStatement, "jsAssignment(dest, it).w\u2026sion, context).makeStmt()");
                return jsStatement;
            }
        });
    }

    @Override
    @NotNull
    public JsStatement visitSetValue(@NotNull IrSetValue expression2, @NotNull JsGenerationContext context2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        JsNameRef ref = new JsNameRef(context2.getNameForValueDeclaration(expression2.getSymbol().getOwner()));
        return this.maybeOptimizeIntoSwitch(expression2.getValue(), context2, (Function1<? super JsExpression, ? extends JsStatement>)new Function1<JsExpression, JsStatement>(ref, expression2, context2){
            final /* synthetic */ JsNameRef $ref;
            final /* synthetic */ IrSetValue $expression;
            final /* synthetic */ JsGenerationContext $context;
            {
                this.$ref = $ref;
                this.$expression = $expression;
                this.$context = $context;
                super(1);
            }

            @NotNull
            public final JsStatement invoke(@NotNull JsExpression it) {
                Intrinsics.checkNotNullParameter(it, "it");
                JsStatement jsStatement = ((JsBinaryOperation)JsAstUtilsKt.withSource((JsNode)JsAstUtilsKt.jsAssignment(this.$ref, it), this.$expression, this.$context)).makeStmt();
                Intrinsics.checkNotNullExpressionValue(jsStatement, "jsAssignment(ref, it).wi\u2026sion, context).makeStmt()");
                return jsStatement;
            }
        });
    }

    @Override
    @NotNull
    public JsStatement visitReturn(@NotNull IrReturn expression2, @NotNull JsGenerationContext context2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        IrReturnTargetSymbol targetSymbol = expression2.getReturnTargetSymbol();
        Function1 lastStatementTransformer2 = targetSymbol instanceof IrReturnableBlockSymbol ? (Function1)new Function1<JsExpression, JsStatement>(context2, targetSymbol){
            final /* synthetic */ JsGenerationContext $context;
            final /* synthetic */ IrReturnTargetSymbol $targetSymbol;
            {
                this.$context = $context;
                this.$targetSymbol = $targetSymbol;
                super(1);
            }

            @NotNull
            public final JsStatement invoke(@NotNull JsExpression it) {
                Intrinsics.checkNotNullParameter(it, "it");
                JsName jsName = this.$context.getNameForReturnableBlock((IrReturnableBlock)((IrReturnableBlockSymbol)this.$targetSymbol).getOwner());
                Intrinsics.checkNotNull(jsName);
                return new JsBreak(jsName.makeRef());
            }
        } : (Function1)visitReturn.lastStatementTransformer.2.INSTANCE;
        return (JsStatement)JsAstUtilsKt.withSource((JsNode)this.maybeOptimizeIntoSwitch(expression2.getValue(), context2, lastStatementTransformer2), expression2, context2);
    }

    @Override
    @NotNull
    public JsStatement visitThrow(@NotNull IrThrow expression2, @NotNull JsGenerationContext context2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        return (JsStatement)JsAstUtilsKt.withSource((JsNode)this.maybeOptimizeIntoSwitch(expression2.getValue(), context2, visitThrow.1.INSTANCE), expression2, context2);
    }

    @Override
    @NotNull
    public JsStatement visitVariable(@NotNull IrVariable declaration2, @NotNull JsGenerationContext context2) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(context2, "context");
        JsName varName = context2.getNameForValueDeclaration(declaration2);
        IrExpression value2 = declaration2.getInitializer();
        if (value2 instanceof IrWhen) {
            JsNameRef jsNameRef = varName.makeRef();
            Intrinsics.checkNotNullExpressionValue(jsNameRef, "varName.makeRef()");
            JsNameRef varRef = jsNameRef;
            Function1 transformer2 = new Function1<JsStatement, JsStatement>(varRef){
                final /* synthetic */ JsNameRef $varRef;
                {
                    this.$varRef = $varRef;
                    super(1);
                }

                @NotNull
                public final JsStatement invoke(@NotNull JsStatement stmt) {
                    Intrinsics.checkNotNullParameter(stmt, "stmt");
                    JsExpression jsExpression = ((JsExpressionStatement)stmt).getExpression();
                    Intrinsics.checkNotNullExpressionValue(jsExpression, "stmt as JsExpressionStatement).expression");
                    JsExpression expr = jsExpression;
                    return new JsBinaryOperation(JsBinaryOperator.ASG, this.$varRef, expr).makeStmt();
                }
            };
            JsStatement jsStatement = new SwitchOptimizer(context2, transformer2).tryOptimize((IrWhen)value2);
            if (jsStatement != null) {
                JsStatement jsStatement2 = jsStatement;
                boolean bl = false;
                boolean bl2 = false;
                JsStatement it = jsStatement2;
                boolean bl3 = false;
                JsStatement[] jsStatementArray = new JsStatement[]{new JsVars(new JsVars.JsVar(varName)), it};
                return (JsStatement)JsAstUtilsKt.withSource((JsNode)new JsBlock(jsStatementArray), declaration2, context2);
            }
        }
        return (JsStatement)JsAstUtilsKt.withSource((JsNode)JsAstUtilsKt.jsVar(varName, value2, context2), declaration2, context2);
    }

    @Override
    @NotNull
    public JsStatement visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @NotNull JsGenerationContext context2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        if (IrTypePredicatesKt.isAny(IrUtilsKt.getConstructedClassType((IrConstructor)expression2.getSymbol().getOwner()))) {
            return JsEmpty.INSTANCE;
        }
        JsStatement jsStatement = ((JsExpression)expression2.accept(new IrElementToJsExpressionTransformer(), context2)).makeStmt();
        Intrinsics.checkNotNullExpressionValue(jsStatement, "expression.accept(IrElem\u2026er(), context).makeStmt()");
        return jsStatement;
    }

    @Override
    @NotNull
    public JsStatement visitCall(@NotNull IrCall expression2, @NotNull JsGenerationContext data2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(data2, "data");
        if (data2.checkIfJsCode(expression2.getSymbol())) {
            JsStatement jsStatement;
            IrExpression irExpression = expression2.getValueArgument(0);
            if (irExpression == null) {
                String string2 = "JsCode is expected";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            List<JsStatement> list2 = JsCodeKt.translateJsCodeIntoStatementList(irExpression);
            Intrinsics.checkNotNull(list2);
            List<JsStatement> statements2 = list2;
            int n = statements2.size();
            switch (n) {
                case 0: {
                    jsStatement = JsEmpty.INSTANCE;
                    break;
                }
                case 1: {
                    jsStatement = (JsStatement)JsAstUtilsKt.withSource((JsNode)CollectionsKt.single(statements2), expression2, data2);
                    break;
                }
                default: {
                    jsStatement = new JsBlock(statements2);
                }
            }
            return jsStatement;
        }
        JsStatement jsStatement = ((JsExpression)JsAstUtilsKt.withSource((JsNode)JsAstUtilsKt.translateCall(expression2, data2, new IrElementToJsExpressionTransformer()), expression2, data2)).makeStmt();
        Intrinsics.checkNotNullExpressionValue(jsStatement, "translateCall(expression\u2026ression, data).makeStmt()");
        return jsStatement;
    }

    @Override
    @NotNull
    public JsStatement visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @NotNull JsGenerationContext context2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        return JsEmpty.INSTANCE;
    }

    @Override
    @NotNull
    public JsStatement visitTry(@NotNull IrTry aTry, @NotNull JsGenerationContext context2) {
        JsStatement jsStatement;
        IrElementBase irElementBase;
        JsCatch jsCatch;
        Intrinsics.checkNotNullParameter(aTry, "aTry");
        Intrinsics.checkNotNullParameter(context2, "context");
        JsBlock jsTryBlock = JsAstUtilsKt.asBlock((JsStatement)aTry.getTryResult().accept(this, context2));
        IrCatch irCatch = CollectionsKt.singleOrNull(aTry.getCatches());
        if (irCatch == null) {
            jsCatch = null;
        } else {
            irElementBase = irCatch;
            boolean bl = false;
            boolean bl2 = false;
            IrElementBase it = irElementBase;
            boolean bl3 = false;
            JsName name = context2.getNameForValueDeclaration(((IrCatch)it).getCatchParameter());
            JsStatement jsCatchBlock = (JsStatement)((IrCatch)it).getResult().accept(this, context2);
            jsCatch = new JsCatch(JsGenerationContextKt.getEmptyScope(), name.getIdent(), jsCatchBlock);
        }
        JsCatch jsCatch2 = jsCatch;
        irElementBase = aTry.getFinallyExpression();
        JsBlock jsFinallyBlock = irElementBase == null ? null : ((jsStatement = (JsStatement)irElementBase.accept(this, context2)) == null ? null : JsAstUtilsKt.asBlock(jsStatement));
        return new JsTry(jsTryBlock, jsCatch2, jsFinallyBlock);
    }

    @Override
    @NotNull
    public JsStatement visitWhen(@NotNull IrWhen expression2, @NotNull JsGenerationContext context2) {
        JsStatement jsStatement;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        JsStatement jsStatement2 = new SwitchOptimizer(context2).tryOptimize(expression2);
        return jsStatement2 == null ? ((jsStatement = (JsStatement)JsAstUtilsKt.toJsNode$default(expression2, this, context2, visitWhen.1.INSTANCE, null, 8, null)) == null ? (JsStatement)JsEmpty.INSTANCE : jsStatement) : jsStatement2;
    }

    @Override
    @NotNull
    public JsStatement visitWhileLoop(@NotNull IrWhileLoop loop2, @NotNull JsGenerationContext context2) {
        JsStatement jsStatement;
        Intrinsics.checkNotNullParameter(loop2, "loop");
        Intrinsics.checkNotNullParameter(context2, "context");
        JsName label = context2.getNameForLoop(loop2);
        Object object = loop2.getBody();
        JsWhile loopStatement = new JsWhile((JsExpression)loop2.getCondition().accept(new IrElementToJsExpressionTransformer(), context2), object == null ? null : (JsStatement)object.accept(this, context2));
        object = label;
        if (object == null) {
            jsStatement = loopStatement;
        } else {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            JsLabel jsLabel = new JsLabel((JsName)it, loopStatement);
            jsStatement = jsLabel;
        }
        return jsStatement;
    }

    @Override
    @NotNull
    public JsStatement visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @NotNull JsGenerationContext context2) {
        JsStatement jsStatement;
        Intrinsics.checkNotNullParameter(loop2, "loop");
        Intrinsics.checkNotNullParameter(context2, "context");
        JsName label = context2.getNameForLoop(loop2);
        Object object = loop2.getBody();
        JsDoWhile loopStatement = new JsDoWhile((JsExpression)loop2.getCondition().accept(new IrElementToJsExpressionTransformer(), context2), object == null ? null : (JsStatement)object.accept(this, context2));
        object = label;
        if (object == null) {
            jsStatement = loopStatement;
        } else {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            JsLabel jsLabel = new JsLabel((JsName)it, loopStatement);
            jsStatement = jsLabel;
        }
        return jsStatement;
    }

    @Override
    @NotNull
    public <T> JsStatement visitConst(@NotNull IrConst<T> expression2, @NotNull JsGenerationContext data2) {
        return (JsStatement)BaseIrElementToJsNodeTransformer.DefaultImpls.visitConst(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2, @NotNull JsGenerationContext data2) {
        return (JsStatement)BaseIrElementToJsNodeTransformer.DefaultImpls.visitAnonymousInitializer(this, declaration2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitBody(@NotNull IrBody body2, @NotNull JsGenerationContext data2) {
        return (JsStatement)BaseIrElementToJsNodeTransformer.DefaultImpls.visitBody(this, body2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitBranch(@NotNull IrBranch branch, @NotNull JsGenerationContext data2) {
        return (JsStatement)BaseIrElementToJsNodeTransformer.DefaultImpls.visitBranch(this, branch, data2);
    }

    @Override
    @NotNull
    public JsStatement visitBreakContinue(@NotNull IrBreakContinue jump, @NotNull JsGenerationContext data2) {
        return (JsStatement)BaseIrElementToJsNodeTransformer.DefaultImpls.visitBreakContinue(this, jump, data2);
    }

    @Override
    @NotNull
    public JsStatement visitCallableReference(@NotNull IrCallableReference<?> expression2, @NotNull JsGenerationContext data2) {
        return (JsStatement)BaseIrElementToJsNodeTransformer.DefaultImpls.visitCallableReference(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitCatch(@NotNull IrCatch aCatch, @NotNull JsGenerationContext data2) {
        return (JsStatement)BaseIrElementToJsNodeTransformer.DefaultImpls.visitCatch(this, aCatch, data2);
    }

    @Override
    @NotNull
    public JsStatement visitClass(@NotNull IrClass declaration2, @NotNull JsGenerationContext data2) {
        return (JsStatement)BaseIrElementToJsNodeTransformer.DefaultImpls.visitClass(this, declaration2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitClassReference(@NotNull IrClassReference expression2, @NotNull JsGenerationContext data2) {
        return (JsStatement)BaseIrElementToJsNodeTransformer.DefaultImpls.visitClassReference(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitConstructor(@NotNull IrConstructor declaration2, @NotNull JsGenerationContext data2) {
        return (JsStatement)BaseIrElementToJsNodeTransformer.DefaultImpls.visitConstructor(this, declaration2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitConstructorCall(@NotNull IrConstructorCall expression2, @NotNull JsGenerationContext data2) {
        return (JsStatement)BaseIrElementToJsNodeTransformer.DefaultImpls.visitConstructorCall(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitContainerExpression(@NotNull IrContainerExpression expression2, @NotNull JsGenerationContext data2) {
        return (JsStatement)BaseIrElementToJsNodeTransformer.DefaultImpls.visitContainerExpression(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitDeclaration(@NotNull IrDeclarationBase declaration2, @NotNull JsGenerationContext data2) {
        return (JsStatement)BaseIrElementToJsNodeTransformer.DefaultImpls.visitDeclaration(this, declaration2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitDeclarationReference(@NotNull IrDeclarationReference expression2, @NotNull JsGenerationContext data2) {
        return (JsStatement)BaseIrElementToJsNodeTransformer.DefaultImpls.visitDeclarationReference(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitDynamicExpression(@NotNull IrDynamicExpression expression2, @NotNull JsGenerationContext data2) {
        return (JsStatement)BaseIrElementToJsNodeTransformer.DefaultImpls.visitDynamicExpression(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @NotNull JsGenerationContext data2) {
        return (JsStatement)BaseIrElementToJsNodeTransformer.DefaultImpls.visitDynamicMemberExpression(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @NotNull JsGenerationContext data2) {
        return (JsStatement)BaseIrElementToJsNodeTransformer.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitElement(@NotNull IrElement element, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitElement(this, element, data2);
    }

    @Override
    @NotNull
    public JsStatement visitElseBranch(@NotNull IrElseBranch branch, @NotNull JsGenerationContext data2) {
        return (JsStatement)BaseIrElementToJsNodeTransformer.DefaultImpls.visitElseBranch(this, branch, data2);
    }

    @Override
    @NotNull
    public JsStatement visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @NotNull JsGenerationContext data2) {
        return (JsStatement)BaseIrElementToJsNodeTransformer.DefaultImpls.visitEnumConstructorCall(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitEnumEntry(@NotNull IrEnumEntry declaration2, @NotNull JsGenerationContext data2) {
        return (JsStatement)BaseIrElementToJsNodeTransformer.DefaultImpls.visitEnumEntry(this, declaration2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @NotNull JsGenerationContext data2) {
        return (JsStatement)BaseIrElementToJsNodeTransformer.DefaultImpls.visitErrorCallExpression(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2, @NotNull JsGenerationContext data2) {
        return (JsStatement)BaseIrElementToJsNodeTransformer.DefaultImpls.visitErrorDeclaration(this, declaration2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitErrorExpression(@NotNull IrErrorExpression expression2, @NotNull JsGenerationContext data2) {
        return (JsStatement)BaseIrElementToJsNodeTransformer.DefaultImpls.visitErrorExpression(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitExpressionBody(@NotNull IrExpressionBody body2, @NotNull JsGenerationContext data2) {
        return (JsStatement)BaseIrElementToJsNodeTransformer.DefaultImpls.visitExpressionBody(this, body2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2, @NotNull JsGenerationContext data2) {
        return (JsStatement)BaseIrElementToJsNodeTransformer.DefaultImpls.visitExternalPackageFragment(this, declaration2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitField(@NotNull IrField declaration2, @NotNull JsGenerationContext data2) {
        return (JsStatement)BaseIrElementToJsNodeTransformer.DefaultImpls.visitField(this, declaration2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @NotNull JsGenerationContext data2) {
        return (JsStatement)BaseIrElementToJsNodeTransformer.DefaultImpls.visitFieldAccess(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitFile(@NotNull IrFile declaration2, @NotNull JsGenerationContext data2) {
        return (JsStatement)BaseIrElementToJsNodeTransformer.DefaultImpls.visitFile(this, declaration2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @NotNull JsGenerationContext data2) {
        return (JsStatement)BaseIrElementToJsNodeTransformer.DefaultImpls.visitFunctionAccess(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitFunctionExpression(@NotNull IrFunctionExpression expression2, @NotNull JsGenerationContext data2) {
        return (JsStatement)BaseIrElementToJsNodeTransformer.DefaultImpls.visitFunctionExpression(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitFunctionReference(@NotNull IrFunctionReference expression2, @NotNull JsGenerationContext data2) {
        return (JsStatement)BaseIrElementToJsNodeTransformer.DefaultImpls.visitFunctionReference(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitGetClass(@NotNull IrGetClass expression2, @NotNull JsGenerationContext data2) {
        return (JsStatement)BaseIrElementToJsNodeTransformer.DefaultImpls.visitGetClass(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitGetEnumValue(@NotNull IrGetEnumValue expression2, @NotNull JsGenerationContext data2) {
        return (JsStatement)BaseIrElementToJsNodeTransformer.DefaultImpls.visitGetEnumValue(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitGetField(@NotNull IrGetField expression2, @NotNull JsGenerationContext data2) {
        return (JsStatement)BaseIrElementToJsNodeTransformer.DefaultImpls.visitGetField(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitGetObjectValue(@NotNull IrGetObjectValue expression2, @NotNull JsGenerationContext data2) {
        return (JsStatement)BaseIrElementToJsNodeTransformer.DefaultImpls.visitGetObjectValue(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitGetValue(@NotNull IrGetValue expression2, @NotNull JsGenerationContext data2) {
        return (JsStatement)BaseIrElementToJsNodeTransformer.DefaultImpls.visitGetValue(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2, @NotNull JsGenerationContext data2) {
        return (JsStatement)BaseIrElementToJsNodeTransformer.DefaultImpls.visitLocalDelegatedProperty(this, declaration2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @NotNull JsGenerationContext data2) {
        return (JsStatement)BaseIrElementToJsNodeTransformer.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitLoop(@NotNull IrLoop loop2, @NotNull JsGenerationContext data2) {
        return (JsStatement)BaseIrElementToJsNodeTransformer.DefaultImpls.visitLoop(this, loop2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @NotNull JsGenerationContext data2) {
        return (JsStatement)BaseIrElementToJsNodeTransformer.DefaultImpls.visitMemberAccess(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitModuleFragment(@NotNull IrModuleFragment declaration2, @NotNull JsGenerationContext data2) {
        return (JsStatement)BaseIrElementToJsNodeTransformer.DefaultImpls.visitModuleFragment(this, declaration2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitPackageFragment(@NotNull IrPackageFragment declaration2, @NotNull JsGenerationContext data2) {
        return (JsStatement)BaseIrElementToJsNodeTransformer.DefaultImpls.visitPackageFragment(this, declaration2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitProperty(@NotNull IrProperty declaration2, @NotNull JsGenerationContext data2) {
        return (JsStatement)BaseIrElementToJsNodeTransformer.DefaultImpls.visitProperty(this, declaration2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitPropertyReference(@NotNull IrPropertyReference expression2, @NotNull JsGenerationContext data2) {
        return (JsStatement)BaseIrElementToJsNodeTransformer.DefaultImpls.visitPropertyReference(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @NotNull JsGenerationContext data2) {
        return (JsStatement)BaseIrElementToJsNodeTransformer.DefaultImpls.visitRawFunctionReference(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitScript(@NotNull IrScript declaration2, @NotNull JsGenerationContext data2) {
        return (JsStatement)BaseIrElementToJsNodeTransformer.DefaultImpls.visitScript(this, declaration2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitSimpleFunction(@NotNull IrSimpleFunction declaration2, @NotNull JsGenerationContext data2) {
        return (JsStatement)BaseIrElementToJsNodeTransformer.DefaultImpls.visitSimpleFunction(this, declaration2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitSingletonReference(@NotNull IrGetSingletonValue expression2, @NotNull JsGenerationContext data2) {
        return (JsStatement)BaseIrElementToJsNodeTransformer.DefaultImpls.visitSingletonReference(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitSpreadElement(@NotNull IrSpreadElement spread, @NotNull JsGenerationContext data2) {
        return (JsStatement)BaseIrElementToJsNodeTransformer.DefaultImpls.visitSpreadElement(this, spread, data2);
    }

    @Override
    @NotNull
    public JsStatement visitStringConcatenation(@NotNull IrStringConcatenation expression2, @NotNull JsGenerationContext data2) {
        return (JsStatement)BaseIrElementToJsNodeTransformer.DefaultImpls.visitStringConcatenation(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @NotNull JsGenerationContext data2) {
        return (JsStatement)BaseIrElementToJsNodeTransformer.DefaultImpls.visitSuspendableExpression(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @NotNull JsGenerationContext data2) {
        return (JsStatement)BaseIrElementToJsNodeTransformer.DefaultImpls.visitSuspensionPoint(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitSyntheticBody(@NotNull IrSyntheticBody body2, @NotNull JsGenerationContext data2) {
        return (JsStatement)BaseIrElementToJsNodeTransformer.DefaultImpls.visitSyntheticBody(this, body2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitTypeAlias(@NotNull IrTypeAlias declaration2, @NotNull JsGenerationContext data2) {
        return (JsStatement)BaseIrElementToJsNodeTransformer.DefaultImpls.visitTypeAlias(this, declaration2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @NotNull JsGenerationContext data2) {
        return (JsStatement)BaseIrElementToJsNodeTransformer.DefaultImpls.visitTypeOperator(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitTypeParameter(@NotNull IrTypeParameter declaration2, @NotNull JsGenerationContext data2) {
        return (JsStatement)BaseIrElementToJsNodeTransformer.DefaultImpls.visitTypeParameter(this, declaration2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitValueAccess(@NotNull IrValueAccessExpression expression2, @NotNull JsGenerationContext data2) {
        return (JsStatement)BaseIrElementToJsNodeTransformer.DefaultImpls.visitValueAccess(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitValueParameter(@NotNull IrValueParameter declaration2, @NotNull JsGenerationContext data2) {
        return (JsStatement)BaseIrElementToJsNodeTransformer.DefaultImpls.visitValueParameter(this, declaration2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitVararg(@NotNull IrVararg expression2, @NotNull JsGenerationContext data2) {
        return (JsStatement)BaseIrElementToJsNodeTransformer.DefaultImpls.visitVararg(this, expression2, data2);
    }
}

