/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.utils;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CommonCoroutineCodegenUtilKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.CoroutineLanguageVersionSettingsUtilKt;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.js.backend.ast.JsArrayLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsObjectLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;
import org.jetbrains.kotlin.js.backend.ast.metadata.CoroutineMetadata;
import org.jetbrains.kotlin.js.backend.ast.metadata.HasMetadata;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.SideEffectKind;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.context.UsageTracker;
import org.jetbrains.kotlin.js.translate.expression.ExpressionVisitor;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.basic.FunctionIntrinsic;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.basic.FunctionIntrinsicWithReceiverComputed;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.TypeOfFIFKt;
import org.jetbrains.kotlin.js.translate.reference.ReferenceTranslator;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.js.translate.utils.UtilsKt;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.LambdaArgument;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentUnmapped;
import org.jetbrains.kotlin.resolve.calls.model.DataFlowInfoForArguments;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.results.ResolutionStatus;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.checkers.PrimitiveNumericComparisonInfo;
import org.jetbrains.kotlin.resolve.scopes.receivers.Receiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.source.PsiSourceElementKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.utils.DFS;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u0098\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b\u001a&\u0010\n\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f\u001a@\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001\u001a\u0018\u0010\u001c\u001a\u00020\u000f2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u0016\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u0016\u0010!\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u001e\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010%\u001a\u00020$2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u001a\"\u0010&\u001a\u00020'*\u00020\u00182\u0006\u0010(\u001a\u00020\u00122\u0006\u0010)\u001a\u00020$2\u0006\u0010*\u001a\u00020+\u001a\u001a\u0010,\u001a\u00020\b*\u00020\u00182\u0006\u0010-\u001a\u00020\u00142\u0006\u0010.\u001a\u00020\u000f\u001a\u001a\u0010,\u001a\u00020\b*\u00020\u00182\u0006\u0010\t\u001a\u00020\b2\u0006\u0010.\u001a\u00020\u000f\u001a\"\u0010/\u001a\u00020\u0006*\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010-\u001a\u00020\u00142\u0006\u00100\u001a\u00020\u000f\u001a\u0016\u00101\u001a\u00020\u000f*\u00020\u00182\n\u00102\u001a\u0006\u0012\u0002\b\u00030#\u001a\"\u00103\u001a\u00020'*\u0002042\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010-\u001a\u00020\u00142\u0006\u00105\u001a\u00020\u001a\u001a\u0014\u00106\u001a\u0004\u0018\u00010 *\u00020\u00182\u0006\u0010.\u001a\u000207\u001a\u0012\u00108\u001a\u00020 *\u00020\u00182\u0006\u0010.\u001a\u000207\u001a\u0014\u00109\u001a\u0004\u0018\u00010:*\u00020\u00182\u0006\u0010.\u001a\u000207\u001a\n\u0010;\u001a\u00020\u001a*\u00020\u0014\u001a\n\u0010<\u001a\u00020\u001a*\u00020\u0014\u001a\n\u0010=\u001a\u00020 *\u00020 \u001aH\u0010>\u001a\u001a\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H@0\u0005\u0012\u0004\u0012\u0002HA0?0\u0005\"\u0004\b\u0000\u0010@\"\u0004\b\u0001\u0010A*\b\u0012\u0004\u0012\u0002H@0\u00052\u0012\u0010B\u001a\u000e\u0012\u0004\u0012\u0002H@\u0012\u0004\u0012\u0002HA0C\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006D"}, d2={"finalElement", "Lcom/intellij/psi/PsiElement;", "getFinalElement", "(Lcom/intellij/psi/PsiElement;)Lcom/intellij/psi/PsiElement;", "createPrototypeStatements", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "superName", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "name", "definePackageAlias", "", "varName", "tag", "parentRef", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "generateDelegateCall", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "fromDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "toDescriptor", "thisObject", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "detectDefaultParameters", "", "source", "getReferenceToJsClass", "classifierDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "getReferenceToJsClassOrArray", "resolveAccessorCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "suspendPropertyDescriptor", "addAccessorsToPrototype", "", "containingClass", "propertyDescriptor", "literal", "Lorg/jetbrains/kotlin/js/backend/ast/JsObjectLiteral;", "addFunctionButNotExport", "descriptor", "expression", "addFunctionToPrototype", "function", "createCoroutineResult", "resolvedCall", "fillCoroutineMetadata", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "hasController", "getPrecisePrimitiveType", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getPrecisePrimitiveTypeNotNull", "getPrimitiveNumericComparisonInfo", "Lorg/jetbrains/kotlin/resolve/checkers/PrimitiveNumericComparisonInfo;", "hasOrInheritsParametersWithDefaultValue", "hasOwnParametersWithDefaultValue", "refineType", "splitToRanges", "Lkotlin/Pair;", "T", "S", "classifier", "Lkotlin/Function1;", "js.translator"})
public final class UtilsKt {
    @NotNull
    public static final JsStatement generateDelegateCall(@NotNull ClassDescriptor classDescriptor, @NotNull FunctionDescriptor fromDescriptor, @NotNull FunctionDescriptor toDescriptor, @NotNull JsExpression thisObject, @NotNull TranslationContext context2, boolean detectDefaultParameters, @Nullable PsiElement source) {
        Object jsParamName;
        Object object;
        List<ValueParameterDescriptor> list2;
        Object object2;
        Intrinsics.checkNotNullParameter(classDescriptor, "classDescriptor");
        Intrinsics.checkNotNullParameter(fromDescriptor, "fromDescriptor");
        Intrinsics.checkNotNullParameter(toDescriptor, "toDescriptor");
        Intrinsics.checkNotNullParameter(thisObject, "thisObject");
        Intrinsics.checkNotNullParameter(context2, "context");
        JsName overriddenMemberFunctionName = UtilsKt.generateDelegateCall$getNameForFunctionWithPossibleDefaultParam(toDescriptor, detectDefaultParameters, context2);
        JsNameRef overriddenMemberFunctionRef = new JsNameRef(overriddenMemberFunctionName, thisObject);
        SmartList<JsParameter> parameters2 = new SmartList<JsParameter>();
        SmartList<JsNameRef> args2 = new SmartList<JsNameRef>();
        if (DescriptorUtils.isExtension(fromDescriptor)) {
            object2 = JsScope.declareTemporaryName(Namer.getReceiverParameterName());
            Intrinsics.checkNotNullExpressionValue(object2, "declareTemporaryName(Nam\u2026tReceiverParameterName())");
            List<ValueParameterDescriptor> extensionFunctionReceiverName = object2;
            parameters2.add(new JsParameter((JsName)((Object)extensionFunctionReceiverName)));
            args2.add(new JsNameRef((JsName)((Object)extensionFunctionReceiverName)));
        }
        if (fromDescriptor.isSuspend()) {
            object2 = fromDescriptor.getValueParameters();
            Intrinsics.checkNotNullExpressionValue(object2, "fromDescriptor.valueParameters");
            Collection collection = (Collection)object2;
            ValueParameterDescriptor valueParameterDescriptor = context2.getContinuationParameterDescriptor();
            Intrinsics.checkNotNull(valueParameterDescriptor);
            list2 = CollectionsKt.plus(collection, valueParameterDescriptor);
        } else {
            object2 = fromDescriptor.getValueParameters();
            Intrinsics.checkNotNullExpressionValue(object2, "fromDescriptor.valueParameters");
            list2 = object2;
        }
        List<ValueParameterDescriptor> valueParameterDescriptors = list2;
        for (ValueParameterDescriptor param : valueParameterDescriptors) {
            String string2 = param.getName().asString();
            Intrinsics.checkNotNullExpressionValue(string2, "param.name.asString()");
            String paramName = string2;
            object = JsScope.declareTemporaryName(paramName);
            Intrinsics.checkNotNullExpressionValue(object, "declareTemporaryName(paramName)");
            jsParamName = object;
            parameters2.add(new JsParameter((JsName)jsParamName));
            args2.add(new JsNameRef((JsName)jsParamName));
        }
        FunctionIntrinsic intrinsic = context2.intrinsics().getFunctionIntrinsic(toDescriptor, context2);
        JsExpression invocation = intrinsic instanceof FunctionIntrinsicWithReceiverComputed ? ((FunctionIntrinsicWithReceiverComputed)intrinsic).apply(thisObject, (List<? extends JsExpression>)args2, context2) : (JsExpression)new JsInvocation((JsExpression)overriddenMemberFunctionRef, (List<? extends JsExpression>)args2);
        invocation.setSource(source);
        jsParamName = TranslationUtils.simpleReturnFunction(context2.scope(), invocation);
        Intrinsics.checkNotNullExpressionValue(jsParamName, "simpleReturnFunction(context.scope(), invocation)");
        HasMetadata functionObject = jsParamName;
        ((SourceInfoAwareJsNode)functionObject).setSource(source);
        object = source;
        jsParamName = object == null ? null : UtilsKt.getFinalElement((PsiElement)object);
        ((JsFunction)functionObject).getBody().setSource(jsParamName instanceof LeafPsiElement ? (LeafPsiElement)jsParamName : null);
        ((JsFunction)functionObject).getParameters().addAll((Collection<JsParameter>)parameters2);
        if (MetadataProperties.isSuspend((JsExpression)functionObject)) {
            UtilsKt.fillCoroutineMetadata((JsFunction)functionObject, context2, fromDescriptor, false);
        }
        JsName fromFunctionName = UtilsKt.generateDelegateCall$getNameForFunctionWithPossibleDefaultParam(fromDescriptor, detectDefaultParameters, context2);
        JsExpression jsExpression = JsAstUtils.prototypeOf(context2.getInnerReference(classDescriptor));
        Intrinsics.checkNotNullExpressionValue(jsExpression, "prototypeOf(context.getI\u2026ference(classDescriptor))");
        JsExpression prototypeRef = jsExpression;
        JsNameRef functionRef = new JsNameRef(fromFunctionName, prototypeRef);
        JsStatement jsStatement = JsAstUtils.assignment(functionRef, (JsExpression)functionObject).makeStmt();
        Intrinsics.checkNotNullExpressionValue(jsStatement, "assignment(functionRef, functionObject).makeStmt()");
        return jsStatement;
    }

    @NotNull
    public static final <T, S> List<Pair<List<T>, S>> splitToRanges(@NotNull List<? extends T> $this$splitToRanges, @NotNull Function1<? super T, ? extends S> classifier2) {
        Object object;
        Intrinsics.checkNotNullParameter($this$splitToRanges, "<this>");
        Intrinsics.checkNotNullParameter(classifier2, "classifier");
        if ($this$splitToRanges.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        int lastIndex = 0;
        S lastClass = classifier2.invoke($this$splitToRanges.get(0));
        boolean bl = false;
        List result2 = new ArrayList();
        Object object2 = SequencesKt.drop(SequencesKt.withIndex(CollectionsKt.asSequence((Iterable)$this$splitToRanges)), 1).iterator();
        while (object2.hasNext()) {
            object = object2.next();
            int index2 = ((IndexedValue)object).component1();
            Object e = ((IndexedValue)object).component2();
            S cls = classifier2.invoke(e);
            if (Intrinsics.areEqual(cls, lastClass)) continue;
            Collection collection = result2;
            Pair<List<? extends T>, S> pair = new Pair<List<? extends T>, S>($this$splitToRanges.subList(lastIndex, index2), lastClass);
            boolean bl2 = false;
            collection.add(pair);
            lastClass = cls;
            lastIndex = index2;
        }
        object2 = result2;
        object = new Pair<List<? extends T>, S>($this$splitToRanges.subList(lastIndex, $this$splitToRanges.size()), lastClass);
        boolean bl3 = false;
        object2.add(object);
        return result2;
    }

    @NotNull
    public static final JsExpression getReferenceToJsClass(@NotNull KotlinType type2, @NotNull TranslationContext context2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter(context2, "context");
        JsExpression jsExpression = UtilsKt.getReferenceToJsClassOrArray(type2, context2);
        boolean bl = false;
        boolean bl2 = false;
        JsExpression it = jsExpression;
        boolean bl3 = false;
        MetadataProperties.setKType(it, TypeOfFIFKt.createKType(context2, type2));
        return jsExpression;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final JsExpression getReferenceToJsClassOrArray(@NotNull KotlinType type2, @NotNull TranslationContext context2) {
        ClassifierDescriptor classifierDescriptor;
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter(context2, "context");
        ClassifierDescriptor classifierDescriptor2 = type2.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor2 == null) {
            Collection<JsExpression> collection;
            void $this$mapTo$iv$iv;
            Collection<KotlinType> collection2 = type2.getConstructor().getSupertypes();
            Intrinsics.checkNotNullExpressionValue(collection2, "type.constructor.supertypes");
            Iterable $this$map$iv = collection2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                KotlinType kotlinType = (KotlinType)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                JsExpression jsExpression = UtilsKt.getReferenceToJsClass(it.getConstructor().getDeclarationDescriptor(), context2);
                collection.add(jsExpression);
            }
            collection = (List)destination$iv$iv;
            List list2 = collection;
            return new JsArrayLiteral(list2);
        }
        ClassifierDescriptor classifierDescriptor3 = classifierDescriptor = classifierDescriptor2;
        return UtilsKt.getReferenceToJsClass(classifierDescriptor3, context2);
    }

    @NotNull
    public static final JsExpression getReferenceToJsClass(@Nullable ClassifierDescriptor classifierDescriptor, @NotNull TranslationContext context2) {
        Object object;
        Intrinsics.checkNotNullParameter(context2, "context");
        ClassifierDescriptor classifierDescriptor2 = classifierDescriptor;
        if (classifierDescriptor2 instanceof ClassDescriptor) {
            object = ReferenceTranslator.translateAsTypeReference((ClassDescriptor)classifierDescriptor, context2);
        } else if (classifierDescriptor2 instanceof TypeParameterDescriptor) {
            boolean bl = ((TypeParameterDescriptor)classifierDescriptor).isReified();
            boolean bl2 = false;
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl4 = false;
                String string2 = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            Object object2 = context2.usageTracker();
            if (object2 != null) {
                ((UsageTracker)object2).used(classifierDescriptor);
            }
            object2 = context2.captureTypeIfNeedAndGetCapturedName((TypeParameterDescriptor)classifierDescriptor);
            object = object2 == null ? (JsExpression)context2.getNameForDescriptor(classifierDescriptor).makeRef() : object2;
        } else {
            throw new IllegalStateException(Intrinsics.stringPlus("Can't get reference for ", classifierDescriptor));
        }
        JsExpression jsExpression = object;
        Intrinsics.checkNotNullExpressionValue(jsExpression, "when (classifierDescript\u2026criptor\")\n        }\n    }");
        boolean bl = false;
        boolean bl5 = false;
        JsExpression it = jsExpression;
        boolean bl6 = false;
        MetadataProperties.setPrimitiveKClass(it, ExpressionVisitor.getPrimitiveClass(context2, classifierDescriptor));
        return jsExpression;
    }

    @NotNull
    public static final JsStatement addFunctionToPrototype(@NotNull TranslationContext $this$addFunctionToPrototype, @NotNull ClassDescriptor classDescriptor, @NotNull FunctionDescriptor descriptor2, @NotNull JsExpression function2) {
        Intrinsics.checkNotNullParameter($this$addFunctionToPrototype, "<this>");
        Intrinsics.checkNotNullParameter(classDescriptor, "classDescriptor");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(function2, "function");
        JsExpression jsExpression = JsAstUtils.prototypeOf($this$addFunctionToPrototype.getInnerReference(classDescriptor));
        Intrinsics.checkNotNullExpressionValue(jsExpression, "prototypeOf(getInnerReference(classDescriptor))");
        JsExpression prototypeRef = jsExpression;
        JsNameRef functionRef = new JsNameRef($this$addFunctionToPrototype.getNameForDescriptor(descriptor2), prototypeRef);
        JsStatement jsStatement = JsAstUtils.assignment(functionRef, function2).makeStmt();
        Intrinsics.checkNotNullExpressionValue(jsStatement, "assignment(functionRef, function).makeStmt()");
        return jsStatement;
    }

    public static final void addAccessorsToPrototype(@NotNull TranslationContext $this$addAccessorsToPrototype, @NotNull ClassDescriptor containingClass, @NotNull PropertyDescriptor propertyDescriptor, @NotNull JsObjectLiteral literal) {
        Intrinsics.checkNotNullParameter($this$addAccessorsToPrototype, "<this>");
        Intrinsics.checkNotNullParameter(containingClass, "containingClass");
        Intrinsics.checkNotNullParameter(propertyDescriptor, "propertyDescriptor");
        Intrinsics.checkNotNullParameter(literal, "literal");
        JsExpression jsExpression = JsAstUtils.prototypeOf($this$addAccessorsToPrototype.getInnerReference(containingClass));
        Intrinsics.checkNotNullExpressionValue(jsExpression, "prototypeOf(getInnerReference(containingClass))");
        JsExpression prototypeRef = jsExpression;
        JsName jsName = $this$addAccessorsToPrototype.getNameForDescriptor(propertyDescriptor);
        Intrinsics.checkNotNullExpressionValue(jsName, "getNameForDescriptor(propertyDescriptor)");
        JsName propertyName = jsName;
        JsInvocation jsInvocation = JsAstUtils.defineProperty(prototypeRef, propertyName.getIdent(), literal);
        Intrinsics.checkNotNullExpressionValue(jsInvocation, "defineProperty(prototype\u2026pertyName.ident, literal)");
        JsInvocation defineProperty2 = jsInvocation;
        $this$addAccessorsToPrototype.addDeclarationStatement(defineProperty2.makeStmt());
    }

    public static final void fillCoroutineMetadata(@NotNull JsFunction $this$fillCoroutineMetadata, @NotNull TranslationContext context2, @NotNull FunctionDescriptor descriptor2, boolean hasController) {
        Intrinsics.checkNotNullParameter($this$fillCoroutineMetadata, "<this>");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        ModuleDescriptor moduleDescriptor = context2.getCurrentModule();
        LanguageVersionSettings languageVersionSettings = context2.getLanguageVersionSettings();
        Intrinsics.checkNotNullExpressionValue(languageVersionSettings, "context.languageVersionSettings");
        PropertyDescriptor suspendPropertyDescriptor = (PropertyDescriptor)CollectionsKt.first((Iterable)moduleDescriptor.getPackage(CoroutineLanguageVersionSettingsUtilKt.coroutinesIntrinsicsPackageFqName(languageVersionSettings)).getMemberScope().getContributedVariables(CommonCoroutineCodegenUtilKt.getCOROUTINE_SUSPENDED_NAME(), NoLookupLocation.FROM_BACKEND));
        JsExpression suspendObject = CallTranslator.INSTANCE.translateGet(context2, UtilsKt.resolveAccessorCall(suspendPropertyDescriptor, context2), null);
        JsName jsName = context2.getNameForDescriptor(TranslationUtils.getCoroutineDoResumeFunction(context2));
        JsExpression jsExpression = ReferenceTranslator.translateAsTypeReference(TranslationUtils.getCoroutineBaseClass(context2), context2);
        JsName jsName2 = UtilsKt.fillCoroutineMetadata$getCoroutinePropertyName(context2, "state");
        JsName jsName3 = UtilsKt.fillCoroutineMetadata$getCoroutinePropertyName(context2, "exceptionState");
        JsName jsName4 = UtilsKt.fillCoroutineMetadata$getCoroutinePropertyName(context2, "finallyPath");
        JsName jsName5 = UtilsKt.fillCoroutineMetadata$getCoroutinePropertyName(context2, "result");
        JsName jsName6 = UtilsKt.fillCoroutineMetadata$getCoroutinePropertyName(context2, "exception");
        boolean bl = descriptor2.getDispatchReceiverParameter() != null;
        SourceElement sourceElement = descriptor2.getSource();
        Intrinsics.checkNotNullExpressionValue(sourceElement, "descriptor.source");
        PsiElement psiElement = PsiSourceElementKt.getPsi(sourceElement);
        Intrinsics.checkNotNullExpressionValue(jsName, "getNameForDescriptor(Tra\u2026oResumeFunction(context))");
        Intrinsics.checkNotNullExpressionValue(jsExpression, "translateAsTypeReference\u2026eClass(context), context)");
        MetadataProperties.setCoroutineMetadata($this$fillCoroutineMetadata, new CoroutineMetadata(jsName, jsName2, jsName3, jsName4, jsName5, jsName6, jsExpression, suspendObject, hasController, bl, psiElement));
    }

    private static final ResolvedCall<PropertyDescriptor> resolveAccessorCall(PropertyDescriptor suspendPropertyDescriptor, TranslationContext context2) {
        return new ResolvedCall<PropertyDescriptor>(context2, suspendPropertyDescriptor){
            final /* synthetic */ TranslationContext $context;
            final /* synthetic */ PropertyDescriptor $suspendPropertyDescriptor;
            {
                this.$context = $context;
                this.$suspendPropertyDescriptor = $suspendPropertyDescriptor;
            }

            @NotNull
            public ResolutionStatus getStatus() {
                return ResolutionStatus.SUCCESS;
            }

            @NotNull
            public Call getCall() {
                return new Call(this.$context){
                    final /* synthetic */ TranslationContext $context;
                    {
                        this.$context = $context;
                    }

                    @Nullable
                    public ASTNode getCallOperationNode() {
                        return null;
                    }

                    @Nullable
                    public Receiver getExplicitReceiver() {
                        return null;
                    }

                    @Nullable
                    public ReceiverValue getDispatchReceiver() {
                        return null;
                    }

                    @Nullable
                    public KtExpression getCalleeExpression() {
                        return null;
                    }

                    @Nullable
                    public KtValueArgumentList getValueArgumentList() {
                        return null;
                    }

                    @NotNull
                    public List<ValueArgument> getValueArguments() {
                        return CollectionsKt.emptyList();
                    }

                    @NotNull
                    public List<LambdaArgument> getFunctionLiteralArguments() {
                        return CollectionsKt.emptyList();
                    }

                    @NotNull
                    public List<KtTypeProjection> getTypeArguments() {
                        return CollectionsKt.emptyList();
                    }

                    @Nullable
                    public KtTypeArgumentList getTypeArgumentList() {
                        return null;
                    }

                    @NotNull
                    public KtElement getCallElement() {
                        Project project = this.$context.getConfig().getProject();
                        Intrinsics.checkNotNullExpressionValue(project, "context.config.project");
                        return new KtPsiFactory(project, false, 2, null).createExpression("COROUTINE_SUSPENDED");
                    }

                    @NotNull
                    public Call.CallType getCallType() {
                        return Call.CallType.DEFAULT;
                    }
                };
            }

            @NotNull
            public PropertyDescriptor getCandidateDescriptor() {
                return this.$suspendPropertyDescriptor;
            }

            @NotNull
            public PropertyDescriptor getResultingDescriptor() {
                return this.$suspendPropertyDescriptor;
            }

            @Nullable
            public Void getExtensionReceiver() {
                return null;
            }

            @Nullable
            public Void getDispatchReceiver() {
                return null;
            }

            @NotNull
            public ExplicitReceiverKind getExplicitReceiverKind() {
                return ExplicitReceiverKind.NO_EXPLICIT_RECEIVER;
            }

            @NotNull
            public Map<ValueParameterDescriptor, ResolvedValueArgument> getValueArguments() {
                boolean bl = false;
                return new LinkedHashMap<K, V>();
            }

            @NotNull
            public List<ResolvedValueArgument> getValueArgumentsByIndex() {
                boolean bl = false;
                return new ArrayList<E>();
            }

            @NotNull
            public ArgumentUnmapped getArgumentMapping(@NotNull ValueArgument valueArgument) {
                Intrinsics.checkNotNullParameter(valueArgument, "valueArgument");
                return ArgumentUnmapped.INSTANCE;
            }

            @NotNull
            public Map<TypeParameterDescriptor, KotlinType> getTypeArguments() {
                boolean bl = false;
                return new LinkedHashMap<K, V>();
            }

            @NotNull
            public DataFlowInfoForArguments getDataFlowInfoForArguments() {
                throw new IllegalStateException();
            }

            @Nullable
            public KotlinType getSmartCastDispatchReceiverType() {
                return null;
            }
        };
    }

    @NotNull
    public static final JsStatement definePackageAlias(@NotNull String name, @NotNull JsName varName, @NotNull String tag, @NotNull JsExpression parentRef) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(varName, "varName");
        Intrinsics.checkNotNullParameter(tag, "tag");
        Intrinsics.checkNotNullParameter(parentRef, "parentRef");
        JsNameRef selfRef = new JsNameRef(name, parentRef);
        SourceInfoAwareJsNode sourceInfoAwareJsNode = JsAstUtils.or(selfRef, JsAstUtils.assignment(selfRef.deepCopy(), new JsObjectLiteral(false)));
        Intrinsics.checkNotNullExpressionValue(sourceInfoAwareJsNode, "or(selfRef, JsAstUtils.a\u2026 JsObjectLiteral(false)))");
        JsBinaryOperation rhs = sourceInfoAwareJsNode;
        JsVars jsVars = JsAstUtils.newVar(varName, rhs);
        boolean bl = false;
        boolean bl2 = false;
        JsVars $this$definePackageAlias_u24lambda_u2d3 = jsVars;
        boolean bl3 = false;
        Intrinsics.checkNotNullExpressionValue($this$definePackageAlias_u24lambda_u2d3, "");
        MetadataProperties.setExportedPackage($this$definePackageAlias_u24lambda_u2d3, tag);
        sourceInfoAwareJsNode = jsVars;
        Intrinsics.checkNotNullExpressionValue(sourceInfoAwareJsNode, "newVar(varName, rhs).app\u2026{ exportedPackage = tag }");
        return (JsStatement)((Object)sourceInfoAwareJsNode);
    }

    @NotNull
    public static final PsiElement getFinalElement(@NotNull PsiElement $this$finalElement) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter($this$finalElement, "<this>");
        PsiElement psiElement2 = $this$finalElement;
        if (psiElement2 instanceof KtFunctionLiteral) {
            PsiElement psiElement3;
            PsiElement psiElement4 = ((KtFunctionLiteral)$this$finalElement).getRBrace();
            psiElement = psiElement3 = psiElement4 == null ? $this$finalElement : psiElement4;
        } else if (psiElement2 instanceof KtDeclarationWithBody) {
            PsiElement psiElement5;
            PsiElement psiElement6;
            PsiElement psiElement7 = ((KtDeclarationWithBody)$this$finalElement).getBodyBlockExpression();
            PsiElement psiElement8 = psiElement6 = psiElement7 == null ? null : psiElement7.getRBrace();
            psiElement = psiElement5 = psiElement6 == null ? ((psiElement7 = (PsiElement)((KtDeclarationWithBody)$this$finalElement).getBodyExpression()) == null ? $this$finalElement : psiElement7) : psiElement6;
        } else {
            PsiElement psiElement9;
            KtBlockExpression ktBlockExpression;
            PsiElement psiElement10;
            psiElement = psiElement2 instanceof KtLambdaExpression ? (psiElement10 = (ktBlockExpression = ((KtLambdaExpression)$this$finalElement).getBodyExpression()) == null ? $this$finalElement : ((psiElement9 = ktBlockExpression.getRBrace()) == null ? $this$finalElement : psiElement9)) : $this$finalElement;
        }
        return psiElement;
    }

    @NotNull
    public static final JsName addFunctionButNotExport(@NotNull TranslationContext $this$addFunctionButNotExport, @NotNull FunctionDescriptor descriptor2, @NotNull JsExpression expression2) {
        Intrinsics.checkNotNullParameter($this$addFunctionButNotExport, "<this>");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(expression2, "expression");
        JsName jsName = $this$addFunctionButNotExport.getInnerNameForDescriptor(descriptor2);
        Intrinsics.checkNotNullExpressionValue(jsName, "getInnerNameForDescriptor(descriptor)");
        return UtilsKt.addFunctionButNotExport($this$addFunctionButNotExport, jsName, expression2);
    }

    @NotNull
    public static final JsName addFunctionButNotExport(@NotNull TranslationContext $this$addFunctionButNotExport, @NotNull JsName name, @NotNull JsExpression expression2) {
        Intrinsics.checkNotNullParameter($this$addFunctionButNotExport, "<this>");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(expression2, "expression");
        JsExpression jsExpression = expression2;
        if (jsExpression instanceof JsFunction) {
            ((JsFunction)expression2).setName(name);
            $this$addFunctionButNotExport.addDeclarationStatement(expression2.makeStmt());
        } else {
            $this$addFunctionButNotExport.addDeclarationStatement(JsAstUtils.newVar(name, expression2));
        }
        return name;
    }

    @NotNull
    public static final List<JsStatement> createPrototypeStatements(@NotNull JsName superName, @NotNull JsName name) {
        Intrinsics.checkNotNullParameter(superName, "superName");
        Intrinsics.checkNotNullParameter(name, "name");
        JsNameRef jsNameRef = superName.makeRef();
        Intrinsics.checkNotNullExpressionValue(jsNameRef, "superName.makeRef()");
        JsNameRef superclassRef = jsNameRef;
        JsExpression jsExpression = JsAstUtils.prototypeOf(superclassRef);
        Intrinsics.checkNotNullExpressionValue(jsExpression, "prototypeOf(superclassRef)");
        JsExpression superPrototype = jsExpression;
        JsExpression[] jsExpressionArray = new JsExpression[]{superPrototype};
        JsInvocation superPrototypeInstance = new JsInvocation((JsExpression)new JsNameRef("create", "Object"), jsExpressionArray);
        JsNameRef jsNameRef2 = name.makeRef();
        Intrinsics.checkNotNullExpressionValue(jsNameRef2, "name.makeRef()");
        JsNameRef classRef = jsNameRef2;
        JsExpression jsExpression2 = JsAstUtils.prototypeOf(classRef);
        Intrinsics.checkNotNullExpressionValue(jsExpression2, "prototypeOf(classRef)");
        JsExpression prototype = jsExpression2;
        JsStatement jsStatement = JsAstUtils.assignment(prototype, superPrototypeInstance).makeStmt();
        Intrinsics.checkNotNullExpressionValue(jsStatement, "assignment(prototype, su\u2026otypeInstance).makeStmt()");
        JsStatement prototypeStatement = jsStatement;
        JsNameRef constructorRef = new JsNameRef("constructor", prototype.deepCopy());
        JsStatement[] jsStatementArray = JsAstUtils.assignment(constructorRef, classRef.deepCopy()).makeStmt();
        Intrinsics.checkNotNullExpressionValue(jsStatementArray, "assignment(constructorRe\u2026ef.deepCopy()).makeStmt()");
        JsStatement[] constructorStatement = jsStatementArray;
        jsStatementArray = new JsStatement[]{prototypeStatement, constructorStatement};
        return CollectionsKt.listOf(jsStatementArray);
    }

    @NotNull
    public static final JsExpression createCoroutineResult(@NotNull TranslationContext $this$createCoroutineResult, @NotNull ResolvedCall<?> resolvedCall2) {
        Intrinsics.checkNotNullParameter($this$createCoroutineResult, "<this>");
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        KtElement ktElement = resolvedCall2.getCall().getCallElement();
        Intrinsics.checkNotNullExpressionValue(ktElement, "resolvedCall.call.callElement");
        KtElement callElement = ktElement;
        JsExpression coroutineRef = TranslationUtils.translateContinuationArgument($this$createCoroutineResult).source(callElement);
        JsNameRef jsNameRef = new JsNameRef("$$coroutineResult$$", coroutineRef);
        boolean bl = false;
        boolean bl2 = false;
        JsNameRef $this$createCoroutineResult_u24lambda_u2d4 = jsNameRef;
        boolean bl3 = false;
        MetadataProperties.setSideEffects($this$createCoroutineResult_u24lambda_u2d4, SideEffectKind.DEPENDS_ON_STATE);
        $this$createCoroutineResult_u24lambda_u2d4.setSource(callElement);
        MetadataProperties.setCoroutineResult($this$createCoroutineResult_u24lambda_u2d4, true);
        MetadataProperties.setSynthetic($this$createCoroutineResult_u24lambda_u2d4, true);
        return jsNameRef;
    }

    @NotNull
    public static final KotlinType refineType(@NotNull KotlinType $this$refineType) {
        KotlinType kotlinType;
        block1: {
            Intrinsics.checkNotNullParameter($this$refineType, "<this>");
            Iterable<KotlinType> iterable = TypeUtils.getAllSupertypes($this$refineType);
            Intrinsics.checkNotNullExpressionValue(iterable, "getAllSupertypes(this)");
            iterable = iterable;
            boolean bl = false;
            Iterable<KotlinType> iterable2 = iterable;
            boolean bl2 = false;
            Iterator<KotlinType> iterator2 = iterable2.iterator();
            while (iterator2.hasNext()) {
                KotlinType kotlinType2;
                KotlinType p0 = kotlinType2 = iterator2.next();
                boolean bl3 = false;
                if (!KotlinBuiltIns.isPrimitiveTypeOrNullablePrimitiveType(p0)) continue;
                kotlinType = kotlinType2;
                break block1;
            }
            kotlinType = null;
        }
        KotlinType kotlinType3 = kotlinType;
        return kotlinType3 == null ? $this$refineType : kotlinType3;
    }

    @Nullable
    public static final KotlinType getPrecisePrimitiveType(@NotNull TranslationContext $this$getPrecisePrimitiveType, @NotNull KtExpression expression2) {
        KotlinType kotlinType;
        Intrinsics.checkNotNullParameter($this$getPrecisePrimitiveType, "<this>");
        Intrinsics.checkNotNullParameter(expression2, "expression");
        BindingContext bindingContext = $this$getPrecisePrimitiveType.bindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext, "bindingContext()");
        BindingContext bindingContext2 = bindingContext;
        KotlinType kotlinType2 = bindingContext2.getType(expression2);
        if (kotlinType2 == null) {
            return null;
        }
        KotlinType ktType = kotlinType = kotlinType2;
        return UtilsKt.refineType(ktType);
    }

    @NotNull
    public static final KotlinType getPrecisePrimitiveTypeNotNull(@NotNull TranslationContext $this$getPrecisePrimitiveTypeNotNull, @NotNull KtExpression expression2) {
        Intrinsics.checkNotNullParameter($this$getPrecisePrimitiveTypeNotNull, "<this>");
        Intrinsics.checkNotNullParameter(expression2, "expression");
        KotlinType kotlinType = UtilsKt.getPrecisePrimitiveType($this$getPrecisePrimitiveTypeNotNull, expression2);
        if (kotlinType == null) {
            throw new IllegalStateException(Intrinsics.stringPlus("Type must be not null for ", expression2));
        }
        return kotlinType;
    }

    @Nullable
    public static final PrimitiveNumericComparisonInfo getPrimitiveNumericComparisonInfo(@NotNull TranslationContext $this$getPrimitiveNumericComparisonInfo, @NotNull KtExpression expression2) {
        Intrinsics.checkNotNullParameter($this$getPrimitiveNumericComparisonInfo, "<this>");
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Object object = $this$getPrimitiveNumericComparisonInfo.getConfig().getConfiguration();
        Intrinsics.checkNotNullExpressionValue(object, "config.configuration");
        object = CommonConfigurationKeysKt.getLanguageVersionSettings((CompilerConfiguration)object);
        boolean bl = false;
        boolean bl2 = false;
        Object it = object;
        boolean bl3 = false;
        return it.supportsFeature(LanguageFeature.ProperIeee754Comparisons) ? (PrimitiveNumericComparisonInfo)$this$getPrimitiveNumericComparisonInfo.bindingContext().get(BindingContext.PRIMITIVE_NUMERIC_COMPARISON_INFO, expression2) : (PrimitiveNumericComparisonInfo)null;
    }

    public static final boolean hasOrInheritsParametersWithDefaultValue(@NotNull FunctionDescriptor $this$hasOrInheritsParametersWithDefaultValue) {
        Intrinsics.checkNotNullParameter($this$hasOrInheritsParametersWithDefaultValue, "<this>");
        Boolean bl = DFS.ifAny((Collection)CollectionsKt.listOf($this$hasOrInheritsParametersWithDefaultValue), UtilsKt::hasOrInheritsParametersWithDefaultValue$lambda-7, hasOrInheritsParametersWithDefaultValue.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(bl, "ifAny(\n    listOf(this),\u2026ersWithDefaultValue() }\n)");
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean hasOwnParametersWithDefaultValue(@NotNull FunctionDescriptor $this$hasOwnParametersWithDefaultValue) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$hasOwnParametersWithDefaultValue, "<this>");
        List<ValueParameterDescriptor> list2 = $this$hasOwnParametersWithDefaultValue.getOriginal().getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list2, "original.valueParameters");
        Iterable $this$any$iv = list2;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
            boolean bl2 = false;
            if (it.declaresDefaultValue()) return true;
            Intrinsics.checkNotNullExpressionValue(it, "it");
            if (ArgumentsUtilsKt.isActualParameterWithCorrespondingExpectedDefault(it)) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    private static final JsName generateDelegateCall$getNameForFunctionWithPossibleDefaultParam(FunctionDescriptor $this$generateDelegateCall_u24getNameForFunctionWithPossibleDefaultParam, boolean $detectDefaultParameters, TranslationContext $context) {
        JsName jsName = $detectDefaultParameters && UtilsKt.hasOrInheritsParametersWithDefaultValue($this$generateDelegateCall_u24getNameForFunctionWithPossibleDefaultParam) ? $context.scope().declareName(Intrinsics.stringPlus($context.getNameForDescriptor($this$generateDelegateCall_u24getNameForFunctionWithPossibleDefaultParam).getIdent(), "$default")) : $context.getNameForDescriptor($this$generateDelegateCall_u24getNameForFunctionWithPossibleDefaultParam);
        Intrinsics.checkNotNullExpressionValue(jsName, "if (detectDefaultParamet\u2026escriptor(this)\n        }");
        return jsName;
    }

    private static final JsName fillCoroutineMetadata$getCoroutinePropertyName(TranslationContext $context, String id) {
        JsName jsName = $context.getNameForDescriptor(TranslationUtils.getCoroutineProperty($context, id));
        Intrinsics.checkNotNullExpressionValue(jsName, "context.getNameForDescri\u2026ineProperty(context, id))");
        return jsName;
    }

    /*
     * WARNING - void declaration
     */
    private static final Iterable hasOrInheritsParametersWithDefaultValue$lambda-7(FunctionDescriptor current) {
        void $this$mapTo$iv$iv;
        Collection<? extends FunctionDescriptor> collection = current.getOverriddenDescriptors();
        Intrinsics.checkNotNullExpressionValue(collection, "current.overriddenDescriptors");
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FunctionDescriptor functionDescriptor = (FunctionDescriptor)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            FunctionDescriptor functionDescriptor2 = it.getOriginal();
            collection2.add(functionDescriptor2);
        }
        return (List)destination$iv$iv;
    }
}

