/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrAttributeContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.NameUtils;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001:\u0002\u0013\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH$J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0006H$J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0006H$R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/InventNamesForLocalClasses;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "allowTopLevelCallables", "", "(Z)V", "computeTopLevelClassName", "", "clazz", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "putLocalClassName", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrAttributeContainer;", "localClassName", "sanitizeNameIfNeeded", "name", "Data", "NameInventor", "ir.backend.common"})
public abstract class InventNamesForLocalClasses
implements FileLoweringPass {
    private final boolean allowTopLevelCallables;

    public InventNamesForLocalClasses(boolean allowTopLevelCallables) {
        this.allowTopLevelCallables = allowTopLevelCallables;
    }

    @NotNull
    protected abstract String computeTopLevelClassName(@NotNull IrClass var1);

    @NotNull
    protected abstract String sanitizeNameIfNeeded(@NotNull String var1);

    protected abstract void putLocalClassName(@NotNull IrAttributeContainer var1, @NotNull String var2);

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter(irFile, "irFile");
        irFile.accept(new NameInventor(), new Data(null, false));
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0003\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000b\u0010\n\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0005H\u00c6\u0003J\u001f\u0010\f\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\u0006\u0010\u0011\u001a\u00020\u0000J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\t\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/InventNamesForLocalClasses$Data;", "", "enclosingName", "", "isLocal", "", "(Ljava/lang/String;Z)V", "getEnclosingName", "()Ljava/lang/String;", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "makeLocal", "toString", "ir.backend.common"})
    private static final class Data {
        @Nullable
        private final String enclosingName;
        private final boolean isLocal;

        public Data(@Nullable String enclosingName, boolean isLocal) {
            this.enclosingName = enclosingName;
            this.isLocal = isLocal;
        }

        @Nullable
        public final String getEnclosingName() {
            return this.enclosingName;
        }

        public final boolean isLocal() {
            return this.isLocal;
        }

        @NotNull
        public final Data makeLocal() {
            return this.isLocal ? this : Data.copy$default(this, null, true, 1, null);
        }

        @Nullable
        public final String component1() {
            return this.enclosingName;
        }

        public final boolean component2() {
            return this.isLocal;
        }

        @NotNull
        public final Data copy(@Nullable String enclosingName, boolean isLocal) {
            return new Data(enclosingName, isLocal);
        }

        public static /* synthetic */ Data copy$default(Data data2, String string2, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = data2.enclosingName;
            }
            if ((n & 2) != 0) {
                bl = data2.isLocal;
            }
            return data2.copy(string2, bl);
        }

        @NotNull
        public String toString() {
            return "Data(enclosingName=" + this.enclosingName + ", isLocal=" + this.isLocal + ')';
        }

        public int hashCode() {
            int result2 = this.enclosingName == null ? 0 : this.enclosingName.hashCode();
            int n = this.isLocal ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result2 = result2 * 31 + n;
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Data)) {
                return false;
            }
            Data data2 = (Data)other;
            if (!Intrinsics.areEqual(this.enclosingName, data2.enclosingName)) {
                return false;
            }
            return this.isLocal == data2.isLocal;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u000b\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u0003H\u0002J\u0018\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\u0018\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\u0018\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\u0018\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\u0018\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\u0018\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u001c2\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\u0018\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u001e2\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\u0018\u0010\u001f\u001a\u00020\u00022\u0006\u0010 \u001a\u00020!2\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\u0018\u0010\"\u001a\u00020\u00022\u0006\u0010 \u001a\u00020#2\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\u0018\u0010$\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020%2\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\u0018\u0010&\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020'2\u0006\u0010\u000e\u001a\u00020\u0003H\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/InventNamesForLocalClasses$NameInventor;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementVisitor;", "", "Lorg/jetbrains/kotlin/backend/common/lower/InventNamesForLocalClasses$Data;", "(Lorg/jetbrains/kotlin/backend/common/lower/InventNamesForLocalClasses;)V", "anonymousClassesCount", "", "", "", "localFunctionNames", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "inventName", "sourceName", "Lorg/jetbrains/kotlin/name/Name;", "data", "visitAnonymousInitializer", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrAnonymousInitializer;", "visitClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "visitConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "visitDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationBase;", "visitElement", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "visitEnumEntry", "Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "visitField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "visitFunctionReference", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "visitPropertyReference", "Lorg/jetbrains/kotlin/ir/expressions/IrPropertyReference;", "visitSimpleFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "visitValueParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "ir.backend.common"})
    private final class NameInventor
    implements IrElementVisitor<Unit, Data> {
        @NotNull
        private final Map<String, Integer> anonymousClassesCount;
        @NotNull
        private final Map<IrFunctionSymbol, String> localFunctionNames;

        public NameInventor() {
            Intrinsics.checkNotNullParameter(InventNamesForLocalClasses.this, "this$0");
            boolean bl = false;
            this.anonymousClassesCount = new LinkedHashMap();
            bl = false;
            this.localFunctionNames = new LinkedHashMap();
        }

        @Override
        public void visitClass(@NotNull IrClass declaration2, @NotNull Data data2) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            Intrinsics.checkNotNullParameter(data2, "data");
            if (!data2.isLocal()) {
                String enclosingName = data2.getEnclosingName();
                String internalName2 = enclosingName != null ? enclosingName + '$' + declaration2.getName().asString() : InventNamesForLocalClasses.this.computeTopLevelClassName(declaration2);
                declaration2.acceptChildren(this, Data.copy$default(data2, internalName2, false, 2, null));
                return;
            }
            String internalName3 = this.inventName(declaration2.getName(), data2);
            InventNamesForLocalClasses.this.putLocalClassName(declaration2, internalName3);
            Data newData = Data.copy$default(data2, internalName3, false, 2, null);
            Data newDataForConstructor = IrUtilsKt.isAnonymousObject(declaration2) ? data2 : newData;
            for (IrDeclaration child : declaration2.getDeclarations()) {
                child.accept(this, child instanceof IrConstructor ? newDataForConstructor : newData);
            }
        }

        @Override
        public void visitConstructor(@NotNull IrConstructor declaration2, @NotNull Data data2) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            Intrinsics.checkNotNullParameter(data2, "data");
            declaration2.acceptChildren(this, data2.makeLocal());
        }

        @Override
        public void visitDeclaration(@NotNull IrDeclarationBase declaration2, @NotNull Data data2) {
            String string2;
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            Intrinsics.checkNotNullParameter(data2, "data");
            if (!(declaration2 instanceof IrDeclarationWithName) || Intrinsics.areEqual(declaration2.getOrigin(), IrDeclarationOrigin.FOR_LOOP_ITERATOR.INSTANCE) || Intrinsics.areEqual(declaration2.getOrigin(), IrDeclarationOrigin.IR_TEMPORARY_VARIABLE.INSTANCE) || Intrinsics.areEqual(declaration2.getOrigin(), IrDeclarationOrigin.PROPERTY_DELEGATE.INSTANCE)) {
                declaration2.acceptChildren(this, data2);
                return;
            }
            String enclosingName = data2.getEnclosingName();
            String string3 = ((IrDeclarationWithName)((Object)declaration2)).getName().asString();
            Intrinsics.checkNotNullExpressionValue(string3, "declaration.name.asString()");
            String simpleName2 = string3;
            if (declaration2 instanceof IrFunction && !NameUtils.hasName(((IrDeclarationWithName)((Object)declaration2)).getName())) {
                String string4 = this.inventName(null, data2);
                boolean bl = false;
                boolean bl2 = false;
                String name = string4;
                boolean bl3 = false;
                Map<IrFunctionSymbol, String> map = this.localFunctionNames;
                IrFunctionSymbol irFunctionSymbol = ((IrFunction)declaration2).getSymbol();
                boolean bl4 = false;
                map.put(irFunctionSymbol, name);
                string2 = string4;
            } else {
                string2 = enclosingName != null ? enclosingName + '$' + simpleName2 : simpleName2;
            }
            String internalName2 = string2;
            Data newData = data2.copy(internalName2, true);
            if (declaration2 instanceof IrProperty && ((IrProperty)declaration2).isDelegated() || declaration2 instanceof IrLocalDelegatedProperty) {
                this.inventName(null, newData);
            }
            declaration2.acceptChildren(this, newData);
        }

        @Override
        public void visitFunctionReference(@NotNull IrFunctionReference expression2, @NotNull Data data2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(data2, "data");
            String string2 = this.localFunctionNames.get(expression2.getSymbol());
            String internalName2 = string2 == null ? this.inventName(null, data2) : string2;
            InventNamesForLocalClasses.this.putLocalClassName(expression2, internalName2);
            expression2.acceptChildren(this, data2);
        }

        @Override
        public void visitPropertyReference(@NotNull IrPropertyReference expression2, @NotNull Data data2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(data2, "data");
            String internalName2 = this.inventName(null, data2);
            InventNamesForLocalClasses.this.putLocalClassName(expression2, internalName2);
            expression2.acceptChildren(this, data2);
        }

        @Override
        public void visitEnumEntry(@NotNull IrEnumEntry declaration2, @NotNull Data data2) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            Intrinsics.checkNotNullParameter(data2, "data");
            declaration2.acceptChildren(this, data2.makeLocal());
        }

        @Override
        public void visitValueParameter(@NotNull IrValueParameter declaration2, @NotNull Data data2) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            Intrinsics.checkNotNullParameter(data2, "data");
            declaration2.acceptChildren(this, data2.makeLocal());
        }

        @Override
        public void visitSimpleFunction(@NotNull IrSimpleFunction declaration2, @NotNull Data data2) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            Intrinsics.checkNotNullParameter(data2, "data");
            if (declaration2.getCorrespondingPropertySymbol() != null) {
                declaration2.acceptChildren(this, data2.makeLocal());
                return;
            }
            if (declaration2.isSuspend() && declaration2.getBody() != null && !Intrinsics.areEqual(declaration2.getOrigin(), IrDeclarationOrigin.LOCAL_FUNCTION_FOR_LAMBDA.INSTANCE)) {
                Data newData = Data.copy$default(data2, this.inventName(declaration2.getName(), data2.getEnclosingName() == null && InventNamesForLocalClasses.this.allowTopLevelCallables ? Data.copy$default(data2, "", false, 2, null) : data2), false, 2, null);
                String internalName2 = this.inventName(null, newData);
                InventNamesForLocalClasses.this.putLocalClassName(declaration2, internalName2);
            }
            IrElementVisitor.DefaultImpls.visitSimpleFunction(this, declaration2, data2);
        }

        @Override
        public void visitField(@NotNull IrField declaration2, @NotNull Data data2) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            Intrinsics.checkNotNullParameter(data2, "data");
            declaration2.acceptChildren(this, data2.makeLocal());
        }

        @Override
        public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2, @NotNull Data data2) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            Intrinsics.checkNotNullParameter(data2, "data");
            declaration2.acceptChildren(this, data2.makeLocal());
        }

        @Override
        public void visitElement(@NotNull IrElement element, @NotNull Data data2) {
            Intrinsics.checkNotNullParameter(element, "element");
            Intrinsics.checkNotNullParameter(data2, "data");
            element.acceptChildren(this, data2);
        }

        private final String inventName(Name sourceName, Data data2) {
            Comparable comparable;
            String enclosingName = data2.getEnclosingName();
            boolean bl = enclosingName != null;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string2 = StringsKt.trimIndent("\n                    There should be at least one name in the stack for every local declaration that needs a name\n                    Source name: " + sourceName + "\n                    Data: " + data2 + "\n                ");
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            if (sourceName == null || sourceName.isSpecial()) {
                Object object = this.anonymousClassesCount.get(enclosingName);
                int count = (object == null ? 0 : (Integer)object) + 1;
                object = this.anonymousClassesCount;
                Integer n = count;
                boolean bl5 = false;
                object.put(enclosingName, n);
                comparable = (Comparable)((Object)String.valueOf(count));
            } else {
                comparable = sourceName;
            }
            Comparable simpleName2 = comparable;
            return InventNamesForLocalClasses.this.sanitizeNameIfNeeded(enclosingName + '$' + simpleName2);
        }

        @Override
        public <T> void visitConst(@NotNull IrConst<T> expression2, @NotNull Data data2) {
            IrElementVisitor.DefaultImpls.visitConst(this, expression2, data2);
        }

        @Override
        public void visitBlock(@NotNull IrBlock expression2, @NotNull Data data2) {
            IrElementVisitor.DefaultImpls.visitBlock(this, expression2, data2);
        }

        @Override
        public void visitBlockBody(@NotNull IrBlockBody body2, @NotNull Data data2) {
            IrElementVisitor.DefaultImpls.visitBlockBody(this, body2, data2);
        }

        @Override
        public void visitBody(@NotNull IrBody body2, @NotNull Data data2) {
            IrElementVisitor.DefaultImpls.visitBody(this, body2, data2);
        }

        @Override
        public void visitBranch(@NotNull IrBranch branch, @NotNull Data data2) {
            IrElementVisitor.DefaultImpls.visitBranch(this, branch, data2);
        }

        @Override
        public void visitBreak(@NotNull IrBreak jump, @NotNull Data data2) {
            IrElementVisitor.DefaultImpls.visitBreak(this, jump, data2);
        }

        @Override
        public void visitBreakContinue(@NotNull IrBreakContinue jump, @NotNull Data data2) {
            IrElementVisitor.DefaultImpls.visitBreakContinue(this, jump, data2);
        }

        @Override
        public void visitCall(@NotNull IrCall expression2, @NotNull Data data2) {
            IrElementVisitor.DefaultImpls.visitCall(this, expression2, data2);
        }

        @Override
        public void visitCallableReference(@NotNull IrCallableReference<?> expression2, @NotNull Data data2) {
            IrElementVisitor.DefaultImpls.visitCallableReference(this, expression2, data2);
        }

        @Override
        public void visitCatch(@NotNull IrCatch aCatch, @NotNull Data data2) {
            IrElementVisitor.DefaultImpls.visitCatch(this, aCatch, data2);
        }

        @Override
        public void visitClassReference(@NotNull IrClassReference expression2, @NotNull Data data2) {
            IrElementVisitor.DefaultImpls.visitClassReference(this, expression2, data2);
        }

        @Override
        public void visitComposite(@NotNull IrComposite expression2, @NotNull Data data2) {
            IrElementVisitor.DefaultImpls.visitComposite(this, expression2, data2);
        }

        @Override
        public void visitConstructorCall(@NotNull IrConstructorCall expression2, @NotNull Data data2) {
            IrElementVisitor.DefaultImpls.visitConstructorCall(this, expression2, data2);
        }

        @Override
        public void visitContainerExpression(@NotNull IrContainerExpression expression2, @NotNull Data data2) {
            IrElementVisitor.DefaultImpls.visitContainerExpression(this, expression2, data2);
        }

        @Override
        public void visitContinue(@NotNull IrContinue jump, @NotNull Data data2) {
            IrElementVisitor.DefaultImpls.visitContinue(this, jump, data2);
        }

        @Override
        public void visitDeclarationReference(@NotNull IrDeclarationReference expression2, @NotNull Data data2) {
            IrElementVisitor.DefaultImpls.visitDeclarationReference(this, expression2, data2);
        }

        @Override
        public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @NotNull Data data2) {
            IrElementVisitor.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data2);
        }

        @Override
        public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @NotNull Data data2) {
            IrElementVisitor.DefaultImpls.visitDoWhileLoop(this, loop2, data2);
        }

        @Override
        public void visitDynamicExpression(@NotNull IrDynamicExpression expression2, @NotNull Data data2) {
            IrElementVisitor.DefaultImpls.visitDynamicExpression(this, expression2, data2);
        }

        @Override
        public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @NotNull Data data2) {
            IrElementVisitor.DefaultImpls.visitDynamicMemberExpression(this, expression2, data2);
        }

        @Override
        public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @NotNull Data data2) {
            IrElementVisitor.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data2);
        }

        @Override
        public void visitElseBranch(@NotNull IrElseBranch branch, @NotNull Data data2) {
            IrElementVisitor.DefaultImpls.visitElseBranch(this, branch, data2);
        }

        @Override
        public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @NotNull Data data2) {
            IrElementVisitor.DefaultImpls.visitEnumConstructorCall(this, expression2, data2);
        }

        @Override
        public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @NotNull Data data2) {
            IrElementVisitor.DefaultImpls.visitErrorCallExpression(this, expression2, data2);
        }

        @Override
        public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2, @NotNull Data data2) {
            IrElementVisitor.DefaultImpls.visitErrorDeclaration(this, declaration2, data2);
        }

        @Override
        public void visitErrorExpression(@NotNull IrErrorExpression expression2, @NotNull Data data2) {
            IrElementVisitor.DefaultImpls.visitErrorExpression(this, expression2, data2);
        }

        @Override
        public void visitExpression(@NotNull IrExpression expression2, @NotNull Data data2) {
            IrElementVisitor.DefaultImpls.visitExpression(this, expression2, data2);
        }

        @Override
        public void visitExpressionBody(@NotNull IrExpressionBody body2, @NotNull Data data2) {
            IrElementVisitor.DefaultImpls.visitExpressionBody(this, body2, data2);
        }

        @Override
        public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2, @NotNull Data data2) {
            IrElementVisitor.DefaultImpls.visitExternalPackageFragment(this, declaration2, data2);
        }

        @Override
        public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @NotNull Data data2) {
            IrElementVisitor.DefaultImpls.visitFieldAccess(this, expression2, data2);
        }

        @Override
        public void visitFile(@NotNull IrFile declaration2, @NotNull Data data2) {
            IrElementVisitor.DefaultImpls.visitFile(this, declaration2, data2);
        }

        @Override
        public void visitFunction(@NotNull IrFunction declaration2, @NotNull Data data2) {
            IrElementVisitor.DefaultImpls.visitFunction(this, declaration2, data2);
        }

        @Override
        public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @NotNull Data data2) {
            IrElementVisitor.DefaultImpls.visitFunctionAccess(this, expression2, data2);
        }

        @Override
        public void visitFunctionExpression(@NotNull IrFunctionExpression expression2, @NotNull Data data2) {
            IrElementVisitor.DefaultImpls.visitFunctionExpression(this, expression2, data2);
        }

        @Override
        public void visitGetClass(@NotNull IrGetClass expression2, @NotNull Data data2) {
            IrElementVisitor.DefaultImpls.visitGetClass(this, expression2, data2);
        }

        @Override
        public void visitGetEnumValue(@NotNull IrGetEnumValue expression2, @NotNull Data data2) {
            IrElementVisitor.DefaultImpls.visitGetEnumValue(this, expression2, data2);
        }

        @Override
        public void visitGetField(@NotNull IrGetField expression2, @NotNull Data data2) {
            IrElementVisitor.DefaultImpls.visitGetField(this, expression2, data2);
        }

        @Override
        public void visitGetObjectValue(@NotNull IrGetObjectValue expression2, @NotNull Data data2) {
            IrElementVisitor.DefaultImpls.visitGetObjectValue(this, expression2, data2);
        }

        @Override
        public void visitGetValue(@NotNull IrGetValue expression2, @NotNull Data data2) {
            IrElementVisitor.DefaultImpls.visitGetValue(this, expression2, data2);
        }

        @Override
        public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @NotNull Data data2) {
            IrElementVisitor.DefaultImpls.visitInstanceInitializerCall(this, expression2, data2);
        }

        @Override
        public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2, @NotNull Data data2) {
            IrElementVisitor.DefaultImpls.visitLocalDelegatedProperty(this, declaration2, data2);
        }

        @Override
        public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @NotNull Data data2) {
            IrElementVisitor.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data2);
        }

        @Override
        public void visitLoop(@NotNull IrLoop loop2, @NotNull Data data2) {
            IrElementVisitor.DefaultImpls.visitLoop(this, loop2, data2);
        }

        @Override
        public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @NotNull Data data2) {
            IrElementVisitor.DefaultImpls.visitMemberAccess(this, expression2, data2);
        }

        @Override
        public void visitModuleFragment(@NotNull IrModuleFragment declaration2, @NotNull Data data2) {
            IrElementVisitor.DefaultImpls.visitModuleFragment(this, declaration2, data2);
        }

        @Override
        public void visitPackageFragment(@NotNull IrPackageFragment declaration2, @NotNull Data data2) {
            IrElementVisitor.DefaultImpls.visitPackageFragment(this, declaration2, data2);
        }

        @Override
        public void visitProperty(@NotNull IrProperty declaration2, @NotNull Data data2) {
            IrElementVisitor.DefaultImpls.visitProperty(this, declaration2, data2);
        }

        @Override
        public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @NotNull Data data2) {
            IrElementVisitor.DefaultImpls.visitRawFunctionReference(this, expression2, data2);
        }

        @Override
        public void visitReturn(@NotNull IrReturn expression2, @NotNull Data data2) {
            IrElementVisitor.DefaultImpls.visitReturn(this, expression2, data2);
        }

        @Override
        public void visitScript(@NotNull IrScript declaration2, @NotNull Data data2) {
            IrElementVisitor.DefaultImpls.visitScript(this, declaration2, data2);
        }

        @Override
        public void visitSetField(@NotNull IrSetField expression2, @NotNull Data data2) {
            IrElementVisitor.DefaultImpls.visitSetField(this, expression2, data2);
        }

        @Override
        public void visitSetValue(@NotNull IrSetValue expression2, @NotNull Data data2) {
            IrElementVisitor.DefaultImpls.visitSetValue(this, expression2, data2);
        }

        @Override
        public void visitSingletonReference(@NotNull IrGetSingletonValue expression2, @NotNull Data data2) {
            IrElementVisitor.DefaultImpls.visitSingletonReference(this, expression2, data2);
        }

        @Override
        public void visitSpreadElement(@NotNull IrSpreadElement spread, @NotNull Data data2) {
            IrElementVisitor.DefaultImpls.visitSpreadElement(this, spread, data2);
        }

        @Override
        public void visitStringConcatenation(@NotNull IrStringConcatenation expression2, @NotNull Data data2) {
            IrElementVisitor.DefaultImpls.visitStringConcatenation(this, expression2, data2);
        }

        @Override
        public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @NotNull Data data2) {
            IrElementVisitor.DefaultImpls.visitSuspendableExpression(this, expression2, data2);
        }

        @Override
        public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @NotNull Data data2) {
            IrElementVisitor.DefaultImpls.visitSuspensionPoint(this, expression2, data2);
        }

        @Override
        public void visitSyntheticBody(@NotNull IrSyntheticBody body2, @NotNull Data data2) {
            IrElementVisitor.DefaultImpls.visitSyntheticBody(this, body2, data2);
        }

        @Override
        public void visitThrow(@NotNull IrThrow expression2, @NotNull Data data2) {
            IrElementVisitor.DefaultImpls.visitThrow(this, expression2, data2);
        }

        @Override
        public void visitTry(@NotNull IrTry aTry, @NotNull Data data2) {
            IrElementVisitor.DefaultImpls.visitTry(this, aTry, data2);
        }

        @Override
        public void visitTypeAlias(@NotNull IrTypeAlias declaration2, @NotNull Data data2) {
            IrElementVisitor.DefaultImpls.visitTypeAlias(this, declaration2, data2);
        }

        @Override
        public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @NotNull Data data2) {
            IrElementVisitor.DefaultImpls.visitTypeOperator(this, expression2, data2);
        }

        @Override
        public void visitTypeParameter(@NotNull IrTypeParameter declaration2, @NotNull Data data2) {
            IrElementVisitor.DefaultImpls.visitTypeParameter(this, declaration2, data2);
        }

        @Override
        public void visitValueAccess(@NotNull IrValueAccessExpression expression2, @NotNull Data data2) {
            IrElementVisitor.DefaultImpls.visitValueAccess(this, expression2, data2);
        }

        @Override
        public void visitVararg(@NotNull IrVararg expression2, @NotNull Data data2) {
            IrElementVisitor.DefaultImpls.visitVararg(this, expression2, data2);
        }

        @Override
        public void visitVariable(@NotNull IrVariable declaration2, @NotNull Data data2) {
            IrElementVisitor.DefaultImpls.visitVariable(this, declaration2, data2);
        }

        @Override
        public void visitWhen(@NotNull IrWhen expression2, @NotNull Data data2) {
            IrElementVisitor.DefaultImpls.visitWhen(this, expression2, data2);
        }

        @Override
        public void visitWhileLoop(@NotNull IrWhileLoop loop2, @NotNull Data data2) {
            IrElementVisitor.DefaultImpls.visitWhileLoop(this, loop2, data2);
        }
    }
}

