/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointAndAreaListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ExtensionPointPriorityListener;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.KeyedLazyInstance;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KeyedExtensionCollector<T, KeyT>
implements ModificationTracker {
    private static final Logger LOG = Logger.getInstance(KeyedExtensionCollector.class);
    @NonNls
    protected final String myLock;
    private Map<String, List<T>> myExplicitExtensions;
    private final ConcurrentMap<String, List<T>> myCache;
    private final String myEpName;
    private final SimpleModificationTracker myTracker;
    protected final AtomicBoolean myEpListenerAdded;

    public KeyedExtensionCollector(@NotNull ExtensionPointName<KeyedLazyInstance<T>> epName) {
        if (epName == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(0);
        }
        this(epName.getName());
    }

    public KeyedExtensionCollector(@NotNull String epName) {
        if (epName == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(1);
        }
        this.myExplicitExtensions = Collections.emptyMap();
        this.myCache = new ConcurrentHashMap<String, List<T>>();
        this.myTracker = new SimpleModificationTracker();
        this.myEpListenerAdded = new AtomicBoolean();
        this.myEpName = epName;
        this.myLock = "lock for KeyedExtensionCollector " + epName;
    }

    public void clearCache() {
        this.myCache.clear();
        this.myTracker.incModificationCount();
    }

    private void addExtensionPointListener(@NotNull ExtensionPoint<KeyedLazyInstance<T>> point) {
        if (point == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(2);
        }
        if (this.myEpListenerAdded.compareAndSet(false, true)) {
            point.addExtensionPointListener(new MyExtensionPointListener(), false, null);
        }
    }

    protected void invalidateCacheForExtension(String key) {
        if (key != null) {
            this.myCache.remove(key);
        }
        this.myTracker.incModificationCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExplicitExtension(@NotNull KeyT key, @NotNull T t) {
        if (key == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(3);
        }
        if (t == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(4);
        }
        String string2 = this.myLock;
        synchronized (string2) {
            String stringKey = this.keyToString(key);
            if (this.myExplicitExtensions == Collections.emptyMap()) {
                this.myExplicitExtensions = new HashMap<String, List<T>>();
            }
            List list2 = this.myExplicitExtensions.computeIfAbsent(stringKey, __ -> new SmartList());
            list2.add(t);
            this.invalidateCacheForExtension(stringKey);
        }
    }

    public void addExplicitExtension(@NotNull KeyT key, @NotNull T t, @NotNull Disposable parentDisposable) {
        if (key == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(5);
        }
        if (t == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(6);
        }
        if (parentDisposable == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(7);
        }
        this.addExplicitExtension(key, t);
        Disposer.register(parentDisposable, () -> this.removeExplicitExtension(key, t));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExplicitExtension(@NotNull KeyT key, @NotNull T t) {
        if (key == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(8);
        }
        if (t == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(9);
        }
        String string2 = this.myLock;
        synchronized (string2) {
            String stringKey = this.keyToString(key);
            List<T> list2 = this.myExplicitExtensions.get(stringKey);
            if (list2 != null) {
                list2.remove(t);
                if (list2.isEmpty()) {
                    this.myExplicitExtensions.remove(stringKey);
                }
            }
            this.invalidateCacheForExtension(stringKey);
        }
    }

    @NotNull
    protected String keyToString(@NotNull KeyT key) {
        if (key == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(10);
        }
        String string2 = key.toString();
        if (string2 == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(11);
        }
        return string2;
    }

    @NotNull
    public List<T> forKey(@NotNull KeyT key) {
        String stringKey;
        List<T> cached2;
        if (key == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(12);
        }
        if ((cached2 = (List<T>)this.myCache.get(stringKey = this.keyToString(key))) == null) {
            List<T> list2 = this.buildExtensions(stringKey, key);
            cached2 = ContainerUtil.immutableCopy(list2);
            cached2 = ConcurrencyUtil.cacheOrGet(this.myCache, stringKey, cached2);
        }
        List<T> list3 = cached2;
        if (list3 == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(13);
        }
        return list3;
    }

    public T findSingle(@NotNull KeyT key) {
        List<T> list2;
        if (key == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(14);
        }
        return (list2 = this.forKey(key)).isEmpty() ? null : (T)list2.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    protected List<T> buildExtensions(@NotNull String stringKey, @NotNull KeyT key) {
        if (stringKey == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(15);
        }
        if (key == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(16);
        }
        List<KeyedLazyInstance<T>> extensions = this.getExtensions();
        String string2 = this.myLock;
        // MONITORENTER : string2
        List<T> list3 = this.myExplicitExtensions.get(stringKey);
        ArrayList<T> arrayList = list3 != null ? new ArrayList<T>(list3) : null;
        List<T> list4 = this.buildExtensionsFromExtensionPoint(arrayList, bean -> stringKey.equals(bean.getKey()), extensions);
        List<T> list2 = ContainerUtil.notNullize(list4);
        // MONITOREXIT : string2
        if (list2 != null) return list2;
        KeyedExtensionCollector.$$$reportNull$$$0(17);
        return list2;
    }

    @NotNull
    protected final List<KeyedLazyInstance<T>> getExtensions() {
        ExtensionPoint<KeyedLazyInstance<T>> point = this.getPoint();
        if (point == null) {
            List<KeyedLazyInstance<T>> list2 = Collections.emptyList();
            if (list2 == null) {
                KeyedExtensionCollector.$$$reportNull$$$0(18);
            }
            return list2;
        }
        this.addExtensionPointListener(point);
        List<KeyedLazyInstance<T>> list3 = point.getExtensionList();
        if (list3 == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(19);
        }
        return list3;
    }

    @Nullable
    final List<T> buildExtensionsFromExtensionPoint(@Nullable List<T> result2, @NotNull Predicate<? super KeyedLazyInstance<T>> isMyBean, @NotNull List<? extends KeyedLazyInstance<T>> extensions) {
        if (isMyBean == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(20);
        }
        if (extensions == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(21);
        }
        for (KeyedLazyInstance<T> bean : extensions) {
            T instance;
            if (!isMyBean.test(bean)) continue;
            try {
                instance = bean.getInstance();
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (ExtensionNotApplicableException ignore) {
                continue;
            }
            catch (Exception | LinkageError e) {
                LOG.error(e);
                continue;
            }
            if (result2 == null) {
                result2 = new SmartList<T>();
            }
            result2.add(instance);
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    protected List<T> buildExtensions(@NotNull Set<String> keys2) {
        if (keys2 == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(22);
        }
        List<KeyedLazyInstance<T>> extensions = this.getExtensions();
        String string2 = this.myLock;
        // MONITORENTER : string2
        List<T> result2 = this.buildExtensionsFromExplicitRegistration(null, keys2::contains);
        result2 = this.buildExtensionsFromExtensionPoint(result2, bean -> keys2.contains(bean.getKey()), extensions);
        List<T> list2 = ContainerUtil.notNullize(result2);
        // MONITOREXIT : string2
        if (list2 != null) return list2;
        KeyedExtensionCollector.$$$reportNull$$$0(23);
        return list2;
    }

    @Nullable
    protected List<T> buildExtensionsFromExplicitRegistration(@Nullable List<T> result2, @NotNull Predicate<? super String> isMyBean) {
        if (isMyBean == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(24);
        }
        for (Map.Entry<String, List<T>> entry : this.myExplicitExtensions.entrySet()) {
            String key = entry.getKey();
            if (!isMyBean.test(key)) continue;
            List<T> list2 = entry.getValue();
            if (result2 == null) {
                result2 = new ArrayList<T>(list2);
                continue;
            }
            result2.addAll(list2);
        }
        return result2;
    }

    @ApiStatus.Internal
    @Nullable
    public final ExtensionPoint<KeyedLazyInstance<T>> getPoint() {
        return Extensions.getRootArea().getExtensionPointIfRegistered(this.myEpName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAnyExtensions() {
        String string2 = this.myLock;
        synchronized (string2) {
            if (!this.myExplicitExtensions.isEmpty()) {
                return true;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl7 : MonitorExitStatement: MONITOREXIT : var1_1
            ExtensionPoint<KeyedLazyInstance<T>> point = this.getPoint();
            return point != null && point.size() != 0;
        }
    }

    @NotNull
    public String getName() {
        String string2 = this.myEpName;
        if (string2 == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(25);
        }
        return string2;
    }

    @Override
    public long getModificationCount() {
        return this.myTracker.getModificationCount();
    }

    protected void ensureValuesLoaded() {
        ExtensionPoint<KeyedLazyInstance<T>> point = this.getPoint();
        if (point != null) {
            for (KeyedLazyInstance<T> bean : point.getExtensionList()) {
                bean.getInstance();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 25: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "epName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 11: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/KeyedExtensionCollector";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringKey";
                break;
            }
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isMyBean";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensions";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/KeyedExtensionCollector";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "keyToString";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "forKey";
                break;
            }
            case 17: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "buildExtensions";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensions";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addExtensionPointListener";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addExplicitExtension";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeExplicitExtension";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "keyToString";
                break;
            }
            case 11: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 25: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "forKey";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findSingle";
                break;
            }
            case 15: 
            case 16: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "buildExtensions";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "buildExtensionsFromExtensionPoint";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "buildExtensionsFromExplicitRegistration";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 11: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 25: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private final class MyExtensionPointListener
    implements ExtensionPointAndAreaListener<KeyedLazyInstance<T>>,
    ExtensionPointPriorityListener {
        private MyExtensionPointListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void extensionAdded(@NotNull KeyedLazyInstance<T> bean, @NotNull PluginDescriptor pluginDescriptor) {
            if (bean == null) {
                MyExtensionPointListener.$$$reportNull$$$0(0);
            }
            if (pluginDescriptor == null) {
                MyExtensionPointListener.$$$reportNull$$$0(1);
            }
            String string2 = KeyedExtensionCollector.this.myLock;
            synchronized (string2) {
                if (bean.getKey() == null) {
                    throw new PluginException("No key specified for extension of class " + bean.getInstance().getClass(), pluginDescriptor.getPluginId());
                }
                KeyedExtensionCollector.this.invalidateCacheForExtension(bean.getKey());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void extensionRemoved(@NotNull KeyedLazyInstance<T> bean, @NotNull PluginDescriptor pluginDescriptor) {
            if (bean == null) {
                MyExtensionPointListener.$$$reportNull$$$0(2);
            }
            if (pluginDescriptor == null) {
                MyExtensionPointListener.$$$reportNull$$$0(3);
            }
            String string2 = KeyedExtensionCollector.this.myLock;
            synchronized (string2) {
                KeyedExtensionCollector.this.invalidateCacheForExtension(bean.getKey());
            }
        }

        @Override
        public void areaReplaced(@NotNull ExtensionsArea area) {
            if (area == null) {
                MyExtensionPointListener.$$$reportNull$$$0(4);
            }
            KeyedExtensionCollector.this.myCache.clear();
            KeyedExtensionCollector.this.myTracker.incModificationCount();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bean";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pluginDescriptor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "area";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/util/KeyedExtensionCollector$MyExtensionPointListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "extensionAdded";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "extensionRemoved";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "areaReplaced";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

