/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

final class Pluralizer {
    static final Pluralizer PLURALIZER;
    private final Map<String, String> irregularSingles = new THashMap<String, String>(CaseInsensitiveStringHashingStrategy.INSTANCE);
    private final Map<String, String> irregularPlurals = new THashMap<String, String>(CaseInsensitiveStringHashingStrategy.INSTANCE);
    private final Set<String> uncountables = new THashSet<String>(CaseInsensitiveStringHashingStrategy.INSTANCE);
    private final List<Pair<Pattern, String>> pluralRules = new ArrayList<Pair<Pattern, String>>();
    private final List<Pair<Pattern, String>> singularRules = new ArrayList<Pair<Pattern, String>>();

    Pluralizer() {
    }

    static String restoreCase(String word, String result2) {
        char lc;
        char uc;
        char wc;
        int i;
        if (word == null || result2 == null || word == result2) {
            return result2;
        }
        int len = Math.min(result2.length(), word.length());
        if (len == 0) {
            return result2;
        }
        char[] chars = result2.toCharArray();
        for (i = 0; i < len; ++i) {
            wc = word.charAt(i);
            if (chars[i] == wc && i != len - 1) continue;
            uc = Character.toUpperCase(chars[i]);
            lc = Character.toLowerCase(chars[i]);
            if (wc != lc && wc != uc) break;
            chars[i] = wc;
        }
        if (i > 0 && i < chars.length && (uc = Character.toUpperCase(wc = word.charAt(i - 1))) != (lc = Character.toLowerCase(wc))) {
            while (i < chars.length) {
                chars[i] = wc == uc ? Character.toUpperCase(chars[i]) : Character.toLowerCase(chars[i]);
                ++i;
            }
        }
        return new String(chars);
    }

    private String sanitizeWord(String word, List<? extends Pair<Pattern, String>> rules) {
        if (Strings.isEmpty(word) || this.uncountables.contains(word)) {
            return word;
        }
        int len = rules.size();
        while (--len > -1) {
            Pair<Pattern, String> rule = rules.get(len);
            Matcher matcher2 = ((Pattern)rule.first).matcher(word);
            if (!matcher2.find()) continue;
            return matcher2.replaceFirst((String)rule.second);
        }
        return null;
    }

    private String replaceWord(String word, Map<String, String> replaceMap, Map<String, String> keepMap, List<? extends Pair<Pattern, String>> rules) {
        if (Strings.isEmpty(word)) {
            return word;
        }
        if (keepMap.containsKey(word)) {
            return word;
        }
        String replacement = replaceMap.get(word);
        if (replacement != null) {
            return replacement;
        }
        return this.sanitizeWord(word, rules);
    }

    @Nullable
    public String plural(@Nullable String word) {
        return Pluralizer.restoreCase(word, this.replaceWord(word, this.irregularSingles, this.irregularPlurals, this.pluralRules));
    }

    private static Pattern sanitizeRule(String rule) {
        return Pattern.compile(rule.startsWith("/") ? rule.substring(1) : "^" + rule + "$", 2);
    }

    protected void addPluralRule(String rule, String replacement) {
        this.pluralRules.add(Pair.create(Pluralizer.sanitizeRule(rule), replacement));
    }

    protected void addSingularRule(String rule, String replacement) {
        this.singularRules.add(Pair.create(Pluralizer.sanitizeRule(rule), replacement));
    }

    protected void addUncountableRule(String word) {
        if (!word.startsWith("/")) {
            this.uncountables.add(word);
        } else {
            this.addPluralRule(word, "$0");
            this.addSingularRule(word, "$0");
        }
    }

    protected void addIrregularRule(String single2, String plural) {
        this.irregularSingles.put(single2, plural);
        this.irregularPlurals.put(plural, single2);
    }

    static {
        Pluralizer pluralizer = new Pluralizer();
        for (String[] stringArray : new String[][]{{"this", "these"}, {"that", "those"}, {"echo", "echoes"}, {"dingo", "dingoes"}, {"volcano", "volcanoes"}, {"tornado", "tornadoes"}, {"torpedo", "torpedoes"}, {"genus", "genera"}, {"viscus", "viscera"}, {"stigma", "stigmata"}, {"stoma", "stomata"}, {"dogma", "dogmata"}, {"lemma", "lemmata"}, {"anathema", "anathemata"}, {"ox", "oxen"}, {"axe", "axes"}, {"die", "dice"}, {"yes", "yeses"}, {"foot", "feet"}, {"eave", "eaves"}, {"goose", "geese"}, {"tooth", "teeth"}, {"quiz", "quizzes"}, {"human", "humans"}, {"proof", "proofs"}, {"carve", "carves"}, {"valve", "valves"}, {"looey", "looies"}, {"thief", "thieves"}, {"groove", "grooves"}, {"pickaxe", "pickaxes"}, {"whiskey", "whiskies"}}) {
            pluralizer.addIrregularRule(stringArray[0], stringArray[1]);
        }
        for (String[] stringArray : new String[][]{{"/s?$", "s"}, {"/([^aeiou]ese)$", "$1"}, {"/(ax|test)is$", "$1es"}, {"/(alias|[^aou]us|t[lm]as|gas|ris)$", "$1es"}, {"/(e[mn]u)s?$", "$1s"}, {"/([^l]ias|[aeiou]las|[ejzr]as|[iu]am)$", "$1"}, {"/(alumn|syllab|octop|vir|radi|nucle|fung|cact|stimul|termin|bacill|foc|uter|loc|strat)(?:us|i)$", "$1i"}, {"/(alumn|alg|vertebr)(?:a|ae)$", "$1ae"}, {"/(seraph|cherub)(?:im)?$", "$1im"}, {"/(her|at|gr)o$", "$1oes"}, {"/(agend|addend|millenni|medi|dat|extrem|bacteri|desiderat|strat|candelabr|errat|ov|symposi|curricul|automat|quor)(?:a|um)$", "$1a"}, {"/(apheli|hyperbat|periheli|asyndet|noumen|phenomen|criteri|organ|prolegomen|hedr|automat)(?:a|on)$", "$1a"}, {"/sis$", "ses"}, {"/(?:(kni|wi|li)fe|(ar|l|ea|eo|oa|hoo)f)$", "$1$2ves"}, {"/([^aeiouy]|qu)y$", "$1ies"}, {"/([^ch][ieo][ln])ey$", "$1ies"}, {"/(x|ch|ss|sh|zz)$", "$1es"}, {"/(matr|cod|mur|sil|vert|ind|append)(?:ix|ex)$", "$1ices"}, {"(m|l)(?:ice|ouse)", "$1ice"}, {"/(pe)(?:rson|ople)$", "$1ople"}, {"/(child)(?:ren)?$", "$1ren"}, {"/eaux$", "$0"}, {"/m[ae]n$", "men"}}) {
            pluralizer.addPluralRule(stringArray[0], stringArray[1]);
        }
        for (String[] stringArray : new String[][]{{"/(.)s$", "$1"}, {"/([^aeiou]s)es$", "$1"}, {"/(wi|kni|(?:after|half|high|low|mid|non|night|[^\\w]|^)li)ves$", "$1fe"}, {"/(ar|(?:wo|[ae])l|[eo][ao])ves$", "$1f"}, {"/ies$", "y"}, {"/\\b([pl]|zomb|(?:neck|cross)?t|coll|faer|food|gen|goon|group|lass|talk|goal|cut)ies$", "$1ie"}, {"/\\b(mon|smil)ies$", "$1ey"}, {"(m|l)ice", "$1ouse"}, {"/(seraph|cherub)im$", "$1"}, {"/.(x|ch|ss|sh|zz|tto|go|cho|alias|[^aou]us|t[lm]as|gas|(?:her|at|gr)o|ris)(?:es)?$", "$1"}, {"/(analy|^ba|diagno|parenthe|progno|synop|the|empha|cri)(?:sis|ses)$", "$1sis"}, {"/(movie|twelve|abuse|e[mn]u)s$", "$1"}, {"/(test)(?:is|es)$", "$1is"}, {"/(x|ch|.ss|sh|zz|tto|go|cho|alias|[^aou]us|tlas|gas|(?:her|at|gr)o|ris)(?:es)?$", "$1"}, {"/(e[mn]u)s?$", "$1"}, {"/(cookie|movie|twelve)s$", "$1"}, {"/(cris|test|diagnos)(?:is|es)$", "$1is"}, {"/(alumn|syllab|octop|vir|radi|nucle|fung|cact|stimul|termin|bacill|foc|uter|loc|strat)(?:us|i)$", "$1us"}, {"/(agend|addend|millenni|dat|extrem|bacteri|desiderat|strat|candelabr|errat|ov|symposi|curricul|quor)a$", "$1um"}, {"/(apheli|hyperbat|periheli|asyndet|noumen|phenomen|criteri|organ|prolegomen|hedr|automat)a$", "$1on"}, {"/(alumn|alg|vertebr)ae$", "$1a"}, {"/(cod|mur|sil|vert|ind)ices$", "$1ex"}, {"/(matr|append)ices$", "$1ix"}, {"/(pe)(rson|ople)$", "$1rson"}, {"/(child)ren$", "$1"}, {"/(eau)x?$", "$1"}, {"/men$", "man"}}) {
            pluralizer.addSingularRule(stringArray[0], stringArray[1]);
        }
        for (String[] stringArray : new String[]{"adulthood", "advice", "agenda", "aid", "alcohol", "ammo", "anime", "athletics", "audio", "bison", "blood", "bream", "buffalo", "butter", "carp", "cash", "chassis", "chess", "clothing", "cod", "commerce", "cooperation", "corps", "debris", "diabetes", "digestion", "elk", "energy", "equipment", "excretion", "expertise", "flounder", "fun", "gallows", "garbage", "graffiti", "headquarters", "health", "herpes", "highjinks", "homework", "housework", "information", "jeans", "justice", "kudos", "labour", "literature", "machinery", "mackerel", "mail", "media", "mews", "moose", "music", "news", "pike", "plankton", "pliers", "police", "pollution", "premises", "rain", "research", "rice", "salmon", "scissors", "series", "sewage", "shambles", "shrimp", "species", "staff", "swine", "tennis", "traffic", "transportation", "trout", "tuna", "wealth", "welfare", "whiting", "wildebeest", "wildlife", "you", "/[^aeiou]ese$/i", "/deer$", "/fish$", "/measles$", "/o[iu]s$", "/pox$", "/sheep$"}) {
            pluralizer.addUncountableRule((String)stringArray);
        }
        PLURALIZER = pluralizer;
    }
}

