/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.intrinsics;

import com.intellij.psi.tree.IElementType;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.jvm.codegen.BlockInfo;
import org.jetbrains.kotlin.backend.jvm.codegen.BooleanConstant;
import org.jetbrains.kotlin.backend.jvm.codegen.BooleanValue;
import org.jetbrains.kotlin.backend.jvm.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.backend.jvm.codegen.MaterialValue;
import org.jetbrains.kotlin.backend.jvm.codegen.PromisedValue;
import org.jetbrains.kotlin.backend.jvm.codegen.PromisedValueKt;
import org.jetbrains.kotlin.backend.jvm.intrinsics.BooleanComparison;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IntegerZeroComparison;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IntrinsicMethod;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IrIntrinsicFunctionKt;
import org.jetbrains.kotlin.backend.jvm.intrinsics.PrimitiveToObjectComparison;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.DescriptorAsmUtil;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.types.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/intrinsics/Equals;", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IntrinsicMethod;", "operator", "Lcom/intellij/psi/tree/IElementType;", "(Lcom/intellij/psi/tree/IElementType;)V", "getOperator", "()Lcom/intellij/psi/tree/IElementType;", "invoke", "Lorg/jetbrains/kotlin/backend/jvm/codegen/PromisedValue;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "codegen", "Lorg/jetbrains/kotlin/backend/jvm/codegen/ExpressionCodegen;", "data", "Lorg/jetbrains/kotlin/backend/jvm/codegen/BlockInfo;", "BooleanNullCheck", "backend.jvm"})
public final class Equals
extends IntrinsicMethod {
    @NotNull
    private final IElementType operator;

    public Equals(@NotNull IElementType operator) {
        Intrinsics.checkNotNullParameter(operator, "operator");
        this.operator = operator;
    }

    @NotNull
    public final IElementType getOperator() {
        return this.operator;
    }

    @Override
    @Nullable
    public PromisedValue invoke(@NotNull IrFunctionAccessExpression expression2, @NotNull ExpressionCodegen codegen2, @NotNull BlockInfo data2) {
        PromisedValue promisedValue;
        boolean useEquals;
        boolean bl;
        IrClass $this$invoke_u24lambda_u2d2;
        Object object;
        Object object2;
        boolean bl2;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(codegen2, "codegen");
        Intrinsics.checkNotNullParameter(data2, "data");
        List<IrExpression> list2 = IrIntrinsicFunctionKt.receiverAndArgs(expression2);
        IrExpression a = list2.get(0);
        IrExpression b = list2.get(1);
        if (IrUtilsKt.isNullConst(a) || IrUtilsKt.isNullConst(b)) {
            PromisedValue promisedValue2;
            IrClass irClass2;
            IrClassSymbol irClassSymbol;
            IrExpression irValue = IrUtilsKt.isNullConst(a) ? b : a;
            PromisedValue value2 = (PromisedValue)irValue.accept(codegen2, data2);
            if (!(AsmUtil.isPrimitive(value2.getType()) || ((irClassSymbol = IrTypesKt.getClassOrNull(irValue.getType())) == null ? false : (irClass2 = (IrClass)irClassSymbol.getOwner()).isInline()) && !IrTypeUtilsKt.isNullable(irValue.getType()))) {
                promisedValue2 = new BooleanNullCheck(value2);
            } else {
                value2.discard();
                promisedValue2 = new BooleanConstant(codegen2, false);
            }
            return promisedValue2;
        }
        ExpressionCodegen $this$invoke_u24lambda_u2d0 = codegen2;
        boolean bl3 = false;
        Type leftType = $this$invoke_u24lambda_u2d0.getAsmType(a);
        ExpressionCodegen $this$invoke_u24lambda_u2d1 = codegen2;
        boolean bl4 = false;
        Type rightType = $this$invoke_u24lambda_u2d1.getAsmType(b);
        IrStatementOrigin opToken = expression2.getOrigin();
        if ((Intrinsics.areEqual(opToken, IrStatementOrigin.EQEQ.INSTANCE) || Intrinsics.areEqual(opToken, IrStatementOrigin.EXCLEQ.INSTANCE)) && (AsmUtil.isIntOrLongPrimitive(leftType) && !AsmUtil.isPrimitive(rightType) || AsmUtil.isIntOrLongPrimitive(rightType) && AsmUtil.isBoxedPrimitiveType(leftType))) {
            MaterialValue aValue = PromisedValueKt.materializedAt$default((PromisedValue)a.accept(codegen2, data2), leftType, a.getType(), false, 4, null);
            MaterialValue bValue = PromisedValueKt.materializedAt$default((PromisedValue)b.accept(codegen2, data2), rightType, b.getType(), false, 4, null);
            return new PrimitiveToObjectComparison(this.operator, AsmUtil.isIntOrLongPrimitive(leftType), aValue, bValue);
        }
        IrClassSymbol bValue = IrTypesKt.getClassOrNull(a.getType());
        if (bValue == null) {
            bl2 = false;
        } else {
            object = object2 = (IrClass)bValue.getOwner();
            $this$invoke_u24lambda_u2d2 = object;
            boolean bl5 = false;
            bl2 = IrUtilsKt.isEnumClass($this$invoke_u24lambda_u2d2) || IrUtilsKt.isEnumEntry($this$invoke_u24lambda_u2d2);
        }
        boolean aIsEnum = bl2;
        object2 = IrTypesKt.getClassOrNull(b.getType());
        if (object2 == null) {
            bl = false;
        } else {
            object = (IrClass)object2.getOwner();
            IrClass $this$invoke_u24lambda_u2d3 = $this$invoke_u24lambda_u2d2 = object;
            boolean bl6 = false;
            bl = IrUtilsKt.isEnumClass($this$invoke_u24lambda_u2d3) || IrUtilsKt.isEnumEntry($this$invoke_u24lambda_u2d3);
        }
        boolean bIsEnum = bl;
        boolean bl7 = useEquals = opToken != IrStatementOrigin.EQEQEQ.INSTANCE && opToken != IrStatementOrigin.EXCLEQEQ.INSTANCE && (!AsmUtil.isPrimitive(leftType) || !Intrinsics.areEqual(leftType, rightType) || Intrinsics.areEqual(leftType, Type.FLOAT_TYPE) || Intrinsics.areEqual(leftType, Type.DOUBLE_TYPE)) && !aIsEnum && !bIsEnum;
        if (useEquals) {
            PromisedValue promisedValue3 = (PromisedValue)a.accept(codegen2, data2);
            object = AsmTypes.OBJECT_TYPE;
            Intrinsics.checkNotNullExpressionValue(object, "OBJECT_TYPE");
            PromisedValueKt.materializeAt(promisedValue3, (Type)object, codegen2.getContext().getIrBuiltIns().getAnyNType());
            PromisedValue promisedValue4 = (PromisedValue)b.accept(codegen2, data2);
            object = AsmTypes.OBJECT_TYPE;
            Intrinsics.checkNotNullExpressionValue(object, "OBJECT_TYPE");
            PromisedValueKt.materializeAt(promisedValue4, (Type)object, codegen2.getContext().getIrBuiltIns().getAnyNType());
            DescriptorAsmUtil.genAreEqualCall(codegen2.getMv());
            object = Type.BOOLEAN_TYPE;
            Intrinsics.checkNotNullExpressionValue(object, "BOOLEAN_TYPE");
            promisedValue = new MaterialValue(codegen2, (Type)object, codegen2.getContext().getIrBuiltIns().getBooleanType());
        } else {
            BooleanValue booleanValue;
            Type operandType;
            Type type2 = operandType = !AsmUtil.isPrimitive(leftType) ? AsmTypes.OBJECT_TYPE : leftType;
            if (Intrinsics.areEqual(operandType, Type.INT_TYPE) && (IrUtilsKt.isIntegerConst(a, 0) || IrUtilsKt.isIntegerConst(b, 0))) {
                IrExpression nonZero = IrUtilsKt.isIntegerConst(a, 0) ? b : a;
                PromisedValue promisedValue5 = (PromisedValue)nonZero.accept(codegen2, data2);
                Intrinsics.checkNotNullExpressionValue(operandType, "operandType");
                booleanValue = new IntegerZeroComparison(this.operator, PromisedValueKt.materializedAt$default(promisedValue5, operandType, nonZero.getType(), false, 4, null));
            } else {
                PromisedValue promisedValue6 = (PromisedValue)a.accept(codegen2, data2);
                Intrinsics.checkNotNullExpressionValue(operandType, "operandType");
                MaterialValue aValue = PromisedValueKt.materializedAt$default(promisedValue6, operandType, a.getType(), false, 4, null);
                MaterialValue bValue2 = PromisedValueKt.materializedAt$default((PromisedValue)b.accept(codegen2, data2), operandType, b.getType(), false, 4, null);
                booleanValue = new BooleanComparison(this.operator, aValue, bValue2);
            }
            promisedValue = booleanValue;
        }
        return promisedValue;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/intrinsics/Equals$BooleanNullCheck;", "Lorg/jetbrains/kotlin/backend/jvm/codegen/BooleanValue;", "value", "Lorg/jetbrains/kotlin/backend/jvm/codegen/PromisedValue;", "(Lorg/jetbrains/kotlin/backend/jvm/codegen/PromisedValue;)V", "getValue", "()Lorg/jetbrains/kotlin/backend/jvm/codegen/PromisedValue;", "discard", "", "jumpIfFalse", "target", "Lorg/jetbrains/org/objectweb/asm/Label;", "jumpIfTrue", "backend.jvm"})
    private static final class BooleanNullCheck
    extends BooleanValue {
        @NotNull
        private final PromisedValue value;

        public BooleanNullCheck(@NotNull PromisedValue value2) {
            Intrinsics.checkNotNullParameter(value2, "value");
            super(value2.getCodegen());
            this.value = value2;
        }

        @NotNull
        public final PromisedValue getValue() {
            return this.value;
        }

        @Override
        public void jumpIfFalse(@NotNull Label target) {
            Unit unit2;
            Intrinsics.checkNotNullParameter(target, "target");
            PromisedValueKt.materialize(this.value);
            Unit it = unit2 = Unit.INSTANCE;
            boolean bl = false;
            this.getMv().ifnonnull(target);
        }

        @Override
        public void jumpIfTrue(@NotNull Label target) {
            Unit unit2;
            Intrinsics.checkNotNullParameter(target, "target");
            PromisedValueKt.materialize(this.value);
            Unit it = unit2 = Unit.INSTANCE;
            boolean bl = false;
            this.getMv().ifnull(target);
        }

        @Override
        public void discard() {
            this.value.discard();
        }
    }
}

