/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.js;

import com.intellij.mock.MockProject;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.phaser.CompilerPhase;
import org.jetbrains.kotlin.backend.common.phaser.PhaseConfig;
import org.jetbrains.kotlin.backend.common.serialization.metadata.KlibMetadataVersion;
import org.jetbrains.kotlin.backend.wasm.WasmCompilerResult;
import org.jetbrains.kotlin.backend.wasm.WasmLoweringPhasesKt;
import org.jetbrains.kotlin.cli.common.CLICompiler;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.CLITool;
import org.jetbrains.kotlin.cli.common.CommonCompilerPerformanceManager;
import org.jetbrains.kotlin.cli.common.CreatePhaseConfigKt;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.UtilsKt;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments;
import org.jetbrains.kotlin.cli.common.config.ContentRootsKt;
import org.jetbrains.kotlin.cli.common.extensions.ScriptEvaluationExtension;
import org.jetbrains.kotlin.cli.common.messages.AnalyzerWithCompilerReport;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageUtil;
import org.jetbrains.kotlin.cli.js.K2JSCompiler;
import org.jetbrains.kotlin.cli.js.K2JsIrCompilerKt;
import org.jetbrains.kotlin.cli.js.ProduceKind;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreApplicationEnvironment;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.IncrementalCompilation;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.incremental.components.ExpectActualTracker;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.incremental.js.IncrementalDataProvider;
import org.jetbrains.kotlin.incremental.js.IncrementalNextRoundChecker;
import org.jetbrains.kotlin.incremental.js.IncrementalResultsConsumer;
import org.jetbrains.kotlin.ir.backend.js.CompilationOutputs;
import org.jetbrains.kotlin.ir.backend.js.CompilerKt;
import org.jetbrains.kotlin.ir.backend.js.CompilerResult;
import org.jetbrains.kotlin.ir.backend.js.JsLoweringPhasesKt;
import org.jetbrains.kotlin.ir.backend.js.KlibKt;
import org.jetbrains.kotlin.ir.backend.js.MainModule;
import org.jetbrains.kotlin.ir.backend.js.ModulesStructure;
import org.jetbrains.kotlin.ir.backend.js.ic.FileUtilKt;
import org.jetbrains.kotlin.ir.backend.js.ic.InvalidationKt;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.impl.IrFactoryImpl;
import org.jetbrains.kotlin.ir.declarations.persistent.PersistentIrFactory;
import org.jetbrains.kotlin.js.analyzer.JsAnalysisResult;
import org.jetbrains.kotlin.js.config.EcmaVersion;
import org.jetbrains.kotlin.js.config.ErrorTolerancePolicy;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.js.config.JsConfig;
import org.jetbrains.kotlin.js.config.RuntimeDiagnostic;
import org.jetbrains.kotlin.js.config.SourceMapSourceEmbedding;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.CompilerEnvironment;
import org.jetbrains.kotlin.serialization.js.ModuleKind;
import org.jetbrains.kotlin.utils.KotlinPaths;
import org.jetbrains.kotlin.utils.StringsKt;
import org.jetbrains.kotlin.utils.fileUtils.FileUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 $2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001$B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\u0002H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J*\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0014J\b\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001a\u0010\u001e\u001a\u00020\u0019*\b\u0012\u0004\u0012\u00020\u00170\u001f2\u0006\u0010\u000f\u001a\u00020\u0002H\u0014J\u0014\u0010 \u001a\u00020\u0019*\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/cli/js/K2JsIrCompiler;", "Lorg/jetbrains/kotlin/cli/common/CLICompiler;", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JSCompilerArguments;", "()V", "defaultPerformanceManager", "Lorg/jetbrains/kotlin/cli/common/CommonCompilerPerformanceManager;", "getDefaultPerformanceManager", "()Lorg/jetbrains/kotlin/cli/common/CommonCompilerPerformanceManager;", "createArguments", "createMetadataVersion", "Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "versionArray", "", "doExecute", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "arguments", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "rootDisposable", "Lcom/intellij/openapi/Disposable;", "paths", "Lorg/jetbrains/kotlin/utils/KotlinPaths;", "executableScriptFileName", "", "setupPlatformSpecificArgumentsAndServices", "", "services", "Lorg/jetbrains/kotlin/config/Services;", "usePerFileInvalidator", "", "addPlatformOptions", "", "write", "Ljava/io/File;", "outputs", "Lorg/jetbrains/kotlin/ir/backend/js/CompilationOutputs;", "Companion", "cli-js"})
public final class K2JsIrCompiler
extends CLICompiler<K2JSCompilerArguments> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CommonCompilerPerformanceManager defaultPerformanceManager = new CommonCompilerPerformanceManager(){};
    @NotNull
    private static final Map<String, ModuleKind> moduleKindMap;
    @NotNull
    private static final Map<String, SourceMapSourceEmbedding> sourceMapContentEmbeddingMap;
    @NotNull
    private static final Map<String, ProduceKind> produceMap;

    @Override
    @NotNull
    public CommonCompilerPerformanceManager getDefaultPerformanceManager() {
        return this.defaultPerformanceManager;
    }

    @Override
    @NotNull
    public K2JSCompilerArguments createArguments() {
        return new K2JSCompilerArguments();
    }

    private final boolean usePerFileInvalidator(CompilerConfiguration configuration) {
        return false;
    }

    @Override
    @NotNull
    protected ExitCode doExecute(@NotNull K2JSCompilerArguments arguments2, @NotNull CompilerConfiguration configuration, @NotNull Disposable rootDisposable, @Nullable KotlinPaths paths) {
        Object result232;
        File file2;
        String string2;
        CharSequence charSequence2;
        Intrinsics.checkNotNullParameter(arguments2, "arguments");
        Intrinsics.checkNotNullParameter(configuration, "configuration");
        Intrinsics.checkNotNullParameter(rootDisposable, "rootDisposable");
        MessageCollector messageCollector = configuration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        Intrinsics.checkNotNullExpressionValue(messageCollector, "configuration.getNotNull\u2026ys.MESSAGE_COLLECTOR_KEY)");
        MessageCollector messageCollector2 = messageCollector;
        ExitCode pluginLoadResult = this.loadPlugins(paths, (CommonCompilerArguments)arguments2, configuration);
        if (pluginLoadResult != ExitCode.OK) {
            return pluginLoadResult;
        }
        if (arguments2.getScript()) {
            Object v0;
            KotlinCoreEnvironment.ProjectEnvironment projectEnv;
            block49: {
                Iterable iterable;
                if (!arguments2.getEnableJsScripting()) {
                    MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.ERROR, "Script for K/JS should be enabled explicitly, see -Xenable-js-scripting", null, 4, null);
                    return ExitCode.COMPILATION_ERROR;
                }
                configuration.put(CommonConfigurationKeys.MODULE_NAME, "repl.kts");
                KotlinCoreApplicationEnvironment environment = KotlinCoreEnvironment.Companion.getOrCreateApplicationEnvironmentForProduction(rootDisposable, configuration);
                projectEnv = new KotlinCoreEnvironment.ProjectEnvironment(rootDisposable, environment, configuration);
                projectEnv.registerExtensionsFromPlugins(configuration);
                MockProject mockProject = projectEnv.getProject();
                Intrinsics.checkNotNullExpressionValue(mockProject, "projectEnv.project");
                List scriptingEvaluators = ScriptEvaluationExtension.Companion.getInstances(mockProject);
                Iterable iterable2 = iterable = (Iterable)scriptingEvaluators;
                for (Object t : iterable2) {
                    ScriptEvaluationExtension it = (ScriptEvaluationExtension)t;
                    boolean bl = false;
                    if (!it.isAccepted(arguments2)) continue;
                    v0 = t;
                    break block49;
                }
                v0 = null;
            }
            ScriptEvaluationExtension scriptingEvaluator = v0;
            if (scriptingEvaluator == null) {
                MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.ERROR, "Unable to evaluate script, no scripting plugin loaded", null, 4, null);
                return ExitCode.COMPILATION_ERROR;
            }
            return scriptingEvaluator.eval(arguments2, configuration, projectEnv);
        }
        if (arguments2.getFreeArgs().isEmpty() && !IncrementalCompilation.isEnabledForJs()) {
            if (arguments2.getVersion()) {
                return ExitCode.OK;
            }
            CharSequence environment = arguments2.getIncludes();
            if (environment == null || environment.length() == 0) {
                messageCollector2.report(CompilerMessageSeverity.ERROR, "Specify at least one source file or directory", null);
                return ExitCode.COMPILATION_ERROR;
            }
        }
        List libraries = CollectionsKt.plus((Collection)K2JsIrCompiler.Companion.configureLibraries(arguments2.getLibraries()), (Iterable)CollectionsKt.listOfNotNull(arguments2.getIncludes()));
        List friendLibraries = K2JsIrCompiler.Companion.configureLibraries(arguments2.getFriendModules());
        List repositories = K2JsIrCompiler.Companion.configureLibraries(arguments2.getRepositries());
        configuration.put(JSConfigurationKeys.LIBRARIES, libraries);
        configuration.put(JSConfigurationKeys.TRANSITIVE_LIBRARIES, libraries);
        configuration.put(JSConfigurationKeys.REPOSITORIES, repositories);
        String[] commonSourcesArray = arguments2.getCommonSources();
        String[] stringArray = commonSourcesArray;
        Set<Object> commonSources = stringArray == null ? SetsKt.emptySet() : ArraysKt.toSet(stringArray);
        for (String arg : arguments2.getFreeArgs()) {
            ContentRootsKt.addKotlinSourceRoot(configuration, arg, commonSources.contains(arg));
        }
        KotlinCoreEnvironment environmentForJS = KotlinCoreEnvironment.Companion.createForProduction(rootDisposable, configuration, EnvironmentConfigFiles.JS_CONFIG_FILES);
        Project projectJs = environmentForJS.getProject();
        CompilerConfiguration configurationJs = environmentForJS.getConfiguration();
        List<KtFile> sourcesFiles = environmentForJS.getSourceFiles();
        configurationJs.put(CLIConfigurationKeys.ALLOW_KOTLIN_PACKAGE, arguments2.getAllowKotlinPackage());
        if (!UtilsKt.checkKotlinPackageUsage(environmentForJS.getConfiguration(), (Collection<? extends KtFile>)sourcesFiles)) {
            return ExitCode.COMPILATION_ERROR;
        }
        String outputFilePath = arguments2.getOutputFile();
        if (outputFilePath == null) {
            messageCollector2.report(CompilerMessageSeverity.ERROR, "IR: Specify output file via -output", null);
            return ExitCode.COMPILATION_ERROR;
        }
        if (messageCollector2.hasErrors()) {
            return ExitCode.COMPILATION_ERROR;
        }
        if (sourcesFiles.isEmpty() && !IncrementalCompilation.isEnabledForJs() && ((charSequence2 = (CharSequence)arguments2.getIncludes()) == null || charSequence2.length() == 0)) {
            messageCollector2.report(CompilerMessageSeverity.ERROR, "No source files", null);
            return ExitCode.COMPILATION_ERROR;
        }
        if (arguments2.getVerbose()) {
            K2JsIrCompiler.Companion.reportCompiledSourcesList(messageCollector2, sourcesFiles);
        }
        File outputFile = new File(outputFilePath);
        String string3 = arguments2.getIrModuleName();
        if (string3 == null) {
            String string4 = FileUtil.getNameWithoutExtension(outputFile);
            Intrinsics.checkNotNullExpressionValue(string4, "getNameWithoutExtension(outputFile)");
            string2 = string4;
        } else {
            string2 = string3;
        }
        String moduleName = string2;
        configurationJs.put(CommonConfigurationKeys.MODULE_NAME, moduleName);
        JsConfig config = new JsConfig(projectJs, configurationJs, CompilerEnvironment.INSTANCE);
        File file3 = outputFile.getParentFile();
        if (file3 == null) {
            File file4 = outputFile.getAbsoluteFile().getParentFile();
            file2 = file4;
            Intrinsics.checkNotNull(file4);
        } else {
            file2 = file3;
        }
        File outputDir2 = file2;
        try {
            config.getConfiguration().put(JSConfigurationKeys.OUTPUT_DIR, outputDir2.getCanonicalFile());
        }
        catch (IOException e) {
            messageCollector2.report(CompilerMessageSeverity.ERROR, "Could not resolve output directory", null);
            return ExitCode.COMPILATION_ERROR;
        }
        List mainCallArguments = Intrinsics.areEqual("noCall", arguments2.getMain()) ? null : CollectionsKt.emptyList();
        List icCaches = K2JsIrCompiler.Companion.configureLibraries(arguments2.getCacheDirectories());
        if (arguments2.getIrBuildCache()) {
            String invalidationType;
            boolean bl;
            K2JsIrCompiler k2JsIrCompiler;
            MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.INFO, "", null, 4, null);
            MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.INFO, "Building cache:", null, 4, null);
            MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.INFO, Intrinsics.stringPlus("to: ", outputFilePath), null, 4, null);
            String string5 = arguments2.getCacheDirectories();
            MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.INFO, string5 == null ? "" : string5, null, 4, null);
            MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.INFO, libraries.toString(), null, 4, null);
            String string4 = arguments2.getIncludes();
            Intrinsics.checkNotNull(string4);
            String includes = string4;
            K2JsIrCompiler $this$doExecute_u24lambda_u2d1 = k2JsIrCompiler = this;
            boolean bl2 = false;
            if (!((Collection)sourcesFiles).isEmpty()) {
                MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.ERROR, "Source files are not supported when -Xinclude is present", null, 4, null);
            }
            MainModule.Klib mainModule = new MainModule.Klib(includes);
            boolean perFileCache = this.usePerFileInvalidator(configuration);
            long start = System.currentTimeMillis();
            if (perFileCache) {
                bl = InvalidationKt.actualizeCacheForModule(includes, outputFilePath, configuration, libraries, icCaches);
            } else {
                CompilerConfiguration compilerConfiguration = config.getConfiguration();
                Intrinsics.checkNotNullExpressionValue(compilerConfiguration, "config.configuration");
                bl = FileUtilKt.buildCache$default(outputFilePath, projectJs, mainModule, compilerConfiguration, libraries, friendLibraries, null, false, FileUtilKt.checkCaches(libraries, icCaches, mainModule.getLibPath()), 192, null);
            }
            boolean updated = bl;
            String string6 = invalidationType = perFileCache ? "per-file" : "per-module";
            if (updated) {
                MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.INFO, "IC " + invalidationType + " cache building duration: " + (System.currentTimeMillis() - start) + "ms", null, 4, null);
            } else {
                MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.INFO, "IC " + invalidationType + " cache up-to-date check duration: " + (System.currentTimeMillis() - start) + "ms", null, 4, null);
            }
            return ExitCode.OK;
        }
        ModulesStructure sourceModule = null;
        if (arguments2.getIncludes() == null) {
            do {
                ModulesStructure modulesStructure;
                List<KtFile> list2 = environmentForJS.getSourceFiles();
                CompilerConfiguration mainModule = config.getConfiguration();
                Intrinsics.checkNotNullExpressionValue(mainModule, "config.configuration");
                sourceModule = KlibKt.prepareAnalyzedSourceModule$default(projectJs, list2, configurationJs, libraries, friendLibraries, new AnalyzerWithCompilerReport(mainModule), !((Collection)icCaches).isEmpty(), !((Collection)icCaches).isEmpty(), !((Collection)icCaches).isEmpty() ? FileUtilKt.checkCaches(libraries, icCaches, arguments2.getIncludes()).getData() : MapsKt.emptyMap(), null, 512, null);
                if (sourceModule == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("sourceModule");
                    modulesStructure = null;
                } else {
                    modulesStructure = sourceModule;
                }
                result232 = modulesStructure.getJsFrontEndResult().getJsAnalysisResult();
                if (!(result232 instanceof JsAnalysisResult.RetryWithAdditionalRoots)) continue;
                environmentForJS.addKotlinSourceRoots(((JsAnalysisResult.RetryWithAdditionalRoots)result232).getAdditionalKotlinRoots());
            } while (result232 instanceof JsAnalysisResult.RetryWithAdditionalRoots);
            if (!sourceModule.getJsFrontEndResult().getJsAnalysisResult().getShouldGenerateCode()) {
                return ExitCode.OK;
            }
        }
        if (arguments2.getIrProduceKlibDir() || arguments2.getIrProduceKlibFile()) {
            ModulesStructure modulesStructure;
            boolean result232;
            if (arguments2.getIrProduceKlibFile() && !(result232 = Intrinsics.areEqual(FilesKt.getExtension(outputFile), "klib"))) {
                boolean $i$a$-require-K2JsIrCompiler$doExecute$232 = false;
                String $i$a$-require-K2JsIrCompiler$doExecute$232 = "Please set up .klib file as output";
                throw new IllegalArgumentException($i$a$-require-K2JsIrCompiler$doExecute$232.toString());
            }
            if (sourceModule == null) {
                Intrinsics.throwUninitializedPropertyAccessException("sourceModule");
                modulesStructure = null;
            } else {
                modulesStructure = sourceModule;
            }
            IrFactory irFactory = new PersistentIrFactory();
            result232 = outputFile.getPath();
            Intrinsics.checkNotNullExpressionValue(result232, "outputFile.path");
            KlibKt.generateKLib$default(modulesStructure, irFactory, (String)result232, arguments2.getIrProduceKlibDir(), false, null, arguments2.getIrPerModuleOutputName(), 48, null);
        }
        if (arguments2.getIrProduceJs()) {
            CompilationOutputs compilationOutputs;
            Object runner;
            ModulesStructure module2;
            ModulesStructure modulesStructure;
            boolean bl;
            Object object22;
            MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.INFO, Intrinsics.stringPlus("Produce executable: ", outputFilePath), null, 4, null);
            result232 = arguments2.getCacheDirectories();
            MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.INFO, (String)(result232 == null ? "" : result232), null, 4, null);
            PhaseConfig phaseConfig = CreatePhaseConfigKt.createPhaseConfig((CompilerPhase)JsLoweringPhasesKt.getJsPhases(), arguments2, messageCollector2);
            String includes = arguments2.getIncludes();
            if (includes != null) {
                Object v11;
                String includesPath;
                block50: {
                    Iterable iterable;
                    if (!((Collection)sourcesFiles).isEmpty()) {
                        MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.ERROR, "Source files are not supported when -Xinclude is present", null, 4, null);
                    }
                    includesPath = new File(includes).getCanonicalPath();
                    Iterable iterable3 = iterable = (Iterable)libraries;
                    for (Object object22 : iterable3) {
                        String string7 = (String)object22;
                        bl = false;
                        if (!Intrinsics.areEqual(new File(string7).getCanonicalPath(), includesPath)) continue;
                        v11 = object22;
                        break block50;
                    }
                    v11 = null;
                }
                String invalidationType = v11;
                if (invalidationType == null) {
                    throw new IllegalStateException(("No library with name " + includes + " (" + includesPath + ") found").toString());
                }
                String mainLibPath = invalidationType;
                MainModule.Klib kLib = new MainModule.Klib(mainLibPath);
                modulesStructure = new ModulesStructure(projectJs, kLib, configurationJs, libraries, friendLibraries, !((Collection)icCaches).isEmpty(), !((Collection)icCaches).isEmpty(), !((Collection)icCaches).isEmpty() ? FileUtilKt.checkCaches(libraries, icCaches, includes).getData() : MapsKt.emptyMap());
            } else if (sourceModule == null) {
                Intrinsics.throwUninitializedPropertyAccessException("sourceModule");
                modulesStructure = null;
            } else {
                modulesStructure = module2 = sourceModule;
            }
            if (arguments2.getWasm()) {
                WasmCompilerResult res2 = org.jetbrains.kotlin.backend.wasm.CompilerKt.compileWasm(module2, new PhaseConfig(WasmLoweringPhasesKt.getWasmPhases(), null, null, null, null, null, null, null, null, null, null, false, false, false, 16382, null), IrFactoryImpl.INSTANCE, SetsKt.setOf(new FqName("main")));
                File file5 = FileUtilsKt.withReplacedExtensionOrNull(outputFile, FilesKt.getExtension(outputFile), "wasm");
                Intrinsics.checkNotNull(file5);
                File outputWasmFile = file5;
                FilesKt.writeBytes(outputWasmFile, res2.getWasm());
                File file6 = FileUtilsKt.withReplacedExtensionOrNull(outputFile, FilesKt.getExtension(outputFile), "wat");
                Intrinsics.checkNotNull(file6);
                File outputWatFile = file6;
                FilesKt.writeText$default(outputWatFile, res2.getWat(), null, 2, null);
                runner = kotlin.text.StringsKt.trimIndent("\n                    const wasmBinary = read(String.raw`" + outputWasmFile.getAbsoluteFile() + "`, 'binary');\n                    const wasmModule = new WebAssembly.Module(wasmBinary);\n                    wasmInstance = new WebAssembly.Instance(wasmModule, { runtime, js_code });\n                    wasmInstance.exports.main();\n                ");
                FilesKt.writeText$default(outputFile, res2.getJs() + '\n' + (String)runner, null, 2, null);
                return ExitCode.OK;
            }
            long start = System.currentTimeMillis();
            runner = arguments2.getIrDceDriven() ? (IrFactory)new PersistentIrFactory() : (IrFactory)IrFactoryImpl.INSTANCE;
            boolean bl3 = !arguments2.getIrDce();
            boolean bl4 = arguments2.getIrDce();
            object22 = K2JsIrCompilerKt.resolve(RuntimeDiagnostic.Companion, arguments2.getIrDceRuntimeDiagnostic(), messageCollector2);
            boolean bl2 = arguments2.getIrDceDriven();
            bl = arguments2.getIrPerModule();
            boolean bl5 = arguments2.getIrPropertyLazyInitialization();
            boolean bl6 = arguments2.getIrLegacyPropertyAccess();
            boolean bl7 = arguments2.getIrBaseClassInMetadata();
            boolean bl8 = arguments2.getIrSafeExternalBoolean();
            RuntimeDiagnostic runtimeDiagnostic = K2JsIrCompilerKt.resolve(RuntimeDiagnostic.Companion, arguments2.getIrSafeExternalBooleanDiagnostic(), messageCollector2);
            boolean bl9 = !((Collection)icCaches).isEmpty();
            CompilerResult compiledModule = CompilerKt.compile$default(module2, phaseConfig, (IrFactory)runner, mainCallArguments, null, bl3, bl4, bl2, object22, false, bl, true, bl5, false, bl6, bl7, bl9, bl8, runtimeDiagnostic, 8720, null);
            MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.INFO, "Executable production duration: " + (System.currentTimeMillis() - start) + "ms", null, 4, null);
            if (arguments2.getIrDce() && !arguments2.getIrDceDriven()) {
                CompilationOutputs compilationOutputs2 = compiledModule.getOutputsAfterDce();
                compilationOutputs = compilationOutputs2;
                Intrinsics.checkNotNull(compilationOutputs2);
            } else {
                CompilationOutputs compilationOutputs3 = compiledModule.getOutputs();
                compilationOutputs = compilationOutputs3;
                Intrinsics.checkNotNull(compilationOutputs3);
            }
            CompilationOutputs outputs = compilationOutputs;
            this.write(outputFile, outputs);
            Iterable<Pair<String, CompilationOutputs>> $this$forEach$iv = outputs.getDependencies();
            boolean $i$f$forEach = false;
            for (Object e : $this$forEach$iv) {
                Pair $dstr$name$content = (Pair)e;
                boolean bl10 = false;
                String name = (String)$dstr$name$content.component1();
                CompilationOutputs content = (CompilationOutputs)$dstr$name$content.component2();
                this.write(FilesKt.resolveSibling(outputFile, Intrinsics.stringPlus(name, ".js")), content);
            }
            if (arguments2.getGenerateDts()) {
                File file7 = FileUtilsKt.withReplacedExtensionOrNull(outputFile, FilesKt.getExtension(outputFile), "d.ts");
                Intrinsics.checkNotNull(file7);
                File dtsFile = file7;
                String string8 = compiledModule.getTsDefinitions();
                if (string8 == null) {
                    throw new IllegalStateException("No ts definitions".toString());
                }
                FilesKt.writeText$default(dtsFile, string8, null, 2, null);
            }
        }
        return ExitCode.OK;
    }

    private final void write(File $this$write, CompilationOutputs outputs) {
        FilesKt.writeText$default($this$write, outputs.getJsCode(), null, 2, null);
        String string2 = outputs.getSourceMap();
        if (string2 != null) {
            String string3;
            String it = string3 = string2;
            boolean bl = false;
            File mapFile = FilesKt.resolveSibling($this$write, Intrinsics.stringPlus($this$write.getName(), ".map"));
            FilesKt.appendText$default($this$write, Intrinsics.stringPlus("\n//# sourceMappingURL=", mapFile.getName()), null, 2, null);
            FilesKt.writeText$default(mapFile, it, null, 2, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void setupPlatformSpecificArgumentsAndServices(@NotNull CompilerConfiguration configuration, @NotNull K2JSCompilerArguments arguments2, @NotNull Services services) {
        String sourceMapEmbedContentString;
        SourceMapSourceEmbedding sourceMapContentEmbedding;
        ErrorTolerancePolicy errorTolerancePolicy;
        String moduleKindName;
        ModuleKind moduleKind;
        String $this$filterNotTo$iv$iv;
        Object destination$iv$iv;
        List<String> list2;
        Intrinsics.checkNotNullParameter(configuration, "configuration");
        Intrinsics.checkNotNullParameter(arguments2, "arguments");
        Intrinsics.checkNotNullParameter(services, "services");
        MessageCollector messageCollector = configuration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        Intrinsics.checkNotNullExpressionValue(messageCollector, "configuration.getNotNull\u2026ys.MESSAGE_COLLECTOR_KEY)");
        MessageCollector messageCollector2 = messageCollector;
        if (arguments2.getTarget() != null) {
            boolean bl = Intrinsics.areEqual("v5", arguments2.getTarget());
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-K2JsIrCompiler$setupPlatformSpecificArgumentsAndServices$22 = false;
                String string2 = arguments2.getTarget();
                Intrinsics.checkNotNull(string2);
                String $i$a$-assert-K2JsIrCompiler$setupPlatformSpecificArgumentsAndServices$22 = Intrinsics.stringPlus("Unsupported ECMA version: ", string2);
                throw new AssertionError((Object)$i$a$-assert-K2JsIrCompiler$setupPlatformSpecificArgumentsAndServices$22);
            }
        }
        configuration.put(JSConfigurationKeys.TARGET, EcmaVersion.defaultVersion());
        if (arguments2.getSourceMap()) {
            String sourceMapSourceRoots;
            configuration.put(JSConfigurationKeys.SOURCE_MAP, true);
            if (arguments2.getSourceMapPrefix() != null) {
                String string3 = arguments2.getSourceMapPrefix();
                Intrinsics.checkNotNull(string3);
                configuration.put(JSConfigurationKeys.SOURCE_MAP_PREFIX, string3);
            }
            if ((sourceMapSourceRoots = arguments2.getSourceMapBaseDirs()) == null && StringUtil.isNotEmpty(arguments2.getSourceMapPrefix())) {
                sourceMapSourceRoots = K2JSCompiler.calculateSourceMapSourceRoot(messageCollector2, arguments2);
            }
            if (sourceMapSourceRoots != null) {
                list2 = StringUtil.split(sourceMapSourceRoots, File.pathSeparator);
                Intrinsics.checkNotNullExpressionValue(list2, "split(sourceMapSourceRoots, File.pathSeparator)");
                List<String> sourceMapSourceRootList = list2;
                configuration.put(JSConfigurationKeys.SOURCE_MAP_SOURCE_ROOTS, sourceMapSourceRootList);
            }
        } else {
            if (arguments2.getSourceMapPrefix() != null) {
                messageCollector2.report(CompilerMessageSeverity.WARNING, "source-map-prefix argument has no effect without source map", null);
            }
            if (arguments2.getSourceMapBaseDirs() != null) {
                messageCollector2.report(CompilerMessageSeverity.WARNING, "source-map-source-root argument has no effect without source map", null);
            }
        }
        if (arguments2.getMetaInfo()) {
            configuration.put(JSConfigurationKeys.META_INFO, true);
        }
        configuration.put(JSConfigurationKeys.TYPED_ARRAYS_ENABLED, arguments2.getTypedArrays());
        configuration.put(JSConfigurationKeys.FRIEND_PATHS_DISABLED, arguments2.getFriendModulesDisabled());
        String friendModules = arguments2.getFriendModules();
        if (!arguments2.getFriendModulesDisabled() && friendModules != null) {
            void $this$filterNot$iv;
            List list3;
            Iterable $this$dropLastWhile$iv;
            list2 = friendModules;
            Object object = File.pathSeparator;
            Intrinsics.checkNotNullExpressionValue(object, "pathSeparator");
            object = new Regex((String)object);
            int n = 0;
            list2 = ((Regex)object).split((CharSequence)((Object)list2), n);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl = false;
                    if (((CharSequence)it).length() == 0) continue;
                    list3 = CollectionsKt.take($this$dropLastWhile$iv, iterator$iv.nextIndex() + 1);
                    break;
                }
            } else {
                list3 = CollectionsKt.emptyList();
            }
            $this$dropLastWhile$iv = list3;
            boolean $i$f$filterNot = false;
            void iterator$iv = $this$filterNot$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            Iterator iterator2 = $this$filterNotTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv$iv = iterator2.next();
                String it = (String)element$iv$iv;
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List friendPaths = (List)destination$iv$iv;
            configuration.put(JSConfigurationKeys.FRIEND_PATHS, friendPaths);
        }
        ModuleKind moduleKind2 = moduleKind = (moduleKindName = arguments2.getModuleKind()) != null ? moduleKindMap.get(moduleKindName) : ModuleKind.PLAIN;
        if (moduleKind == null) {
            messageCollector2.report(CompilerMessageSeverity.ERROR, "Unknown module kind: " + moduleKindName + ". Valid values are: plain, amd, commonjs, umd", null);
            moduleKind = ModuleKind.PLAIN;
        }
        configuration.put(JSConfigurationKeys.MODULE_KIND, moduleKind);
        configuration.putIfNotNull(JSConfigurationKeys.INCREMENTAL_DATA_PROVIDER, services.get(IncrementalDataProvider.class));
        configuration.putIfNotNull(JSConfigurationKeys.INCREMENTAL_RESULTS_CONSUMER, services.get(IncrementalResultsConsumer.class));
        configuration.putIfNotNull(JSConfigurationKeys.INCREMENTAL_NEXT_ROUND_CHECKER, services.get(IncrementalNextRoundChecker.class));
        configuration.putIfNotNull(CommonConfigurationKeys.LOOKUP_TRACKER, services.get(LookupTracker.class));
        configuration.putIfNotNull(CommonConfigurationKeys.EXPECT_ACTUAL_TRACKER, services.get(ExpectActualTracker.class));
        $this$filterNotTo$iv$iv = arguments2.getErrorTolerancePolicy();
        if ($this$filterNotTo$iv$iv == null) {
            errorTolerancePolicy = null;
        } else {
            Object it = destination$iv$iv = $this$filterNotTo$iv$iv;
            boolean bl = false;
            errorTolerancePolicy = ErrorTolerancePolicy.Companion.resolvePolicy((String)it);
        }
        ErrorTolerancePolicy errorTolerancePolicy2 = errorTolerancePolicy;
        configuration.putIfNotNull(JSConfigurationKeys.ERROR_TOLERANCE_POLICY, errorTolerancePolicy2);
        $this$filterNotTo$iv$iv = errorTolerancePolicy2;
        if ($this$filterNotTo$iv$iv == null ? false : ((ErrorTolerancePolicy)((Object)$this$filterNotTo$iv$iv)).getAllowErrors()) {
            configuration.put(JSConfigurationKeys.DEVELOPER_MODE, true);
        }
        SourceMapSourceEmbedding sourceMapSourceEmbedding = sourceMapContentEmbedding = (sourceMapEmbedContentString = arguments2.getSourceMapEmbedSources()) != null ? sourceMapContentEmbeddingMap.get(sourceMapEmbedContentString) : SourceMapSourceEmbedding.INLINING;
        if (sourceMapContentEmbedding == null) {
            String message2 = "Unknown source map source embedding mode: " + sourceMapEmbedContentString + ". Valid values are: " + StringUtil.join((Collection<String>)sourceMapContentEmbeddingMap.keySet(), ", ");
            messageCollector2.report(CompilerMessageSeverity.ERROR, message2, null);
            sourceMapContentEmbedding = SourceMapSourceEmbedding.INLINING;
        }
        configuration.put(JSConfigurationKeys.SOURCE_MAP_EMBED_SOURCES, sourceMapContentEmbedding);
        if (!arguments2.getSourceMap() && sourceMapEmbedContentString != null) {
            messageCollector2.report(CompilerMessageSeverity.WARNING, "source-map-embed-sources argument has no effect without source map", null);
        }
        configuration.put(JSConfigurationKeys.PRINT_REACHABILITY_INFO, arguments2.getIrDcePrintReachabilityInfo());
        configuration.put(JSConfigurationKeys.FAKE_OVERRIDE_VALIDATOR, arguments2.getFakeOverrideValidator());
    }

    @Override
    @NotNull
    public String executableScriptFileName() {
        throw new NotImplementedError(Intrinsics.stringPlus("An operation is not implemented: ", "Provide a proper way to run the compiler with IR BE"));
    }

    @Override
    @NotNull
    protected BinaryVersion createMetadataVersion(@NotNull int[] versionArray) {
        Intrinsics.checkNotNullParameter(versionArray, "versionArray");
        return new KlibMetadataVersion(Arrays.copyOf(versionArray, versionArray.length));
    }

    @Override
    protected void addPlatformOptions(@NotNull List<String> $this$addPlatformOptions, @NotNull K2JSCompilerArguments arguments2) {
        Intrinsics.checkNotNullParameter($this$addPlatformOptions, "<this>");
        Intrinsics.checkNotNullParameter(arguments2, "arguments");
    }

    @JvmStatic
    public static final void main(@NotNull String[] args2) {
        Companion.main(args2);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to("plain", ModuleKind.PLAIN), TuplesKt.to("commonjs", ModuleKind.COMMON_JS), TuplesKt.to("amd", ModuleKind.AMD), TuplesKt.to("umd", ModuleKind.UMD)};
        moduleKindMap = MapsKt.mapOf(pairArray);
        pairArray = new Pair[]{TuplesKt.to("always", SourceMapSourceEmbedding.ALWAYS), TuplesKt.to("never", SourceMapSourceEmbedding.NEVER), TuplesKt.to("inlining", SourceMapSourceEmbedding.INLINING)};
        sourceMapContentEmbeddingMap = MapsKt.mapOf(pairArray);
        pairArray = new Pair[]{TuplesKt.to(null, ProduceKind.DEFAULT), TuplesKt.to("js", ProduceKind.JS), TuplesKt.to("klib", ProduceKind.KLIB)};
        produceMap = MapsKt.mapOf(pairArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u0002J\u001b\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u0011H\u0007\u00a2\u0006\u0002\u0010\u0012J\u001e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\fH\u0002J\u0012\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\f*\u00020\u0005H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u00020\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/cli/js/K2JsIrCompiler$Companion;", "", "()V", "moduleKindMap", "", "", "Lorg/jetbrains/kotlin/serialization/js/ModuleKind;", "produceMap", "Lorg/jetbrains/kotlin/cli/js/ProduceKind;", "sourceMapContentEmbeddingMap", "Lorg/jetbrains/kotlin/js/config/SourceMapSourceEmbedding;", "configureLibraries", "", "libraryString", "main", "", "args", "", "([Ljava/lang/String;)V", "reportCompiledSourcesList", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "sourceFiles", "Lorg/jetbrains/kotlin/psi/KtFile;", "splitByPathSeparator", "cli-js"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void main(@NotNull String[] args2) {
            Intrinsics.checkNotNullParameter(args2, "args");
            CLITool.Companion.doMain(new K2JsIrCompiler(), args2);
        }

        /*
         * WARNING - void declaration
         */
        private final void reportCompiledSourcesList(MessageCollector messageCollector, List<? extends KtFile> sourceFiles2) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = sourceFiles2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void file2;
                KtFile ktFile = (KtFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                VirtualFile virtualFile2 = file2.getVirtualFile();
                String string2 = virtualFile2 != null ? MessageUtil.virtualFileToPath(virtualFile2) : Intrinsics.stringPlus(file2.getName(), " (no virtual file)");
                collection.add(string2);
            }
            List fileNames = (List)destination$iv$iv;
            messageCollector.report(CompilerMessageSeverity.LOGGING, Intrinsics.stringPlus("Compiling source files: ", StringsKt.join(fileNames, ", ")), null);
        }

        private final List<String> configureLibraries(String libraryString) {
            String string2 = libraryString;
            return string2 == null ? CollectionsKt.emptyList() : this.splitByPathSeparator(string2);
        }

        /*
         * WARNING - void declaration
         */
        private final List<String> splitByPathSeparator(String $this$splitByPathSeparator) {
            void $this$filterNotTo$iv$iv;
            List list2;
            String[] it;
            CharSequence charSequence2 = $this$splitByPathSeparator;
            Object object = File.pathSeparator;
            Intrinsics.checkNotNullExpressionValue(object, "pathSeparator");
            object = new Regex((String)object);
            int n = 0;
            List<String> $this$dropLastWhile$iv = ((Regex)object).split(charSequence2, n);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator<String> iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    it = iterator$iv.previous();
                    boolean bl = false;
                    if (((CharSequence)it).length() == 0) continue;
                    list2 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, iterator$iv.nextIndex() + 1);
                    break;
                }
            } else {
                list2 = CollectionsKt.emptyList();
            }
            String[] $this$toTypedArray$iv = (String[])list2;
            boolean $i$f$toTypedArray = false;
            String[] thisCollection$iv = $this$toTypedArray$iv;
            it = thisCollection$iv.toArray(new String[0]);
            if (it == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            String[] $this$filterNot$iv = it;
            boolean $i$f$filterNot = false;
            thisCollection$iv = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            void var7_10 = $this$filterNotTo$iv$iv;
            int n2 = 0;
            int n3 = ((void)var7_10).length;
            while (n2 < n3) {
                void element$iv$iv = var7_10[n2];
                ++n2;
                String it2 = (String)element$iv$iv;
                boolean bl = false;
                if (((CharSequence)it2).length() == 0) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

