/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.js.dce;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.CLITool;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.arguments.K2JSDceArguments;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.js.dce.K2JSDce;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.js.dce.Context;
import org.jetbrains.kotlin.js.dce.DCELogLevel;
import org.jetbrains.kotlin.js.dce.DeadCodeElimination;
import org.jetbrains.kotlin.js.dce.DeadCodeEliminationResult;
import org.jetbrains.kotlin.js.dce.DeadCodeEliminationStatus;
import org.jetbrains.kotlin.js.dce.InputFile;
import org.jetbrains.kotlin.js.dce.InputResource;
import org.jetbrains.kotlin.js.dce.PrintTreeKt;
import org.jetbrains.kotlin.js.dce.UtilKt;
import org.jetbrains.kotlin.js.parser.sourcemaps.JSONKt;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonArray;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonNode;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonObject;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonString;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonSyntaxException;
import org.jetbrains.kotlin.js.sourceMap.RelativePathCalculator;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 &2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001&B\u0005\u00a2\u0006\u0002\u0010\u0003J&\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\nH\u0002J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\nH\u0002J\u001e\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J \u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0019\u001a\u00020\u0002H\u0016J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0002H\u0014J\b\u0010\u001f\u001a\u00020\nH\u0016J\u0010\u0010 \u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\nH\u0002J\u0018\u0010!\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\bH\u0002J&\u0010#\u001a\u00020\u001b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010$\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\nH\u0002J\f\u0010%\u001a\u00020\n*\u00020\nH\u0002\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/cli/js/dce/K2JSDce;", "Lorg/jetbrains/kotlin/cli/common/CLITool;", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JSDceArguments;", "()V", "collectInputFiles", "", "Lorg/jetbrains/kotlin/js/dce/InputFile;", "baseDir", "Ljava/io/File;", "fileName", "", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "collectInputFilesFromDirectory", "path", "collectInputFilesFromZip", "copyFiles", "", "files", "overwriteOnlyOlderFiles", "", "copyResource", "resource", "Lorg/jetbrains/kotlin/js/dce/InputResource;", "targetFile", "createArguments", "execImpl", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "services", "Lorg/jetbrains/kotlin/config/Services;", "arguments", "executableScriptFileName", "getModuleNameFromPath", "mapSourcePaths", "inputFile", "performDce", "singleInputFile", "metaJs", "Companion", "cli-js"})
public final class K2JSDce
extends CLITool<K2JSDceArguments> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public K2JSDceArguments createArguments() {
        return new K2JSDceArguments();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected ExitCode execImpl(@NotNull MessageCollector messageCollector, @NotNull Services services, @NotNull K2JSDceArguments arguments2) {
        ExitCode exitCode;
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(messageCollector, "messageCollector");
        Intrinsics.checkNotNullParameter(services, "services");
        Intrinsics.checkNotNullParameter(arguments2, "arguments");
        String string2 = arguments2.getOutputDirectory();
        File baseDir = new File(string2 == null ? "min" : string2);
        Iterable $this$flatMap$iv = arguments2.getFreeArgs();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            String arg = (String)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.collectInputFiles(baseDir, arg, messageCollector);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        List files2 = (List)destination$iv$iv;
        if (messageCollector.hasErrors()) {
            return ExitCode.COMPILATION_ERROR;
        }
        if (files2.isEmpty() && !arguments2.getVersion()) {
            MessageCollector.DefaultImpls.report$default(messageCollector, CompilerMessageSeverity.ERROR, "no source files", null, 4, null);
            return ExitCode.COMPILATION_ERROR;
        }
        Map existingFiles = new LinkedHashMap();
        for (Object file2 : files2) {
            Object object = (InputFile)existingFiles.get(((InputFile)file2).getOutputPath());
            if (object != null) {
                InputFile inputFile;
                InputFile it = inputFile = object;
                boolean bl = false;
                MessageCollector.DefaultImpls.report$default(messageCollector, CompilerMessageSeverity.ERROR, "duplicate target file will be created for '" + ((InputFile)file2).getResource().getName() + "' and '" + it.getResource().getName() + '\'', null, 4, null);
                return ExitCode.COMPILATION_ERROR;
            }
            object = existingFiles;
            String string3 = ((InputFile)file2).getOutputPath();
            object.put(string3, file2);
            if (!new File(((InputFile)file2).getOutputPath()).isDirectory()) continue;
            MessageCollector.DefaultImpls.report$default(messageCollector, CompilerMessageSeverity.ERROR, "cannot open output file '" + ((InputFile)file2).getOutputPath() + "': it is a directory", null, 4, null);
            return ExitCode.COMPILATION_ERROR;
        }
        if (!arguments2.getDevMode()) {
            exitCode = this.performDce(files2, arguments2, messageCollector);
        } else {
            Object file2;
            file2 = arguments2.getDevModeOverwritingStrategy();
            Object devModeOverwritingStrategy = file2 == null ? System.getProperty("kotlin.js.dce.devmode.overwriting.strategy", "older") : file2;
            boolean overwriteOnlyOlderFiles = Intrinsics.areEqual(devModeOverwritingStrategy, "older");
            this.copyFiles(files2, overwriteOnlyOlderFiles);
            exitCode = ExitCode.OK;
        }
        return exitCode;
    }

    private final ExitCode performDce(List<InputFile> files2, K2JSDceArguments arguments2, MessageCollector messageCollector) {
        String[] stringArray;
        String[] $this$orEmpty$iv = arguments2.getDeclarationsToKeep();
        boolean $i$f$orEmpty = false;
        String[] stringArray2 = $this$orEmpty$iv;
        if (stringArray2 == null) {
            boolean $i$f$emptyArray = false;
            stringArray = new String[]{};
        } else {
            stringArray = stringArray2;
        }
        Set<String> includedDeclarations = ArraysKt.toSet(stringArray);
        Function2 logConsumer2 = new Function2<DCELogLevel, String, Unit>(messageCollector){
            final /* synthetic */ MessageCollector $messageCollector;
            {
                this.$messageCollector = $messageCollector;
                super(2);
            }

            public final void invoke(@NotNull DCELogLevel level, @NotNull String message2) {
                CompilerMessageSeverity compilerMessageSeverity;
                Intrinsics.checkNotNullParameter((Object)((Object)level), "level");
                Intrinsics.checkNotNullParameter(message2, "message");
                DCELogLevel dCELogLevel = level;
                int n = performDce.logConsumer.WhenMappings.$EnumSwitchMapping$0[dCELogLevel.ordinal()];
                switch (n) {
                    case 1: {
                        compilerMessageSeverity = CompilerMessageSeverity.ERROR;
                        break;
                    }
                    case 2: {
                        compilerMessageSeverity = CompilerMessageSeverity.WARNING;
                        break;
                    }
                    case 3: {
                        compilerMessageSeverity = CompilerMessageSeverity.LOGGING;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                CompilerMessageSeverity severity = compilerMessageSeverity;
                MessageCollector.DefaultImpls.report$default(this.$messageCollector, severity, message2, null, 4, null);
            }
        };
        DeadCodeEliminationResult dceResult = DeadCodeElimination.Companion.run((Collection<InputFile>)files2, includedDeclarations, arguments2.getPrintReachabilityInfo(), logConsumer2);
        if (dceResult.getStatus() == DeadCodeEliminationStatus.FAILED) {
            return ExitCode.COMPILATION_ERROR;
        }
        if (arguments2.getPrintReachabilityInfo()) {
            CompilerMessageSeverity reachabilitySeverity = CompilerMessageSeverity.INFO;
            MessageCollector.DefaultImpls.report$default(messageCollector, reachabilitySeverity, "", null, 4, null);
            Iterable<Context.Node> iterable = dceResult.getReachableNodes();
            Context context2 = dceResult.getContext();
            Intrinsics.checkNotNull(context2);
            for (Context.Node node : UtilKt.extractReachableRoots(iterable, context2)) {
                PrintTreeKt.printTree(node, (Function1<? super String, Unit>)new Function1<String, Unit>(messageCollector, reachabilitySeverity){
                    final /* synthetic */ MessageCollector $messageCollector;
                    final /* synthetic */ CompilerMessageSeverity $reachabilitySeverity;
                    {
                        this.$messageCollector = $messageCollector;
                        this.$reachabilitySeverity = $reachabilitySeverity;
                        super(1);
                    }

                    public final void invoke(@NotNull String it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        MessageCollector.DefaultImpls.report$default(this.$messageCollector, this.$reachabilitySeverity, it, null, 4, null);
                    }
                }, false, true);
            }
        }
        return ExitCode.OK;
    }

    private final void copyFiles(List<InputFile> files2, boolean overwriteOnlyOlderFiles) {
        for (InputFile file2 : files2) {
            InputResource inputResource;
            this.copyResource(file2.getResource(), new File(file2.getOutputPath()), overwriteOnlyOlderFiles);
            InputResource inputResource2 = file2.getSourceMapResource();
            if (inputResource2 == null) continue;
            InputResource sourceMap2 = inputResource = inputResource2;
            boolean bl = false;
            File sourceMapTarget = new File(Intrinsics.stringPlus(file2.getOutputPath(), ".map"));
            File inputFile = new File(sourceMap2.getName());
            if (inputFile.exists() && this.mapSourcePaths(inputFile, sourceMapTarget)) continue;
            this.copyResource(sourceMap2, sourceMapTarget, overwriteOnlyOlderFiles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void copyResource(InputResource resource, File targetFile, boolean overwriteOnlyOlderFiles) {
        if (overwriteOnlyOlderFiles && targetFile.exists() && ((Number)resource.getLastModified().invoke()).longValue() < targetFile.lastModified()) {
            return;
        }
        targetFile.getParentFile().mkdirs();
        Closeable closeable = resource.getReader().invoke();
        Throwable throwable = null;
        try {
            long l;
            InputStream input = (InputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = new FileOutputStream(targetFile);
            Throwable throwable2 = null;
            try {
                FileOutputStream output = (FileOutputStream)closeable2;
                boolean bl2 = false;
                l = ByteStreamsKt.copyTo$default(input, output, 0, 2, null);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally(closeable2, throwable2);
            }
            long l2 = l;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final boolean mapSourcePaths(File inputFile, File targetFile) {
        void $this$toTypedArray$iv;
        Collection<JsonString> collection;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        JsonString[] $this$mapTo$iv$iv2;
        String string2;
        Iterator it;
        Object object;
        Object object2;
        void $this$mapTo$iv$iv3;
        Object object3;
        JsonNode jsonNode;
        JsonObject jsonObject;
        JsonNode jsonNode2;
        try {
            jsonNode2 = JSONKt.parseJson(inputFile);
        }
        catch (JsonSyntaxException e) {
            return false;
        }
        JsonNode json = jsonNode2;
        JsonObject jsonObject2 = jsonObject = json instanceof JsonObject ? (JsonObject)json : null;
        if (jsonObject == null) {
            jsonNode = null;
        } else {
            object3 = jsonObject.getProperties();
            jsonNode = object3.get("sources");
        }
        JsonNode jsonNode3 = jsonNode;
        JsonArray jsonArray = e = jsonNode3 instanceof JsonArray ? (JsonArray)jsonNode3 : null;
        if (e == null) {
            return false;
        }
        JsonArray sourcesArray = e;
        Iterable $this$map$iv2 = sourcesArray.getElements();
        boolean $i$f$map232 = false;
        object3 = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        boolean $i$f$mapTo232 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            JsonNode jsonNode4 = (JsonNode)item$iv$iv;
            object2 = destination$iv$iv;
            boolean bl = false;
            Object object4 = object = it instanceof JsonString ? (JsonString)((Object)it) : null;
            if (object == null) {
                return false;
            }
            string2 = ((JsonString)object).getValue();
            object2.add(string2);
        }
        List sources = (List)destination$iv$iv;
        File $i$f$map232 = targetFile.getParentFile();
        Intrinsics.checkNotNullExpressionValue($i$f$map232, "targetFile.parentFile");
        RelativePathCalculator pathCalculator = new RelativePathCalculator($i$f$map232);
        Iterable $this$map$iv3 = sources;
        boolean $i$f$map = false;
        Iterable $i$f$mapTo232 = $this$map$iv3;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv3, 10));
        boolean $i$f$mapTo = false;
        for (Object t : $this$mapTo$iv$iv2) {
            void it2;
            object = (String)t;
            object2 = destination$iv$iv2;
            boolean bl = false;
            String result2 = pathCalculator.calculateRelativePathTo(new File(inputFile.getParentFile(), (String)it2));
            string2 = result2 != null ? (new File(targetFile.getParentFile(), result2).exists() ? result2 : it2) : it2;
            object2.add(string2);
        }
        List mappedSources = (List)destination$iv$iv2;
        if (Intrinsics.areEqual(mappedSources, sources)) {
            return false;
        }
        destination$iv$iv2 = mappedSources;
        string2 = "sources";
        object2 = ((JsonObject)json).getProperties();
        boolean $i$f$map3 = false;
        it = $this$map$iv;
        Collection jsonStringArray = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it3;
            String string3 = (String)item$iv$iv;
            collection = jsonStringArray;
            boolean bl = false;
            JsonString jsonString = new JsonString((String)it3);
            collection.add(jsonString);
        }
        collection = (List)jsonStringArray;
        $this$map$iv = collection;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        JsonString[] jsonStringArray2 = thisCollection$iv.toArray(new JsonString[0]);
        if (jsonStringArray2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        $this$mapTo$iv$iv2 = jsonStringArray2;
        JsonNode[] jsonNodeArray = Arrays.copyOf($this$mapTo$iv$iv2, $this$mapTo$iv$iv2.length);
        object2.put(string2, new JsonArray(jsonNodeArray));
        targetFile.getParentFile().mkdirs();
        object3 = new OutputStreamWriter((OutputStream)new FileOutputStream(targetFile), "UTF-8");
        Throwable throwable = null;
        try {
            OutputStreamWriter it4 = (OutputStreamWriter)object3;
            boolean bl = false;
            it4.write(json.toString());
            Unit unit2 = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object3, throwable);
        }
        return true;
    }

    private final List<InputFile> collectInputFiles(File baseDir, String fileName, MessageCollector messageCollector) {
        List<InputFile> list2;
        File file2 = new File(fileName);
        if (file2.isDirectory()) {
            list2 = this.collectInputFilesFromDirectory(baseDir, fileName);
        } else if (file2.isFile()) {
            if (StringsKt.endsWith$default(fileName, ".js", false, 2, null)) {
                list2 = CollectionsKt.listOf(this.singleInputFile(baseDir, fileName));
            } else if (StringsKt.endsWith$default(fileName, ".zip", false, 2, null) || StringsKt.endsWith$default(fileName, ".jar", false, 2, null)) {
                list2 = this.collectInputFilesFromZip(baseDir, fileName);
            } else {
                MessageCollector.DefaultImpls.report$default(messageCollector, CompilerMessageSeverity.WARNING, "invalid file name '" + file2.getAbsolutePath() + "'; must end either with '.js', '.zip' or '.jar'", null, 4, null);
                list2 = CollectionsKt.emptyList();
            }
        } else {
            MessageCollector.DefaultImpls.report$default(messageCollector, CompilerMessageSeverity.ERROR, Intrinsics.stringPlus("source file or directory not found: ", fileName), null, 4, null);
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    private final InputFile singleInputFile(File baseDir, String path2) {
        InputResource inputResource;
        String moduleName = this.getModuleNameFromPath(path2);
        String pathToSourceMapCandidate = Intrinsics.stringPlus(path2, ".map");
        String pathToSourceMap = new File(pathToSourceMapCandidate).exists() ? pathToSourceMapCandidate : null;
        InputResource inputResource2 = InputResource.Companion.file(path2);
        String string2 = pathToSourceMap;
        if (string2 == null) {
            inputResource = null;
        } else {
            void it;
            String string3;
            String string4 = string3 = string2;
            InputResource inputResource3 = inputResource2;
            boolean bl = false;
            InputResource inputResource4 = InputResource.Companion.file((String)it);
            inputResource2 = inputResource3;
            inputResource = inputResource4;
        }
        string2 = new File(baseDir, Intrinsics.stringPlus(moduleName, ".js")).getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue(string2, "File(baseDir, \"$moduleName.js\").absolutePath");
        String string5 = moduleName;
        String string6 = string2;
        InputResource inputResource5 = inputResource;
        InputResource inputResource6 = inputResource2;
        return new InputFile(inputResource6, inputResource5, string6, string5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<InputFile> collectInputFilesFromZip(File baseDir, String path2) {
        List<InputFile> list2;
        Closeable closeable = new ZipFile(path2);
        Throwable throwable = null;
        try {
            ZipFile zipFile2 = (ZipFile)closeable;
            boolean bl = false;
            Enumeration<? extends ZipEntry> enumeration = zipFile2.entries();
            Intrinsics.checkNotNullExpressionValue(enumeration, "zipFile.entries()");
            list2 = SequencesKt.toList(SequencesKt.map(SequencesKt.distinctBy(SequencesKt.filter(SequencesKt.filter(SequencesKt.filter(SequencesKt.asSequence(CollectionsKt.iterator(enumeration)), collectInputFilesFromZip.1.1.INSTANCE), collectInputFilesFromZip.1.2.INSTANCE), (Function1)new Function1<ZipEntry, Boolean>(zipFile2, this){
                final /* synthetic */ ZipFile $zipFile;
                final /* synthetic */ K2JSDce this$0;
                {
                    this.$zipFile = $zipFile;
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(ZipEntry it) {
                    String string2 = it.getName();
                    Intrinsics.checkNotNullExpressionValue(string2, "it.name");
                    return this.$zipFile.getEntry(K2JSDce.access$metaJs(this.this$0, string2)) != null;
                }
            }), collectInputFilesFromZip.1.4.INSTANCE), (Function1)new Function1<ZipEntry, InputFile>(this, zipFile2, path2, baseDir){
                final /* synthetic */ K2JSDce this$0;
                final /* synthetic */ ZipFile $zipFile;
                final /* synthetic */ String $path;
                final /* synthetic */ File $baseDir;
                {
                    this.this$0 = $receiver;
                    this.$zipFile = $zipFile;
                    this.$path = $path;
                    this.$baseDir = $baseDir;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final InputFile invoke(ZipEntry entry) {
                    InputResource inputResource;
                    String string2 = entry.getName();
                    Intrinsics.checkNotNullExpressionValue(string2, "entry.name");
                    String moduleName = K2JSDce.access$getModuleNameFromPath(this.this$0, string2);
                    String pathToSourceMapCandidate = Intrinsics.stringPlus(entry.getName(), ".map");
                    String pathToSourceMap = this.$zipFile.getEntry(pathToSourceMapCandidate) != null ? pathToSourceMapCandidate : null;
                    String string3 = entry.getName();
                    Intrinsics.checkNotNullExpressionValue(string3, "entry.name");
                    InputResource inputResource2 = InputResource.Companion.zipFile(this.$path, string3);
                    string3 = pathToSourceMap;
                    if (string3 == null) {
                        inputResource = null;
                    } else {
                        void it;
                        String string4 = string3;
                        String string5 = this.$path;
                        String string6 = string4;
                        InputResource inputResource3 = inputResource2;
                        boolean bl = false;
                        InputResource inputResource4 = InputResource.Companion.zipFile(string5, (String)it);
                        inputResource2 = inputResource3;
                        inputResource = inputResource4;
                    }
                    string3 = new File(this.$baseDir, Intrinsics.stringPlus(moduleName, ".js")).getAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue(string3, "File(baseDir, \"$moduleName.js\").absolutePath");
                    String string7 = moduleName;
                    String string8 = string3;
                    InputResource inputResource5 = inputResource;
                    InputResource inputResource6 = inputResource2;
                    return new InputFile(inputResource6, inputResource5, string8, string7);
                }
            }));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        return list2;
    }

    private final List<InputFile> collectInputFilesFromDirectory(File baseDir, String path2) {
        return SequencesKt.toList(SequencesKt.map(SequencesKt.filter(SequencesKt.filter(SequencesKt.filter(FilesKt.walkTopDown(new File(path2)), collectInputFilesFromDirectory.1.INSTANCE), collectInputFilesFromDirectory.2.INSTANCE), (Function1)new Function1<File, Boolean>(this){
            final /* synthetic */ K2JSDce this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull File it) {
                Intrinsics.checkNotNullParameter(it, "it");
                String string2 = it.getPath();
                Intrinsics.checkNotNullExpressionValue(string2, "it.path");
                return new File(K2JSDce.access$metaJs(this.this$0, string2)).exists();
            }
        }), (Function1)new Function1<File, InputFile>(this, baseDir){
            final /* synthetic */ K2JSDce this$0;
            final /* synthetic */ File $baseDir;
            {
                this.this$0 = $receiver;
                this.$baseDir = $baseDir;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final InputFile invoke(@NotNull File entry) {
                InputResource inputResource;
                Intrinsics.checkNotNullParameter(entry, "entry");
                String string2 = entry.getName();
                Intrinsics.checkNotNullExpressionValue(string2, "entry.name");
                String moduleName = K2JSDce.access$getModuleNameFromPath(this.this$0, string2);
                String pathToSourceMapCandidate = Intrinsics.stringPlus(entry.getPath(), ".map");
                String pathToSourceMap = new File(pathToSourceMapCandidate).exists() ? pathToSourceMapCandidate : null;
                String string3 = entry.getPath();
                Intrinsics.checkNotNullExpressionValue(string3, "entry.path");
                InputResource inputResource2 = InputResource.Companion.file(string3);
                string3 = pathToSourceMap;
                if (string3 == null) {
                    inputResource = null;
                } else {
                    void it;
                    String string4;
                    String string5 = string4 = string3;
                    InputResource inputResource3 = inputResource2;
                    boolean bl = false;
                    InputResource inputResource4 = InputResource.Companion.file((String)it);
                    inputResource2 = inputResource3;
                    inputResource = inputResource4;
                }
                string3 = new File(this.$baseDir, Intrinsics.stringPlus(moduleName, ".js")).getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue(string3, "File(baseDir, \"$moduleName.js\").absolutePath");
                String string6 = moduleName;
                String string7 = string3;
                InputResource inputResource5 = inputResource;
                InputResource inputResource6 = inputResource2;
                return new InputFile(inputResource6, inputResource5, string7, string6);
            }
        }));
    }

    private final String metaJs(String $this$metaJs) {
        return Intrinsics.stringPlus(StringsKt.removeSuffix($this$metaJs, (CharSequence)".js"), ".meta.js");
    }

    private final String getModuleNameFromPath(String path2) {
        int dotIndex = StringsKt.lastIndexOf$default((CharSequence)path2, '.', 0, false, 6, null);
        int slashIndex = Math.max(StringsKt.lastIndexOf$default((CharSequence)path2, '/', 0, false, 6, null), StringsKt.lastIndexOf$default((CharSequence)path2, '\\', 0, false, 6, null));
        String string2 = path2.substring(slashIndex + 1, dotIndex < 0 ? path2.length() : dotIndex);
        Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string2;
    }

    @Override
    @NotNull
    public String executableScriptFileName() {
        return "kotlin-dce-js";
    }

    @JvmStatic
    public static final void main(@NotNull String[] args2) {
        Companion.main(args2);
    }

    public static final /* synthetic */ String access$metaJs(K2JSDce $this, String $receiver) {
        return $this.metaJs($receiver);
    }

    public static final /* synthetic */ String access$getModuleNameFromPath(K2JSDce $this, String path2) {
        return $this.getModuleNameFromPath(path2);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/cli/js/dce/K2JSDce$Companion;", "", "()V", "main", "", "args", "", "", "([Ljava/lang/String;)V", "cli-js"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void main(@NotNull String[] args2) {
            Intrinsics.checkNotNullParameter(args2, "args");
            CLITool.Companion.doMain(new K2JSDce(), args2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

