/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.cfa;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.CheckersComponentKt;
import org.jetbrains.kotlin.fir.analysis.cfa.AbstractFirPropertyInitializationChecker;
import org.jetbrains.kotlin.fir.analysis.cfa.LocalPropertyAndCapturedWriteCollector;
import org.jetbrains.kotlin.fir.analysis.cfa.PathAwarePropertyInitializationInfo;
import org.jetbrains.kotlin.fir.analysis.cfa.PropertyInitializationInfoCollector;
import org.jetbrains.kotlin.fir.analysis.checkers.cfa.FirControlFlowChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationCheckers;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraph;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J&\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J&\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J&\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J&\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J \u0010\u001f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/fir/analysis/cfa/FirControlFlowAnalyzer;", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "declarationCheckers", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/DeclarationCheckers;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/DeclarationCheckers;)V", "cfaCheckers", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/cfa/FirControlFlowChecker;", "variableAssignmentCheckers", "Lorg/jetbrains/kotlin/fir/analysis/cfa/AbstractFirPropertyInitializationChecker;", "analyzeClassInitializer", "", "klass", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "graph", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "analyzeFunction", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "analyzePropertyAccessor", "accessor", "Lorg/jetbrains/kotlin/fir/declarations/FirPropertyAccessor;", "analyzePropertyInitializer", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "runAssignmentCfaCheckers", "checkers"})
public final class FirControlFlowAnalyzer {
    @NotNull
    private final Set<FirControlFlowChecker> cfaCheckers;
    @NotNull
    private final Set<AbstractFirPropertyInitializationChecker> variableAssignmentCheckers;

    public FirControlFlowAnalyzer(@NotNull FirSession session2, @NotNull DeclarationCheckers declarationCheckers) {
        Intrinsics.checkNotNullParameter(session2, "session");
        Intrinsics.checkNotNullParameter(declarationCheckers, "declarationCheckers");
        this.cfaCheckers = declarationCheckers.getControlFlowAnalyserCheckers();
        this.variableAssignmentCheckers = declarationCheckers.getVariableAssignmentCfaBasedCheckers();
    }

    public /* synthetic */ FirControlFlowAnalyzer(FirSession firSession, DeclarationCheckers declarationCheckers, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            declarationCheckers = CheckersComponentKt.getCheckersComponent(firSession).getDeclarationCheckers();
        }
        this(firSession, declarationCheckers);
    }

    public final void analyzeClassInitializer(@NotNull FirClass klass, @NotNull ControlFlowGraph graph2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(klass, "klass");
        Intrinsics.checkNotNullParameter(graph2, "graph");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        if (graph2.getOwner() != null) {
            return;
        }
        Iterable $this$forEach$iv = this.cfaCheckers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirControlFlowChecker it = (FirControlFlowChecker)element$iv;
            boolean bl = false;
            it.analyze(graph2, reporter, context2);
        }
    }

    public final void analyzeFunction(@NotNull FirFunction function2, @NotNull ControlFlowGraph graph2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        boolean bl;
        block6: {
            Object it;
            Intrinsics.checkNotNullParameter(function2, "function");
            Intrinsics.checkNotNullParameter(graph2, "graph");
            Intrinsics.checkNotNullParameter(context2, "context");
            Intrinsics.checkNotNullParameter(reporter, "reporter");
            if (graph2.getOwner() != null) {
                return;
            }
            Iterable $this$forEach$iv = this.cfaCheckers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (FirControlFlowChecker)element$iv;
                boolean bl2 = false;
                ((FirControlFlowChecker)it).analyze(graph2, reporter, context2);
            }
            Iterable $this$any$iv = context2.getContainingDeclarations();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (FirDeclaration)element$iv;
                    boolean bl3 = false;
                    if (!(it instanceof FirProperty || it instanceof FirFunction)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        this.runAssignmentCfaCheckers(graph2, reporter, context2);
    }

    public final void analyzePropertyInitializer(@NotNull FirProperty property2, @NotNull ControlFlowGraph graph2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(property2, "property");
        Intrinsics.checkNotNullParameter(graph2, "graph");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        if (graph2.getOwner() != null) {
            return;
        }
        Iterable $this$forEach$iv = this.cfaCheckers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirControlFlowChecker it = (FirControlFlowChecker)element$iv;
            boolean bl = false;
            it.analyze(graph2, reporter, context2);
        }
        this.runAssignmentCfaCheckers(graph2, reporter, context2);
    }

    public final void analyzePropertyAccessor(@NotNull FirPropertyAccessor accessor, @NotNull ControlFlowGraph graph2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(accessor, "accessor");
        Intrinsics.checkNotNullParameter(graph2, "graph");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        if (graph2.getOwner() != null) {
            return;
        }
        Iterable $this$forEach$iv = this.cfaCheckers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirControlFlowChecker it = (FirControlFlowChecker)element$iv;
            boolean bl = false;
            it.analyze(graph2, reporter, context2);
        }
        this.runAssignmentCfaCheckers(graph2, reporter, context2);
    }

    private final void runAssignmentCfaCheckers(ControlFlowGraph graph2, DiagnosticReporter reporter, CheckerContext context2) {
        Pair<Set<FirPropertySymbol>, Set<FirVariableAssignment>> pair = LocalPropertyAndCapturedWriteCollector.Companion.collect(graph2);
        Set<FirPropertySymbol> properties2 = pair.component1();
        Set<FirVariableAssignment> capturedWrites = pair.component2();
        if (properties2.isEmpty()) {
            return;
        }
        Map<CFGNode<?>, PathAwarePropertyInitializationInfo> data2 = new PropertyInitializationInfoCollector(properties2, null, 2, null).getData(graph2);
        Iterable $this$forEach$iv = this.variableAssignmentCheckers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AbstractFirPropertyInitializationChecker it = (AbstractFirPropertyInitializationChecker)element$iv;
            boolean bl = false;
            it.analyze(graph2, reporter, data2, properties2, capturedWrites, context2);
        }
    }
}

