/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.proxy.reflection;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeParameter;
import kotlin.reflect.KVisibility;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.interpreter.CallInterceptor;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreterEnvironment;
import org.jetbrains.kotlin.ir.interpreter.proxy.reflection.FunctionWithAllInvokes;
import org.jetbrains.kotlin.ir.interpreter.proxy.reflection.ReflectionProxy;
import org.jetbrains.kotlin.ir.interpreter.state.State;
import org.jetbrains.kotlin.ir.interpreter.state.StateKt;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.KFunctionState;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u001b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00022\u00020\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ'\u00103\u001a\u0004\u0018\u00010\u00032\u0016\u00104\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000305\"\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u00106J \u00107\u001a\u0004\u0018\u00010\u00032\u0014\u00104\u001a\u0010\u0012\u0004\u0012\u00020$\u0012\u0006\u0012\u0004\u0018\u00010\u000308H\u0016J\u0013\u00109\u001a\u00020\u00162\b\u0010:\u001a\u0004\u0018\u00010\u0003H\u0096\u0002J\b\u0010;\u001a\u00020\u0010H\u0016J\b\u0010<\u001a\u00020 H\u0016J\u0014\u0010=\u001a\u00020\u0016*\u00020>2\u0006\u0010:\u001a\u00020>H\u0002J\u000e\u0010?\u001a\u0004\u0018\u00010@*\u00020>H\u0002J\f\u0010A\u001a\u00020\u0016*\u00020>H\u0002R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0017R\u0014\u0010\u0019\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0017R\u0014\u0010\u001a\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0017R\u0014\u0010\u001b\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0017R\u0014\u0010\u001c\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0017R\u0014\u0010\u001d\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0017R\u0014\u0010\u001e\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0017R\u0014\u0010\u001f\u001a\u00020 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u000eR\u0014\u0010&\u001a\u00020'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u001a\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u000eR\u0016\u0010/\u001a\u0004\u0018\u0001008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00102\u00a8\u0006B"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/proxy/reflection/KFunctionProxy;", "Lorg/jetbrains/kotlin/ir/interpreter/proxy/reflection/ReflectionProxy;", "Lkotlin/reflect/KFunction;", "", "Lorg/jetbrains/kotlin/ir/interpreter/proxy/reflection/FunctionWithAllInvokes;", "state", "Lorg/jetbrains/kotlin/ir/interpreter/state/reflection/KFunctionState;", "callInterceptor", "Lorg/jetbrains/kotlin/ir/interpreter/CallInterceptor;", "(Lorg/jetbrains/kotlin/ir/interpreter/state/reflection/KFunctionState;Lorg/jetbrains/kotlin/ir/interpreter/CallInterceptor;)V", "annotations", "", "", "getAnnotations", "()Ljava/util/List;", "arity", "", "getArity", "()I", "getCallInterceptor", "()Lorg/jetbrains/kotlin/ir/interpreter/CallInterceptor;", "isAbstract", "", "()Z", "isExternal", "isFinal", "isInfix", "isInline", "isOpen", "isOperator", "isSuspend", "name", "", "getName", "()Ljava/lang/String;", "parameters", "Lkotlin/reflect/KParameter;", "getParameters", "returnType", "Lkotlin/reflect/KType;", "getReturnType", "()Lkotlin/reflect/KType;", "getState", "()Lorg/jetbrains/kotlin/ir/interpreter/state/reflection/KFunctionState;", "typeParameters", "Lkotlin/reflect/KTypeParameter;", "getTypeParameters", "visibility", "Lkotlin/reflect/KVisibility;", "getVisibility", "()Lkotlin/reflect/KVisibility;", "call", "args", "", "([Ljava/lang/Object;)Ljava/lang/Object;", "callBy", "", "equals", "other", "hashCode", "toString", "eqaulsByAdapteeCall", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "getAdapteeCallSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "isAdapter", "ir.interpreter"})
public final class KFunctionProxy
implements KFunction<Object>,
FunctionWithAllInvokes,
ReflectionProxy {
    @NotNull
    private final KFunctionState state;
    @NotNull
    private final CallInterceptor callInterceptor;
    private final int arity;

    public KFunctionProxy(@NotNull KFunctionState state, @NotNull CallInterceptor callInterceptor) {
        Intrinsics.checkNotNullParameter(state, "state");
        Intrinsics.checkNotNullParameter(callInterceptor, "callInterceptor");
        this.state = state;
        this.callInterceptor = callInterceptor;
        Integer n = this.getState().getArity();
        this.arity = n == null ? 23 : n;
    }

    @Override
    @NotNull
    public KFunctionState getState() {
        return this.state;
    }

    @Override
    @NotNull
    public CallInterceptor getCallInterceptor() {
        return this.callInterceptor;
    }

    @Override
    public int getArity() {
        return this.arity;
    }

    @Override
    public boolean isInline() {
        return this.getState().getIrFunction().isInline();
    }

    @Override
    public boolean isExternal() {
        return this.getState().getIrFunction().isExternal();
    }

    @Override
    public boolean isOperator() {
        return this.getState().getIrFunction() instanceof IrSimpleFunction && ((IrSimpleFunction)this.getState().getIrFunction()).isOperator();
    }

    @Override
    public boolean isInfix() {
        return this.getState().getIrFunction() instanceof IrSimpleFunction && ((IrSimpleFunction)this.getState().getIrFunction()).isInfix();
    }

    @Override
    @NotNull
    public String getName() {
        String string2 = this.getState().getIrFunction().getName().asString();
        Intrinsics.checkNotNullExpressionValue(string2, "state.irFunction.name.asString()");
        return string2;
    }

    @Override
    @NotNull
    public List<Annotation> getAnnotations() {
        throw new NotImplementedError(Intrinsics.stringPlus("An operation is not implemented: ", "Not yet implemented"));
    }

    @Override
    @NotNull
    public List<KParameter> getParameters() {
        return this.getState().getParameters(this.getCallInterceptor());
    }

    @Override
    @NotNull
    public KType getReturnType() {
        return this.getState().getReturnType(this.getCallInterceptor());
    }

    @Override
    @NotNull
    public List<KTypeParameter> getTypeParameters() {
        return this.getState().getTypeParameters(this.getCallInterceptor());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object call(Object ... args2) {
        void $this$mapTo$iv$iv;
        State state;
        IrValueParameter it;
        IrValueParameter irValueParameter;
        State state2;
        Intrinsics.checkNotNullParameter(args2, "args");
        int index2 = 0;
        IrValueParameter irValueParameter2 = this.getState().getIrFunction().getDispatchReceiverParameter();
        if (irValueParameter2 == null) {
            state2 = null;
        } else {
            it = irValueParameter = irValueParameter2;
            boolean bl = false;
            int n = index2;
            index2 = n + 1;
            state2 = this.getEnvironment().convertToState$ir_interpreter(args2[n], it.getType());
        }
        State dispatchReceiver = state2;
        irValueParameter = this.getState().getIrFunction().getExtensionReceiverParameter();
        if (irValueParameter == null) {
            state = null;
        } else {
            IrValueParameter it2 = it = irValueParameter;
            boolean bl = false;
            int n = index2;
            index2 = n + 1;
            state = this.getEnvironment().convertToState$ir_interpreter(args2[n], it2.getType());
        }
        State extensionReceiver = state;
        Iterable $this$map$iv = this.getState().getIrFunction().getValueParameters();
        boolean $i$f$map = false;
        Iterable bl = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void parameter;
            IrValueParameter irValueParameter3 = (IrValueParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            int n = index2;
            index2 = n + 1;
            State state3 = this.getEnvironment().convertToState$ir_interpreter(args2[n], parameter.getType());
            collection.add(state3);
        }
        List argsVariables = (List)destination$iv$iv;
        State[] stateArray = new State[]{dispatchReceiver, extensionReceiver};
        List valueArguments = CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull(stateArray), (Iterable)argsVariables);
        return CallInterceptor.DefaultImpls.interceptProxy$default(this.getCallInterceptor(), this.getState().getIrFunction(), valueArguments, null, 4, null);
    }

    @Override
    @Nullable
    public Object callBy(@NotNull Map<KParameter, ? extends Object> args2) {
        Intrinsics.checkNotNullParameter(args2, "args");
        throw new NotImplementedError(Intrinsics.stringPlus("An operation is not implemented: ", "Not yet implemented"));
    }

    @Override
    @Nullable
    public KVisibility getVisibility() {
        return this.toKVisibility(this.getState().getIrFunction().getVisibility());
    }

    @Override
    public boolean isFinal() {
        return this.getState().getIrFunction() instanceof IrSimpleFunction && ((IrSimpleFunction)this.getState().getIrFunction()).getModality() == Modality.FINAL;
    }

    @Override
    public boolean isOpen() {
        return this.getState().getIrFunction() instanceof IrSimpleFunction && ((IrSimpleFunction)this.getState().getIrFunction()).getModality() == Modality.OPEN;
    }

    @Override
    public boolean isAbstract() {
        return this.getState().getIrFunction() instanceof IrSimpleFunction && ((IrSimpleFunction)this.getState().getIrFunction()).getModality() == Modality.ABSTRACT;
    }

    @Override
    public boolean isSuspend() {
        return AdditionalIrUtilsKt.isSuspend(this.getState().getIrFunction());
    }

    @Override
    public boolean equals(@Nullable Object other) {
        IrDeclarationOrigin irDeclarationOrigin;
        if (this == other) {
            return true;
        }
        if (!(other instanceof KFunctionProxy)) {
            return false;
        }
        if (this.getArity() != ((KFunctionProxy)other).getArity() || this.isSuspend() != ((KFunctionProxy)other).isSuspend()) {
            return false;
        }
        IrType irType = this.getState().getFunInterface();
        if (irType == null) {
            irDeclarationOrigin = null;
        } else {
            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(irType);
            if (irClassSymbol == null) {
                irDeclarationOrigin = null;
            } else {
                IrClass irClass2 = (IrClass)irClassSymbol.getOwner();
                irDeclarationOrigin = irClass2.getOrigin();
            }
        }
        if (Intrinsics.areEqual(irDeclarationOrigin, IrDeclarationOrigin.IR_EXTERNAL_JAVA_DECLARATION_STUB.INSTANCE)) {
            return this.getState() == ((KFunctionProxy)other).getState();
        }
        if (!StateKt.hasTheSameFieldsWith(this.getState(), ((KFunctionProxy)other).getState())) {
            return false;
        }
        return this.isAdapter(this.getState().getIrFunction()) && this.isAdapter(((KFunctionProxy)other).getState().getIrFunction()) ? this.eqaulsByAdapteeCall(this.getState().getIrFunction(), ((KFunctionProxy)other).getState().getIrFunction()) : Intrinsics.areEqual(this.getState().getIrFunction(), ((KFunctionProxy)other).getState().getIrFunction());
    }

    @Override
    public int hashCode() {
        int n;
        if (this.isAdapter(this.getState().getIrFunction())) {
            IrFunctionSymbol irFunctionSymbol = this.getAdapteeCallSymbol(this.getState().getIrFunction());
            Intrinsics.checkNotNull(irFunctionSymbol);
            n = irFunctionSymbol.hashCode();
        } else {
            n = this.getState().getIrFunction().hashCode();
        }
        return n;
    }

    @Override
    @NotNull
    public String toString() {
        return this.getState().toString();
    }

    private final boolean isAdapter(IrFunction $this$isAdapter) {
        return Intrinsics.areEqual($this$isAdapter.getOrigin(), IrDeclarationOrigin.ADAPTER_FOR_CALLABLE_REFERENCE.INSTANCE);
    }

    private final IrFunctionSymbol getAdapteeCallSymbol(IrFunction $this$getAdapteeCallSymbol) {
        IrFunctionAccessExpression irFunctionAccessExpression;
        if (!this.isAdapter($this$getAdapteeCallSymbol)) {
            return null;
        }
        IrBody irBody = $this$getAdapteeCallSymbol.getBody();
        Intrinsics.checkNotNull(irBody);
        IrStatement statement2 = CollectionsKt.single(IrUtilsKt.getStatements(irBody));
        IrStatement call2 = statement2 instanceof IrTypeOperatorCall ? (IrStatement)((IrTypeOperatorCall)statement2).getArgument() : (statement2 instanceof IrReturn ? (IrStatement)((IrReturn)statement2).getValue() : irFunctionAccessExpression);
        irFunctionAccessExpression = call2 instanceof IrFunctionAccessExpression ? (IrFunctionAccessExpression)call2 : null;
        return irFunctionAccessExpression == null ? null : (IrFunctionSymbol)irFunctionAccessExpression.getSymbol();
    }

    private final boolean eqaulsByAdapteeCall(IrFunction $this$eqaulsByAdapteeCall, IrFunction other) {
        Pair<IrExpression, IrExpression> pair;
        if (!this.isAdapter($this$eqaulsByAdapteeCall) || !this.isAdapter(other)) {
            return false;
        }
        IrBody irBody = $this$eqaulsByAdapteeCall.getBody();
        Intrinsics.checkNotNull(irBody);
        IrStatement statement2 = CollectionsKt.single(IrUtilsKt.getStatements(irBody));
        IrBody irBody2 = other.getBody();
        Intrinsics.checkNotNull(irBody2);
        IrStatement otherStatement = CollectionsKt.single(IrUtilsKt.getStatements(irBody2));
        IrStatement irStatement = statement2;
        if (irStatement instanceof IrTypeOperatorCall) {
            if (!(otherStatement instanceof IrTypeOperatorCall)) {
                return false;
            }
            pair = new Pair<IrExpression, IrExpression>(((IrTypeOperatorCall)statement2).getArgument(), ((IrTypeOperatorCall)otherStatement).getArgument());
        } else if (irStatement instanceof IrReturn) {
            if (!(otherStatement instanceof IrReturn)) {
                return false;
            }
            pair = new Pair<IrExpression, IrExpression>(((IrReturn)statement2).getValue(), ((IrReturn)otherStatement).getValue());
        } else {
            pair = new Pair<IrStatement, IrStatement>(statement2, otherStatement);
        }
        Pair<IrExpression, IrExpression> pair2 = pair;
        IrStatement thisArg = (IrStatement)pair2.component1();
        IrStatement otherArg = pair2.component2();
        if (!(thisArg instanceof IrFunctionAccessExpression) || !(otherArg instanceof IrFunctionAccessExpression)) {
            return false;
        }
        return Intrinsics.areEqual(((IrFunctionAccessExpression)thisArg).getSymbol(), ((IrFunctionAccessExpression)otherArg).getSymbol());
    }

    @Override
    @Nullable
    public Object invoke() {
        return FunctionWithAllInvokes.DefaultImpls.invoke(this);
    }

    @Override
    @Nullable
    public Object invoke(@Nullable Object p1) {
        return FunctionWithAllInvokes.DefaultImpls.invoke((FunctionWithAllInvokes)this, p1);
    }

    @Override
    @Nullable
    public Object invoke(@Nullable Object p1, @Nullable Object p2) {
        return FunctionWithAllInvokes.DefaultImpls.invoke((FunctionWithAllInvokes)this, p1, p2);
    }

    @Override
    @Nullable
    public Object invoke(@Nullable Object p1, @Nullable Object p2, @Nullable Object p3) {
        return FunctionWithAllInvokes.DefaultImpls.invoke((FunctionWithAllInvokes)this, p1, p2, p3);
    }

    @Override
    @Nullable
    public Object invoke(@Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4) {
        return FunctionWithAllInvokes.DefaultImpls.invoke((FunctionWithAllInvokes)this, p1, p2, p3, p4);
    }

    @Override
    @Nullable
    public Object invoke(@Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5) {
        return FunctionWithAllInvokes.DefaultImpls.invoke((FunctionWithAllInvokes)this, p1, p2, p3, p4, p5);
    }

    @Override
    @Nullable
    public Object invoke(@Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6) {
        return FunctionWithAllInvokes.DefaultImpls.invoke((FunctionWithAllInvokes)this, p1, p2, p3, p4, p5, p6);
    }

    @Override
    @Nullable
    public Object invoke(@Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6, @Nullable Object p7) {
        return FunctionWithAllInvokes.DefaultImpls.invoke((FunctionWithAllInvokes)this, p1, p2, p3, p4, p5, p6, p7);
    }

    @Override
    @Nullable
    public Object invoke(@Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6, @Nullable Object p7, @Nullable Object p8) {
        return FunctionWithAllInvokes.DefaultImpls.invoke((FunctionWithAllInvokes)this, p1, p2, p3, p4, p5, p6, p7, p8);
    }

    @Override
    @Nullable
    public Object invoke(@Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6, @Nullable Object p7, @Nullable Object p8, @Nullable Object p9) {
        return FunctionWithAllInvokes.DefaultImpls.invoke((FunctionWithAllInvokes)this, p1, p2, p3, p4, p5, p6, p7, p8, p9);
    }

    @Override
    @Nullable
    public Object invoke(@Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6, @Nullable Object p7, @Nullable Object p8, @Nullable Object p9, @Nullable Object p10) {
        return FunctionWithAllInvokes.DefaultImpls.invoke((FunctionWithAllInvokes)this, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10);
    }

    @Override
    @Nullable
    public Object invoke(@Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6, @Nullable Object p7, @Nullable Object p8, @Nullable Object p9, @Nullable Object p10, @Nullable Object p11) {
        return FunctionWithAllInvokes.DefaultImpls.invoke((FunctionWithAllInvokes)this, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11);
    }

    @Override
    @Nullable
    public Object invoke(@Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6, @Nullable Object p7, @Nullable Object p8, @Nullable Object p9, @Nullable Object p10, @Nullable Object p11, @Nullable Object p12) {
        return FunctionWithAllInvokes.DefaultImpls.invoke((FunctionWithAllInvokes)this, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12);
    }

    @Override
    @Nullable
    public Object invoke(@Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6, @Nullable Object p7, @Nullable Object p8, @Nullable Object p9, @Nullable Object p10, @Nullable Object p11, @Nullable Object p12, @Nullable Object p13) {
        return FunctionWithAllInvokes.DefaultImpls.invoke((FunctionWithAllInvokes)this, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13);
    }

    @Override
    @Nullable
    public Object invoke(@Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6, @Nullable Object p7, @Nullable Object p8, @Nullable Object p9, @Nullable Object p10, @Nullable Object p11, @Nullable Object p12, @Nullable Object p13, @Nullable Object p14) {
        return FunctionWithAllInvokes.DefaultImpls.invoke((FunctionWithAllInvokes)this, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14);
    }

    @Override
    @Nullable
    public Object invoke(@Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6, @Nullable Object p7, @Nullable Object p8, @Nullable Object p9, @Nullable Object p10, @Nullable Object p11, @Nullable Object p12, @Nullable Object p13, @Nullable Object p14, @Nullable Object p15) {
        return FunctionWithAllInvokes.DefaultImpls.invoke((FunctionWithAllInvokes)this, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15);
    }

    @Override
    @Nullable
    public Object invoke(@Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6, @Nullable Object p7, @Nullable Object p8, @Nullable Object p9, @Nullable Object p10, @Nullable Object p11, @Nullable Object p12, @Nullable Object p13, @Nullable Object p14, @Nullable Object p15, @Nullable Object p16) {
        return FunctionWithAllInvokes.DefaultImpls.invoke((FunctionWithAllInvokes)this, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15, p16);
    }

    @Override
    @Nullable
    public Object invoke(@Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6, @Nullable Object p7, @Nullable Object p8, @Nullable Object p9, @Nullable Object p10, @Nullable Object p11, @Nullable Object p12, @Nullable Object p13, @Nullable Object p14, @Nullable Object p15, @Nullable Object p16, @Nullable Object p17) {
        return FunctionWithAllInvokes.DefaultImpls.invoke((FunctionWithAllInvokes)this, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15, p16, p17);
    }

    @Override
    @Nullable
    public Object invoke(@Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6, @Nullable Object p7, @Nullable Object p8, @Nullable Object p9, @Nullable Object p10, @Nullable Object p11, @Nullable Object p12, @Nullable Object p13, @Nullable Object p14, @Nullable Object p15, @Nullable Object p16, @Nullable Object p17, @Nullable Object p18) {
        return FunctionWithAllInvokes.DefaultImpls.invoke((FunctionWithAllInvokes)this, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15, p16, p17, p18);
    }

    @Override
    @Nullable
    public Object invoke(@Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6, @Nullable Object p7, @Nullable Object p8, @Nullable Object p9, @Nullable Object p10, @Nullable Object p11, @Nullable Object p12, @Nullable Object p13, @Nullable Object p14, @Nullable Object p15, @Nullable Object p16, @Nullable Object p17, @Nullable Object p18, @Nullable Object p19) {
        return FunctionWithAllInvokes.DefaultImpls.invoke((FunctionWithAllInvokes)this, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15, p16, p17, p18, p19);
    }

    @Override
    @Nullable
    public Object invoke(@Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6, @Nullable Object p7, @Nullable Object p8, @Nullable Object p9, @Nullable Object p10, @Nullable Object p11, @Nullable Object p12, @Nullable Object p13, @Nullable Object p14, @Nullable Object p15, @Nullable Object p16, @Nullable Object p17, @Nullable Object p18, @Nullable Object p19, @Nullable Object p20) {
        return FunctionWithAllInvokes.DefaultImpls.invoke((FunctionWithAllInvokes)this, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15, p16, p17, p18, p19, p20);
    }

    @Override
    @Nullable
    public Object invoke(@Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6, @Nullable Object p7, @Nullable Object p8, @Nullable Object p9, @Nullable Object p10, @Nullable Object p11, @Nullable Object p12, @Nullable Object p13, @Nullable Object p14, @Nullable Object p15, @Nullable Object p16, @Nullable Object p17, @Nullable Object p18, @Nullable Object p19, @Nullable Object p20, @Nullable Object p21) {
        return FunctionWithAllInvokes.DefaultImpls.invoke((FunctionWithAllInvokes)this, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15, p16, p17, p18, p19, p20, p21);
    }

    @Override
    @Nullable
    public Object invoke(@Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6, @Nullable Object p7, @Nullable Object p8, @Nullable Object p9, @Nullable Object p10, @Nullable Object p11, @Nullable Object p12, @Nullable Object p13, @Nullable Object p14, @Nullable Object p15, @Nullable Object p16, @Nullable Object p17, @Nullable Object p18, @Nullable Object p19, @Nullable Object p20, @Nullable Object p21, @Nullable Object p22) {
        return FunctionWithAllInvokes.DefaultImpls.invoke((FunctionWithAllInvokes)this, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15, p16, p17, p18, p19, p20, p21, p22);
    }

    @Override
    @Nullable
    public Object invoke(Object ... args2) {
        return FunctionWithAllInvokes.DefaultImpls.invoke((FunctionWithAllInvokes)this, args2);
    }

    @Override
    @Nullable
    public KVisibility toKVisibility(@NotNull DescriptorVisibility $this$toKVisibility) {
        return ReflectionProxy.DefaultImpls.toKVisibility(this, $this$toKVisibility);
    }

    @Override
    @NotNull
    public IrInterpreterEnvironment getEnvironment() {
        return ReflectionProxy.DefaultImpls.getEnvironment(this);
    }
}

