/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.inference;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.CopyUtilsKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirLookupTrackerComponent;
import org.jetbrains.kotlin.fir.FirLookupTrackerComponentKt;
import org.jetbrains.kotlin.fir.FirModuleDataKt;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirTowerDataContext;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.builder.FirValueParameterBuilder;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousFunctionExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirLambdaArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvable;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.resolve.FirTowerDataMode;
import org.jetbrains.kotlin.fir.resolve.ResolutionMode;
import org.jetbrains.kotlin.fir.resolve.ResolutionModeKt;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.CallableReferenceResolutionKt;
import org.jetbrains.kotlin.fir.resolve.calls.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.FirNamedReferenceWithCandidate;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionContext;
import org.jetbrains.kotlin.fir.resolve.inference.CompletionModeCalculatorKt;
import org.jetbrains.kotlin.fir.resolve.inference.ConeTypeVariableForLambdaReturnType;
import org.jetbrains.kotlin.fir.resolve.inference.ConstraintSystemCompleter;
import org.jetbrains.kotlin.fir.resolve.inference.FirBuilderInferenceSession;
import org.jetbrains.kotlin.fir.resolve.inference.FirCallCompleterKt;
import org.jetbrains.kotlin.fir.resolve.inference.FirInferenceSession;
import org.jetbrains.kotlin.fir.resolve.inference.InferenceComponentsKt;
import org.jetbrains.kotlin.fir.resolve.inference.LambdaAnalyzer;
import org.jetbrains.kotlin.fir.resolve.inference.PostponedArgumentsAnalyzer;
import org.jetbrains.kotlin.fir.resolve.inference.PostponedResolvedAtom;
import org.jetbrains.kotlin.fir.resolve.inference.ResolvedLambdaAtom;
import org.jetbrains.kotlin.fir.resolve.inference.ReturnArgumentsAnalysisResult;
import org.jetbrains.kotlin.fir.resolve.inference.model.ConeArgumentConstraintPosition;
import org.jetbrains.kotlin.fir.resolve.inference.model.ConeExpectedTypeConstraintPosition;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.resolve.transformers.FirCallCompletionResultsWriterTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.InvocationKindTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.body.resolve.BodyResolveContext;
import org.jetbrains.kotlin.fir.resolve.transformers.body.resolve.FirAbstractBodyResolveTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.body.resolve.FirBodyResolveTransformer;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirAnonymousFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeAttributes;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirImplicitTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.fir.types.impl.ConeClassLikeTypeImpl;
import org.jetbrains.kotlin.fir.visitors.FirTransformerUtilKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilderKt;
import org.jetbrains.kotlin.resolve.calls.inference.InferenceUtilsKt;
import org.jetbrains.kotlin.resolve.calls.inference.components.ConstraintSystemCompletionMode;
import org.jetbrains.kotlin.resolve.calls.inference.model.NewConstraintSystemImpl;
import org.jetbrains.kotlin.types.TypeApproximatorConfiguration;
import org.jetbrains.kotlin.types.model.MarkerExtensionsKt;
import org.jetbrains.kotlin.types.model.StubTypeMarker;
import org.jetbrains.kotlin.types.model.TypeSubstitutorMarker;
import org.jetbrains.kotlin.types.model.TypeSystemInferenceExtensionContext;
import org.jetbrains.kotlin.types.model.TypeVariableMarker;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0002;<B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J/\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0012\"\f\b\u0000\u0010\u0013*\u00020\u0014*\u00020\u00152\u0006\u0010\u0016\u001a\u0002H\u00132\u0006\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\u0002\u0010\u0019J;\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0012\"\f\b\u0000\u0010\u0013*\u00020\u0014*\u00020\u00152\u0006\u0010\u0016\u001a\u0002H\u00132\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\u0002\u0010\u001eJS\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0012\"\f\b\u0000\u0010\u0013*\u00020\u0014*\u00020\u00152\u0006\u0010\u0016\u001a\u0002H\u00132\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u001dH\u0002\u00a2\u0006\u0002\u0010\"J\u0018\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\b\b\u0002\u0010'\u001a\u00020(J\u000e\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,J\u0016\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202JE\u00103\u001a\u00020.\"\f\b\u0000\u0010\u0013*\u00020\u0014*\u00020\u00152\u0006\u00101\u001a\u0002022\u0006\u00104\u001a\u0002052\u0006\u0010\u0016\u001a\u0002H\u00132\u0006\u00106\u001a\u0002072\n\b\u0002\u00108\u001a\u0004\u0018\u00010*\u00a2\u0006\u0002\u00109J\f\u0010:\u001a\u000207*\u000207H\u0002R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lorg/jetbrains/kotlin/fir/resolve/inference/FirCallCompleter;", "", "transformer", "Lorg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/FirBodyResolveTransformer;", "components", "Lorg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/FirAbstractBodyResolveTransformer$BodyResolveTransformerComponents;", "(Lorg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/FirBodyResolveTransformer;Lorg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/FirAbstractBodyResolveTransformer$BodyResolveTransformerComponents;)V", "completer", "Lorg/jetbrains/kotlin/fir/resolve/inference/ConstraintSystemCompleter;", "getCompleter", "()Lorg/jetbrains/kotlin/fir/resolve/inference/ConstraintSystemCompleter;", "inferenceSession", "Lorg/jetbrains/kotlin/fir/resolve/inference/FirInferenceSession;", "getInferenceSession", "()Lorg/jetbrains/kotlin/fir/resolve/inference/FirInferenceSession;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "completeCall", "Lorg/jetbrains/kotlin/fir/resolve/inference/FirCallCompleter$CompletionResult;", "T", "Lorg/jetbrains/kotlin/fir/expressions/FirResolvable;", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "call", "data", "Lorg/jetbrains/kotlin/fir/resolve/ResolutionMode;", "(Lorg/jetbrains/kotlin/fir/expressions/FirResolvable;Lorg/jetbrains/kotlin/fir/resolve/ResolutionMode;)Lorg/jetbrains/kotlin/fir/resolve/inference/FirCallCompleter$CompletionResult;", "expectedTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "expectedTypeMismatchIsReportedInChecker", "", "(Lorg/jetbrains/kotlin/fir/expressions/FirResolvable;Lorg/jetbrains/kotlin/fir/types/FirTypeRef;Z)Lorg/jetbrains/kotlin/fir/resolve/inference/FirCallCompleter$CompletionResult;", "mayBeCoercionToUnitApplied", "isFromCast", "shouldEnforceExpectedType", "(Lorg/jetbrains/kotlin/fir/expressions/FirResolvable;Lorg/jetbrains/kotlin/fir/types/FirTypeRef;ZZZZ)Lorg/jetbrains/kotlin/fir/resolve/inference/FirCallCompleter$CompletionResult;", "createCompletionResultsWriter", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirCallCompletionResultsWriterTransformer;", "substitutor", "Lorg/jetbrains/kotlin/fir/resolve/substitution/ConeSubstitutor;", "mode", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirCallCompletionResultsWriterTransformer$Mode;", "createPostponedArgumentsAnalyzer", "Lorg/jetbrains/kotlin/fir/resolve/inference/PostponedArgumentsAnalyzer;", "context", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;", "prepareLambdaAtomForFactoryPattern", "", "atom", "Lorg/jetbrains/kotlin/fir/resolve/inference/ResolvedLambdaAtom;", "candidate", "Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;", "runCompletionForCall", "completionMode", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/ConstraintSystemCompletionMode;", "initialType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "analyzer", "(Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;Lorg/jetbrains/kotlin/resolve/calls/inference/components/ConstraintSystemCompletionMode;Lorg/jetbrains/kotlin/fir/expressions/FirResolvable;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/fir/resolve/inference/PostponedArgumentsAnalyzer;)V", "approximateLambdaInputType", "CompletionResult", "LambdaAnalyzerImpl", "resolve"})
public final class FirCallCompleter {
    @NotNull
    private final FirBodyResolveTransformer transformer;
    @NotNull
    private final FirAbstractBodyResolveTransformer.BodyResolveTransformerComponents components;
    @NotNull
    private final FirSession session;
    @NotNull
    private final ConstraintSystemCompleter completer;

    public FirCallCompleter(@NotNull FirBodyResolveTransformer transformer2, @NotNull FirAbstractBodyResolveTransformer.BodyResolveTransformerComponents components2) {
        Intrinsics.checkNotNullParameter(transformer2, "transformer");
        Intrinsics.checkNotNullParameter(components2, "components");
        this.transformer = transformer2;
        this.components = components2;
        this.session = this.components.getSession();
        this.completer = new ConstraintSystemCompleter(this.components, this.transformer.getContext());
    }

    private final FirInferenceSession getInferenceSession() {
        return this.transformer.getContext().getInferenceSession();
    }

    @NotNull
    public final ConstraintSystemCompleter getCompleter() {
        return this.completer;
    }

    @NotNull
    public final <T extends FirResolvable & FirStatement> CompletionResult<T> completeCall(@NotNull T call2, @Nullable FirTypeRef expectedTypeRef, boolean expectedTypeMismatchIsReportedInChecker) {
        Intrinsics.checkNotNullParameter(call2, "call");
        return this.completeCall(call2, expectedTypeRef, false, expectedTypeMismatchIsReportedInChecker, false, true);
    }

    public static /* synthetic */ CompletionResult completeCall$default(FirCallCompleter firCallCompleter, FirResolvable firResolvable, FirTypeRef firTypeRef, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return firCallCompleter.completeCall(firResolvable, firTypeRef, bl);
    }

    @NotNull
    public final <T extends FirResolvable & FirStatement> CompletionResult<T> completeCall(@NotNull T call2, @NotNull ResolutionMode data2) {
        Intrinsics.checkNotNullParameter(call2, "call");
        Intrinsics.checkNotNullParameter(data2, "data");
        ResolutionMode.WithExpectedType withExpectedType = data2 instanceof ResolutionMode.WithExpectedType ? (ResolutionMode.WithExpectedType)data2 : null;
        ResolutionMode.WithExpectedType withExpectedType2 = data2 instanceof ResolutionMode.WithExpectedType ? (ResolutionMode.WithExpectedType)data2 : null;
        return this.completeCall(call2, ResolutionModeKt.expectedType(data2, this.components, true), withExpectedType != null ? withExpectedType.getMayBeCoercionToUnitApplied() : false, withExpectedType2 != null ? withExpectedType2.getExpectedTypeMismatchIsReportedInChecker() : false, data2 instanceof ResolutionMode.WithExpectedTypeFromCast, !(data2 instanceof ResolutionMode.WithSuggestedType));
    }

    private final <T extends FirResolvable & FirStatement> CompletionResult<T> completeCall(T call2, FirTypeRef expectedTypeRef, boolean mayBeCoercionToUnitApplied, boolean expectedTypeMismatchIsReportedInChecker, boolean isFromCast, boolean shouldEnforceExpectedType) {
        CompletionResult<FirResolvable> completionResult;
        FirReference firReference;
        FirResolvedTypeRef typeRef = ResolveUtilsKt.typeFromCallee(this.components, call2);
        if (call2 instanceof FirVariableAssignment) {
            ((FirVariableAssignment)call2).replaceLValueTypeRef(typeRef);
        }
        FirNamedReferenceWithCandidate firNamedReferenceWithCandidate = (firReference = call2.getCalleeReference()) instanceof FirNamedReferenceWithCandidate ? (FirNamedReferenceWithCandidate)firReference : null;
        if (firNamedReferenceWithCandidate == null) {
            return new CompletionResult<T>(call2, true);
        }
        FirNamedReferenceWithCandidate reference = firNamedReferenceWithCandidate;
        Candidate candidate2 = reference.getCandidate();
        ConeKotlinType initialType = ResolveUtilsKt.initialTypeOfCandidate(this.components, candidate2, call2);
        if (call2 instanceof FirExpression) {
            FirResolvedTypeRef resolvedTypeRef = CopyUtilsKt.resolvedTypeFromPrototype(typeRef, initialType);
            FirExpression $this$resultType$iv = (FirExpression)call2;
            boolean $i$f$setResultType = false;
            $this$resultType$iv.replaceTypeRef(resolvedTypeRef);
            FirLookupTrackerComponent firLookupTrackerComponent = FirLookupTrackerComponentKt.getLookupTracker(this.session);
            if (firLookupTrackerComponent != null) {
                FirLookupTrackerComponentKt.recordTypeResolveAsLookup(firLookupTrackerComponent, resolvedTypeRef, call2.getSource(), null);
            }
        }
        ConeExpectedTypeConstraintPosition expectedTypeConstraintPosition = new ConeExpectedTypeConstraintPosition(expectedTypeMismatchIsReportedInChecker);
        if (expectedTypeRef instanceof FirResolvedTypeRef) {
            if (!shouldEnforceExpectedType) {
                ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible(candidate2.getSystem(), initialType, ((FirResolvedTypeRef)expectedTypeRef).getType(), expectedTypeConstraintPosition);
            } else if (isFromCast) {
                if (FirCallCompleterKt.access$isFunctionForExpectTypeFromCastFeature(candidate2)) {
                    candidate2.getSystem().addSubtypeConstraint(initialType, ((FirResolvedTypeRef)expectedTypeRef).getType(), new ConeExpectedTypeConstraintPosition(false));
                }
            } else if (!CallableReferenceResolutionKt.isUnitOrFlexibleUnit(FirTypeUtilsKt.getConeType(expectedTypeRef)) || !mayBeCoercionToUnitApplied) {
                candidate2.getSystem().addSubtypeConstraint(initialType, ((FirResolvedTypeRef)expectedTypeRef).getType(), expectedTypeConstraintPosition);
            } else if (!candidate2.getSystem().getNotFixedTypeVariables().isEmpty()) {
                ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible(candidate2.getSystem(), initialType, ((FirResolvedTypeRef)expectedTypeRef).getType(), expectedTypeConstraintPosition);
            }
        }
        ConstraintSystemCompletionMode completionMode = CompletionModeCalculatorKt.computeCompletionMode(candidate2, InferenceComponentsKt.getInferenceComponents(this.session), expectedTypeRef, initialType);
        PostponedArgumentsAnalyzer analyzer2 = this.createPostponedArgumentsAnalyzer(this.transformer.getResolutionContext());
        FirTransformerUtilKt.transformSingle(call2, InvocationKindTransformer.INSTANCE, null);
        switch (WhenMappings.$EnumSwitchMapping$0[completionMode.ordinal()]) {
            case 1: {
                if (this.getInferenceSession().shouldRunCompletion(call2)) {
                    this.runCompletionForCall(candidate2, completionMode, call2, initialType, analyzer2);
                    ConeSubstitutor finalSubstitutor = (ConeSubstitutor)InferenceUtilsKt.buildAbstractResultingSubstitutor$default(candidate2.getSystem().asReadOnlyStorage(), TypeComponentsKt.getTypeContext(this.session), false, 2, null);
                    FirResolvable completedCall = (FirResolvable)FirTransformerUtilKt.transformSingle(call2, new FirCallCompletionResultsWriterTransformer(this.session, finalSubstitutor, this.components.getReturnTypeCalculator(), TypeComponentsKt.getTypeApproximator(this.session), this.components.getDataFlowAnalyzer(), null, 32, null), null);
                    this.getInferenceSession().addCompletedCall(completedCall, candidate2);
                    completionResult = new CompletionResult<FirResolvable>(completedCall, true);
                    break;
                }
                this.getInferenceSession().addPartiallyResolvedCall(call2);
                completionResult = new CompletionResult<FirResolvable>(call2, false);
                break;
            }
            case 2: {
                this.runCompletionForCall(candidate2, completionMode, call2, initialType, analyzer2);
                this.getInferenceSession().addPartiallyResolvedCall(call2);
                completionResult = new CompletionResult<T>(call2, false);
                break;
            }
            case 3: {
                throw new IllegalStateException();
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return completionResult;
    }

    public final <T extends FirResolvable & FirStatement> void runCompletionForCall(@NotNull Candidate candidate2, @NotNull ConstraintSystemCompletionMode completionMode, @NotNull T call2, @NotNull ConeKotlinType initialType, @Nullable PostponedArgumentsAnalyzer analyzer2) {
        Intrinsics.checkNotNullParameter(candidate2, "candidate");
        Intrinsics.checkNotNullParameter((Object)completionMode, "completionMode");
        Intrinsics.checkNotNullParameter(call2, "call");
        Intrinsics.checkNotNullParameter(initialType, "initialType");
        PostponedArgumentsAnalyzer postponedArgumentsAnalyzer = analyzer2;
        if (postponedArgumentsAnalyzer == null) {
            postponedArgumentsAnalyzer = this.createPostponedArgumentsAnalyzer(this.transformer.getResolutionContext());
        }
        PostponedArgumentsAnalyzer analyzer3 = postponedArgumentsAnalyzer;
        ConstraintSystemCompleter.complete$default(this.completer, candidate2.getSystem().asConstraintSystemCompleterContext(), completionMode, CollectionsKt.listOf(call2), initialType, this.transformer.getResolutionContext(), false, new Function1<PostponedResolvedAtom, Unit>(analyzer3, candidate2, completionMode){
            final /* synthetic */ PostponedArgumentsAnalyzer $analyzer;
            final /* synthetic */ Candidate $candidate;
            final /* synthetic */ ConstraintSystemCompletionMode $completionMode;
            {
                this.$analyzer = $analyzer;
                this.$candidate = $candidate;
                this.$completionMode = $completionMode;
                super(1);
            }

            public final void invoke(@NotNull PostponedResolvedAtom it) {
                Intrinsics.checkNotNullParameter(it, "it");
                this.$analyzer.analyze(this.$candidate.getSystem().asPostponedArgumentsAnalyzerContext(), it, this.$candidate, this.$completionMode);
            }
        }, 32, null);
    }

    public static /* synthetic */ void runCompletionForCall$default(FirCallCompleter firCallCompleter, Candidate candidate2, ConstraintSystemCompletionMode constraintSystemCompletionMode, FirResolvable firResolvable, ConeKotlinType coneKotlinType, PostponedArgumentsAnalyzer postponedArgumentsAnalyzer, int n, Object object) {
        if ((n & 0x10) != 0) {
            postponedArgumentsAnalyzer = null;
        }
        firCallCompleter.runCompletionForCall(candidate2, constraintSystemCompletionMode, firResolvable, coneKotlinType, postponedArgumentsAnalyzer);
    }

    public final void prepareLambdaAtomForFactoryPattern(@NotNull ResolvedLambdaAtom atom, @NotNull Candidate candidate2) {
        Intrinsics.checkNotNullParameter(atom, "atom");
        Intrinsics.checkNotNullParameter(candidate2, "candidate");
        ConeTypeVariableForLambdaReturnType returnVariable = new ConeTypeVariableForLambdaReturnType(atom.getAtom(), "_R");
        NewConstraintSystemImpl csBuilder = candidate2.getSystem().getBuilder();
        csBuilder.registerVariable(returnVariable);
        TypeSubstitutorMarker typeSubstitutorMarker = csBuilder.buildCurrentSubstitutor();
        TypeSystemInferenceExtensionContext typeSystemInferenceExtensionContext = csBuilder.asConstraintSystemCompleterContext();
        ConeKotlinType coneKotlinType = atom.getExpectedType();
        Intrinsics.checkNotNull(coneKotlinType);
        ConeClassLikeType functionalType = (ConeClassLikeType)MarkerExtensionsKt.safeSubstitute(typeSubstitutorMarker, typeSystemInferenceExtensionContext, coneKotlinType);
        int size = functionalType.getTypeArguments().length;
        ConeTypeProjection[] coneTypeProjectionArray = new ConeTypeProjection[size];
        ConeClassLikeLookupTag coneClassLikeLookupTag = functionalType.getLookupTag();
        for (int i = 0; i < size; ++i) {
            int n = i;
            coneTypeProjectionArray[n] = n != size - 1 ? functionalType.getTypeArguments()[n] : (ConeTypeProjection)returnVariable.getDefaultType();
        }
        ConeAttributes coneAttributes = functionalType.getAttributes();
        boolean bl = ConeTypeUtilsKt.isNullable(functionalType);
        ConeTypeProjection[] coneTypeProjectionArray2 = coneTypeProjectionArray;
        ConeClassLikeLookupTag coneClassLikeLookupTag2 = coneClassLikeLookupTag;
        ConeClassLikeTypeImpl expectedType = new ConeClassLikeTypeImpl(coneClassLikeLookupTag2, coneTypeProjectionArray2, bl, coneAttributes);
        csBuilder.addSubtypeConstraint(expectedType, functionalType, new ConeArgumentConstraintPosition(atom.getAtom()));
        atom.replaceExpectedType(expectedType, returnVariable.getDefaultType());
        atom.replaceTypeVariableForLambdaReturnType(returnVariable);
    }

    @NotNull
    public final FirCallCompletionResultsWriterTransformer createCompletionResultsWriter(@NotNull ConeSubstitutor substitutor2, @NotNull FirCallCompletionResultsWriterTransformer.Mode mode) {
        Intrinsics.checkNotNullParameter(substitutor2, "substitutor");
        Intrinsics.checkNotNullParameter((Object)mode, "mode");
        return new FirCallCompletionResultsWriterTransformer(this.session, substitutor2, this.components.getReturnTypeCalculator(), TypeComponentsKt.getTypeApproximator(this.session), this.components.getDataFlowAnalyzer(), mode);
    }

    public static /* synthetic */ FirCallCompletionResultsWriterTransformer createCompletionResultsWriter$default(FirCallCompleter firCallCompleter, ConeSubstitutor coneSubstitutor, FirCallCompletionResultsWriterTransformer.Mode mode, int n, Object object) {
        if ((n & 2) != 0) {
            mode = FirCallCompletionResultsWriterTransformer.Mode.Normal;
        }
        return firCallCompleter.createCompletionResultsWriter(coneSubstitutor, mode);
    }

    @NotNull
    public final PostponedArgumentsAnalyzer createPostponedArgumentsAnalyzer(@NotNull ResolutionContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        LambdaAnalyzerImpl lambdaAnalyzer = new LambdaAnalyzerImpl();
        return new PostponedArgumentsAnalyzer(context2, lambdaAnalyzer, InferenceComponentsKt.getInferenceComponents(this.session), this.transformer.getComponents().getCallResolver());
    }

    private final ConeKotlinType approximateLambdaInputType(ConeKotlinType $this$approximateLambdaInputType) {
        ConeKotlinType coneKotlinType = TypeComponentsKt.getTypeApproximator(this.session).approximateToSuperType($this$approximateLambdaInputType, (TypeApproximatorConfiguration)TypeApproximatorConfiguration.FinalApproximationAfterResolutionAndInference.INSTANCE);
        if (coneKotlinType == null) {
            coneKotlinType = $this$approximateLambdaInputType;
        }
        return coneKotlinType;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\f\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\nJ\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J(\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\u00020\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/inference/FirCallCompleter$CompletionResult;", "T", "", "result", "callCompleted", "", "(Ljava/lang/Object;Z)V", "getCallCompleted", "()Z", "getResult", "()Ljava/lang/Object;", "Ljava/lang/Object;", "component1", "component2", "copy", "(Ljava/lang/Object;Z)Lorg/jetbrains/kotlin/fir/resolve/inference/FirCallCompleter$CompletionResult;", "equals", "other", "hashCode", "", "toString", "", "resolve"})
    public static final class CompletionResult<T> {
        private final T result;
        private final boolean callCompleted;

        public CompletionResult(T result2, boolean callCompleted) {
            this.result = result2;
            this.callCompleted = callCompleted;
        }

        public final T getResult() {
            return this.result;
        }

        public final boolean getCallCompleted() {
            return this.callCompleted;
        }

        public final T component1() {
            return this.result;
        }

        public final boolean component2() {
            return this.callCompleted;
        }

        @NotNull
        public final CompletionResult<T> copy(T result2, boolean callCompleted) {
            return new CompletionResult<T>(result2, callCompleted);
        }

        public static /* synthetic */ CompletionResult copy$default(CompletionResult completionResult, Object object, boolean bl, int n, Object object2) {
            if ((n & 1) != 0) {
                object = completionResult.result;
            }
            if ((n & 2) != 0) {
                bl = completionResult.callCompleted;
            }
            return completionResult.copy(object, bl);
        }

        @NotNull
        public String toString() {
            return "CompletionResult(result=" + this.result + ", callCompleted=" + this.callCompleted + ')';
        }

        public int hashCode() {
            int result2 = this.result == null ? 0 : this.result.hashCode();
            int n = this.callCompleted ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result2 = result2 * 31 + n;
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CompletionResult)) {
                return false;
            }
            CompletionResult completionResult = (CompletionResult)other;
            if (!Intrinsics.areEqual(this.result, completionResult.result)) {
                return false;
            }
            return this.callCompleted == completionResult.callCompleted;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JN\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/inference/FirCallCompleter$LambdaAnalyzerImpl;", "Lorg/jetbrains/kotlin/fir/resolve/inference/LambdaAnalyzer;", "(Lorg/jetbrains/kotlin/fir/resolve/inference/FirCallCompleter;)V", "analyzeAndGetLambdaReturnArguments", "Lorg/jetbrains/kotlin/fir/resolve/inference/ReturnArgumentsAnalysisResult;", "lambdaAtom", "Lorg/jetbrains/kotlin/fir/resolve/inference/ResolvedLambdaAtom;", "receiverType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "parameters", "", "expectedReturnType", "stubsForPostponedVariables", "", "Lorg/jetbrains/kotlin/types/model/TypeVariableMarker;", "Lorg/jetbrains/kotlin/types/model/StubTypeMarker;", "candidate", "Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;", "resolve"})
    private final class LambdaAnalyzerImpl
    implements LambdaAnalyzer {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public ReturnArgumentsAnalysisResult analyzeAndGetLambdaReturnArguments(@NotNull ResolvedLambdaAtom lambdaAtom, @Nullable ConeKotlinType receiverType, @NotNull List<? extends ConeKotlinType> parameters2, @Nullable ConeKotlinType expectedReturnType, @NotNull Map<TypeVariableMarker, ? extends StubTypeMarker> stubsForPostponedVariables, @NotNull Candidate candidate2) {
            void this_$iv;
            FirBuilderInferenceSession firBuilderInferenceSession;
            void condition$iv232;
            FirTypeRef firTypeRef;
            FirResolvedTypeRef firResolvedTypeRef;
            FirAnonymousFunction firAnonymousFunction;
            FirResolvedTypeRef firResolvedTypeRef2;
            FirValueParameter firValueParameter;
            ConeKotlinType itType;
            FirValueParameter matchedParameter;
            FirPureAbstractElement firPureAbstractElement;
            FirValueParameter firValueParameter2;
            Object currentArgument;
            boolean bl;
            boolean needItParam;
            FirAnonymousFunction lambdaArgument;
            block25: {
                Intrinsics.checkNotNullParameter(lambdaAtom, "lambdaAtom");
                Intrinsics.checkNotNullParameter(parameters2, "parameters");
                Intrinsics.checkNotNullParameter(stubsForPostponedVariables, "stubsForPostponedVariables");
                Intrinsics.checkNotNullParameter(candidate2, "candidate");
                lambdaArgument = lambdaAtom.getAtom();
                needItParam = lambdaArgument.getValueParameters().isEmpty() && parameters2.size() == 1;
                LinkedHashMap<FirExpression, FirValueParameter> linkedHashMap = candidate2.getArgumentMapping();
                if (linkedHashMap != null) {
                    for (Map.Entry entry : ((Map)linkedHashMap).entrySet()) {
                        FirAnonymousFunction currentLambdaArgument;
                        bl = false;
                        currentArgument = (FirExpression)entry.getKey();
                        FirValueParameter currentValueParameter = (FirValueParameter)entry.getValue();
                        FirLambdaArgumentExpression firLambdaArgumentExpression = currentArgument instanceof FirLambdaArgumentExpression ? (FirLambdaArgumentExpression)currentArgument : null;
                        FirExpression firExpression2 = firLambdaArgumentExpression != null ? firLambdaArgumentExpression.getExpression() : null;
                        FirAnonymousFunctionExpression firAnonymousFunctionExpression = firExpression2 instanceof FirAnonymousFunctionExpression ? (FirAnonymousFunctionExpression)firExpression2 : null;
                        FirAnonymousFunction firAnonymousFunction2 = currentLambdaArgument = firAnonymousFunctionExpression != null ? firAnonymousFunctionExpression.getAnonymousFunction() : null;
                        FirValueParameter object2 = currentLambdaArgument == lambdaArgument ? currentValueParameter : (FirValueParameter)null;
                        if (object2 == null) continue;
                        firValueParameter2 = object2;
                        break block25;
                    }
                    firValueParameter2 = null;
                } else {
                    firValueParameter2 = null;
                }
            }
            ClassMembersKt.setMatchingParameterFunctionType(lambdaArgument, (firPureAbstractElement = (matchedParameter = firValueParameter2)) != null && (firPureAbstractElement = firPureAbstractElement.getReturnTypeRef()) != null ? FirTypeUtilsKt.getConeType((FirTypeRef)firPureAbstractElement) : null);
            if (needItParam) {
                Name name = Name.identifier("it");
                Intrinsics.checkNotNullExpressionValue(name, "identifier(\"it\")");
                Name name2 = name;
                itType = CollectionsKt.single(parameters2);
                FirCallCompleter firCallCompleter = FirCallCompleter.this;
                boolean $i$f$buildValueParameter = false;
                Object $this$analyzeAndGetLambdaReturnArguments_u24lambda_u2d1 = currentArgument = new FirValueParameterBuilder();
                boolean bl2 = false;
                KtSourceElement ktSourceElement = lambdaAtom.getAtom().getSource();
                ((FirValueParameterBuilder)$this$analyzeAndGetLambdaReturnArguments_u24lambda_u2d1).setSource(ktSourceElement != null ? KtSourceElementKt.fakeElement(ktSourceElement, KtFakeSourceElementKind.ItLambdaParameter.INSTANCE) : null);
                ((FirValueParameterBuilder)$this$analyzeAndGetLambdaReturnArguments_u24lambda_u2d1).setModuleData(FirModuleDataKt.getModuleData(firCallCompleter.session));
                ((FirValueParameterBuilder)$this$analyzeAndGetLambdaReturnArguments_u24lambda_u2d1).setOrigin(FirDeclarationOrigin.Source.INSTANCE);
                ((FirValueParameterBuilder)$this$analyzeAndGetLambdaReturnArguments_u24lambda_u2d1).setReturnTypeRef(TypeUtilsKt.toFirResolvedTypeRef$default(firCallCompleter.approximateLambdaInputType(itType), null, null, 3, null));
                ((FirValueParameterBuilder)$this$analyzeAndGetLambdaReturnArguments_u24lambda_u2d1).setName(name2);
                ((FirValueParameterBuilder)$this$analyzeAndGetLambdaReturnArguments_u24lambda_u2d1).setSymbol(new FirValueParameterSymbol(name2));
                ((FirValueParameterBuilder)$this$analyzeAndGetLambdaReturnArguments_u24lambda_u2d1).setDefaultValue(null);
                ((FirValueParameterBuilder)$this$analyzeAndGetLambdaReturnArguments_u24lambda_u2d1).setCrossinline(false);
                ((FirValueParameterBuilder)$this$analyzeAndGetLambdaReturnArguments_u24lambda_u2d1).setNoinline(false);
                ((FirValueParameterBuilder)$this$analyzeAndGetLambdaReturnArguments_u24lambda_u2d1).setVararg(false);
                firValueParameter = ((FirValueParameterBuilder)currentArgument).build();
            } else {
                firValueParameter = null;
            }
            FirValueParameter itParam = firValueParameter;
            ConeKotlinType coneKotlinType = expectedReturnType;
            if (coneKotlinType != null) {
                ConeKotlinType coneKotlinType2 = coneKotlinType;
                bl = false;
                firResolvedTypeRef2 = CopyUtilsKt.resolvedTypeFromPrototype(lambdaArgument.getReturnTypeRef(), coneKotlinType2);
            } else {
                firResolvedTypeRef2 = null;
            }
            FirResolvedTypeRef expectedReturnTypeRef = firResolvedTypeRef2;
            FirAnonymousFunction firAnonymousFunction3 = lambdaArgument;
            if (receiverType != null && (itType = FirCallCompleter.this.approximateLambdaInputType(receiverType)) != null) {
                void it232;
                ConeKotlinType bl3 = itType;
                firAnonymousFunction = firAnonymousFunction3;
                boolean bl2 = false;
                FirTypeRef firTypeRef2 = lambdaArgument.getReceiverTypeRef();
                firResolvedTypeRef = firTypeRef2 != null ? CopyUtilsKt.resolvedTypeFromPrototype(firTypeRef2, (ConeKotlinType)it232) : null;
                firAnonymousFunction3 = firAnonymousFunction;
            } else {
                firResolvedTypeRef = null;
            }
            firAnonymousFunction3.replaceReceiverTypeRef(firResolvedTypeRef);
            FirLookupTrackerComponent lookupTracker = FirLookupTrackerComponentKt.getLookupTracker(FirCallCompleter.this.session);
            Iterable iterable = lambdaArgument.getValueParameters();
            Object it232 = FirCallCompleter.this;
            boolean $i$f$forEachIndexed22 = false;
            int index$iv = 0;
            for (Object item$iv : iterable) {
                void parameter;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                FirValueParameter firValueParameter3 = (FirValueParameter)item$iv;
                int index2 = n;
                boolean bl4 = false;
                ConeKotlinType newReturnType = ((FirCallCompleter)it232).approximateLambdaInputType(parameters2.get(index2));
                FirResolvedTypeRef newReturnTypeRef = parameter.getReturnTypeRef() instanceof FirImplicitTypeRef ? TypeUtilsKt.toFirResolvedTypeRef$default(newReturnType, parameter.getSource(), null, 2, null) : CopyUtilsKt.resolvedTypeFromPrototype(parameter.getReturnTypeRef(), newReturnType);
                parameter.replaceReturnTypeRef(newReturnTypeRef);
                FirLookupTrackerComponent firLookupTrackerComponent = lookupTracker;
                if (firLookupTrackerComponent == null) continue;
                FirLookupTrackerComponentKt.recordTypeResolveAsLookup(firLookupTrackerComponent, newReturnTypeRef, parameter.getSource(), null);
            }
            lambdaArgument.replaceValueParameters(CollectionsKt.plus((Collection)lambdaArgument.getValueParameters(), (Iterable)CollectionsKt.listOfNotNull(itParam)));
            FirAnonymousFunction firAnonymousFunction4 = lambdaArgument;
            FirResolvedTypeRef firResolvedTypeRef3 = expectedReturnTypeRef;
            if (firResolvedTypeRef3 != null) {
                Object $i$f$forEachIndexed22 = it232 = firResolvedTypeRef3;
                firAnonymousFunction = firAnonymousFunction4;
                boolean bl5 = false;
                FirLookupTrackerComponent firLookupTrackerComponent = lookupTracker;
                if (firLookupTrackerComponent != null) {
                    void it3;
                    FirLookupTrackerComponentKt.recordTypeResolveAsLookup(firLookupTrackerComponent, (FirTypeRef)it3, lambdaArgument.getSource(), null);
                }
                firAnonymousFunction4 = firAnonymousFunction;
                firTypeRef = (FirTypeRef)it232;
            } else {
                firTypeRef = FirCallCompleter.this.components.getNoExpectedType();
            }
            firAnonymousFunction4.replaceReturnTypeRef(firTypeRef);
            boolean it232 = !stubsForPostponedVariables.isEmpty();
            Object it3 = FirCallCompleter.this;
            boolean $i$f$runIf = false;
            if (condition$iv232 != false) {
                boolean bl6 = false;
                firBuilderInferenceSession = new FirBuilderInferenceSession(lambdaArgument, ((FirCallCompleter)it3).transformer.getResolutionContext(), stubsForPostponedVariables);
            } else {
                firBuilderInferenceSession = null;
            }
            FirBuilderInferenceSession firBuilderInferenceSession2 = firBuilderInferenceSession;
            BodyResolveContext condition$iv232 = FirCallCompleter.this.transformer.getContext();
            it3 = lambdaArgument.getSymbol();
            FirCallCompleter firCallCompleter = FirCallCompleter.this;
            boolean $i$f$withAnonymousFunctionTowerDataContext = false;
            void this_$iv$iv = this_$iv;
            boolean $i$f$withTowerModeCleanup = false;
            FirTowerDataMode initialMode$iv$iv = this_$iv$iv.getTowerDataMode();
            try {
                FirAnonymousFunction firAnonymousFunction5;
                void symbol$iv;
                boolean bl7 = false;
                FirTowerDataContext newContext$iv = this_$iv.getSpecialTowerDataContexts().getAnonymousFunctionContext((FirAnonymousFunctionSymbol)symbol$iv);
                if (newContext$iv != null) {
                    this_$iv.setRegularTowerDataContexts(this_$iv.getRegularTowerDataContexts().copyWithSpecial(newContext$iv));
                }
                boolean bl3 = false;
                if (firBuilderInferenceSession2 != null) {
                    FirAnonymousFunction firAnonymousFunction6;
                    BodyResolveContext this_$iv2 = firCallCompleter.transformer.getContext();
                    boolean $i$f$withInferenceSession = false;
                    FirInferenceSession oldSession$iv = this_$iv2.getInferenceSession();
                    this_$iv2.setInferenceSession(firBuilderInferenceSession2);
                    try {
                        boolean bl4 = false;
                        firAnonymousFunction6 = (FirAnonymousFunction)FirTransformerUtilKt.transformSingle((FirElement)lambdaArgument, firCallCompleter.transformer, new ResolutionMode.LambdaResolution(expectedReturnTypeRef));
                    }
                    finally {
                        this_$iv2.setInferenceSession(oldSession$iv);
                    }
                    firAnonymousFunction5 = firAnonymousFunction6;
                } else {
                    firAnonymousFunction5 = (FirAnonymousFunction)FirTransformerUtilKt.transformSingle((FirElement)lambdaArgument, firCallCompleter.transformer, new ResolutionMode.LambdaResolution(expectedReturnTypeRef));
                }
                FirAnonymousFunction firAnonymousFunction7 = firAnonymousFunction5;
            }
            finally {
                this_$iv$iv.setTowerDataMode(initialMode$iv$iv);
            }
            FirCallCompleter.this.transformer.getContext().dropContextForAnonymousFunction(lambdaArgument);
            Collection<FirStatement> returnArguments = FirCallCompleter.this.components.getDataFlowAnalyzer().returnExpressionsOfAnonymousFunction(lambdaArgument);
            return new ReturnArgumentsAnalysisResult(returnArguments, firBuilderInferenceSession2);
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ConstraintSystemCompletionMode.values().length];
            nArray[ConstraintSystemCompletionMode.FULL.ordinal()] = 1;
            nArray[ConstraintSystemCompletionMode.PARTIAL.ordinal()] = 2;
            nArray[ConstraintSystemCompletionMode.UNTIL_FIRST_LAMBDA.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

