/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.FindClassInModuleKt;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.incremental.IncrementalJvmCache;
import org.jetbrains.kotlin.incremental.JavaClassesTrackerImplKt;
import org.jetbrains.kotlin.incremental.SerializedJavaClassWithSource;
import org.jetbrains.kotlin.load.java.JavaClassesTracker;
import org.jetbrains.kotlin.load.java.descriptors.JavaClassDescriptor;
import org.jetbrains.kotlin.load.java.lazy.descriptors.LazyJavaClassDescriptor;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\nH\u0016J\f\u0010\u0018\u001a\u00020\u0019*\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/incremental/JavaClassesTrackerImpl;", "Lorg/jetbrains/kotlin/load/java/JavaClassesTracker;", "cache", "Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache;", "untrackedJavaClasses", "", "Lorg/jetbrains/kotlin/name/ClassId;", "(Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache;Ljava/util/Set;)V", "classDescriptors", "", "Lorg/jetbrains/kotlin/load/java/descriptors/JavaClassDescriptor;", "classToSourceSerialized", "", "Lorg/jetbrains/kotlin/incremental/SerializedJavaClassWithSource;", "javaClassesUpdates", "", "getJavaClassesUpdates", "()Ljava/util/Collection;", "onCompletedAnalysis", "", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "reportClass", "classDescriptor", "wasContentRequested", "", "kotlin-build-common"})
public final class JavaClassesTrackerImpl
implements JavaClassesTracker {
    @NotNull
    private final IncrementalJvmCache cache;
    @NotNull
    private final Set<ClassId> untrackedJavaClasses;
    @NotNull
    private final Map<ClassId, SerializedJavaClassWithSource> classToSourceSerialized;
    @NotNull
    private final List<JavaClassDescriptor> classDescriptors;

    public JavaClassesTrackerImpl(@NotNull IncrementalJvmCache cache2, @NotNull Set<ClassId> untrackedJavaClasses) {
        Intrinsics.checkNotNullParameter(cache2, "cache");
        Intrinsics.checkNotNullParameter(untrackedJavaClasses, "untrackedJavaClasses");
        this.cache = cache2;
        this.untrackedJavaClasses = untrackedJavaClasses;
        this.classToSourceSerialized = new HashMap();
        this.classDescriptors = new ArrayList();
    }

    @NotNull
    public final Collection<SerializedJavaClassWithSource> getJavaClassesUpdates() {
        return this.classToSourceSerialized.values();
    }

    @Override
    public void reportClass(@NotNull JavaClassDescriptor classDescriptor) {
        Intrinsics.checkNotNullParameter(classDescriptor, "classDescriptor");
        ClassId classId = DescriptorUtilsKt.getClassId((ClassifierDescriptor)classDescriptor);
        Intrinsics.checkNotNull(classId);
        ClassId classId2 = classId;
        if (!this.cache.isJavaClassToTrack(classId2) || JavaClassesTrackerImplKt.access$getJavaSourceFile(classDescriptor) == null) {
            return;
        }
        this.classDescriptors.add(classDescriptor);
    }

    @Override
    public void onCompletedAnalysis(@NotNull ModuleDescriptor module2) {
        Intrinsics.checkNotNullParameter(module2, "module");
        for (ClassId classId : CollectionsKt.plus(this.cache.getObsoleteJavaClasses(), (Iterable)this.untrackedJavaClasses)) {
            FindClassInModuleKt.findClassAcrossModuleDependencies(module2, classId);
        }
        for (JavaClassDescriptor classDescriptor : CollectionsKt.toList((Iterable)this.classDescriptors)) {
            boolean bl;
            ClassId classId;
            Intrinsics.checkNotNull(DescriptorUtilsKt.getClassId((ClassifierDescriptor)classDescriptor));
            if (!this.cache.isJavaClassAlreadyInCache(classId) && !this.untrackedJavaClasses.contains(classId) && !this.wasContentRequested(classDescriptor)) continue;
            boolean bl2 = bl = !this.classToSourceSerialized.containsKey(classId);
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string2 = "Duplicated JavaClassDescriptor " + classId + " reported to IC";
                throw new AssertionError((Object)string2);
            }
            this.classToSourceSerialized.put(classId, (SerializedJavaClassWithSource)JavaClassesTrackerImplKt.getCONVERTING_JAVA_CLASSES_TO_PROTO().time((Function0)new Function0<SerializedJavaClassWithSource>(classDescriptor){
                final /* synthetic */ JavaClassDescriptor $classDescriptor;
                {
                    this.$classDescriptor = $classDescriptor;
                    super(0);
                }

                @NotNull
                public final SerializedJavaClassWithSource invoke() {
                    return JavaClassesTrackerImplKt.convertToProto(this.$classDescriptor);
                }
            }));
        }
    }

    private final boolean wasContentRequested(JavaClassDescriptor $this$wasContentRequested) {
        JavaClassDescriptor $this$safeAs$iv = $this$wasContentRequested;
        boolean $i$f$safeAs = false;
        JavaClassDescriptor javaClassDescriptor = $this$safeAs$iv;
        if (!(javaClassDescriptor instanceof LazyJavaClassDescriptor)) {
            javaClassDescriptor = null;
        }
        LazyJavaClassDescriptor lazyJavaClassDescriptor = (LazyJavaClassDescriptor)javaClassDescriptor;
        return !(lazyJavaClassDescriptor != null ? !lazyJavaClassDescriptor.wasScopeContentRequested() : false);
    }
}

