/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.AtomicNullableLazyValue;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.PsiJavaParserFacadeImpl;
import com.intellij.psi.impl.cache.TypeAnnotationContainer;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsJavaCodeReferenceElementImpl;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.TreeElement;
import java.util.List;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClsTypeElementImpl
extends ClsElementImpl
implements PsiTypeElement {
    private final PsiElement myParent;
    @NotNull
    private final String myTypeText;
    private final char myVariance;
    @NotNull
    private final TypeAnnotationContainer myAnnotations;
    @NotNull
    private final NullableLazyValue<ClsElementImpl> myChild;
    @NotNull
    private final NotNullLazyValue<PsiType> myCachedType;

    public ClsTypeElementImpl(@NotNull PsiElement parent2, @NotNull String typeText, char variance) {
        if (parent2 == null) {
            ClsTypeElementImpl.$$$reportNull$$$0(0);
        }
        if (typeText == null) {
            ClsTypeElementImpl.$$$reportNull$$$0(1);
        }
        this(parent2, typeText, variance, TypeAnnotationContainer.EMPTY);
    }

    ClsTypeElementImpl(@Nullable PsiElement parent2, @NotNull TypeInfo typeInfo) {
        if (typeInfo == null) {
            ClsTypeElementImpl.$$$reportNull$$$0(2);
        }
        this(parent2, Objects.requireNonNull(TypeInfo.createTypeText(typeInfo)), '\u0000', typeInfo.getTypeAnnotations());
    }

    ClsTypeElementImpl(@Nullable PsiElement parent2, @NotNull String typeText, char variance, @NotNull TypeAnnotationContainer annotations2) {
        if (typeText == null) {
            ClsTypeElementImpl.$$$reportNull$$$0(3);
        }
        if (annotations2 == null) {
            ClsTypeElementImpl.$$$reportNull$$$0(4);
        }
        this.myParent = parent2;
        this.myTypeText = TypeInfo.internFrequentType(typeText);
        this.myVariance = variance;
        this.myAnnotations = annotations2;
        this.myChild = new AtomicNullableLazyValue<ClsElementImpl>(){

            @Override
            protected ClsElementImpl compute() {
                return ClsTypeElementImpl.this.calculateChild();
            }
        };
        this.myCachedType = new AtomicNotNullLazyValue<PsiType>(){

            @Override
            @NotNull
            protected PsiType compute() {
                PsiType psiType2 = ClsTypeElementImpl.this.calculateType();
                if (psiType2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                return psiType2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsTypeElementImpl$2", "compute"));
            }
        };
    }

    @Override
    public PsiElement @NotNull [] getChildren() {
        PsiElement[] psiElementArray;
        ClsElementImpl child = this.myChild.getValue();
        if (child != null) {
            PsiElement[] psiElementArray2 = new PsiElement[1];
            psiElementArray = psiElementArray2;
            psiElementArray2[0] = child;
        } else {
            psiElementArray = PsiElement.EMPTY_ARRAY;
        }
        if (psiElementArray == null) {
            ClsTypeElementImpl.$$$reportNull$$$0(5);
        }
        return psiElementArray;
    }

    @Override
    public PsiElement getParent() {
        return this.myParent;
    }

    @Override
    public String getText() {
        String shortClassName = PsiNameHelper.getShortClassName(this.myTypeText);
        return this.decorateTypeText(shortClassName);
    }

    private String decorateTypeText(String shortClassName) {
        switch (this.myVariance) {
            case '\u0000': {
                return shortClassName;
            }
            case '+': {
                return "? extends " + shortClassName;
            }
            case '-': {
                return "? super " + shortClassName;
            }
            case '*': {
                return "?";
            }
        }
        assert (false) : this.myVariance;
        return null;
    }

    public String getCanonicalText() {
        return this.decorateTypeText(this.myTypeText);
    }

    @Override
    public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
        if (buffer == null) {
            ClsTypeElementImpl.$$$reportNull$$$0(6);
        }
        buffer.append(this.getType().getCanonicalText(true));
    }

    @Override
    public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
        if (element == null) {
            ClsTypeElementImpl.$$$reportNull$$$0(7);
        }
        this.setMirrorCheckingType(element, JavaElementType.TYPE);
        ClsElementImpl child = this.myChild.getValue();
        if (child != null) {
            child.setMirror(element.getFirstChildNode());
        }
    }

    private boolean isArray() {
        return this.myTypeText.endsWith("[]");
    }

    private boolean isVarArgs() {
        return this.myTypeText.endsWith("...");
    }

    @Override
    @NotNull
    public PsiType getType() {
        PsiType psiType2 = this.myCachedType.getValue();
        if (psiType2 == null) {
            ClsTypeElementImpl.$$$reportNull$$$0(8);
        }
        return psiType2;
    }

    @Override
    public PsiJavaCodeReferenceElement getInnermostComponentReferenceElement() {
        return null;
    }

    private ClsElementImpl calculateChild() {
        if (PsiJavaParserFacadeImpl.getPrimitiveType(this.myTypeText) != null) {
            return null;
        }
        if (this.isArray()) {
            if (this.myVariance == '\u0000') {
                return this.getDeepestArrayElement();
            }
            return new ClsTypeElementImpl(this, this.myTypeText, '\u0000', this.myAnnotations.forBound());
        }
        if (this.isVarArgs()) {
            return this.getDeepestArrayElement();
        }
        return this.myVariance == '*' ? null : new ClsJavaCodeReferenceElementImpl(this, this.myTypeText, this.myVariance == '\u0000' ? this.myAnnotations : this.myAnnotations.forBound());
    }

    int getArrayDepth() {
        boolean varArgs = this.isVarArgs();
        if (!varArgs && !this.isArray()) {
            return 0;
        }
        int bracketPos = this.myTypeText.length() - (varArgs ? 3 : 2);
        int depth = 1;
        while (bracketPos > 2 && this.myTypeText.startsWith("[]", bracketPos - 2)) {
            bracketPos -= 2;
            ++depth;
        }
        return depth;
    }

    @NotNull
    private ClsElementImpl getDeepestArrayElement() {
        int depth = this.getArrayDepth();
        int bracketPos = this.myTypeText.length() - depth * 2 - (this.isVarArgs() ? 1 : 0);
        TypeAnnotationContainer container = this.myAnnotations;
        for (int i = 0; i < depth; ++i) {
            container = container.forArrayElement();
        }
        return new ClsTypeElementImpl(this, this.myTypeText.substring(0, bracketPos), this.myVariance, container);
    }

    @NotNull
    private PsiType createArrayType(PsiTypeElement deepestChild) {
        int depth = this.getArrayDepth();
        List containers = ((StreamEx)StreamEx.iterate(this.myAnnotations, TypeAnnotationContainer::forArrayElement).limit(depth)).toList();
        PsiType type2 = deepestChild.getType();
        for (int i = depth - 1; i >= 0; --i) {
            type2 = i == 0 && this.isVarArgs() ? new PsiEllipsisType(type2) : type2.createArrayType();
            type2 = type2.annotate(((TypeAnnotationContainer)containers.get(i)).getProvider(this));
        }
        PsiType psiType2 = type2;
        if (psiType2 == null) {
            ClsTypeElementImpl.$$$reportNull$$$0(9);
        }
        return psiType2;
    }

    @NotNull
    private PsiType calculateType() {
        PsiType psiType2 = this.calculateBaseType().annotate(this.myAnnotations.getProvider(this));
        if (psiType2 == null) {
            ClsTypeElementImpl.$$$reportNull$$$0(10);
        }
        return psiType2;
    }

    @NotNull
    private PsiType calculateBaseType() {
        PsiPrimitiveType result2 = PsiJavaParserFacadeImpl.getPrimitiveType(this.myTypeText);
        if (result2 != null) {
            PsiPrimitiveType psiPrimitiveType = result2;
            if (psiPrimitiveType == null) {
                ClsTypeElementImpl.$$$reportNull$$$0(11);
            }
            return psiPrimitiveType;
        }
        ClsElementImpl childElement = this.myChild.getValue();
        if (childElement instanceof ClsTypeElementImpl) {
            if (this.isArray()) {
                switch (this.myVariance) {
                    case '\u0000': {
                        return this.createArrayType((PsiTypeElement)((Object)childElement));
                    }
                    case '+': {
                        PsiWildcardType psiWildcardType = PsiWildcardType.createExtends(this.getManager(), ((PsiTypeElement)((Object)childElement)).getType());
                        if (psiWildcardType == null) {
                            ClsTypeElementImpl.$$$reportNull$$$0(12);
                        }
                        return psiWildcardType;
                    }
                    case '-': {
                        PsiWildcardType psiWildcardType = PsiWildcardType.createSuper(this.getManager(), ((PsiTypeElement)((Object)childElement)).getType());
                        if (psiWildcardType == null) {
                            ClsTypeElementImpl.$$$reportNull$$$0(13);
                        }
                        return psiWildcardType;
                    }
                }
                assert (false) : this.myVariance;
                if (null == null) {
                    ClsTypeElementImpl.$$$reportNull$$$0(14);
                }
                return null;
            }
            assert (this.isVarArgs()) : this;
            return this.createArrayType((PsiTypeElement)((Object)childElement));
        }
        if (childElement instanceof ClsJavaCodeReferenceElementImpl) {
            PsiClassReferenceType psiClassReferenceType = new PsiClassReferenceType((PsiJavaCodeReferenceElement)((Object)childElement), null);
            switch (this.myVariance) {
                case '\u0000': {
                    PsiClassReferenceType psiClassReferenceType2 = psiClassReferenceType;
                    if (psiClassReferenceType2 == null) {
                        ClsTypeElementImpl.$$$reportNull$$$0(15);
                    }
                    return psiClassReferenceType2;
                }
                case '+': {
                    PsiWildcardType psiWildcardType = PsiWildcardType.createExtends(this.getManager(), psiClassReferenceType.annotate(this.myAnnotations.forBound().getProvider(childElement)));
                    if (psiWildcardType == null) {
                        ClsTypeElementImpl.$$$reportNull$$$0(16);
                    }
                    return psiWildcardType;
                }
                case '-': {
                    PsiWildcardType psiWildcardType = PsiWildcardType.createSuper(this.getManager(), psiClassReferenceType.annotate(this.myAnnotations.forBound().getProvider(childElement)));
                    if (psiWildcardType == null) {
                        ClsTypeElementImpl.$$$reportNull$$$0(17);
                    }
                    return psiWildcardType;
                }
                case '*': {
                    PsiWildcardType psiWildcardType = PsiWildcardType.createUnbounded(this.getManager());
                    if (psiWildcardType == null) {
                        ClsTypeElementImpl.$$$reportNull$$$0(18);
                    }
                    return psiWildcardType;
                }
            }
            assert (false) : this.myVariance;
            if (null == null) {
                ClsTypeElementImpl.$$$reportNull$$$0(19);
            }
            return null;
        }
        assert (childElement == null) : this;
        PsiWildcardType psiWildcardType = PsiWildcardType.createUnbounded(this.getManager());
        if (psiWildcardType == null) {
            ClsTypeElementImpl.$$$reportNull$$$0(20);
        }
        return psiWildcardType;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            ClsTypeElementImpl.$$$reportNull$$$0(21);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitTypeElement(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public PsiAnnotation @NotNull [] getAnnotations() {
        throw new UnsupportedOperationException();
    }

    @Override
    public PsiAnnotation findAnnotation(@NotNull String qualifiedName2) {
        if (qualifiedName2 == null) {
            ClsTypeElementImpl.$$$reportNull$$$0(22);
        }
        return PsiImplUtil.findAnnotation(this, qualifiedName2);
    }

    @Override
    @NotNull
    public PsiAnnotation addAnnotation(@NotNull String qualifiedName2) {
        if (qualifiedName2 == null) {
            ClsTypeElementImpl.$$$reportNull$$$0(23);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public PsiAnnotation @NotNull [] getApplicableAnnotations() {
        PsiAnnotation[] psiAnnotationArray = this.getType().getAnnotations();
        if (psiAnnotationArray == null) {
            ClsTypeElementImpl.$$$reportNull$$$0(24);
        }
        return psiAnnotationArray;
    }

    @Override
    public String toString() {
        return "PsiTypeElement:" + this.getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeText";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeInfo";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/compiled/ClsTypeElementImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/compiled/ClsTypeElementImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createArrayType";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateType";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateBaseType";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicableAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "appendMirrorText";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setMirror";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotation";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addAnnotation";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

