/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.lower.AbstractVariableRemapper;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.loops.HeaderProcessorKt;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredStatementOrigin;
import org.jetbrains.kotlin.backend.jvm.ir.IrInlineReferenceLocatorKt;
import org.jetbrains.kotlin.backend.jvm.ir.IrInlineScopeResolver;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.declarations.impl.IrVariableImpl;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrPublicSymbolBase;
import org.jetbrains.kotlin.ir.symbols.impl.IrVariableSymbolImpl;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00142\u00020\u0001:\u0002\u0014\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\u00020\b*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\n\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmOptimizationLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "isObjectEquals", "", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Z", "getOperandsIfCallToEQEQOrEquals", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "Companion", "Transformer", "backend.jvm.lower"})
public final class JvmOptimizationLowering
implements FileLoweringPass {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JvmBackendContext context;

    public JvmOptimizationLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    private final boolean isObjectEquals(IrFunction $this$isObjectEquals) {
        return Intrinsics.areEqual($this$isObjectEquals.getName().asString(), "equals") && ((Collection)$this$isObjectEquals.getValueParameters()).size() == 1 && IrTypePredicatesKt.isNullableAny($this$isObjectEquals.getValueParameters().get(0).getType()) && $this$isObjectEquals.getExtensionReceiverParameter() == null && $this$isObjectEquals.getDispatchReceiverParameter() != null;
    }

    private final Pair<IrExpression, IrExpression> getOperandsIfCallToEQEQOrEquals(IrCall call2) {
        Pair<IrExpression, IrExpression> pair;
        if (Intrinsics.areEqual(call2.getSymbol(), this.context.getIrBuiltIns().getEqeqSymbol())) {
            IrExpression irExpression = call2.getValueArgument(0);
            Intrinsics.checkNotNull(irExpression);
            IrExpression left = irExpression;
            IrExpression irExpression2 = call2.getValueArgument(1);
            Intrinsics.checkNotNull(irExpression2);
            IrExpression right = irExpression2;
            pair = TuplesKt.to(left, right);
        } else if (this.isObjectEquals((IrFunction)call2.getSymbol().getOwner())) {
            IrExpression irExpression = call2.getDispatchReceiver();
            Intrinsics.checkNotNull(irExpression);
            IrExpression left = irExpression;
            IrExpression irExpression3 = call2.getValueArgument(0);
            Intrinsics.checkNotNull(irExpression3);
            IrExpression right = irExpression3;
            pair = TuplesKt.to(left, right);
        } else {
            pair = null;
        }
        return pair;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter(irFile, "irFile");
        irFile.transformChildren(new Transformer(IrInlineReferenceLocatorKt.findInlineCallSites(irFile, this.context)), null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmOptimizationLowering$Companion;", "", "()V", "isNegation", "", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "backend.jvm.lower"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isNegation(@NotNull IrExpression expression2, @NotNull JvmBackendContext context2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(context2, "context");
            if (!(expression2 instanceof IrCall)) return false;
            IrSimpleFunctionSymbol irSimpleFunctionSymbol = ((IrCall)expression2).getSymbol();
            IrPublicSymbolBase irPublicSymbolBase = irSimpleFunctionSymbol instanceof IrPublicSymbolBase ? (IrPublicSymbolBase)((Object)irSimpleFunctionSymbol) : null;
            if (!Intrinsics.areEqual(irPublicSymbolBase != null ? irPublicSymbolBase.getSignature() : null, context2.getIrBuiltIns().getBooleanNotSymbol().getSignature())) return false;
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001a\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0002H\u0002J\u0016\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\fH\u0002J\u001a\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010 \u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010!\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010\"\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020$2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010%\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020&2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010'\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020(2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0002H\u0016J\f\u0010)\u001a\u00020**\u00020\u000fH\u0002J\u000e\u0010+\u001a\u0004\u0018\u00010\u0014*\u00020\fH\u0002R\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmOptimizationLowering$Transformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformer;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "inlineScopeResolver", "Lorg/jetbrains/kotlin/backend/jvm/ir/IrInlineScopeResolver;", "(Lorg/jetbrains/kotlin/backend/jvm/lower/JvmOptimizationLowering;Lorg/jetbrains/kotlin/backend/jvm/ir/IrInlineScopeResolver;)V", "dontTouchTemporaryVals", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "Lkotlin/collections/HashSet;", "findLoopVariablePosition", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/expressions/IrContainerExpression;", "", "statement", "Lorg/jetbrains/kotlin/ir/IrStatement;", "getInlineableValueForTemporaryVal", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "optimizePropertyAccess", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "data", "removeUnnecessaryTemporaryVariables", "", "statements", "", "reuseLoopVariableAsInductionVariableIfPossible", "irForLoopBlock", "visitBlockBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "body", "Lorg/jetbrains/kotlin/ir/expressions/IrBlockBody;", "visitCall", "visitContainerExpression", "visitDeclaration", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationBase;", "visitGetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "visitWhen", "Lorg/jetbrains/kotlin/ir/expressions/IrWhen;", "isLoopVariable", "", "rewritePostfixIncrDecr", "backend.jvm.lower"})
    private final class Transformer
    implements IrElementTransformer<IrDeclaration> {
        @NotNull
        private final IrInlineScopeResolver inlineScopeResolver;
        @NotNull
        private final HashSet<IrVariable> dontTouchTemporaryVals;

        public Transformer(IrInlineScopeResolver inlineScopeResolver) {
            Intrinsics.checkNotNullParameter(inlineScopeResolver, "inlineScopeResolver");
            this.inlineScopeResolver = inlineScopeResolver;
            this.dontTouchTemporaryVals = new HashSet();
        }

        @Override
        @NotNull
        public IrStatement visitDeclaration(@NotNull IrDeclarationBase declaration2, @Nullable IrDeclaration data2) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            return IrElementTransformer.DefaultImpls.visitDeclaration(this, declaration2, declaration2);
        }

        @Override
        @NotNull
        public IrExpression visitCall(@NotNull IrCall expression2, @Nullable IrDeclaration data2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            expression2.transformChildren(this, data2);
            IrSimpleFunction callee = (IrSimpleFunction)expression2.getSymbol().getOwner();
            if (Intrinsics.areEqual(callee.getOrigin(), IrDeclarationOrigin.DEFAULT_PROPERTY_ACCESSOR.INSTANCE)) {
                return this.optimizePropertyAccess(expression2, data2);
            }
            if (Companion.isNegation(expression2, JvmOptimizationLowering.this.getContext())) {
                IrExpression irExpression = expression2.getDispatchReceiver();
                Intrinsics.checkNotNull(irExpression);
                if (Companion.isNegation(irExpression, JvmOptimizationLowering.this.getContext())) {
                    IrExpression irExpression2 = expression2.getDispatchReceiver();
                    if (irExpression2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrCall");
                    }
                    IrExpression irExpression3 = ((IrCall)irExpression2).getDispatchReceiver();
                    Intrinsics.checkNotNull(irExpression3);
                    return irExpression3;
                }
            }
            Pair pair = JvmOptimizationLowering.this.getOperandsIfCallToEQEQOrEquals(expression2);
            if (pair != null) {
                Pair pair2 = pair;
                JvmOptimizationLowering jvmOptimizationLowering = JvmOptimizationLowering.this;
                Pair pair3 = pair2;
                boolean bl = false;
                IrExpression left = (IrExpression)pair3.component1();
                IrExpression right = (IrExpression)pair3.component2();
                if (IrUtilsKt.isNullConst(left) && IrUtilsKt.isNullConst(right)) {
                    return IrConstImpl.Companion.constTrue(expression2.getStartOffset(), expression2.getEndOffset(), jvmOptimizationLowering.getContext().getIrBuiltIns().getBooleanType());
                }
                if (IrUtilsKt.isNullConst(left) && right instanceof IrConst || IrUtilsKt.isNullConst(right) && left instanceof IrConst) {
                    return IrConstImpl.Companion.constFalse(expression2.getStartOffset(), expression2.getEndOffset(), jvmOptimizationLowering.getContext().getIrBuiltIns().getBooleanType());
                }
            }
            return expression2;
        }

        /*
         * WARNING - void declaration
         */
        private final IrExpression optimizePropertyAccess(IrCall expression2, IrDeclaration data2) {
            void this_$iv$iv$iv;
            void startOffset$iv$iv;
            void $this$irBlock$iv$iv;
            void $this$irBlock_u24default$iv;
            Object object;
            IrElement irElement;
            IrField backingField2;
            IrSimpleFunction accessor;
            block13: {
                block12: {
                    Object b = expression2.getSymbol().getOwner();
                    IrSimpleFunction irSimpleFunction = b instanceof IrSimpleFunction ? (IrSimpleFunction)b : null;
                    if (irSimpleFunction == null) {
                        return expression2;
                    }
                    accessor = irSimpleFunction;
                    if (accessor.getModality() != Modality.FINAL || accessor.isExternal()) {
                        return expression2;
                    }
                    Object object2 = accessor.getCorrespondingPropertySymbol();
                    if (object2 == null || (object2 = (IrProperty)object2.getOwner()) == null) {
                        return expression2;
                    }
                    Object property2 = object2;
                    if (((IrProperty)property2).isLateinit()) {
                        return expression2;
                    }
                    IrField irField = ((IrProperty)property2).getBackingField();
                    if (irField == null) {
                        return expression2;
                    }
                    backingField2 = irField;
                    irElement = data2;
                    if (irElement == null) break block12;
                    object = irElement;
                    IrInlineScopeResolver irInlineScopeResolver = this.inlineScopeResolver;
                    IrElement p0 = (IrElement)object;
                    boolean bl = false;
                    IrDeclarationContainer irDeclarationContainer = irInlineScopeResolver.findContainer(p0);
                    irElement = irDeclarationContainer;
                    if (irDeclarationContainer != null) break block13;
                }
                return expression2;
            }
            IrElement scope2 = irElement;
            if (!Intrinsics.areEqual(scope2, accessor.getParent()) || !Intrinsics.areEqual(scope2, backingField2.getParent())) {
                return expression2;
            }
            IrExpression receiver = expression2.getDispatchReceiver();
            object = LowerUtilsKt.createIrBuilder(JvmOptimizationLowering.this.getContext(), (IrSymbol)expression2.getSymbol(), expression2.getStartOffset(), expression2.getEndOffset());
            JvmOptimizationLowering jvmOptimizationLowering = JvmOptimizationLowering.this;
            IrStatementOrigin origin$iv = null;
            IrType resultType$iv = ((IrExpression)expression2).getType();
            boolean $i$f$irBlock = false;
            void var13_14 = $this$irBlock_u24default$iv;
            int n = ((IrExpression)expression2).getStartOffset();
            int endOffset$iv$iv = ((IrExpression)expression2).getEndOffset();
            boolean $i$f$irBlock2 = false;
            IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock$iv$iv.getContext(), $this$irBlock$iv$iv.getScope(), (int)startOffset$iv$iv, endOffset$iv$iv, origin$iv, resultType$iv, false, 64, null);
            boolean $i$f$block = false;
            void $this$optimizePropertyAccess_u24lambda_u2d3 = this_$iv$iv$iv;
            boolean bl = false;
            if (backingField2.isStatic() && receiver != null && !(receiver instanceof IrGetValue)) {
                $this$optimizePropertyAccess_u24lambda_u2d3.unaryPlus(IrUtilsKt.coerceToUnit(receiver, $this$optimizePropertyAccess_u24lambda_u2d3.getContext().getIrBuiltIns(), jvmOptimizationLowering.getContext().getTypeSystem()));
            }
            if (!((Collection)accessor.getValueParameters()).isEmpty()) {
                IrExpression irExpression;
                IrExpression irExpression2 = irExpression = receiver;
                IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$optimizePropertyAccess_u24lambda_u2d3;
                void var24_28 = $this$optimizePropertyAccess_u24lambda_u2d3;
                boolean bl2 = false;
                boolean bl3 = backingField2.isStatic();
                IrExpression irExpression3 = !bl3 ? irExpression : null;
                IrExpression irExpression4 = expression2.getValueArgument(expression2.getValueArgumentsCount() - 1);
                Intrinsics.checkNotNull(irExpression4);
                var24_28.unaryPlus(ExpressionHelpersKt.irSetField$default(irBuilderWithScope, irExpression3, backingField2, irExpression4, null, 8, null));
            } else {
                IrExpression irExpression;
                IrExpression it = irExpression = receiver;
                IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$optimizePropertyAccess_u24lambda_u2d3;
                void var24_29 = $this$optimizePropertyAccess_u24lambda_u2d3;
                boolean bl4 = false;
                boolean bl5 = backingField2.isStatic();
                var24_29.unaryPlus(ExpressionHelpersKt.irGetField(irBuilderWithScope, !bl5 ? irExpression : null, backingField2));
            }
            return this_$iv$iv$iv.doBuild();
        }

        @Override
        @NotNull
        public IrExpression visitWhen(@NotNull IrWhen expression2, @Nullable IrDeclaration data2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            boolean isCompilerGenerated = expression2.getOrigin() == null;
            expression2.transformChildren(this, data2);
            expression2.getBranches().removeIf(arg_0 -> Transformer.visitWhen$lambda-4(isCompilerGenerated, arg_0));
            if (Intrinsics.areEqual(expression2.getOrigin(), IrStatementOrigin.ANDAND.INSTANCE)) {
                IrCallImpl irCallImpl;
                boolean bl;
                boolean bl2 = bl = IrTypePredicatesKt.isBoolean(expression2.getType()) && expression2.getBranches().size() == 2 && IrUtilsKt.isTrueConst(expression2.getBranches().get(1).getCondition()) && IrUtilsKt.isFalseConst(expression2.getBranches().get(1).getResult());
                if (_Assertions.ENABLED && !bl) {
                    boolean $i$a$-assert-JvmOptimizationLowering$Transformer$visitWhen$32 = false;
                    String $i$a$-assert-JvmOptimizationLowering$Transformer$visitWhen$32 = "ANDAND condition should have an 'if true then false' body on its second branch. Failing expression: " + DumpIrTreeKt.dump$default(expression2, false, false, 3, null);
                    throw new AssertionError((Object)$i$a$-assert-JvmOptimizationLowering$Transformer$visitWhen$32);
                }
                IrCallImpl $this$visitWhen_u24lambda_u2d6 = irCallImpl = IrCallImpl.Companion.fromSymbolOwner$default(IrCallImpl.Companion, expression2.getStartOffset(), expression2.getEndOffset(), JvmOptimizationLowering.this.getContext().getIrBuiltIns().getBooleanType(), JvmOptimizationLowering.this.getContext().getIrBuiltIns().getAndandSymbol(), 0, 0, null, null, 240, null);
                boolean bl3 = false;
                $this$visitWhen_u24lambda_u2d6.putValueArgument(0, expression2.getBranches().get(0).getCondition());
                $this$visitWhen_u24lambda_u2d6.putValueArgument(1, expression2.getBranches().get(0).getResult());
                return irCallImpl;
            }
            if (Intrinsics.areEqual(expression2.getOrigin(), IrStatementOrigin.OROR.INSTANCE)) {
                IrCallImpl irCallImpl;
                boolean bl;
                boolean bl4 = bl = IrTypePredicatesKt.isBoolean(expression2.getType()) && expression2.getBranches().size() == 2 && IrUtilsKt.isTrueConst(expression2.getBranches().get(0).getResult()) && IrUtilsKt.isTrueConst(expression2.getBranches().get(1).getCondition());
                if (_Assertions.ENABLED && !bl) {
                    boolean $i$a$-assert-JvmOptimizationLowering$Transformer$visitWhen$52 = false;
                    String $i$a$-assert-JvmOptimizationLowering$Transformer$visitWhen$52 = "OROR condition should have an 'if a then true' body on its first branch, and an 'if true then b' body on its second branch. Failing expression: " + DumpIrTreeKt.dump$default(expression2, false, false, 3, null);
                    throw new AssertionError((Object)$i$a$-assert-JvmOptimizationLowering$Transformer$visitWhen$52);
                }
                IrCallImpl $this$visitWhen_u24lambda_u2d8 = irCallImpl = IrCallImpl.Companion.fromSymbolOwner$default(IrCallImpl.Companion, expression2.getStartOffset(), expression2.getEndOffset(), JvmOptimizationLowering.this.getContext().getIrBuiltIns().getBooleanType(), JvmOptimizationLowering.this.getContext().getIrBuiltIns().getOrorSymbol(), 0, 0, null, null, 240, null);
                boolean bl5 = false;
                $this$visitWhen_u24lambda_u2d8.putValueArgument(0, expression2.getBranches().get(0).getCondition());
                $this$visitWhen_u24lambda_u2d8.putValueArgument(1, expression2.getBranches().get(1).getResult());
                return irCallImpl;
            }
            if (expression2.getBranches().size() == 0) {
                return new IrBlockImpl(expression2.getStartOffset(), expression2.getEndOffset(), JvmOptimizationLowering.this.getContext().getIrBuiltIns().getUnitType(), null, 8, null);
            }
            IrBranch firstBranch = CollectionsKt.first(expression2.getBranches());
            if (IrUtilsKt.isTrueConst(firstBranch.getCondition()) && isCompilerGenerated) {
                return firstBranch.getResult();
            }
            return expression2;
        }

        private final IrExpression getInlineableValueForTemporaryVal(IrStatement statement2) {
            IrVariable irVariable2 = statement2 instanceof IrVariable ? (IrVariable)statement2 : null;
            if (irVariable2 == null) {
                return null;
            }
            IrVariable variable2 = irVariable2;
            if (!Intrinsics.areEqual(variable2.getOrigin(), IrDeclarationOrigin.IR_TEMPORARY_VARIABLE.INSTANCE) || variable2.isVar()) {
                return null;
            }
            if (this.dontTouchTemporaryVals.contains(variable2)) {
                return null;
            }
            IrExpression initializer2 = variable2.getInitializer();
            if (initializer2 instanceof IrConst) {
                return initializer2;
            }
            if (initializer2 instanceof IrGetValue) {
                IrValueDeclaration initializerValue2 = ((IrGetValue)initializer2).getSymbol().getOwner();
                if (initializerValue2 instanceof IrVariable) {
                    IrExpression irExpression;
                    if (((IrVariable)initializerValue2).isVar()) {
                        irExpression = null;
                    } else if (Intrinsics.areEqual(initializerValue2.getOrigin(), IrDeclarationOrigin.IR_TEMPORARY_VARIABLE.INSTANCE)) {
                        irExpression = this.getInlineableValueForTemporaryVal(initializerValue2);
                        if (irExpression == null) {
                            irExpression = initializer2;
                        }
                    } else {
                        irExpression = initializer2;
                    }
                    return irExpression;
                }
                if (initializerValue2 instanceof IrValueParameter) {
                    return initializerValue2.isAssignable() ? null : initializer2;
                }
            }
            return null;
        }

        private final void removeUnnecessaryTemporaryVariables(List<IrStatement> statements2) {
            block2: {
                statements2.removeIf(arg_0 -> Transformer.removeUnnecessaryTemporaryVariables$lambda-9(this, arg_0));
                if (statements2.size() != 2) break block2;
                IrStatement first = statements2.get(0);
                IrStatement second = statements2.get(1);
                if (first instanceof IrVariable && Intrinsics.areEqual(((IrVariable)first).getOrigin(), IrDeclarationOrigin.IR_TEMPORARY_VARIABLE.INSTANCE) && second instanceof IrGetValue && Intrinsics.areEqual(((IrVariable)first).getSymbol(), ((IrGetValue)second).getSymbol())) {
                    statements2.clear();
                    IrExpression irExpression = ((IrVariable)first).getInitializer();
                    if (irExpression != null) {
                        IrExpression it = irExpression;
                        boolean bl = false;
                        statements2.add(it);
                    }
                }
            }
        }

        @Override
        @NotNull
        public IrBody visitBlockBody(@NotNull IrBlockBody body2, @Nullable IrDeclaration data2) {
            Intrinsics.checkNotNullParameter(body2, "body");
            body2.transformChildren(this, data2);
            this.removeUnnecessaryTemporaryVariables(body2.getStatements());
            return body2;
        }

        @Override
        @NotNull
        public IrExpression visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable IrDeclaration data2) {
            IrCall irCall;
            IrStatement subject;
            Intrinsics.checkNotNullParameter(expression2, "expression");
            if (Intrinsics.areEqual(expression2.getOrigin(), IrStatementOrigin.WHEN.INSTANCE) && (subject = CollectionsKt.firstOrNull(expression2.getStatements())) instanceof IrVariable && ((IrVariable)subject).getInitializer() instanceof IrGetValue) {
                this.dontTouchTemporaryVals.add((IrVariable)subject);
            }
            if ((Intrinsics.areEqual(expression2.getOrigin(), IrStatementOrigin.POSTFIX_DECR.INSTANCE) || Intrinsics.areEqual(expression2.getOrigin(), IrStatementOrigin.POSTFIX_INCR.INSTANCE)) && (irCall = this.rewritePostfixIncrDecr(expression2)) != null) {
                IrCall it = irCall;
                boolean bl = false;
                return it;
            }
            if (Intrinsics.areEqual(expression2.getOrigin(), IrStatementOrigin.FOR_LOOP.INSTANCE)) {
                this.reuseLoopVariableAsInductionVariableIfPossible(expression2);
            }
            expression2.transformChildren(this, data2);
            this.removeUnnecessaryTemporaryVariables(expression2.getStatements());
            return expression2;
        }

        /*
         * WARNING - void declaration
         */
        private final void reuseLoopVariableAsInductionVariableIfPossible(IrContainerExpression irForLoopBlock) {
            int inductionVariableIndex;
            IrStatement it;
            IrComposite loopInitialization;
            block13: {
                int n;
                void $this$indexOfFirst$iv;
                if (irForLoopBlock.getStatements().size() != 2) {
                    return;
                }
                Object object = irForLoopBlock.getStatements().get(0);
                IrComposite irComposite = object instanceof IrComposite ? (IrComposite)object : null;
                if (irComposite == null) {
                    return;
                }
                loopInitialization = irComposite;
                object = loopInitialization.getStatements();
                JvmOptimizationLowering jvmOptimizationLowering = JvmOptimizationLowering.this;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv) {
                    it = (IrStatement)item$iv;
                    boolean bl = false;
                    if (HeaderProcessorKt.isInductionVariable(it, jvmOptimizationLowering.getContext())) {
                        n = index$iv;
                        break block13;
                    }
                    ++index$iv;
                }
                n = inductionVariableIndex = -1;
            }
            if (inductionVariableIndex < 0) {
                return;
            }
            IrStatement $i$f$indexOfFirst = loopInitialization.getStatements().get(inductionVariableIndex);
            IrVariable irVariable2 = $i$f$indexOfFirst instanceof IrVariable ? (IrVariable)$i$f$indexOfFirst : null;
            if (irVariable2 == null) {
                return;
            }
            IrVariable inductionVariable = irVariable2;
            Pair<IrContainerExpression, Integer> pair = this.findLoopVariablePosition(irForLoopBlock.getStatements().get(1));
            if (pair == null) {
                return;
            }
            Pair<IrContainerExpression, Integer> loopVariablePosition = pair;
            IrContainerExpression loopVariableContainer = loopVariablePosition.component1();
            int loopVariableIndex = ((Number)loopVariablePosition.component2()).intValue();
            it = loopVariableContainer.getStatements().get(loopVariableIndex);
            IrVariable irVariable3 = it instanceof IrVariable ? (IrVariable)it : null;
            if (irVariable3 == null) {
                return;
            }
            IrVariable loopVariable = irVariable3;
            IrExpression irExpression = loopVariable.getInitializer();
            if (irExpression == null) {
                return;
            }
            IrExpression loopVariableInitializer = irExpression;
            if (!(loopVariableInitializer instanceof IrGetValue)) {
                return;
            }
            if (!Intrinsics.areEqual(((IrGetValue)loopVariableInitializer).getSymbol(), inductionVariable.getSymbol())) {
                return;
            }
            IrType inductionVariableType = inductionVariable.getType();
            IrType loopVariableType = loopVariable.getType();
            if (IrTypeUtilsKt.isNullable(loopVariableType)) {
                return;
            }
            if (!Intrinsics.areEqual(IrTypesKt.getClassifierOrNull(loopVariableType), IrTypesKt.getClassifierOrNull(inductionVariableType))) {
                return;
            }
            IrVariableImpl newLoopVariable = new IrVariableImpl(loopVariable.getStartOffset(), loopVariable.getEndOffset(), loopVariable.getOrigin(), new IrVariableSymbolImpl(null, 1, null), loopVariable.getName(), loopVariableType, true, false, false);
            newLoopVariable.setInitializer(inductionVariable.getInitializer());
            newLoopVariable.setParent(inductionVariable.getParent());
            loopInitialization.getStatements().set(inductionVariableIndex, newLoopVariable);
            loopVariableContainer.getStatements().remove(loopVariableIndex);
            AbstractVariableRemapper remapper2 = new AbstractVariableRemapper(inductionVariable, loopVariable, newLoopVariable){
                final /* synthetic */ IrVariable $inductionVariable;
                final /* synthetic */ IrVariable $loopVariable;
                final /* synthetic */ IrVariableImpl $newLoopVariable;
                {
                    this.$inductionVariable = $inductionVariable;
                    this.$loopVariable = $loopVariable;
                    this.$newLoopVariable = $newLoopVariable;
                }

                @Nullable
                protected IrValueDeclaration remapVariable(@NotNull IrValueDeclaration value2) {
                    Intrinsics.checkNotNullParameter(value2, "value");
                    return Intrinsics.areEqual(value2, this.$inductionVariable) || Intrinsics.areEqual(value2, this.$loopVariable) ? (IrValueDeclaration)this.$newLoopVariable : null;
                }
            };
            irForLoopBlock.getStatements().get(1).transformChildren(remapper2, null);
        }

        private final Pair<IrContainerExpression, Integer> findLoopVariablePosition(IrStatement statement2) {
            IrStatement irStatement = statement2;
            if (irStatement instanceof IrDoWhileLoop) {
                int loopVariableIndex;
                IrComposite iterationInitialization;
                block11: {
                    int n;
                    IrDoWhileLoop irDoWhileLoop = statement2 instanceof IrDoWhileLoop ? (IrDoWhileLoop)statement2 : null;
                    if (irDoWhileLoop == null) {
                        return null;
                    }
                    IrDoWhileLoop doWhileLoop = irDoWhileLoop;
                    if (!Intrinsics.areEqual(doWhileLoop.getOrigin(), JvmLoweredStatementOrigin.DO_WHILE_COUNTER_LOOP.INSTANCE)) {
                        return null;
                    }
                    IrExpression irExpression = doWhileLoop.getBody();
                    IrComposite irComposite = irExpression instanceof IrComposite ? (IrComposite)irExpression : null;
                    if (irComposite == null) {
                        return null;
                    }
                    IrComposite doWhileLoopBody = irComposite;
                    if (!Intrinsics.areEqual(doWhileLoopBody.getOrigin(), IrStatementOrigin.FOR_LOOP_INNER_WHILE.INSTANCE)) {
                        return null;
                    }
                    IrStatement irStatement2 = doWhileLoopBody.getStatements().get(0);
                    IrComposite irComposite2 = irStatement2 instanceof IrComposite ? (IrComposite)irStatement2 : null;
                    if (irComposite2 == null) {
                        return null;
                    }
                    iterationInitialization = irComposite2;
                    List<IrStatement> $this$indexOfFirst$iv = iterationInitialization.getStatements();
                    boolean $i$f$indexOfFirst = false;
                    int index$iv = 0;
                    Iterator<IrStatement> iterator2 = $this$indexOfFirst$iv.iterator();
                    while (iterator2.hasNext()) {
                        IrStatement item$iv;
                        IrStatement it = item$iv = iterator2.next();
                        boolean bl = false;
                        if (this.isLoopVariable(it)) {
                            n = index$iv;
                            break block11;
                        }
                        ++index$iv;
                    }
                    n = loopVariableIndex = -1;
                }
                if (loopVariableIndex < 0) {
                    return null;
                }
                return TuplesKt.to(iterationInitialization, loopVariableIndex);
            }
            if (irStatement instanceof IrWhen) {
                IrExpression irExpression = ((IrWhen)statement2).getBranches().get(0).getResult();
                IrDoWhileLoop irDoWhileLoop = irExpression instanceof IrDoWhileLoop ? (IrDoWhileLoop)irExpression : null;
                if (irDoWhileLoop == null) {
                    return null;
                }
                IrDoWhileLoop doWhileLoop = irDoWhileLoop;
                return this.findLoopVariablePosition(doWhileLoop);
            }
            return null;
        }

        private final boolean isLoopVariable(IrStatement $this$isLoopVariable) {
            return $this$isLoopVariable instanceof IrVariable && Intrinsics.areEqual(((IrVariable)$this$isLoopVariable).getOrigin(), IrDeclarationOrigin.FOR_LOOP_VARIABLE.INSTANCE);
        }

        private final IrCall rewritePostfixIncrDecr(IrContainerExpression $this$rewritePostfixIncrDecr) {
            IrStatementOrigin irStatementOrigin = $this$rewritePostfixIncrDecr.getOrigin();
            if (Intrinsics.areEqual(irStatementOrigin, IrStatementOrigin.POSTFIX_INCR.INSTANCE) ? true : Intrinsics.areEqual(irStatementOrigin, IrStatementOrigin.POSTFIX_DECR.INSTANCE)) {
                IrStatement irStatement = $this$rewritePostfixIncrDecr.getStatements().get(0);
                IrVariable irVariable2 = irStatement instanceof IrVariable ? (IrVariable)irStatement : null;
                if (irVariable2 == null) {
                    return null;
                }
                IrVariable tmpVar = irVariable2;
                IrExpression irExpression = tmpVar.getInitializer();
                IrGetValue irGetValue = irExpression instanceof IrGetValue ? (IrGetValue)irExpression : null;
                if (irGetValue == null) {
                    return null;
                }
                IrGetValue getIncrVar = irGetValue;
                if (!IrTypePredicatesKt.isInt(getIncrVar.getType())) {
                    return null;
                }
                IrStatement irStatement2 = $this$rewritePostfixIncrDecr.getStatements().get(1);
                IrSetValue irSetValue = irStatement2 instanceof IrSetValue ? (IrSetValue)irStatement2 : null;
                if (irSetValue == null) {
                    return null;
                }
                IrSetValue setVar = irSetValue;
                if (!Intrinsics.areEqual(setVar.getSymbol(), getIncrVar.getSymbol())) {
                    return null;
                }
                IrExpression irExpression2 = setVar.getValue();
                IrCall irCall = irExpression2 instanceof IrCall ? (IrCall)irExpression2 : null;
                if (irCall == null) {
                    return null;
                }
                IrCall setVarValue = irCall;
                Name calleeName = ((IrSimpleFunction)setVarValue.getSymbol().getOwner()).getName();
                if (!Intrinsics.areEqual(calleeName, OperatorNameConventions.INC) && !Intrinsics.areEqual(calleeName, OperatorNameConventions.DEC)) {
                    return null;
                }
                IrExpression irExpression3 = setVarValue.getDispatchReceiver();
                IrGetValue irGetValue2 = irExpression3 instanceof IrGetValue ? (IrGetValue)irExpression3 : null;
                if (irGetValue2 == null) {
                    return null;
                }
                IrGetValue calleeArg = irGetValue2;
                if (!Intrinsics.areEqual(calleeArg.getSymbol(), tmpVar.getSymbol())) {
                    return null;
                }
                IrStatement irStatement3 = $this$rewritePostfixIncrDecr.getStatements().get(2);
                IrGetValue irGetValue3 = irStatement3 instanceof IrGetValue ? (IrGetValue)irStatement3 : null;
                if (irGetValue3 == null) {
                    return null;
                }
                IrGetValue getTmpVar = irGetValue3;
                if (!Intrinsics.areEqual(getTmpVar.getSymbol(), tmpVar.getSymbol())) {
                    return null;
                }
                IrSimpleFunctionSymbol intrinsicSymbol = Intrinsics.areEqual(calleeName, OperatorNameConventions.INC) ? JvmOptimizationLowering.this.getContext().getIr().getSymbols().getIntPostfixIncr() : JvmOptimizationLowering.this.getContext().getIr().getSymbols().getIntPostfixDecr();
                IrStatement $this$rewritePostfixIncrDecr_u24lambda_u2d14 = irStatement3 = IrCallImpl.Companion.fromSymbolOwner($this$rewritePostfixIncrDecr.getStartOffset(), $this$rewritePostfixIncrDecr.getEndOffset(), intrinsicSymbol);
                boolean bl = false;
                ((IrFunctionAccessExpression)$this$rewritePostfixIncrDecr_u24lambda_u2d14).putValueArgument(0, getIncrVar);
                return (IrCall)irStatement3;
            }
            return null;
        }

        @Override
        @NotNull
        public IrExpression visitGetValue(@NotNull IrGetValue expression2, @Nullable IrDeclaration data2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrValueDeclaration variable2 = expression2.getSymbol().getOwner();
            IrExpression replacement = this.getInlineableValueForTemporaryVal(variable2);
            return replacement instanceof IrConst ? (IrExpression)((IrConst)replacement).copyWithOffsets(expression2.getStartOffset(), expression2.getEndOffset()) : (replacement instanceof IrGetValue ? (IrExpression)((IrGetValue)replacement).copyWithOffsets(expression2.getStartOffset(), expression2.getEndOffset()) : (IrExpression)expression2);
        }

        @Override
        @NotNull
        public IrStatement visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitAnonymousInitializer(this, declaration2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitBlock(@NotNull IrBlock expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitBlock(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrBody visitBody(@NotNull IrBody body2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitBody(this, body2, data2);
        }

        @Override
        @NotNull
        public IrBranch visitBranch(@NotNull IrBranch branch, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitBranch(this, branch, data2);
        }

        @Override
        @NotNull
        public IrExpression visitBreak(@NotNull IrBreak jump, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitBreak(this, jump, data2);
        }

        @Override
        @NotNull
        public IrExpression visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitBreakContinue(this, jump, data2);
        }

        @Override
        @NotNull
        public IrElement visitCallableReference(@NotNull IrCallableReference<?> expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitCallableReference(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrCatch visitCatch(@NotNull IrCatch aCatch, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitCatch(this, aCatch, data2);
        }

        @Override
        @NotNull
        public IrStatement visitClass(@NotNull IrClass declaration2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitClass(this, declaration2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitClassReference(@NotNull IrClassReference expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitClassReference(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitComposite(@NotNull IrComposite expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitComposite(this, expression2, data2);
        }

        @Override
        @NotNull
        public <T> IrExpression visitConst(@NotNull IrConst<T> expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitConst(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrConstantValue visitConstantArray(@NotNull IrConstantArray expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitConstantArray(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrConstantValue visitConstantObject(@NotNull IrConstantObject expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitConstantObject(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrConstantValue visitConstantPrimitive(@NotNull IrConstantPrimitive expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitConstantPrimitive(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrConstantValue visitConstantValue(@NotNull IrConstantValue expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitConstantValue(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrStatement visitConstructor(@NotNull IrConstructor declaration2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitConstructor(this, declaration2, data2);
        }

        @Override
        @NotNull
        public IrElement visitConstructorCall(@NotNull IrConstructorCall expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitConstructorCall(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitContinue(@NotNull IrContinue jump, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitContinue(this, jump, data2);
        }

        @Override
        @NotNull
        public IrExpression visitDeclarationReference(@NotNull IrDeclarationReference expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitDeclarationReference(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrElement visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitDoWhileLoop(this, loop2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitDynamicExpression(@NotNull IrDynamicExpression expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitDynamicExpression(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitDynamicMemberExpression(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrElement visitElement(@NotNull IrElement element, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitElement(this, element, data2);
        }

        @Override
        @NotNull
        public IrElseBranch visitElseBranch(@NotNull IrElseBranch branch, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitElseBranch(this, branch, data2);
        }

        @Override
        @NotNull
        public IrElement visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitEnumConstructorCall(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrStatement visitEnumEntry(@NotNull IrEnumEntry declaration2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitEnumEntry(this, declaration2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitErrorCallExpression(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrStatement visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitErrorDeclaration(this, declaration2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitErrorExpression(@NotNull IrErrorExpression expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitErrorExpression(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitExpression(@NotNull IrExpression expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitExpression(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrBody visitExpressionBody(@NotNull IrExpressionBody body2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitExpressionBody(this, body2, data2);
        }

        @Override
        @NotNull
        public IrExternalPackageFragment visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitExternalPackageFragment(this, declaration2, data2);
        }

        @Override
        @NotNull
        public IrStatement visitField(@NotNull IrField declaration2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitField(this, declaration2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitFieldAccess(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrFile visitFile(@NotNull IrFile declaration2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitFile(this, declaration2, data2);
        }

        @Override
        @NotNull
        public IrStatement visitFunction(@NotNull IrFunction declaration2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitFunction(this, declaration2, data2);
        }

        @Override
        @NotNull
        public IrElement visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitFunctionAccess(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrElement visitFunctionExpression(@NotNull IrFunctionExpression expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitFunctionExpression(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrElement visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitFunctionReference(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitGetClass(@NotNull IrGetClass expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitGetClass(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitGetEnumValue(@NotNull IrGetEnumValue expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitGetEnumValue(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitGetField(@NotNull IrGetField expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitGetField(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitGetObjectValue(@NotNull IrGetObjectValue expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitGetObjectValue(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitInstanceInitializerCall(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrStatement visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitLocalDelegatedProperty(this, declaration2, data2);
        }

        @Override
        @NotNull
        public IrElement visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitLoop(@NotNull IrLoop loop2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitLoop(this, loop2, data2);
        }

        @Override
        @NotNull
        public IrElement visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitMemberAccess(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrModuleFragment visitModuleFragment(@NotNull IrModuleFragment declaration2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitModuleFragment(this, declaration2, data2);
        }

        @Override
        @NotNull
        public IrElement visitPackageFragment(@NotNull IrPackageFragment declaration2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitPackageFragment(this, declaration2, data2);
        }

        @Override
        @NotNull
        public IrStatement visitProperty(@NotNull IrProperty declaration2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitProperty(this, declaration2, data2);
        }

        @Override
        @NotNull
        public IrElement visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitPropertyReference(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitRawFunctionReference(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitReturn(@NotNull IrReturn expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitReturn(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrStatement visitScript(@NotNull IrScript declaration2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitScript(this, declaration2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitSetField(@NotNull IrSetField expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitSetField(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitSetValue(@NotNull IrSetValue expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitSetValue(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrStatement visitSimpleFunction(@NotNull IrSimpleFunction declaration2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitSimpleFunction(this, declaration2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitSingletonReference(@NotNull IrGetSingletonValue expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitSingletonReference(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrSpreadElement visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitSpreadElement(this, spread, data2);
        }

        @Override
        @NotNull
        public IrExpression visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitStringConcatenation(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitSuspendableExpression(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitSuspensionPoint(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrBody visitSyntheticBody(@NotNull IrSyntheticBody body2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitSyntheticBody(this, body2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitThrow(@NotNull IrThrow expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitThrow(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitTry(@NotNull IrTry aTry, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitTry(this, aTry, data2);
        }

        @Override
        @NotNull
        public IrStatement visitTypeAlias(@NotNull IrTypeAlias declaration2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitTypeAlias(this, declaration2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitTypeOperator(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrStatement visitTypeParameter(@NotNull IrTypeParameter declaration2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitTypeParameter(this, declaration2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitValueAccess(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrStatement visitValueParameter(@NotNull IrValueParameter declaration2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitValueParameter(this, declaration2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitVararg(@NotNull IrVararg expression2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitVararg(this, expression2, data2);
        }

        @Override
        @NotNull
        public IrStatement visitVariable(@NotNull IrVariable declaration2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitVariable(this, declaration2, data2);
        }

        @Override
        @NotNull
        public IrExpression visitWhileLoop(@NotNull IrWhileLoop loop2, @Nullable IrDeclaration data2) {
            return IrElementTransformer.DefaultImpls.visitWhileLoop(this, loop2, data2);
        }

        private static final boolean visitWhen$lambda-4(boolean $isCompilerGenerated, IrBranch it) {
            Intrinsics.checkNotNullParameter(it, "it");
            return IrUtilsKt.isFalseConst(it.getCondition()) && $isCompilerGenerated;
        }

        private static final boolean removeUnnecessaryTemporaryVariables$lambda-9(Transformer this$0, IrStatement it) {
            Intrinsics.checkNotNullParameter(this$0, "this$0");
            Intrinsics.checkNotNullParameter(it, "it");
            return this$0.getInlineableValueForTemporaryVal(it) != null;
        }
    }
}

