/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.ir2wasm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.BodyGenerator;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ClassInfoKt;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ClassMetadata;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ConstantDataElement;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ConstantDataIntArray;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ConstantDataIntField;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ConstantDataStruct;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.DeclarationGeneratorKt;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.InterfaceImplementation;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.InterfaceMetadata;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.VirtualMethodMetadata;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmFunctionCodegenContextImpl;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmModuleCodegenContext;
import org.jetbrains.kotlin.backend.wasm.lower.WasmBridgesConstructionKt;
import org.jetbrains.kotlin.backend.wasm.utils.AnnotationsKt;
import org.jetbrains.kotlin.backend.wasm.utils.WasmArrayInfo;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrResolveUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.MiscKt;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoidKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.wasm.ir.WasmArrayDeclaration;
import org.jetbrains.kotlin.wasm.ir.WasmExport;
import org.jetbrains.kotlin.wasm.ir.WasmExpressionBuilder;
import org.jetbrains.kotlin.wasm.ir.WasmFunction;
import org.jetbrains.kotlin.wasm.ir.WasmFunctionType;
import org.jetbrains.kotlin.wasm.ir.WasmGlobal;
import org.jetbrains.kotlin.wasm.ir.WasmHeapType;
import org.jetbrains.kotlin.wasm.ir.WasmImmediate;
import org.jetbrains.kotlin.wasm.ir.WasmImportPair;
import org.jetbrains.kotlin.wasm.ir.WasmIrExpressionBuilder;
import org.jetbrains.kotlin.wasm.ir.WasmOp;
import org.jetbrains.kotlin.wasm.ir.WasmRefNullType;
import org.jetbrains.kotlin.wasm.ir.WasmRtt;
import org.jetbrains.kotlin.wasm.ir.WasmStructDeclaration;
import org.jetbrains.kotlin.wasm.ir.WasmStructFieldDeclaration;
import org.jetbrains.kotlin.wasm.ir.WasmSymbol;
import org.jetbrains.kotlin.wasm.ir.WasmSymbolReadOnly;
import org.jetbrains.kotlin.wasm.ir.WasmTable;
import org.jetbrains.kotlin.wasm.ir.WasmType;
import org.jetbrains.kotlin.wasm.ir.WasmTypeDeclaration;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010#\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020&H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000e\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/DeclarationGenerator;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementVisitorVoid;", "context", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmModuleCodegenContext;", "(Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmModuleCodegenContext;)V", "backendContext", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "getContext", "()Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmModuleCodegenContext;", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "unitGetInstanceFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "getUnitGetInstanceFunction", "()Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "unitGetInstanceFunction$delegate", "Lkotlin/Lazy;", "binaryDataStruct", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/ConstantDataStruct;", "classMetadata", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/ClassMetadata;", "interfaceTable", "jsCodeName", "", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "visitClass", "", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "visitElement", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "visitField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "visitFunction", "visitProperty", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "visitTypeAlias", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeAlias;", "backend.wasm"})
public final class DeclarationGenerator
implements IrElementVisitorVoid {
    @NotNull
    private final WasmModuleCodegenContext context;
    @NotNull
    private final WasmBackendContext backendContext;
    @NotNull
    private final IrBuiltIns irBuiltIns;
    @NotNull
    private final Lazy unitGetInstanceFunction$delegate;

    public DeclarationGenerator(@NotNull WasmModuleCodegenContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
        this.backendContext = this.context.getBackendContext();
        this.irBuiltIns = this.backendContext.getIrBuiltIns();
        this.unitGetInstanceFunction$delegate = LazyKt.lazy((Function0)new Function0<IrSimpleFunction>(this){
            final /* synthetic */ DeclarationGenerator this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final IrSimpleFunction invoke() {
                return MiscKt.findUnitGetInstanceFunction(DeclarationGenerator.access$getBackendContext$p(this.this$0));
            }
        });
    }

    @NotNull
    public final WasmModuleCodegenContext getContext() {
        return this.context;
    }

    private final IrSimpleFunction getUnitGetInstanceFunction() {
        Lazy lazy = this.unitGetInstanceFunction$delegate;
        return (IrSimpleFunction)lazy.getValue();
    }

    @Override
    public void visitElement(@NotNull IrElement element) {
        Intrinsics.checkNotNullParameter(element, "element");
        throw new IllegalStateException(("Unexpected element of type " + Reflection.getOrCreateKotlinClass(element.getClass())).toString());
    }

    @Override
    public void visitProperty(@NotNull IrProperty declaration2) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        if (!declaration2.isExternal()) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
    }

    @Override
    public void visitTypeAlias(@NotNull IrTypeAlias declaration2) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
    }

    private final String jsCodeName(IrFunction declaration2) {
        StringBuilder stringBuilder2 = new StringBuilder();
        FqName fqName2 = IrUtilsKt.getFqNameWhenAvailable(declaration2);
        Intrinsics.checkNotNull(fqName2);
        return stringBuilder2.append(fqName2.asString()).append('_').append(WasmBridgesConstructionKt.wasmSignature((IrSimpleFunction)declaration2, this.irBuiltIns).hashCode()).toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitFunction(@NotNull IrFunction declaration2) {
        String initPriority;
        Iterator<IrValueParameter> $this$mapTo$iv$iv;
        void $this$map$iv22;
        WasmImportPair importedName;
        WasmImportPair wasmImportPair;
        String jsCode2;
        boolean isIntrinsic;
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        if (declaration2 instanceof IrConstructor && this.backendContext.getInlineClassesUtils().isClassInlineLike(IrUtilsKt.getParentAsClass(declaration2))) {
            return;
        }
        boolean bl = isIntrinsic = AnnotationsKt.hasWasmNoOpCastAnnotation(declaration2) || AnnotationsKt.getWasmOpAnnotation(declaration2) != null;
        if (isIntrinsic) {
            return;
        }
        String string2 = AnnotationsKt.getJsFunAnnotation(declaration2);
        if (string2 == null) {
            string2 = declaration2.isExternal() ? declaration2.getName().asString() : null;
        }
        if ((jsCode2 = string2) != null) {
            String jsCodeName = this.jsCodeName(declaration2);
            this.context.addJsFun(jsCodeName, jsCode2);
            wasmImportPair = new WasmImportPair("js_code", this.jsCodeName(declaration2));
        } else {
            wasmImportPair = importedName = AnnotationsKt.getWasmImportAnnotation(declaration2);
        }
        if (IrFakeOverrideUtilsKt.isFakeOverride(declaration2)) {
            return;
        }
        String watName = String.valueOf(IrUtilsKt.getFqNameWhenAvailable(declaration2));
        List<IrValueParameter> irParameters = DeclarationGeneratorKt.getEffectiveValueParameters(declaration2);
        WasmType resultType = Intrinsics.areEqual(declaration2, this.getUnitGetInstanceFunction()) ? this.context.transformType(declaration2.getReturnType()) : this.context.transformResultType(declaration2.getReturnType());
        Iterable iterable = irParameters;
        String string3 = watName;
        boolean $i$f$map = false;
        void var11_15 = $this$map$iv22;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv22, 10));
        boolean $i$f$mapTo = false;
        Object object = $this$mapTo$iv$iv.iterator();
        while (object.hasNext()) {
            void it;
            Object item$iv$iv = object.next();
            IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(this.context.transformValueParameterType((IrValueParameter)it));
        }
        List<WasmType> list2 = CollectionsKt.listOfNotNull(resultType);
        List list3 = (List)destination$iv$iv;
        String string4 = string3;
        WasmFunctionType wasmFunctionType = new WasmFunctionType(string4, list3, list2);
        this.context.defineFunctionType(declaration2.getSymbol(), wasmFunctionType);
        if (declaration2 instanceof IrSimpleFunction) {
            if (((IrSimpleFunction)declaration2).getModality() == Modality.ABSTRACT) {
                return;
            }
            if (org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.isOverridableOrOverrides((IrSimpleFunction)declaration2)) {
                this.context.registerVirtualFunction(((IrSimpleFunction)declaration2).getSymbol());
            }
        }
        boolean $this$map$iv22 = Intrinsics.areEqual(declaration2, IrResolveUtilsKt.getRealOverrideTarget(declaration2));
        if (_Assertions.ENABLED && !$this$map$iv22) {
            boolean $i$a$-assert-DeclarationGenerator$visitFunction$22 = false;
            String $i$a$-assert-DeclarationGenerator$visitFunction$22 = "Sanity check that " + declaration2 + " is a real function that can be used in calls";
            throw new AssertionError((Object)$i$a$-assert-DeclarationGenerator$visitFunction$22);
        }
        if (importedName != null) {
            this.context.defineFunction(declaration2.getSymbol(), new WasmFunction.Imported(watName, wasmFunctionType, importedName));
            return;
        }
        WasmFunction.Defined function2 = new WasmFunction.Defined(watName, wasmFunctionType, null, null, 12, null);
        WasmFunctionCodegenContextImpl functionCodegenContext = new WasmFunctionCodegenContextImpl(declaration2, function2, this.backendContext, this.context);
        for (IrValueParameter irParameter2 : irParameters) {
            functionCodegenContext.defineLocal(irParameter2.getSymbol());
        }
        WasmExpressionBuilder exprGen = functionCodegenContext.getBodyGen();
        BodyGenerator bodyBuilder = new BodyGenerator(functionCodegenContext);
        if (!(declaration2.getBody() instanceof IrBlockBody)) {
            boolean bl3 = false;
            String string5 = "Only IrBlockBody is supported";
            throw new IllegalArgumentException(string5.toString());
        }
        IrBody irBody = declaration2.getBody();
        if (irBody != null) {
            IrElementVisitorVoidKt.acceptVoid(irBody, bodyBuilder);
        }
        if (declaration2 instanceof IrConstructor) {
            exprGen.buildGetLocal(function2.getLocals().get(0));
            exprGen.buildInstr(WasmOp.RETURN, new WasmImmediate[0]);
        }
        if (!((Collection)wasmFunctionType.getResultTypes()).isEmpty()) {
            exprGen.buildUnreachable();
        }
        this.context.defineFunction(declaration2.getSymbol(), function2);
        object = declaration2;
        String string6 = Intrinsics.areEqual(object, this.backendContext.getFieldInitFunction()) ? "0" : (initPriority = Intrinsics.areEqual(object, this.backendContext.getMainCallsWrapperFunction()) ? "1" : null);
        if (initPriority != null) {
            this.context.registerInitFunction(function2, initPriority);
        }
        if (DeclarationGeneratorKt.isExported(declaration2)) {
            object = AnnotationUtilsKt.getJsNameOrKotlinName(declaration2).getIdentifier();
            Intrinsics.checkNotNullExpressionValue(object, "identifier");
            this.context.addExport(new WasmExport.Function((String)object, function2));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitClass(@NotNull IrClass declaration2) {
        WasmTable table;
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        if (IrUtilsKt.isAnnotationClass(declaration2)) {
            return;
        }
        if (declaration2.isExternal()) {
            return;
        }
        IrClassSymbol symbol2 = declaration2.getSymbol();
        WasmArrayInfo wasmArrayInfo = AnnotationsKt.getWasmArrayAnnotation(declaration2);
        if (wasmArrayInfo != null) {
            WasmArrayInfo wasmArrayAnnotation = wasmArrayInfo;
            boolean bl = false;
            String nameStr = String.valueOf(IrUtilsKt.getFqNameWhenAvailable(declaration2));
            WasmArrayDeclaration wasmArrayDeclaration = new WasmArrayDeclaration(nameStr, new WasmStructFieldDeclaration("field", this.context.transformFieldType(wasmArrayAnnotation.getType()), true));
            this.context.defineGcType(symbol2, wasmArrayDeclaration);
            return;
        }
        if (IrUtilsKt.isInterface(declaration2)) {
            InterfaceMetadata metadata2 = new InterfaceMetadata(declaration2, this.irBuiltIns);
            for (VirtualMethodMetadata method : metadata2.getMethods()) {
                IrSimpleFunctionSymbol methodSymbol = method.getFunction().getSymbol();
                table = new WasmTable(null, new WasmRefNullType(new WasmHeapType.Type((WasmSymbolReadOnly<? extends WasmTypeDeclaration>)this.context.referenceFunctionType(methodSymbol))), null, 5, null);
                this.context.defineInterfaceMethodTable(methodSymbol, table);
            }
            this.context.registerInterface(symbol2);
        } else {
            ClassMetadata metadata3;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            String nameStr = String.valueOf(IrUtilsKt.getFqNameWhenAvailable(declaration2));
            Iterable method = ClassInfoKt.allFields(declaration2, this.irBuiltIns);
            String string2 = nameStr;
            boolean $i$f$map = false;
            table = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IrField irField = (IrField)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string3 = it.getName().toString();
                Intrinsics.checkNotNullExpressionValue(string3, "it.name.toString()");
                collection.add(new WasmStructFieldDeclaration(string3, this.context.transformFieldType(it.getType()), true));
            }
            List list2 = (List)destination$iv$iv;
            String string4 = string2;
            WasmStructDeclaration structType = new WasmStructDeclaration(string4, list2);
            this.context.defineGcType(symbol2, structType);
            int depth = 0;
            ClassMetadata subMetadata = metadata3 = this.context.getClassMetadata(symbol2);
            while (subMetadata.getSuperClass() != null) {
                ++depth;
            }
            List initBody = new ArrayList();
            WasmIrExpressionBuilder wasmExpressionGenerator = new WasmIrExpressionBuilder(initBody);
            WasmSymbol<WasmTypeDeclaration> wasmGcType = this.context.referenceGcType(symbol2);
            ClassMetadata superClass = metadata3.getSuperClass();
            if (superClass != null) {
                WasmSymbol<WasmGlobal> superRTT = this.context.referenceClassRTT(superClass.getKlass().getSymbol());
                wasmExpressionGenerator.buildGetGlobal(superRTT);
                wasmExpressionGenerator.buildRttSub(wasmGcType);
            } else {
                wasmExpressionGenerator.buildRttCanon(wasmGcType);
            }
            String string5 = "rtt_of_" + nameStr;
            WasmRtt wasmRtt = new WasmRtt(depth, (WasmSymbolReadOnly<? extends WasmTypeDeclaration>)new WasmSymbol<WasmStructDeclaration>(structType));
            WasmGlobal rtt = new WasmGlobal(string5, wasmRtt, false, initBody, null, 16, null);
            this.context.defineRTT(symbol2, rtt);
            this.context.registerClass(symbol2);
            this.context.generateTypeInfo(symbol2, this.binaryDataStruct(metadata3));
            if (declaration2.getModality() != Modality.ABSTRACT) {
                this.context.generateInterfaceTable(symbol2, this.interfaceTable(metadata3));
                for (IrClass i : metadata3.getInterfaces()) {
                    void $this$associateTo$iv$iv;
                    InterfaceImplementation interfaceImplementation = new InterfaceImplementation(i.getSymbol(), declaration2.getSymbol());
                    InterfaceMetadata interfaceMetadata = new InterfaceMetadata(i, this.irBuiltIns);
                    Iterable $this$associate$iv = interfaceMetadata.getMethods();
                    boolean $i$f$associate = false;
                    int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
                    Iterable iterable = $this$associate$iv;
                    Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
                    boolean $i$f$associateTo = false;
                    for (Object element$iv$iv : $this$associateTo$iv$iv) {
                        VirtualMethodMetadata classMethod;
                        Object v1;
                        VirtualMethodMetadata method2;
                        Map map;
                        block16: {
                            map = destination$iv$iv2;
                            method2 = (VirtualMethodMetadata)element$iv$iv;
                            boolean bl = false;
                            Iterable iterable2 = metadata3.getVirtualMethods();
                            for (Object t : iterable2) {
                                VirtualMethodMetadata it = (VirtualMethodMetadata)t;
                                boolean bl2 = false;
                                if (!Intrinsics.areEqual(it.getSignature(), method2.getSignature())) continue;
                                v1 = t;
                                break block16;
                            }
                            v1 = null;
                        }
                        if ((VirtualMethodMetadata)v1 == null) {
                            throw new IllegalStateException(("Cannot find class implementation of method " + method2.getSignature() + " in class " + IrUtilsKt.getFqNameWhenAvailable(declaration2)).toString());
                        }
                        Pair<IrFunctionSymbol, WasmSymbol<WasmFunction>> pair = TuplesKt.to((IrFunctionSymbol)method2.getFunction().getSymbol(), this.context.referenceFunction(classMethod.getFunction().getSymbol()));
                        map.put(pair.getFirst(), pair.getSecond());
                    }
                    Map table2 = destination$iv$iv2;
                    this.context.registerInterfaceImplementationMethod(interfaceImplementation, table2);
                }
            }
        }
        for (IrDeclaration member2 : declaration2.getDeclarations()) {
            IrElementVisitorVoidKt.acceptVoid(member2, this);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final ConstantDataStruct binaryDataStruct(ClassMetadata classMetadata) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        ConstantDataIntField constantDataIntField;
        Object it;
        IrClass superClass;
        Object object;
        int invalidIndex = -1;
        boolean fqnShouldBeEmitted = CommonConfigurationKeysKt.getLanguageVersionSettings(this.context.getBackendContext().getConfiguration()).getFlag(AnalysisFlags.getAllowFullyQualifiedNameInKClass());
        if (fqnShouldBeEmitted) {
            object = FqNamesUtilKt.parentOrNull(AdditionalIrUtilsKt.getKotlinFqName(classMetadata.getKlass()));
            if (object == null || (object = ((FqName)object).asString()) == null) {
                object = "";
            }
        } else {
            object = "";
        }
        String packageName = object;
        String string2 = AdditionalIrUtilsKt.getKotlinFqName(classMetadata.getKlass()).shortName().asString();
        Intrinsics.checkNotNullExpressionValue(string2, "classMetadata.klass.kotl\u2026me.shortName().asString()");
        String simpleName2 = string2;
        ConstantDataIntField[] constantDataIntFieldArray = new ConstantDataIntField[]{new ConstantDataIntField("TypePackageNameLength", packageName.length()), new ConstantDataIntField("TypePackageNamePtr", this.context.referenceStringLiteral(packageName)), new ConstantDataIntField("TypeNameLength", simpleName2.length()), new ConstantDataIntField("TypeNamePtr", this.context.referenceStringLiteral(simpleName2))};
        ConstantDataStruct typeInfo = new ConstantDataStruct("TypeInfo", CollectionsKt.listOf(constantDataIntFieldArray));
        IrClass irClass2 = superClass = ClassInfoKt.getSuperClass(classMetadata.getKlass(), this.context.getBackendContext().getIrBuiltIns());
        if (irClass2 != null) {
            it = irClass2;
            boolean bl = false;
            constantDataIntField = new ConstantDataIntField("SuperTypeId", this.context.referenceClassId(((IrClass)it).getSymbol()));
        } else {
            constantDataIntField = new ConstantDataIntField("SuperTypeId", -1);
        }
        ConstantDataIntField superTypeId = constantDataIntField;
        ConstantDataIntField vtableSizeField = new ConstantDataIntField("V-table length", classMetadata.getVirtualMethods().size());
        it = classMetadata.getVirtualMethods();
        String string3 = "V-table";
        boolean $i$f$map = false;
        void var13_14 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            VirtualMethodMetadata virtualMethodMetadata = (VirtualMethodMetadata)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it2.getFunction().getModality() == Modality.ABSTRACT ? new WasmSymbol<Integer>(invalidIndex) : this.context.referenceVirtualFunctionId(it2.getFunction().getSymbol()));
        }
        List list2 = (List)destination$iv$iv;
        String string4 = string3;
        ConstantDataIntArray vtableArray = new ConstantDataIntArray(string4, list2);
        ConstantDataIntField interfaceTablePtr = new ConstantDataIntField("interfaceTablePtr", this.context.referenceInterfaceTableAddress(classMetadata.getKlass().getSymbol()));
        ConstantDataElement[] constantDataElementArray = new ConstantDataElement[]{typeInfo, superTypeId, interfaceTablePtr, vtableSizeField, vtableArray};
        return new ConstantDataStruct("Class TypeInfo: " + IrUtilsKt.getFqNameWhenAvailable(classMetadata.getKlass()) + ' ', CollectionsKt.listOf(constantDataElementArray));
    }

    /*
     * WARNING - void declaration
     */
    private final ConstantDataStruct interfaceTable(ClassMetadata classMetadata) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        List<IrClass> interfaces = classMetadata.getInterfaces();
        ConstantDataIntField size = new ConstantDataIntField("size", interfaces.size());
        Iterable iterable = interfaces;
        String string2 = "interfaceIds";
        boolean $i$f$map22 = false;
        void var7_8 = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            IrClass irClass2 = (IrClass)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.context.referenceInterfaceId(it.getSymbol()));
        }
        List list2 = (List)destination$iv$iv;
        String string3 = string2;
        ConstantDataIntArray interfaceIds = new ConstantDataIntArray(string3, list2);
        Iterable $i$f$map22 = interfaces;
        string2 = "interfaceImplementationId";
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrClass bl = (IrClass)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(this.context.referenceInterfaceImplementationId(new InterfaceImplementation(it.getSymbol(), classMetadata.getKlass().getSymbol())));
        }
        List list3 = (List)destination$iv$iv2;
        String string4 = string2;
        ConstantDataIntArray interfaceImplementationIds = new ConstantDataIntArray(string4, list3);
        ConstantDataElement[] constantDataElementArray = new ConstantDataElement[]{size, interfaceIds, interfaceImplementationIds};
        return new ConstantDataStruct("Class interface table: " + IrUtilsKt.getFqNameWhenAvailable(classMetadata.getKlass()) + ' ', CollectionsKt.listOf(constantDataElementArray));
    }

    @Override
    public void visitField(@NotNull IrField declaration2) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        if (!declaration2.isStatic()) {
            return;
        }
        WasmType wasmType = this.context.transformType(declaration2.getType());
        List initBody = new ArrayList();
        WasmIrExpressionBuilder wasmExpressionGenerator = new WasmIrExpressionBuilder(initBody);
        DeclarationGeneratorKt.generateDefaultInitializerForType(wasmType, wasmExpressionGenerator);
        WasmGlobal global = new WasmGlobal(String.valueOf(IrUtilsKt.getFqNameWhenAvailable(declaration2)), wasmType, true, initBody, null, 16, null);
        this.context.defineGlobal(declaration2.getSymbol(), global);
    }

    @Override
    public void visitElement(@NotNull IrElement element, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitElement(this, element, data2);
    }

    @Override
    public void visitProperty(@NotNull IrProperty declaration2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration2, data2);
    }

    @Override
    public void visitTypeAlias(@NotNull IrTypeAlias declaration2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration2, data2);
    }

    @Override
    public void visitFunction(@NotNull IrFunction declaration2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration2, data2);
    }

    @Override
    public void visitClass(@NotNull IrClass declaration2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration2, data2);
    }

    @Override
    public void visitField(@NotNull IrField declaration2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitField(this, declaration2, data2);
    }

    @Override
    public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration2);
    }

    @Override
    public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration2, data2);
    }

    @Override
    public void visitBlock(@NotNull IrBlock expression2) {
        IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2);
    }

    @Override
    public void visitBlock(@NotNull IrBlock expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2, data2);
    }

    @Override
    public void visitBlockBody(@NotNull IrBlockBody body2) {
        IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2);
    }

    @Override
    public void visitBlockBody(@NotNull IrBlockBody body2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2, data2);
    }

    @Override
    public void visitBody(@NotNull IrBody body2) {
        IrElementVisitorVoid.DefaultImpls.visitBody(this, body2);
    }

    @Override
    public void visitBody(@NotNull IrBody body2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitBody(this, body2, data2);
    }

    @Override
    public void visitBranch(@NotNull IrBranch branch) {
        IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch);
    }

    @Override
    public void visitBranch(@NotNull IrBranch branch, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch, data2);
    }

    @Override
    public void visitBreak(@NotNull IrBreak jump) {
        IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump);
    }

    @Override
    public void visitBreak(@NotNull IrBreak jump, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump, data2);
    }

    @Override
    public void visitBreakContinue(@NotNull IrBreakContinue jump) {
        IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump);
    }

    @Override
    public void visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump, data2);
    }

    @Override
    public void visitCall(@NotNull IrCall expression2) {
        IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2);
    }

    @Override
    public void visitCall(@NotNull IrCall expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2, data2);
    }

    @Override
    public void visitCallableReference(@NotNull IrCallableReference<?> expression2) {
        IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2);
    }

    @Override
    public void visitCallableReference(@NotNull IrCallableReference<?> expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2, data2);
    }

    @Override
    public void visitCatch(@NotNull IrCatch aCatch) {
        IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch);
    }

    @Override
    public void visitCatch(@NotNull IrCatch aCatch, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch, data2);
    }

    @Override
    public void visitClassReference(@NotNull IrClassReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2);
    }

    @Override
    public void visitClassReference(@NotNull IrClassReference expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2, data2);
    }

    @Override
    public void visitComposite(@NotNull IrComposite expression2) {
        IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2);
    }

    @Override
    public void visitComposite(@NotNull IrComposite expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2, data2);
    }

    @Override
    public <T> void visitConst(@NotNull IrConst<T> expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2);
    }

    @Override
    public <T> void visitConst(@NotNull IrConst<T> expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2, data2);
    }

    @Override
    public void visitConstantArray(@NotNull IrConstantArray expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression2);
    }

    @Override
    public void visitConstantArray(@NotNull IrConstantArray expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression2, data2);
    }

    @Override
    public void visitConstantObject(@NotNull IrConstantObject expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression2);
    }

    @Override
    public void visitConstantObject(@NotNull IrConstantObject expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression2, data2);
    }

    @Override
    public void visitConstantPrimitive(@NotNull IrConstantPrimitive expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression2);
    }

    @Override
    public void visitConstantPrimitive(@NotNull IrConstantPrimitive expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression2, data2);
    }

    @Override
    public void visitConstantValue(@NotNull IrConstantValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression2);
    }

    @Override
    public void visitConstantValue(@NotNull IrConstantValue expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression2, data2);
    }

    @Override
    public void visitConstructor(@NotNull IrConstructor declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration2);
    }

    @Override
    public void visitConstructor(@NotNull IrConstructor declaration2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration2, data2);
    }

    @Override
    public void visitConstructorCall(@NotNull IrConstructorCall expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2);
    }

    @Override
    public void visitConstructorCall(@NotNull IrConstructorCall expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2, data2);
    }

    @Override
    public void visitContainerExpression(@NotNull IrContainerExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2);
    }

    @Override
    public void visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2, data2);
    }

    @Override
    public void visitContinue(@NotNull IrContinue jump) {
        IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump);
    }

    @Override
    public void visitContinue(@NotNull IrContinue jump, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump, data2);
    }

    @Override
    public void visitDeclaration(@NotNull IrDeclarationBase declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration2);
    }

    @Override
    public void visitDeclaration(@NotNull IrDeclarationBase declaration2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration2, data2);
    }

    @Override
    public void visitDeclarationReference(@NotNull IrDeclarationReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2);
    }

    @Override
    public void visitDeclarationReference(@NotNull IrDeclarationReference expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2, data2);
    }

    @Override
    public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
        IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2);
    }

    @Override
    public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data2);
    }

    @Override
    public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2) {
        IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2);
    }

    @Override
    public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2, data2);
    }

    @Override
    public void visitDynamicExpression(@NotNull IrDynamicExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2);
    }

    @Override
    public void visitDynamicExpression(@NotNull IrDynamicExpression expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2, data2);
    }

    @Override
    public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2);
    }

    @Override
    public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2, data2);
    }

    @Override
    public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2);
    }

    @Override
    public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data2);
    }

    @Override
    public void visitElseBranch(@NotNull IrElseBranch branch) {
        IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch);
    }

    @Override
    public void visitElseBranch(@NotNull IrElseBranch branch, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch, data2);
    }

    @Override
    public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
        IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2);
    }

    @Override
    public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2, data2);
    }

    @Override
    public void visitEnumEntry(@NotNull IrEnumEntry declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration2);
    }

    @Override
    public void visitEnumEntry(@NotNull IrEnumEntry declaration2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration2, data2);
    }

    @Override
    public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2);
    }

    @Override
    public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2, data2);
    }

    @Override
    public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration2);
    }

    @Override
    public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration2, data2);
    }

    @Override
    public void visitErrorExpression(@NotNull IrErrorExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2);
    }

    @Override
    public void visitErrorExpression(@NotNull IrErrorExpression expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2, data2);
    }

    @Override
    public void visitExpression(@NotNull IrExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2);
    }

    @Override
    public void visitExpression(@NotNull IrExpression expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2, data2);
    }

    @Override
    public void visitExpressionBody(@NotNull IrExpressionBody body2) {
        IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2);
    }

    @Override
    public void visitExpressionBody(@NotNull IrExpressionBody body2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2, data2);
    }

    @Override
    public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration2);
    }

    @Override
    public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration2, data2);
    }

    @Override
    public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2);
    }

    @Override
    public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2, data2);
    }

    @Override
    public void visitFile(@NotNull IrFile declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration2);
    }

    @Override
    public void visitFile(@NotNull IrFile declaration2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration2, data2);
    }

    @Override
    public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2);
    }

    @Override
    public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2, data2);
    }

    @Override
    public void visitFunctionExpression(@NotNull IrFunctionExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2);
    }

    @Override
    public void visitFunctionExpression(@NotNull IrFunctionExpression expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2, data2);
    }

    @Override
    public void visitFunctionReference(@NotNull IrFunctionReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2);
    }

    @Override
    public void visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2, data2);
    }

    @Override
    public void visitGetClass(@NotNull IrGetClass expression2) {
        IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2);
    }

    @Override
    public void visitGetClass(@NotNull IrGetClass expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2, data2);
    }

    @Override
    public void visitGetEnumValue(@NotNull IrGetEnumValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2);
    }

    @Override
    public void visitGetEnumValue(@NotNull IrGetEnumValue expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2, data2);
    }

    @Override
    public void visitGetField(@NotNull IrGetField expression2) {
        IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2);
    }

    @Override
    public void visitGetField(@NotNull IrGetField expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2, data2);
    }

    @Override
    public void visitGetObjectValue(@NotNull IrGetObjectValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2);
    }

    @Override
    public void visitGetObjectValue(@NotNull IrGetObjectValue expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2, data2);
    }

    @Override
    public void visitGetValue(@NotNull IrGetValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2);
    }

    @Override
    public void visitGetValue(@NotNull IrGetValue expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2, data2);
    }

    @Override
    public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2) {
        IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2);
    }

    @Override
    public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2, data2);
    }

    @Override
    public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration2);
    }

    @Override
    public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration2, data2);
    }

    @Override
    public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2);
    }

    @Override
    public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data2);
    }

    @Override
    public void visitLoop(@NotNull IrLoop loop2) {
        IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2);
    }

    @Override
    public void visitLoop(@NotNull IrLoop loop2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2, data2);
    }

    @Override
    public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2) {
        IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2);
    }

    @Override
    public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2, data2);
    }

    @Override
    public void visitModuleFragment(@NotNull IrModuleFragment declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration2);
    }

    @Override
    public void visitModuleFragment(@NotNull IrModuleFragment declaration2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration2, data2);
    }

    @Override
    public void visitPackageFragment(@NotNull IrPackageFragment declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration2);
    }

    @Override
    public void visitPackageFragment(@NotNull IrPackageFragment declaration2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration2, data2);
    }

    @Override
    public void visitPropertyReference(@NotNull IrPropertyReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2);
    }

    @Override
    public void visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2, data2);
    }

    @Override
    public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2);
    }

    @Override
    public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2, data2);
    }

    @Override
    public void visitReturn(@NotNull IrReturn expression2) {
        IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2);
    }

    @Override
    public void visitReturn(@NotNull IrReturn expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2, data2);
    }

    @Override
    public void visitScript(@NotNull IrScript declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration2);
    }

    @Override
    public void visitScript(@NotNull IrScript declaration2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration2, data2);
    }

    @Override
    public void visitSetField(@NotNull IrSetField expression2) {
        IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2);
    }

    @Override
    public void visitSetField(@NotNull IrSetField expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2, data2);
    }

    @Override
    public void visitSetValue(@NotNull IrSetValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2);
    }

    @Override
    public void visitSetValue(@NotNull IrSetValue expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2, data2);
    }

    @Override
    public void visitSimpleFunction(@NotNull IrSimpleFunction declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration2);
    }

    @Override
    public void visitSimpleFunction(@NotNull IrSimpleFunction declaration2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration2, data2);
    }

    @Override
    public void visitSingletonReference(@NotNull IrGetSingletonValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2);
    }

    @Override
    public void visitSingletonReference(@NotNull IrGetSingletonValue expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2, data2);
    }

    @Override
    public void visitSpreadElement(@NotNull IrSpreadElement spread) {
        IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread);
    }

    @Override
    public void visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread, data2);
    }

    @Override
    public void visitStringConcatenation(@NotNull IrStringConcatenation expression2) {
        IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2);
    }

    @Override
    public void visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2, data2);
    }

    @Override
    public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2);
    }

    @Override
    public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2, data2);
    }

    @Override
    public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2) {
        IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2);
    }

    @Override
    public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2, data2);
    }

    @Override
    public void visitSyntheticBody(@NotNull IrSyntheticBody body2) {
        IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2);
    }

    @Override
    public void visitSyntheticBody(@NotNull IrSyntheticBody body2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2, data2);
    }

    @Override
    public void visitThrow(@NotNull IrThrow expression2) {
        IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2);
    }

    @Override
    public void visitThrow(@NotNull IrThrow expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2, data2);
    }

    @Override
    public void visitTry(@NotNull IrTry aTry) {
        IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry);
    }

    @Override
    public void visitTry(@NotNull IrTry aTry, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry, data2);
    }

    @Override
    public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
        IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2);
    }

    @Override
    public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2, data2);
    }

    @Override
    public void visitTypeParameter(@NotNull IrTypeParameter declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration2);
    }

    @Override
    public void visitTypeParameter(@NotNull IrTypeParameter declaration2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration2, data2);
    }

    @Override
    public void visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2, data2);
    }

    @Override
    public void visitValueParameter(@NotNull IrValueParameter declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration2);
    }

    @Override
    public void visitValueParameter(@NotNull IrValueParameter declaration2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration2, data2);
    }

    @Override
    public void visitVararg(@NotNull IrVararg expression2) {
        IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2);
    }

    @Override
    public void visitVararg(@NotNull IrVararg expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2, data2);
    }

    @Override
    public void visitVariable(@NotNull IrVariable declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration2);
    }

    @Override
    public void visitVariable(@NotNull IrVariable declaration2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration2, data2);
    }

    @Override
    public void visitVariableAccess(@NotNull IrValueAccessExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitVariableAccess(this, expression2);
    }

    @Override
    public void visitWhen(@NotNull IrWhen expression2) {
        IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2);
    }

    @Override
    public void visitWhen(@NotNull IrWhen expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2, data2);
    }

    @Override
    public void visitWhileLoop(@NotNull IrWhileLoop loop2) {
        IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2);
    }

    @Override
    public void visitWhileLoop(@NotNull IrWhileLoop loop2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2, data2);
    }

    public static final /* synthetic */ WasmBackendContext access$getBackendContext$p(DeclarationGenerator $this) {
        return $this.backendContext;
    }
}

