/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirResolvedDeclarationStatus;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.transformers.AbstractFirStatusResolveTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.StatusComputationSession;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.symbols.FirPhaseManagerKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001BS\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\bH\u0002J\u001a\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\f\u0010\u001d\u001a\u00020\u0013*\u00020\bH\u0014J\f\u0010\u001e\u001a\u00020\u0013*\u00020\bH\u0014R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirDesignatedStatusResolveTransformer;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/AbstractFirStatusResolveTransformer;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "designation", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "targetClass", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "statusComputationSession", "Lorg/jetbrains/kotlin/fir/resolve/transformers/StatusComputationSession;", "designationMapForLocalClasses", "", "scopeForLocalClass", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;Ljava/util/Iterator;Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;Lorg/jetbrains/kotlin/fir/resolve/transformers/StatusComputationSession;Ljava/util/Map;Lorg/jetbrains/kotlin/fir/scopes/FirScope;)V", "classLocated", "", "currentElement", "shouldSkipClass", "declaration", "transformRegularClass", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "regularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "data", "Lorg/jetbrains/kotlin/fir/declarations/FirResolvedDeclarationStatus;", "needResolveMembers", "needResolveNestedClassifiers", "resolve"})
public class FirDesignatedStatusResolveTransformer
extends AbstractFirStatusResolveTransformer {
    @NotNull
    private final Iterator<FirDeclaration> designation;
    @NotNull
    private final FirClassLikeDeclaration targetClass;
    @Nullable
    private FirDeclaration currentElement;
    private boolean classLocated;

    public FirDesignatedStatusResolveTransformer(@NotNull FirSession session2, @NotNull ScopeSession scopeSession, @NotNull Iterator<? extends FirDeclaration> designation2, @NotNull FirClassLikeDeclaration targetClass, @NotNull StatusComputationSession statusComputationSession, @NotNull Map<FirClassLikeDeclaration, ? extends FirClassLikeDeclaration> designationMapForLocalClasses, @Nullable FirScope scopeForLocalClass) {
        Intrinsics.checkNotNullParameter(session2, "session");
        Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
        Intrinsics.checkNotNullParameter(designation2, "designation");
        Intrinsics.checkNotNullParameter(targetClass, "targetClass");
        Intrinsics.checkNotNullParameter(statusComputationSession, "statusComputationSession");
        Intrinsics.checkNotNullParameter(designationMapForLocalClasses, "designationMapForLocalClasses");
        super(session2, scopeSession, statusComputationSession, designationMapForLocalClasses, scopeForLocalClass);
        this.designation = designation2;
        this.targetClass = targetClass;
    }

    private final boolean shouldSkipClass(FirDeclaration declaration2) {
        boolean result2;
        if (this.classLocated) {
            return !Intrinsics.areEqual(declaration2, this.targetClass);
        }
        if (this.currentElement == null && this.designation.hasNext()) {
            this.currentElement = this.designation.next();
        }
        if (result2 = Intrinsics.areEqual(this.currentElement, declaration2)) {
            if (Intrinsics.areEqual(this.currentElement, this.targetClass)) {
                this.classLocated = true;
            }
            this.currentElement = null;
        }
        return !result2;
    }

    @Override
    protected boolean needResolveMembers(@NotNull FirDeclaration $this$needResolveMembers) {
        Intrinsics.checkNotNullParameter($this$needResolveMembers, "<this>");
        return this.classLocated;
    }

    @Override
    protected boolean needResolveNestedClassifiers(@NotNull FirDeclaration $this$needResolveNestedClassifiers) {
        Intrinsics.checkNotNullParameter($this$needResolveNestedClassifiers, "<this>");
        return !this.classLocated;
    }

    @Override
    @NotNull
    public FirStatement transformRegularClass(@NotNull FirRegularClass regularClass, @Nullable FirResolvedDeclarationStatus data2) {
        FirStatement firStatement;
        Intrinsics.checkNotNullParameter(regularClass, "regularClass");
        if (this.shouldSkipClass(regularClass)) {
            return regularClass;
        }
        FirPhaseManagerKt.ensureResolved(regularClass.getSymbol(), FirResolvePhase.TYPES);
        boolean classLocated = this.classLocated;
        if (classLocated) {
            boolean bl = Intrinsics.areEqual(regularClass, this.targetClass);
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            StatusComputationSession.StatusComputationStatus computationStatus = this.getStatusComputationSession().startComputing(regularClass);
            this.forceResolveStatusesOfSupertypes(regularClass);
            if (computationStatus != StatusComputationSession.StatusComputationStatus.Computed) {
                regularClass.transformStatus(this, this.getStatusResolver().resolveStatus(regularClass, this.getContainingClass(), false));
            }
        } else if (!(regularClass.getStatus() instanceof FirResolvedDeclarationStatus)) {
            regularClass.transformStatus(this, this.getStatusResolver().resolveStatus(regularClass, this.getContainingClass(), false));
            this.getStatusComputationSession().computeOnlyClassStatus(regularClass);
        }
        FirStatement it = firStatement = this.transformClass((FirClass)regularClass, data2);
        boolean bl = false;
        if (classLocated) {
            this.getStatusComputationSession().endComputing(regularClass);
        }
        return firStatement;
    }
}

