/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.ic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.backend.js.ic.InlineFunctionHashProvider;
import org.jetbrains.kotlin.ir.backend.js.ic.InlineGraphTrackerKt;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitor;
import org.jetbrains.kotlin.utils.DFS;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001aB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0016\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\b\u0012\u00060\u0007j\u0002`\b0\u0005\u00a2\u0006\u0002\u0010\tJ$\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\b\u0012\u00060\u0007j\u0002`\u000e0\u00052\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J@\u0010\u0012\u001a$\u0012\u0004\u0012\u00020\u0011\u0012\u001a\u0012\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0014\u0012\b\u0012\u00060\u0007j\u0002`\u000e0\u00130\u00100\u00052\u0016\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\b\u0012\u00060\u0007j\u0002`\u000e0\u0005J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\u0019H\u0002R\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\b\u0012\u00060\u0007j\u0002`\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/ic/InlineFunctionHashBuilder;", "", "hashProvider", "Lorg/jetbrains/kotlin/ir/backend/js/ic/InlineFunctionHashProvider;", "flatHashes", "", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "", "Lorg/jetbrains/kotlin/ir/backend/js/ic/FlatHash;", "(Lorg/jetbrains/kotlin/ir/backend/js/ic/InlineFunctionHashProvider;Ljava/util/Map;)V", "inlineGraph", "", "", "buildHashes", "Lorg/jetbrains/kotlin/ir/backend/js/ic/TransHash;", "dirtyFiles", "", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "buildInlineGraph", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "computedHashed", "checkCircles", "", "topologicalOrder", "", "GraphBuilder", "backend.js"})
public final class InlineFunctionHashBuilder {
    @NotNull
    private final InlineFunctionHashProvider hashProvider;
    @NotNull
    private final Map<IrSimpleFunction, Long> flatHashes;
    @NotNull
    private final Map<IrSimpleFunction, Set<IrSimpleFunction>> inlineGraph;

    public InlineFunctionHashBuilder(@NotNull InlineFunctionHashProvider hashProvider2, @NotNull Map<IrSimpleFunction, Long> flatHashes) {
        Intrinsics.checkNotNullParameter(hashProvider2, "hashProvider");
        Intrinsics.checkNotNullParameter(flatHashes, "flatHashes");
        this.hashProvider = hashProvider2;
        this.flatHashes = flatHashes;
        this.inlineGraph = new LinkedHashMap();
    }

    private final List<IrSimpleFunction> topologicalOrder() {
        List<IrSimpleFunction> list2 = DFS.topologicalOrder((Iterable)this.inlineGraph.keySet(), arg_0 -> InlineFunctionHashBuilder.topologicalOrder$lambda-2(this, arg_0));
        Intrinsics.checkNotNullExpressionValue(list2, "topologicalOrder(inlineG\u2026)\n            }\n        }");
        return list2;
    }

    private final void checkCircles() {
        Set visited2 = new LinkedHashSet();
        for (IrSimpleFunction f : this.inlineGraph.keySet()) {
            InlineFunctionHashBuilder.checkCircles$walk(visited2, f, this, f);
            boolean bl = visited2.isEmpty();
            if (!_Assertions.ENABLED || bl) continue;
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
    }

    @NotNull
    public final Map<IrSimpleFunction, Long> buildHashes(@NotNull Collection<? extends IrFile> dirtyFiles) {
        Intrinsics.checkNotNullParameter(dirtyFiles, "dirtyFiles");
        Iterable $this$forEach$iv = dirtyFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrFile it = (IrFile)element$iv;
            boolean bl = false;
            it.acceptChildren(new GraphBuilder(), (Set)new LinkedHashSet());
        }
        this.checkCircles();
        List<IrSimpleFunction> rpo = this.topologicalOrder();
        Map computedHashes = new LinkedHashMap();
        for (IrSimpleFunction f : CollectionsKt.asReversed(rpo)) {
            String stringHash;
            Set<IrSimpleFunction> callees;
            if (!f.isInline()) continue;
            Object object = new StringBuilder();
            StringBuilder $this$buildHashes_u24lambda_u2d6 = object;
            boolean bl = false;
            if (this.inlineGraph.get(f) == null) {
                throw new IllegalStateException("Expected to be in".toString());
            }
            for (IrSimpleFunction callee : callees) {
                long hash = InlineFunctionHashBuilder.buildHashes$transHash(computedHashes, this, callee);
                String string2 = Long.toString(hash, CharsKt.checkRadix(36));
                Intrinsics.checkNotNullExpressionValue(string2, "toString(this, checkRadix(radix))");
                $this$buildHashes_u24lambda_u2d6.append(string2);
            }
            Long l = this.flatHashes.get(f);
            if (l == null) {
                throw new IllegalStateException(("Internal error: No flat hash for " + RenderIrElementKt.render(f)).toString());
            }
            $this$buildHashes_u24lambda_u2d6.append(l);
            Intrinsics.checkNotNullExpressionValue(((StringBuilder)object).toString(), "StringBuilder().apply(builderAction).toString()");
            object = computedHashes;
            Object object2 = stringHash;
            byte[] byArray = ((String)object2).getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue(byArray, "this as java.lang.String).getBytes(charset)");
            object2 = InlineGraphTrackerKt.md5(byArray);
            object.put(f, object2);
        }
        return computedHashes;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<IrFile, Collection<Pair<IdSignature, Long>>> buildInlineGraph(@NotNull Map<IrSimpleFunction, Long> computedHashed) {
        void $this$mapTo$iv$iv;
        Map perFileInlineGraph;
        Object object;
        Object list$iv$iv;
        Object value$iv$iv$iv;
        Object key$iv$iv;
        Map.Entry it;
        Map $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter(computedHashed, "computedHashed");
        Iterable $this$groupBy$iv = this.inlineGraph.entrySet();
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator<Object> iterator2 = $this$groupByTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it2;
            Object object2;
            Object t = iterator2.next();
            it = (Map.Entry)t;
            boolean $i$a$-groupBy-InlineFunctionHashBuilder$buildInlineGraph$perFileInlineGraph$332 = false;
            key$iv$iv = IrUtilsKt.getFile((IrDeclaration)it.getKey());
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            list$iv$iv = (List)object2;
            Map.Entry $i$a$-groupBy-InlineFunctionHashBuilder$buildInlineGraph$perFileInlineGraph$332 = (Map.Entry)t;
            object = list$iv$iv;
            boolean bl = false;
            object.add((Set)it2.getValue());
        }
        Map $this$map$iv = perFileInlineGraph = destination$iv$iv;
        boolean $i$f$map = false;
        $this$groupByTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        for (Map.Entry entry : $this$mapTo$iv$iv.entrySet()) {
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            list$iv$iv = entry;
            object = destination$iv$iv;
            boolean bl = false;
            key$iv$iv = (Iterable)it.getValue();
            Object k = it.getKey();
            boolean $i$f$flatMap = false;
            value$iv$iv$iv = $this$flatMap$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$mapNotNullTo$iv$iv;
                Set edges = (Set)element$iv$iv;
                boolean bl2 = false;
                Iterable $this$mapNotNull$iv = edges;
                boolean $i$f$mapNotNull = false;
                Iterable iterable2 = $this$mapNotNull$iv;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator3 = $this$forEach$iv$iv$iv.iterator();
                while (iterator3.hasNext()) {
                    Pair<IdSignature, Long> pair;
                    Object element$iv$iv$iv;
                    Object element$iv$iv2 = element$iv$iv$iv = iterator3.next();
                    boolean bl3 = false;
                    IrSimpleFunction callee = (IrSimpleFunction)element$iv$iv2;
                    boolean bl4 = false;
                    if (!callee.isFakeOverride()) {
                        IdSignature signature2;
                        IdSignature idSignature = signature2 = callee.getSymbol().getSignature();
                        boolean bl5 = idSignature != null ? idSignature.getVisibleCrossFile() : false;
                        if (bl5) {
                            long l;
                            Long l2 = computedHashed.get(callee);
                            if (l2 != null) {
                                l = l2;
                            } else {
                                Long l3 = this.hashProvider.hashForExternalFunction(callee);
                                if (l3 != null) {
                                    l = l3;
                                } else {
                                    throw new IllegalStateException(("Internal error: No has found for " + RenderIrElementKt.render(callee)).toString());
                                }
                            }
                            pair = TuplesKt.to(signature2, l);
                        } else {
                            pair = null;
                        }
                    } else {
                        pair = null;
                    }
                    if (pair == null) continue;
                    Pair<IdSignature, Long> it$iv$iv = pair;
                    boolean bl6 = false;
                    destination$iv$iv3.add(it$iv$iv);
                }
                Iterable list$iv$iv2 = (List)destination$iv$iv3;
                CollectionsKt.addAll(destination$iv$iv2, list$iv$iv2);
            }
            object.add(TuplesKt.to(k, (List)destination$iv$iv2));
        }
        return MapsKt.toMap((List)destination$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    private static final Iterable topologicalOrder$lambda-2(InlineFunctionHashBuilder this$0, IrSimpleFunction it) {
        Iterable iterable;
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Set<IrSimpleFunction> set = this$0.inlineGraph.get(it);
        if (set != null) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = set;
            boolean $i$f$filter = false;
            Iterable iterable2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                IrSimpleFunction f = (IrSimpleFunction)element$iv$iv;
                boolean bl = false;
                if (!this$0.inlineGraph.containsKey(f)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            iterable = (List)destination$iv$iv;
        } else {
            InlineFunctionHashBuilder $this$topologicalOrder_u24lambda_u2d2_u24lambda_u2d1 = this$0;
            boolean bl = false;
            iterable = SetsKt.emptySet();
        }
        return iterable;
    }

    private static final void checkCircles$walk(Set<IrSimpleFunction> visited2, IrSimpleFunction f, InlineFunctionHashBuilder this$0, IrSimpleFunction current) {
        if (!visited2.add(current)) {
            throw new IllegalStateException(("Inline circle detected: " + RenderIrElementKt.render(current) + " into " + RenderIrElementKt.render(f)).toString());
        }
        Set<IrSimpleFunction> set = this$0.inlineGraph.get(current);
        if (set != null) {
            Set<IrSimpleFunction> it = set;
            boolean bl = false;
            Iterable $this$forEach$iv = it;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IrSimpleFunction callee = (IrSimpleFunction)element$iv;
                boolean bl2 = false;
                InlineFunctionHashBuilder.checkCircles$walk(visited2, f, this$0, callee);
            }
        }
        visited2.remove(current);
    }

    private static final long buildHashes$transHash(Map<IrSimpleFunction, Long> computedHashes, InlineFunctionHashBuilder this$0, IrSimpleFunction callee) {
        long l;
        Long l2 = computedHashes.get(callee);
        if (l2 != null) {
            l = l2;
        } else {
            Long l3 = this$0.hashProvider.hashForExternalFunction(callee);
            if (l3 != null) {
                l = l3;
            } else {
                throw new IllegalStateException(("Internal error: No has found for " + RenderIrElementKt.render(callee)).toString());
            }
        }
        return l;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0016J\u001e\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0016J\u001e\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00042\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/ic/InlineFunctionHashBuilder$GraphBuilder;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementVisitor;", "", "", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "(Lorg/jetbrains/kotlin/ir/backend/js/ic/InlineFunctionHashBuilder;)V", "visitCall", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "data", "visitElement", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "visitSimpleFunction", "declaration", "backend.js"})
    private final class GraphBuilder
    implements IrElementVisitor<Unit, Set<IrSimpleFunction>> {
        @Override
        public void visitElement(@NotNull IrElement element, @NotNull Set<IrSimpleFunction> data2) {
            Intrinsics.checkNotNullParameter(element, "element");
            Intrinsics.checkNotNullParameter(data2, "data");
            element.acceptChildren(this, data2);
        }

        @Override
        public void visitSimpleFunction(@NotNull IrSimpleFunction declaration2, @NotNull Set<IrSimpleFunction> data2) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            Intrinsics.checkNotNullParameter(data2, "data");
            Set newGraph = new LinkedHashSet();
            InlineFunctionHashBuilder.this.inlineGraph.put(declaration2, newGraph);
            declaration2.acceptChildren(this, newGraph);
        }

        @Override
        public void visitCall(@NotNull IrCall expression2, @NotNull Set<IrSimpleFunction> data2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(data2, "data");
            IrSimpleFunction callee = (IrSimpleFunction)expression2.getSymbol().getOwner();
            if (callee.isInline()) {
                data2.add(callee);
            }
            expression2.acceptChildren(this, data2);
        }

        @Override
        public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitAnonymousInitializer(this, declaration2, data2);
        }

        @Override
        public void visitBlock(@NotNull IrBlock expression2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitBlock(this, expression2, data2);
        }

        @Override
        public void visitBlockBody(@NotNull IrBlockBody body2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitBlockBody(this, body2, data2);
        }

        @Override
        public void visitBody(@NotNull IrBody body2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitBody(this, body2, data2);
        }

        @Override
        public void visitBranch(@NotNull IrBranch branch, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitBranch(this, branch, data2);
        }

        @Override
        public void visitBreak(@NotNull IrBreak jump, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitBreak(this, jump, data2);
        }

        @Override
        public void visitBreakContinue(@NotNull IrBreakContinue jump, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitBreakContinue(this, jump, data2);
        }

        @Override
        public void visitCallableReference(@NotNull IrCallableReference<?> expression2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitCallableReference(this, expression2, data2);
        }

        @Override
        public void visitCatch(@NotNull IrCatch aCatch, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitCatch(this, aCatch, data2);
        }

        @Override
        public void visitClass(@NotNull IrClass declaration2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitClass(this, declaration2, data2);
        }

        @Override
        public void visitClassReference(@NotNull IrClassReference expression2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitClassReference(this, expression2, data2);
        }

        @Override
        public void visitComposite(@NotNull IrComposite expression2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitComposite(this, expression2, data2);
        }

        @Override
        public <T> void visitConst(@NotNull IrConst<T> expression2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitConst(this, expression2, data2);
        }

        @Override
        public void visitConstantArray(@NotNull IrConstantArray expression2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitConstantArray(this, expression2, data2);
        }

        @Override
        public void visitConstantObject(@NotNull IrConstantObject expression2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitConstantObject(this, expression2, data2);
        }

        @Override
        public void visitConstantPrimitive(@NotNull IrConstantPrimitive expression2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitConstantPrimitive(this, expression2, data2);
        }

        @Override
        public void visitConstantValue(@NotNull IrConstantValue expression2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitConstantValue(this, expression2, data2);
        }

        @Override
        public void visitConstructor(@NotNull IrConstructor declaration2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitConstructor(this, declaration2, data2);
        }

        @Override
        public void visitConstructorCall(@NotNull IrConstructorCall expression2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitConstructorCall(this, expression2, data2);
        }

        @Override
        public void visitContainerExpression(@NotNull IrContainerExpression expression2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitContainerExpression(this, expression2, data2);
        }

        @Override
        public void visitContinue(@NotNull IrContinue jump, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitContinue(this, jump, data2);
        }

        @Override
        public void visitDeclaration(@NotNull IrDeclarationBase declaration2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitDeclaration(this, declaration2, data2);
        }

        @Override
        public void visitDeclarationReference(@NotNull IrDeclarationReference expression2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitDeclarationReference(this, expression2, data2);
        }

        @Override
        public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data2);
        }

        @Override
        public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitDoWhileLoop(this, loop2, data2);
        }

        @Override
        public void visitDynamicExpression(@NotNull IrDynamicExpression expression2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitDynamicExpression(this, expression2, data2);
        }

        @Override
        public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitDynamicMemberExpression(this, expression2, data2);
        }

        @Override
        public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data2);
        }

        @Override
        public void visitElseBranch(@NotNull IrElseBranch branch, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitElseBranch(this, branch, data2);
        }

        @Override
        public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitEnumConstructorCall(this, expression2, data2);
        }

        @Override
        public void visitEnumEntry(@NotNull IrEnumEntry declaration2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitEnumEntry(this, declaration2, data2);
        }

        @Override
        public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitErrorCallExpression(this, expression2, data2);
        }

        @Override
        public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitErrorDeclaration(this, declaration2, data2);
        }

        @Override
        public void visitErrorExpression(@NotNull IrErrorExpression expression2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitErrorExpression(this, expression2, data2);
        }

        @Override
        public void visitExpression(@NotNull IrExpression expression2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitExpression(this, expression2, data2);
        }

        @Override
        public void visitExpressionBody(@NotNull IrExpressionBody body2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitExpressionBody(this, body2, data2);
        }

        @Override
        public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitExternalPackageFragment(this, declaration2, data2);
        }

        @Override
        public void visitField(@NotNull IrField declaration2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitField(this, declaration2, data2);
        }

        @Override
        public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitFieldAccess(this, expression2, data2);
        }

        @Override
        public void visitFile(@NotNull IrFile declaration2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitFile(this, declaration2, data2);
        }

        @Override
        public void visitFunction(@NotNull IrFunction declaration2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitFunction(this, declaration2, data2);
        }

        @Override
        public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitFunctionAccess(this, expression2, data2);
        }

        @Override
        public void visitFunctionExpression(@NotNull IrFunctionExpression expression2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitFunctionExpression(this, expression2, data2);
        }

        @Override
        public void visitFunctionReference(@NotNull IrFunctionReference expression2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitFunctionReference(this, expression2, data2);
        }

        @Override
        public void visitGetClass(@NotNull IrGetClass expression2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitGetClass(this, expression2, data2);
        }

        @Override
        public void visitGetEnumValue(@NotNull IrGetEnumValue expression2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitGetEnumValue(this, expression2, data2);
        }

        @Override
        public void visitGetField(@NotNull IrGetField expression2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitGetField(this, expression2, data2);
        }

        @Override
        public void visitGetObjectValue(@NotNull IrGetObjectValue expression2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitGetObjectValue(this, expression2, data2);
        }

        @Override
        public void visitGetValue(@NotNull IrGetValue expression2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitGetValue(this, expression2, data2);
        }

        @Override
        public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitInstanceInitializerCall(this, expression2, data2);
        }

        @Override
        public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitLocalDelegatedProperty(this, declaration2, data2);
        }

        @Override
        public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data2);
        }

        @Override
        public void visitLoop(@NotNull IrLoop loop2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitLoop(this, loop2, data2);
        }

        @Override
        public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitMemberAccess(this, expression2, data2);
        }

        @Override
        public void visitModuleFragment(@NotNull IrModuleFragment declaration2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitModuleFragment(this, declaration2, data2);
        }

        @Override
        public void visitPackageFragment(@NotNull IrPackageFragment declaration2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitPackageFragment(this, declaration2, data2);
        }

        @Override
        public void visitProperty(@NotNull IrProperty declaration2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitProperty(this, declaration2, data2);
        }

        @Override
        public void visitPropertyReference(@NotNull IrPropertyReference expression2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitPropertyReference(this, expression2, data2);
        }

        @Override
        public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitRawFunctionReference(this, expression2, data2);
        }

        @Override
        public void visitReturn(@NotNull IrReturn expression2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitReturn(this, expression2, data2);
        }

        @Override
        public void visitScript(@NotNull IrScript declaration2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitScript(this, declaration2, data2);
        }

        @Override
        public void visitSetField(@NotNull IrSetField expression2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitSetField(this, expression2, data2);
        }

        @Override
        public void visitSetValue(@NotNull IrSetValue expression2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitSetValue(this, expression2, data2);
        }

        @Override
        public void visitSingletonReference(@NotNull IrGetSingletonValue expression2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitSingletonReference(this, expression2, data2);
        }

        @Override
        public void visitSpreadElement(@NotNull IrSpreadElement spread, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitSpreadElement(this, spread, data2);
        }

        @Override
        public void visitStringConcatenation(@NotNull IrStringConcatenation expression2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitStringConcatenation(this, expression2, data2);
        }

        @Override
        public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitSuspendableExpression(this, expression2, data2);
        }

        @Override
        public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitSuspensionPoint(this, expression2, data2);
        }

        @Override
        public void visitSyntheticBody(@NotNull IrSyntheticBody body2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitSyntheticBody(this, body2, data2);
        }

        @Override
        public void visitThrow(@NotNull IrThrow expression2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitThrow(this, expression2, data2);
        }

        @Override
        public void visitTry(@NotNull IrTry aTry, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitTry(this, aTry, data2);
        }

        @Override
        public void visitTypeAlias(@NotNull IrTypeAlias declaration2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitTypeAlias(this, declaration2, data2);
        }

        @Override
        public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitTypeOperator(this, expression2, data2);
        }

        @Override
        public void visitTypeParameter(@NotNull IrTypeParameter declaration2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitTypeParameter(this, declaration2, data2);
        }

        @Override
        public void visitValueAccess(@NotNull IrValueAccessExpression expression2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitValueAccess(this, expression2, data2);
        }

        @Override
        public void visitValueParameter(@NotNull IrValueParameter declaration2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitValueParameter(this, declaration2, data2);
        }

        @Override
        public void visitVararg(@NotNull IrVararg expression2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitVararg(this, expression2, data2);
        }

        @Override
        public void visitVariable(@NotNull IrVariable declaration2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitVariable(this, declaration2, data2);
        }

        @Override
        public void visitWhen(@NotNull IrWhen expression2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitWhen(this, expression2, data2);
        }

        @Override
        public void visitWhileLoop(@NotNull IrWhileLoop loop2, @NotNull Set<IrSimpleFunction> data2) {
            IrElementVisitor.DefaultImpls.visitWhileLoop(this, loop2, data2);
        }
    }
}

