/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.List;
import kotlin.Unit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.codegen.AccessorForCompanionObjectInstanceFieldDescriptor;
import org.jetbrains.kotlin.codegen.AccessorForConstructorDescriptor;
import org.jetbrains.kotlin.codegen.AnnotationCodegen;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.BranchedValue;
import org.jetbrains.kotlin.codegen.CallableMethod;
import org.jetbrains.kotlin.codegen.CallableReferenceUtilKt;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.CodegenUtilKt;
import org.jetbrains.kotlin.codegen.FieldInfo;
import org.jetbrains.kotlin.codegen.FrameMap;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.StringConcatGenerator;
import org.jetbrains.kotlin.codegen.SyntheticClassDescriptorForLambda;
import org.jetbrains.kotlin.codegen.binding.CalculatedClosure;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.context.CodegenContext;
import org.jetbrains.kotlin.codegen.intrinsics.HashCode;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.config.JvmDefaultMode;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableAccessorDescriptor;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmProtoBufUtil;
import org.jetbrains.kotlin.metadata.jvm.serialization.JvmStringTable;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.protobuf.MessageLite;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.InlineClassDescriptorResolver;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationResolver;
import org.jetbrains.kotlin.resolve.inline.InlineOnlyKt;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.InlineClassManglingRulesKt;
import org.jetbrains.kotlin.resolve.jvm.RuntimeAssertionInfo;
import org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOrigin;
import org.jetbrains.kotlin.serialization.DescriptorSerializer;
import org.jetbrains.kotlin.synthetic.SyntheticJavaPropertyDescriptor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

public class DescriptorAsmUtil {
    private DescriptorAsmUtil() {
    }

    @NotNull
    public static String getNameForCapturedReceiverField(@NotNull CallableDescriptor descriptor2, @NotNull BindingContext bindingContext, @NotNull LanguageVersionSettings languageVersionSettings) {
        if (descriptor2 == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(0);
        }
        if (bindingContext == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(1);
        }
        if (languageVersionSettings == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(2);
        }
        return DescriptorAsmUtil.getLabeledThisNameForReceiver(descriptor2, bindingContext, languageVersionSettings, "this_", "receiver$0");
    }

    @NotNull
    public static String getNameForReceiverParameter(@NotNull CallableDescriptor descriptor2, @NotNull BindingContext bindingContext, @NotNull LanguageVersionSettings languageVersionSettings) {
        if (descriptor2 == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(3);
        }
        if (bindingContext == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(4);
        }
        if (languageVersionSettings == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(5);
        }
        return DescriptorAsmUtil.getLabeledThisNameForReceiver(descriptor2, bindingContext, languageVersionSettings, "$this$", "$receiver");
    }

    @NotNull
    private static String getLabeledThisNameForReceiver(@NotNull CallableDescriptor descriptor2, @NotNull BindingContext bindingContext, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull String prefix, @NotNull String defaultName) {
        if (descriptor2 == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(6);
        }
        if (bindingContext == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(7);
        }
        if (languageVersionSettings == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(8);
        }
        if (prefix == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(9);
        }
        if (defaultName == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(10);
        }
        if (!languageVersionSettings.supportsFeature(LanguageFeature.NewCapturedReceiverFieldNamingConvention)) {
            String string2 = defaultName;
            if (string2 == null) {
                DescriptorAsmUtil.$$$reportNull$$$0(11);
            }
            return string2;
        }
        Name callableName = null;
        if (descriptor2 instanceof FunctionDescriptor) {
            String labelName = bindingContext.get(CodegenBinding.CALL_LABEL_FOR_LAMBDA_ARGUMENT, (FunctionDescriptor)descriptor2);
            if (labelName != null) {
                String string3 = AsmUtil.getLabeledThisName(labelName, prefix, defaultName);
                if (string3 == null) {
                    DescriptorAsmUtil.$$$reportNull$$$0(12);
                }
                return string3;
            }
            if (descriptor2 instanceof VariableAccessorDescriptor) {
                VariableAccessorDescriptor accessor = (VariableAccessorDescriptor)descriptor2;
                callableName = accessor.getCorrespondingVariable().getName();
            }
        }
        if (callableName == null) {
            callableName = descriptor2.getName();
        }
        if (callableName.isSpecial()) {
            String string4 = defaultName;
            if (string4 == null) {
                DescriptorAsmUtil.$$$reportNull$$$0(13);
            }
            return string4;
        }
        String string5 = AsmUtil.getLabeledThisName(callableName.asString(), prefix, defaultName);
        if (string5 == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(14);
        }
        return string5;
    }

    @NotNull
    public static Type boxType(@NotNull Type type2, @NotNull KotlinType kotlinType, @NotNull KotlinTypeMapper typeMapper2) {
        if (type2 == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(15);
        }
        if (kotlinType == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(16);
        }
        if (typeMapper2 == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(17);
        }
        if (InlineClassesUtilsKt.isInlineClassType(kotlinType)) {
            Type type3 = typeMapper2.mapTypeAsDeclaration(kotlinType);
            if (type3 == null) {
                DescriptorAsmUtil.$$$reportNull$$$0(18);
            }
            return type3;
        }
        Type boxedPrimitiveType = AsmUtil.boxPrimitiveType(type2);
        Type type4 = boxedPrimitiveType != null ? boxedPrimitiveType : type2;
        if (type4 == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(19);
        }
        return type4;
    }

    public static boolean isAbstractMethod(FunctionDescriptor functionDescriptor, OwnerKind kind, JvmDefaultMode jvmDefaultMode2) {
        return (functionDescriptor.getModality() == Modality.ABSTRACT || JvmCodegenUtil.isJvmInterface(functionDescriptor.getContainingDeclaration()) && !JvmAnnotationUtilKt.isCompiledToJvmDefault(functionDescriptor, jvmDefaultMode2)) && !DescriptorAsmUtil.isStaticMethod(kind, functionDescriptor);
    }

    public static boolean isStaticMethod(OwnerKind kind, CallableMemberDescriptor functionDescriptor) {
        return DescriptorAsmUtil.isStaticKind(kind) || KotlinTypeMapper.isStaticAccessor(functionDescriptor) || CodegenUtilKt.isJvmStaticInObjectOrClassOrInterface(functionDescriptor);
    }

    public static boolean isStaticKind(OwnerKind kind) {
        return kind == OwnerKind.PACKAGE || kind == OwnerKind.DEFAULT_IMPLS || kind == OwnerKind.ERASED_INLINE_CLASS;
    }

    public static int getMethodAsmFlags(FunctionDescriptor functionDescriptor, OwnerKind kind, GenerationState state) {
        return DescriptorAsmUtil.getMethodAsmFlags(functionDescriptor, kind, state.getDeprecationProvider(), state.getJvmDefaultMode());
    }

    public static int getMethodAsmFlags(FunctionDescriptor functionDescriptor, OwnerKind kind, DeprecationResolver deprecationResolver, JvmDefaultMode jvmDefaultMode2) {
        DeclarationDescriptor containingDeclaration;
        int flags = DescriptorAsmUtil.getCommonCallableFlags(functionDescriptor, kind, deprecationResolver);
        for (AnnotationCodegen.JvmFlagAnnotation flagAnnotation : AnnotationCodegen.METHOD_FLAGS) {
            flags |= flagAnnotation.getJvmFlag(functionDescriptor.getOriginal());
        }
        if (functionDescriptor.getOriginal().isExternal()) {
            flags |= 0x100;
        }
        if (CodegenUtilKt.isJvmStaticInCompanionObject(functionDescriptor)) {
            flags &= 0xFFFFFEFF;
        }
        if (functionDescriptor.getModality() == Modality.FINAL && !(functionDescriptor instanceof ConstructorDescriptor) && !JvmCodegenUtil.isJvmInterface(containingDeclaration = functionDescriptor.getContainingDeclaration())) {
            flags |= 0x10;
        }
        if (DescriptorAsmUtil.isStaticMethod(kind, functionDescriptor)) {
            flags |= 8;
        }
        if (DescriptorAsmUtil.isAbstractMethod(functionDescriptor, kind, jvmDefaultMode2)) {
            flags |= 0x400;
        }
        if (KotlinTypeMapper.isAccessor(functionDescriptor) || JvmAnnotationUtilKt.hasJvmSyntheticAnnotation(functionDescriptor) || DescriptorAsmUtil.isInlineClassWrapperConstructor(functionDescriptor, kind) || InlineClassDescriptorResolver.isSynthesizedBoxMethod(functionDescriptor) || InlineClassDescriptorResolver.isSynthesizedUnboxMethod(functionDescriptor)) {
            flags |= 0x1000;
        }
        return flags;
    }

    private static boolean isInlineClassWrapperConstructor(@NotNull FunctionDescriptor functionDescriptor, @Nullable OwnerKind kind) {
        if (functionDescriptor == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(20);
        }
        if (!(functionDescriptor instanceof ConstructorDescriptor)) {
            return false;
        }
        ClassDescriptor classDescriptor = ((ConstructorDescriptor)functionDescriptor).getConstructedClass();
        return InlineClassesUtilsKt.isInlineClass(classDescriptor) && kind == OwnerKind.IMPLEMENTATION;
    }

    public static int getCommonCallableFlags(FunctionDescriptor functionDescriptor, @NotNull GenerationState state) {
        if (state == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(21);
        }
        return DescriptorAsmUtil.getCommonCallableFlags(functionDescriptor, null, state.getDeprecationProvider());
    }

    private static int getCommonCallableFlags(FunctionDescriptor functionDescriptor, @Nullable OwnerKind kind, @NotNull DeprecationResolver deprecationResolver) {
        if (deprecationResolver == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(22);
        }
        int flags = DescriptorAsmUtil.getVisibilityAccessFlag(functionDescriptor, kind);
        flags |= DescriptorAsmUtil.getVarargsFlag(functionDescriptor);
        flags |= DescriptorAsmUtil.getDeprecatedAccessFlag(functionDescriptor);
        if (deprecationResolver.isDeprecatedHidden(functionDescriptor) || InlineOnlyKt.isInlineWithReified(functionDescriptor)) {
            flags |= 0x1000;
        }
        return flags;
    }

    public static int getVisibilityAccessFlag(@NotNull MemberDescriptor descriptor2) {
        if (descriptor2 == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(23);
        }
        return DescriptorAsmUtil.getVisibilityAccessFlag(descriptor2, null);
    }

    private static int getVisibilityAccessFlag(@NotNull MemberDescriptor descriptor2, @Nullable OwnerKind kind) {
        Integer specialCase;
        if (descriptor2 == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(24);
        }
        if ((specialCase = DescriptorAsmUtil.specialCaseVisibility(descriptor2, kind)) != null) {
            return specialCase;
        }
        DescriptorVisibility visibility2 = descriptor2.getVisibility();
        Integer defaultMapping = DescriptorAsmUtil.getVisibilityAccessFlag(visibility2);
        if (defaultMapping == null) {
            throw new IllegalStateException(visibility2 + " is not a valid visibility in backend for " + DescriptorRenderer.DEBUG_TEXT.render(descriptor2));
        }
        return defaultMapping;
    }

    @Nullable
    public static Integer getVisibilityAccessFlag(DescriptorVisibility visibility2) {
        return AsmUtil.getVisibilityAccessFlag(visibility2.getDelegate());
    }

    public static int getVisibilityAccessFlagForClass(@NotNull ClassDescriptor descriptor2) {
        if (descriptor2 == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(25);
        }
        if (descriptor2 instanceof SyntheticClassDescriptorForLambda) {
            return DescriptorAsmUtil.getVisibilityAccessFlagForAnonymous(descriptor2);
        }
        if (descriptor2.getKind() == ClassKind.ENUM_ENTRY) {
            return 0;
        }
        if (descriptor2.getVisibility() == DescriptorVisibilities.PUBLIC || descriptor2.getVisibility() == DescriptorVisibilities.PROTECTED || descriptor2.getVisibility() == DescriptorVisibilities.LOCAL || descriptor2.getVisibility() == DescriptorVisibilities.INTERNAL) {
            return 1;
        }
        return 0;
    }

    private static int getVisibilityAccessFlagForAnonymous(@NotNull ClassDescriptor descriptor2) {
        if (descriptor2 == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(26);
        }
        return InlineUtil.isInlineOrContainingInline(descriptor2.getContainingDeclaration()) ? 1 : 0;
    }

    public static int getSyntheticAccessFlagForLambdaClass(@NotNull ClassDescriptor descriptor2) {
        if (descriptor2 == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(27);
        }
        return descriptor2 instanceof SyntheticClassDescriptorForLambda && ((SyntheticClassDescriptorForLambda)descriptor2).isCallableReference() ? 4096 : 0;
    }

    public static int calculateInnerClassAccessFlags(@NotNull ClassDescriptor innerClass) {
        if (innerClass == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(28);
        }
        int visibility2 = innerClass instanceof SyntheticClassDescriptorForLambda ? DescriptorAsmUtil.getVisibilityAccessFlagForAnonymous(innerClass) : (innerClass.getVisibility() == DescriptorVisibilities.LOCAL ? 1 : DescriptorAsmUtil.getVisibilityAccessFlag(innerClass));
        return visibility2 | DescriptorAsmUtil.getSyntheticAccessFlagForLambdaClass(innerClass) | DescriptorAsmUtil.innerAccessFlagsForModalityAndKind(innerClass) | (innerClass.isInner() ? 0 : 8);
    }

    private static int innerAccessFlagsForModalityAndKind(@NotNull ClassDescriptor innerClass) {
        if (innerClass == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(29);
        }
        switch (innerClass.getKind()) {
            case INTERFACE: {
                return 1536;
            }
            case ENUM_CLASS: {
                return 16400;
            }
            case ANNOTATION_CLASS: {
                return 9728;
            }
        }
        Modality modality = innerClass.getModality();
        if (modality == Modality.FINAL) {
            return 16;
        }
        if (modality == Modality.ABSTRACT || modality == Modality.SEALED) {
            return 1024;
        }
        return 0;
    }

    public static int getDeprecatedAccessFlag(@NotNull MemberDescriptor descriptor2) {
        if (descriptor2 == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(30);
        }
        if (descriptor2 instanceof PropertyAccessorDescriptor) {
            return KotlinBuiltIns.isDeprecated(descriptor2) ? 131072 : DescriptorAsmUtil.getDeprecatedAccessFlag(((PropertyAccessorDescriptor)descriptor2).getCorrespondingProperty());
        }
        if (KotlinBuiltIns.isDeprecated(descriptor2)) {
            return 131072;
        }
        return 0;
    }

    private static int getVarargsFlag(FunctionDescriptor functionDescriptor) {
        if (!functionDescriptor.getValueParameters().isEmpty() && functionDescriptor.getValueParameters().get(functionDescriptor.getValueParameters().size() - 1).getVarargElementType() != null) {
            return 128;
        }
        return 0;
    }

    @Nullable
    private static Integer specialCaseVisibility(@NotNull MemberDescriptor memberDescriptor, @Nullable OwnerKind kind) {
        PropertyDescriptor property2;
        if (memberDescriptor == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(31);
        }
        DeclarationDescriptor containingDeclaration = memberDescriptor.getContainingDeclaration();
        DescriptorVisibility memberVisibility = memberDescriptor.getVisibility();
        if (JvmCodegenUtil.isNonIntrinsicPrivateCompanionObjectInInterface(memberDescriptor)) {
            return 1;
        }
        if (memberDescriptor instanceof FunctionDescriptor && DescriptorAsmUtil.isInlineClassWrapperConstructor((FunctionDescriptor)memberDescriptor, kind)) {
            return 2;
        }
        if (kind != OwnerKind.ERASED_INLINE_CLASS && memberDescriptor instanceof ConstructorDescriptor && !(memberDescriptor instanceof AccessorForConstructorDescriptor) && InlineClassManglingRulesKt.shouldHideConstructorDueToInlineClassTypeValueParameters((ConstructorDescriptor)memberDescriptor)) {
            return 2;
        }
        if (memberDescriptor instanceof ConstructorDescriptor && !(memberDescriptor instanceof AccessorForConstructorDescriptor) && DescriptorUtils.isSealedClass(((ConstructorDescriptor)memberDescriptor).getConstructedClass()) && memberDescriptor.getVisibility() != DescriptorVisibilities.PUBLIC) {
            return 2;
        }
        if (InlineOnlyKt.isInlineOnlyPrivateInBytecode(memberDescriptor)) {
            return 2;
        }
        if (memberVisibility == DescriptorVisibilities.LOCAL && memberDescriptor instanceof CallableMemberDescriptor) {
            return 1;
        }
        if (DescriptorUtils.isEnumEntry(memberDescriptor)) {
            return 0;
        }
        if (CodegenUtilKt.isToArrayFromCollection(memberDescriptor)) {
            return 1;
        }
        if (memberDescriptor instanceof ConstructorDescriptor && DescriptorUtils.isAnonymousObject(memberDescriptor.getContainingDeclaration())) {
            return DescriptorAsmUtil.getVisibilityAccessFlagForAnonymous((ClassDescriptor)memberDescriptor.getContainingDeclaration());
        }
        if (memberDescriptor instanceof SyntheticJavaPropertyDescriptor) {
            return DescriptorAsmUtil.getVisibilityAccessFlag(((SyntheticJavaPropertyDescriptor)memberDescriptor).getGetMethod());
        }
        if (memberDescriptor instanceof PropertyAccessorDescriptor && (property2 = ((PropertyAccessorDescriptor)memberDescriptor).getCorrespondingProperty()) instanceof SyntheticJavaPropertyDescriptor) {
            FunctionDescriptor method;
            FunctionDescriptor functionDescriptor = method = memberDescriptor == property2.getGetter() ? ((SyntheticJavaPropertyDescriptor)property2).getGetMethod() : ((SyntheticJavaPropertyDescriptor)property2).getSetMethod();
            assert (method != null) : "No get/set method in SyntheticJavaPropertyDescriptor: " + property2;
            return DescriptorAsmUtil.getVisibilityAccessFlag(method);
        }
        if (memberDescriptor instanceof CallableDescriptor && memberVisibility == DescriptorVisibilities.PROTECTED) {
            for (CallableDescriptor overridden : DescriptorUtils.getAllOverriddenDescriptors((CallableDescriptor)((Object)memberDescriptor))) {
                if (!JvmCodegenUtil.isJvmInterface(overridden.getContainingDeclaration())) continue;
                return 1;
            }
        }
        if (!DescriptorVisibilities.isPrivate(memberVisibility)) {
            return null;
        }
        if (memberDescriptor instanceof AccessorForCompanionObjectInstanceFieldDescriptor) {
            return 0;
        }
        if (memberDescriptor instanceof ConstructorDescriptor && DescriptorUtils.isEnumEntry(containingDeclaration)) {
            return 0;
        }
        return null;
    }

    public static void genClosureFields(@NotNull CalculatedClosure closure, ClassBuilder v, KotlinTypeMapper typeMapper2, @NotNull LanguageVersionSettings languageVersionSettings) {
        KotlinType captureReceiverType;
        if (closure == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(32);
        }
        if (languageVersionSettings == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(33);
        }
        ArrayList<Pair<String, Type>> allFields = new ArrayList<Pair<String, Type>>();
        ClassDescriptor captureThis = closure.getCapturedOuterClassDescriptor();
        if (captureThis != null) {
            allFields.add(Pair.create((Object)"this$0", (Object)typeMapper2.mapType(captureThis)));
        }
        if ((captureReceiverType = closure.getCapturedReceiverFromOuterContext()) != null && !CallableReferenceUtilKt.isForCallableReference(closure)) {
            String fieldName = closure.getCapturedReceiverFieldName(typeMapper2.getBindingContext(), languageVersionSettings);
            allFields.add((Pair<String, Type>)Pair.create((Object)fieldName, (Object)typeMapper2.mapType(captureReceiverType)));
        }
        allFields.addAll(closure.getRecordedFields());
        DescriptorAsmUtil.genClosureFields(allFields, v);
    }

    public static void genClosureFields(List<Pair<String, Type>> allFields, ClassBuilder builder2) {
        int access = 4112;
        for (Pair<String, Type> field2 : allFields) {
            builder2.newField(JvmDeclarationOrigin.NO_ORIGIN, access, (String)field2.first, ((Type)field2.second).getDescriptor(), null, null);
        }
    }

    public static int genAssignInstanceFieldFromParam(FieldInfo info, int index2, InstructionAdapter iv) {
        return DescriptorAsmUtil.genAssignInstanceFieldFromParam(info, index2, iv, 0, false);
    }

    public static int genAssignInstanceFieldFromParam(FieldInfo info, int index2, InstructionAdapter iv, int ownerIndex, boolean cast) {
        assert (!info.isStatic());
        Type fieldType = info.getFieldType();
        KotlinType fieldKotlinType = info.getFieldKotlinType();
        SimpleType nullableAny = fieldKotlinType != null ? fieldKotlinType.getConstructor().getBuiltIns().getNullableAnyType() : null;
        iv.load(ownerIndex, info.getOwnerType());
        if (cast) {
            iv.load(index2, AsmTypes.OBJECT_TYPE);
            StackValue.coerce(AsmTypes.OBJECT_TYPE, nullableAny, fieldType, fieldKotlinType, iv);
        } else {
            iv.load(index2, fieldType);
        }
        iv.visitFieldInsn(181, info.getOwnerInternalName(), info.getFieldName(), fieldType.getDescriptor());
        return index2 += fieldType.getSize();
    }

    public static void genInvokeAppendMethod(@NotNull StringConcatGenerator generator2, @NotNull Type type2, @Nullable KotlinType kotlinType, @Nullable KotlinTypeMapper typeMapper2, @NotNull StackValue stackValue) {
        CallableMethod specializedToString;
        if (generator2 == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(34);
        }
        if (type2 == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(35);
        }
        if (stackValue == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(36);
        }
        if ((specializedToString = DescriptorAsmUtil.getSpecializedToStringCallableMethodOrNull(kotlinType, typeMapper2)) != null) {
            stackValue.put(type2, kotlinType, generator2.getMv());
            specializedToString.genInvokeInstruction(generator2.getMv());
            generator2.invokeAppend(AsmTypes.JAVA_STRING_TYPE);
        } else if (kotlinType != null && InlineClassesUtilsKt.isInlineClassType(kotlinType)) {
            SimpleType nullableAnyType = kotlinType.getConstructor().getBuiltIns().getNullableAnyType();
            stackValue.put(type2, kotlinType, generator2.getMv());
            StackValue.coerce(type2, kotlinType, AsmTypes.OBJECT_TYPE, nullableAnyType, generator2.getMv());
            generator2.invokeAppend(AsmTypes.OBJECT_TYPE);
        } else {
            generator2.putValueOrProcessConstant(stackValue, type2, kotlinType);
        }
    }

    public static StackValue genToString(@NotNull StackValue receiver, @NotNull Type receiverType, @Nullable KotlinType receiverKotlinType, @Nullable KotlinTypeMapper typeMapper2) {
        if (receiver == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(37);
        }
        if (receiverType == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(38);
        }
        return StackValue.operation(AsmTypes.JAVA_STRING_TYPE, v -> {
            SimpleType kotlinType;
            Type type2;
            CallableMethod specializedToString = DescriptorAsmUtil.getSpecializedToStringCallableMethodOrNull(receiverKotlinType, typeMapper2);
            if (specializedToString != null) {
                receiver.put(receiverType, receiverKotlinType, (InstructionAdapter)v);
                specializedToString.genInvokeInstruction((InstructionAdapter)v);
                return null;
            }
            if (receiverKotlinType != null && InlineClassesUtilsKt.isInlineClassType(receiverKotlinType)) {
                type2 = AsmTypes.OBJECT_TYPE;
                kotlinType = receiverKotlinType.getConstructor().getBuiltIns().getNullableAnyType();
            } else {
                type2 = AsmUtil.stringValueOfType(receiverType);
                kotlinType = null;
            }
            receiver.put(type2, kotlinType, (InstructionAdapter)v);
            v.invokestatic("java/lang/String", "valueOf", "(" + type2.getDescriptor() + ")Ljava/lang/String;", false);
            return null;
        });
    }

    @Nullable
    private static CallableMethod getSpecializedToStringCallableMethodOrNull(@Nullable KotlinType receiverKotlinType, @Nullable KotlinTypeMapper typeMapper2) {
        if (typeMapper2 == null) {
            return null;
        }
        if (receiverKotlinType == null) {
            return null;
        }
        if (!InlineClassesUtilsKt.isInlineClassType(receiverKotlinType)) {
            return null;
        }
        if (receiverKotlinType.isMarkedNullable()) {
            return null;
        }
        ClassifierDescriptor receiverTypeDescriptor = receiverKotlinType.getConstructor().getDeclarationDescriptor();
        assert (receiverTypeDescriptor != null && InlineClassesUtilsKt.isInlineClass(receiverTypeDescriptor)) : "Inline class type expected: " + receiverKotlinType;
        ClassDescriptor receiverClassDescriptor = (ClassDescriptor)receiverTypeDescriptor;
        FunctionDescriptor toStringDescriptor = receiverClassDescriptor.getUnsubstitutedMemberScope().getContributedFunctions(Name.identifier("toString"), NoLookupLocation.FROM_BACKEND).stream().filter(f -> f.getValueParameters().size() == 0 && KotlinBuiltIns.isString(f.getReturnType()) && f.getDispatchReceiverParameter() != null && f.getExtensionReceiverParameter() == null).findFirst().orElseThrow(() -> new AssertionError((Object)("'toString' not found in member scope of " + receiverClassDescriptor)));
        return typeMapper2.mapToCallableMethod(toStringDescriptor, false, OwnerKind.ERASED_INLINE_CLASS);
    }

    public static void genHashCode(MethodVisitor mv, InstructionAdapter iv, Type type2, JvmTarget jvmTarget) {
        if (type2.getSort() == 9) {
            Type elementType = AsmUtil.correctElementType(type2);
            if (elementType.getSort() == 10 || elementType.getSort() == 9) {
                iv.invokestatic("java/util/Arrays", "hashCode", "([Ljava/lang/Object;)I", false);
            } else {
                iv.invokestatic("java/util/Arrays", "hashCode", "(" + type2.getDescriptor() + ")I", false);
            }
        } else if (type2.getSort() == 10) {
            iv.invokevirtual("java/lang/Object", "hashCode", "()I", false);
        } else if (type2.getSort() == 1) {
            Label end = new Label();
            iv.dup();
            iv.ifeq(end);
            iv.pop();
            iv.iconst(1);
            iv.mark(end);
        } else if (JvmTarget.JVM_1_6 == jvmTarget) {
            if (type2.getSort() == 7) {
                DescriptorAsmUtil.genLongHashCode(mv, iv);
            } else if (type2.getSort() == 8) {
                iv.invokestatic("java/lang/Double", "doubleToLongBits", "(D)J", false);
                DescriptorAsmUtil.genLongHashCode(mv, iv);
            } else if (type2.getSort() == 6) {
                iv.invokestatic("java/lang/Float", "floatToIntBits", "(F)I", false);
            }
        } else {
            HashCode.Companion.invokeHashCode(iv, type2);
        }
    }

    private static void genLongHashCode(MethodVisitor mv, InstructionAdapter iv) {
        iv.dup2();
        iv.iconst(32);
        iv.ushr(Type.LONG_TYPE);
        iv.xor(Type.LONG_TYPE);
        mv.visitInsn(136);
    }

    @NotNull
    public static StackValue genEqualsForExpressionsOnStack(@NotNull IElementType opToken, @NotNull StackValue left, @NotNull StackValue right) {
        if (opToken == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(39);
        }
        if (left == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(40);
        }
        if (right == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(41);
        }
        Type leftType = left.type;
        Type rightType = right.type;
        if (AsmUtil.isPrimitive(leftType) && leftType == rightType) {
            StackValue stackValue = StackValue.cmp(opToken, leftType, left, right);
            if (stackValue == null) {
                DescriptorAsmUtil.$$$reportNull$$$0(42);
            }
            return stackValue;
        }
        StackValue stackValue = StackValue.operation(Type.BOOLEAN_TYPE, v -> {
            left.put(AsmTypes.OBJECT_TYPE, left.kotlinType, (InstructionAdapter)v);
            right.put(AsmTypes.OBJECT_TYPE, right.kotlinType, (InstructionAdapter)v);
            return DescriptorAsmUtil.genAreEqualCall(v, opToken);
        });
        if (stackValue == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(43);
        }
        return stackValue;
    }

    @NotNull
    public static BranchedValue genTotalOrderEqualsForExpressionOnStack(final @NotNull StackValue left, final @NotNull StackValue right, final @NotNull Type asmType) {
        if (left == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(44);
        }
        if (right == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(45);
        }
        if (asmType == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(46);
        }
        return new BranchedValue(left, right, asmType, 153){

            @Override
            public void condJump(@NotNull Label jumpLabel, @NotNull InstructionAdapter iv, boolean jumpIfFalse) {
                if (jumpLabel == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (iv == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (asmType.getSort() == 6) {
                    left.put(asmType, this.kotlinType, iv);
                    right.put(asmType, this.kotlinType, iv);
                    iv.invokestatic("java/lang/Float", "compare", "(FF)I", false);
                    iv.visitJumpInsn(this.patchOpcode(jumpIfFalse ? 154 : 153, iv), jumpLabel);
                } else if (asmType.getSort() == 8) {
                    left.put(asmType, this.kotlinType, iv);
                    right.put(asmType, this.kotlinType, iv);
                    iv.invokestatic("java/lang/Double", "compare", "(DD)I", false);
                    iv.visitJumpInsn(this.patchOpcode(jumpIfFalse ? 154 : 153, iv), jumpLabel);
                } else {
                    StackValue value2 = DescriptorAsmUtil.genEqualsForExpressionsOnStack(KtTokens.EQEQ, left, right);
                    BranchedValue.Companion.condJump(value2, jumpLabel, jumpIfFalse, iv);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "jumpLabel";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "iv";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/kotlin/codegen/DescriptorAsmUtil$1";
                objectArray[2] = "condJump";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    public static StackValue genEqualsBoxedOnStack(@NotNull IElementType opToken) {
        if (opToken == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(47);
        }
        StackValue stackValue = StackValue.operation(Type.BOOLEAN_TYPE, v -> DescriptorAsmUtil.genAreEqualCall(v, opToken));
        if (stackValue == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(48);
        }
        return stackValue;
    }

    public static void genAreEqualCall(InstructionAdapter v) {
        v.invokestatic("kotlin/jvm/internal/Intrinsics", "areEqual", "(Ljava/lang/Object;Ljava/lang/Object;)Z", false);
    }

    @NotNull
    private static Unit genAreEqualCall(InstructionAdapter v, @NotNull IElementType opToken) {
        if (opToken == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(49);
        }
        DescriptorAsmUtil.genAreEqualCall(v);
        if (opToken == KtTokens.EXCLEQ || opToken == KtTokens.EXCLEQEQEQ) {
            AsmUtil.genInvertBoolean(v);
        }
        Unit unit2 = Unit.INSTANCE;
        if (unit2 == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(50);
        }
        return unit2;
    }

    public static void genIEEE754EqualForNullableTypesCall(InstructionAdapter v, Type left, Type right) {
        v.invokestatic("kotlin/jvm/internal/Intrinsics", "areEqual", "(" + left.getDescriptor() + right.getDescriptor() + ")Z", false);
    }

    public static void genIncrement(Type baseType2, int myDelta, InstructionAdapter v) {
        Type operationType = AsmUtil.numberFunctionOperandType(baseType2);
        AsmUtil.numConst(myDelta, operationType, v);
        v.add(operationType);
        StackValue.coerce(operationType, baseType2, v);
    }

    static void genNotNullAssertionsForParameters(@NotNull InstructionAdapter v, @NotNull GenerationState state, @NotNull FunctionDescriptor descriptor2, @NotNull FrameMap frameMap) {
        if (v == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(51);
        }
        if (state == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(52);
        }
        if (descriptor2 == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(53);
        }
        if (frameMap == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(54);
        }
        if (state.isParamAssertionsDisabled()) {
            return;
        }
        if (descriptor2.isSuspend()) {
            return;
        }
        if (DescriptorAsmUtil.getVisibilityAccessFlag(descriptor2) == 2) {
            ReceiverParameterDescriptor receiverParameter;
            if (state.isReceiverAssertionsDisabled()) {
                return;
            }
            if (descriptor2.isOperator() && (receiverParameter = descriptor2.getExtensionReceiverParameter()) != null) {
                String name = DescriptorAsmUtil.getNameForReceiverParameter(descriptor2, state.getBindingContext(), state.getLanguageVersionSettings());
                DescriptorAsmUtil.genParamAssertion(v, state, frameMap, receiverParameter, name, descriptor2);
            }
            return;
        }
        ReceiverParameterDescriptor receiverParameter = descriptor2.getExtensionReceiverParameter();
        if (receiverParameter != null) {
            String name = DescriptorAsmUtil.getNameForReceiverParameter(descriptor2, state.getBindingContext(), state.getLanguageVersionSettings());
            DescriptorAsmUtil.genParamAssertion(v, state, frameMap, receiverParameter, name, descriptor2);
        }
        for (ValueParameterDescriptor parameter : descriptor2.getValueParameters()) {
            DescriptorAsmUtil.genParamAssertion(v, state, frameMap, parameter, parameter.getName().asString(), descriptor2);
        }
    }

    private static void genParamAssertion(@NotNull InstructionAdapter v, @NotNull GenerationState state, @NotNull FrameMap frameMap, @NotNull ParameterDescriptor parameter, @NotNull String name, @NotNull FunctionDescriptor containingDeclaration) {
        KotlinType type2;
        if (v == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(55);
        }
        if (state == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(56);
        }
        if (frameMap == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(57);
        }
        if (parameter == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(58);
        }
        if (name == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(59);
        }
        if (containingDeclaration == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(60);
        }
        if (TypeUtils.isNullableType(type2 = parameter.getType()) || InlineClassesUtilsKt.isNullableUnderlyingType(type2)) {
            return;
        }
        Type asmType = state.getTypeMapper().mapType(type2);
        if (asmType.getSort() == 10 || asmType.getSort() == 9) {
            StackValue value2;
            int index2;
            if (JvmCodegenUtil.isDeclarationOfBigArityFunctionInvoke(containingDeclaration) || JvmCodegenUtil.isDeclarationOfBigArityCreateCoroutineMethod(containingDeclaration)) {
                index2 = DescriptorAsmUtil.getIndexOfParameterInVarargInvokeArray(parameter);
                value2 = StackValue.arrayElement(AsmTypes.OBJECT_TYPE, null, StackValue.local(1, AsmUtil.getArrayType(AsmTypes.OBJECT_TYPE)), StackValue.constant(index2));
            } else {
                index2 = frameMap.getIndex(parameter);
                value2 = StackValue.local(index2, asmType);
            }
            value2.put(asmType, v);
            v.visitLdcInsn(name);
            String methodName = state.getUnifiedNullChecks() ? "checkNotNullParameter" : "checkParameterIsNotNull";
            v.invokestatic("kotlin/jvm/internal/Intrinsics", methodName, "(Ljava/lang/Object;Ljava/lang/String;)V", false);
        }
    }

    @NotNull
    public static StackValue genNotNullAssertions(final @NotNull GenerationState state, final @NotNull StackValue stackValue, final @Nullable RuntimeAssertionInfo runtimeAssertionInfo) {
        if (state == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(61);
        }
        if (stackValue == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(62);
        }
        if (state.isCallAssertionsDisabled()) {
            StackValue stackValue2 = stackValue;
            if (stackValue2 == null) {
                DescriptorAsmUtil.$$$reportNull$$$0(63);
            }
            return stackValue2;
        }
        if (runtimeAssertionInfo == null || !runtimeAssertionInfo.getNeedNotNullAssertion()) {
            StackValue stackValue3 = stackValue;
            if (stackValue3 == null) {
                DescriptorAsmUtil.$$$reportNull$$$0(64);
            }
            return stackValue3;
        }
        return new StackValue(stackValue.type, stackValue.kotlinType){

            @Override
            public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v) {
                if (type2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (v == null) {
                    2.$$$reportNull$$$0(1);
                }
                Type innerType = stackValue.type;
                KotlinType innerKotlinType = stackValue.kotlinType;
                stackValue.put(innerType, innerKotlinType, v);
                if (innerType.getSort() == 10 || innerType.getSort() == 9) {
                    v.dup();
                    v.visitLdcInsn(runtimeAssertionInfo.getMessage());
                    String methodName = state.getUnifiedNullChecks() ? "checkNotNullExpressionValue" : "checkExpressionValueIsNotNull";
                    v.invokestatic("kotlin/jvm/internal/Intrinsics", methodName, "(Ljava/lang/Object;Ljava/lang/String;)V", false);
                }
                StackValue.coerce(innerType, innerKotlinType, type2, kotlinType, v);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "type";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "v";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/kotlin/codegen/DescriptorAsmUtil$2";
                objectArray[2] = "putSelector";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static int getIndexOfParameterInVarargInvokeArray(@NotNull ParameterDescriptor parameter) {
        if (parameter == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(65);
        }
        if (parameter instanceof ReceiverParameterDescriptor) {
            return 0;
        }
        DeclarationDescriptor container = parameter.getContainingDeclaration();
        assert (parameter instanceof ValueParameterDescriptor) : "Non-extension-receiver parameter must be a value parameter: " + parameter;
        int extensionShift = ((CallableDescriptor)container).getExtensionReceiverParameter() == null ? 0 : 1;
        return extensionShift + ((ValueParameterDescriptor)parameter).getIndex();
    }

    public static void generateVarargInvokeArityAssert(InstructionAdapter v, int functionArity) {
        Label start = new Label();
        v.load(1, AsmUtil.getArrayType(AsmTypes.OBJECT_TYPE));
        v.arraylength();
        v.iconst(functionArity);
        v.ificmpeq(start);
        v.visitLdcInsn("Vararg argument must contain " + functionArity + " elements.");
        v.invokestatic("kotlin/jvm/internal/Intrinsics", "throwIllegalArgument", "(Ljava/lang/String;)V", false);
        v.visitLabel(start);
    }

    public static boolean isInstancePropertyWithStaticBackingField(@NotNull PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(66);
        }
        return propertyDescriptor.getKind() != CallableMemberDescriptor.Kind.FAKE_OVERRIDE && DescriptorUtils.isObject(propertyDescriptor.getContainingDeclaration());
    }

    public static int getVisibilityForBackingField(@NotNull PropertyDescriptor propertyDescriptor, boolean isDelegate) {
        boolean isExtensionProperty;
        if (propertyDescriptor == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(67);
        }
        boolean bl = isExtensionProperty = propertyDescriptor.getExtensionReceiverParameter() != null;
        if (isDelegate || isExtensionProperty) {
            return 2;
        }
        return propertyDescriptor.isLateInit() || JvmCodegenUtil.isConstOrHasJvmFieldAnnotation(propertyDescriptor) ? DescriptorAsmUtil.getVisibilityAccessFlag(DescriptorAsmUtil.descriptorForVisibility(propertyDescriptor)) : 2;
    }

    private static MemberDescriptor descriptorForVisibility(@NotNull PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(68);
        }
        if (!propertyDescriptor.isVar()) {
            return propertyDescriptor;
        }
        return propertyDescriptor.getSetter() != null ? propertyDescriptor.getSetter() : propertyDescriptor;
    }

    public static boolean isPropertyWithBackingFieldCopyInOuterClass(@NotNull PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(69);
        }
        DeclarationDescriptor propertyContainer = propertyDescriptor.getContainingDeclaration();
        return propertyDescriptor.isConst() && DescriptorUtils.isCompanionObject(propertyContainer) && JvmCodegenUtil.isJvmInterface(propertyContainer.getContainingDeclaration()) && DescriptorAsmUtil.getVisibilityForBackingField(propertyDescriptor, false) == 1;
    }

    public static void writeAnnotationData(@NotNull AnnotationVisitor av, @NotNull DescriptorSerializer serializer2, @NotNull MessageLite message) {
        if (av == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(70);
        }
        if (serializer2 == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(71);
        }
        if (message == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(72);
        }
        DescriptorAsmUtil.writeAnnotationData(av, message, (JvmStringTable)((Object)serializer2.getStringTable()));
    }

    public static void writeAnnotationData(@NotNull AnnotationVisitor av, @NotNull MessageLite message, @NotNull JvmStringTable stringTable2) {
        if (av == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(73);
        }
        if (message == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(74);
        }
        if (stringTable2 == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(75);
        }
        AsmUtil.writeAnnotationData(av, JvmProtoBufUtil.writeData(message, stringTable2), ArrayUtil.toStringArray(stringTable2.getStrings()));
    }

    public static void putJavaLangClassInstance(@NotNull InstructionAdapter v, @NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull KotlinTypeMapper typeMapper2) {
        if (v == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(76);
        }
        if (type2 == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(77);
        }
        if (typeMapper2 == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(78);
        }
        if (kotlinType != null && InlineClassesUtilsKt.isInlineClassType(kotlinType)) {
            v.aconst(DescriptorAsmUtil.boxType(type2, kotlinType, typeMapper2));
        } else if (AsmUtil.isPrimitive(type2)) {
            v.getstatic(AsmUtil.boxType(type2).getInternalName(), "TYPE", "Ljava/lang/Class;");
        } else {
            v.aconst(type2);
        }
    }

    public static int getReceiverIndex(@NotNull CodegenContext context, @NotNull CallableMemberDescriptor descriptor2) {
        OwnerKind kind;
        if (context == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(79);
        }
        if (descriptor2 == null) {
            DescriptorAsmUtil.$$$reportNull$$$0(80);
        }
        return (kind = context.getContextKind()) != OwnerKind.DEFAULT_IMPLS && DescriptorAsmUtil.isStaticMethod(kind, descriptor2) ? 0 : 1;
    }

    public static boolean isHiddenConstructor(FunctionDescriptor descriptor2) {
        if (!(descriptor2 instanceof ClassConstructorDescriptor)) {
            return false;
        }
        ClassConstructorDescriptor classConstructorDescriptor = (ClassConstructorDescriptor)descriptor2;
        if (InlineClassManglingRulesKt.shouldHideConstructorDueToInlineClassTypeValueParameters(descriptor2)) {
            return true;
        }
        return DescriptorUtils.isSealedClass(classConstructorDescriptor.getConstructedClass()) && classConstructorDescriptor.getVisibility() != DescriptorVisibilities.PUBLIC;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 42: 
            case 43: 
            case 48: 
            case 50: 
            case 63: 
            case 64: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 42: 
            case 43: 
            case 48: 
            case 50: 
            case 63: 
            case 64: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bindingContext";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageVersionSettings";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultName";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 42: 
            case 43: 
            case 48: 
            case 50: 
            case 63: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/DescriptorAsmUtil";
                break;
            }
            case 15: 
            case 35: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kotlinType";
                break;
            }
            case 17: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeMapper";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionDescriptor";
                break;
            }
            case 21: 
            case 52: 
            case 56: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deprecationResolver";
                break;
            }
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerClass";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberDescriptor";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closure";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generator";
                break;
            }
            case 36: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackValue";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiver";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiverType";
                break;
            }
            case 39: 
            case 47: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "opToken";
                break;
            }
            case 40: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 41: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "asmType";
                break;
            }
            case 51: 
            case 55: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "v";
                break;
            }
            case 54: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameMap";
                break;
            }
            case 58: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingDeclaration";
                break;
            }
            case 66: 
            case 67: 
            case 68: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyDescriptor";
                break;
            }
            case 70: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "av";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializer";
                break;
            }
            case 72: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringTable";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/DescriptorAsmUtil";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabeledThisNameForReceiver";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "boxType";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "genEqualsForExpressionsOnStack";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "genEqualsBoxedOnStack";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "genAreEqualCall";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "genNotNullAssertions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNameForCapturedReceiverField";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getNameForReceiverParameter";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getLabeledThisNameForReceiver";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 42: 
            case 43: 
            case 48: 
            case 50: 
            case 63: 
            case 64: {
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "boxType";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isInlineClassWrapperConstructor";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getCommonCallableFlags";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getVisibilityAccessFlag";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getVisibilityAccessFlagForClass";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getVisibilityAccessFlagForAnonymous";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getSyntheticAccessFlagForLambdaClass";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "calculateInnerClassAccessFlags";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "innerAccessFlagsForModalityAndKind";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getDeprecatedAccessFlag";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "specialCaseVisibility";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "genClosureFields";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "genInvokeAppendMethod";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "genToString";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "genEqualsForExpressionsOnStack";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "genTotalOrderEqualsForExpressionOnStack";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "genEqualsBoxedOnStack";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "genAreEqualCall";
                break;
            }
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "genNotNullAssertionsForParameters";
                break;
            }
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "genParamAssertion";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "genNotNullAssertions";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getIndexOfParameterInVarargInvokeArray";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "isInstancePropertyWithStaticBackingField";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "getVisibilityForBackingField";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "descriptorForVisibility";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "isPropertyWithBackingFieldCopyInOuterClass";
                break;
            }
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "writeAnnotationData";
                break;
            }
            case 76: 
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "putJavaLangClassInstance";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "getReceiverIndex";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 42: 
            case 43: 
            case 48: 
            case 50: 
            case 63: 
            case 64: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

