/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.diagnostics;

import com.intellij.openapi.util.CompositeModificationTracker;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.util.CachedValueImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtStubbedPsiUtil;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;
import org.jetbrains.kotlin.resolve.diagnostics.DiagnosticsWithSuppression;
import org.jetbrains.kotlin.resolve.diagnostics.KotlinSuppressCache;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u0015H\u0016J\u0006\u0010\u0016\u001a\u00020\u0017J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\f0\u001cJ\u0006\u0010\u001d\u001a\u00020\bJ\b\u0010\u001e\u001a\u00020\u0001H\u0016J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u000f2\u0006\u0010 \u001a\u00020\fH\u0002J\b\u0010!\u001a\u00020\bH\u0002J\u000e\u0010\"\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\fJ\b\u0010#\u001a\u00020\u0017H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u000fH\u0016R\u001c\u0010\u0006\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/resolve/diagnostics/MutableDiagnosticsWithSuppression;", "Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;", "suppressCache", "Lorg/jetbrains/kotlin/resolve/diagnostics/KotlinSuppressCache;", "delegateDiagnostics", "(Lorg/jetbrains/kotlin/resolve/diagnostics/KotlinSuppressCache;Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;)V", "cache", "Lcom/intellij/util/CachedValueImpl;", "Lorg/jetbrains/kotlin/resolve/diagnostics/DiagnosticsWithSuppression;", "kotlin.jvm.PlatformType", "diagnosticList", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "Lkotlin/collections/ArrayList;", "diagnosticsCallback", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink$DiagnosticsCallback;", "modificationTracker", "Lcom/intellij/openapi/util/CompositeModificationTracker;", "getModificationTracker", "()Lcom/intellij/openapi/util/CompositeModificationTracker;", "all", "", "clear", "", "forElement", "psiElement", "Lcom/intellij/psi/PsiElement;", "getOwnDiagnostics", "", "getReadonlyView", "noSuppression", "onTheFlyDiagnosticsCallback", "diagnostic", "readonlyView", "report", "resetCallback", "setCallbackIfNotSet", "", "callback", "frontend"})
public final class MutableDiagnosticsWithSuppression
implements Diagnostics {
    @NotNull
    private final KotlinSuppressCache suppressCache;
    @NotNull
    private final Diagnostics delegateDiagnostics;
    @NotNull
    private final ArrayList<Diagnostic> diagnosticList;
    @Nullable
    private volatile DiagnosticSink.DiagnosticsCallback diagnosticsCallback;
    @NotNull
    private final CachedValueImpl<DiagnosticsWithSuppression> cache;
    @NotNull
    private final CompositeModificationTracker modificationTracker;

    public MutableDiagnosticsWithSuppression(@NotNull KotlinSuppressCache suppressCache, @NotNull Diagnostics delegateDiagnostics) {
        Intrinsics.checkNotNullParameter(suppressCache, "suppressCache");
        Intrinsics.checkNotNullParameter(delegateDiagnostics, "delegateDiagnostics");
        this.suppressCache = suppressCache;
        this.delegateDiagnostics = delegateDiagnostics;
        this.diagnosticList = new ArrayList();
        this.cache = new CachedValueImpl(() -> MutableDiagnosticsWithSuppression.cache$lambda-0(this));
        this.modificationTracker = new CompositeModificationTracker(this.delegateDiagnostics.getModificationTracker());
    }

    private final DiagnosticsWithSuppression readonlyView() {
        Object object = this.cache.getValue();
        Intrinsics.checkNotNull(object);
        return (DiagnosticsWithSuppression)object;
    }

    @NotNull
    public CompositeModificationTracker getModificationTracker() {
        return this.modificationTracker;
    }

    @Override
    @NotNull
    public Collection<Diagnostic> all() {
        Collection<Diagnostic> collection = this.readonlyView().all();
        Intrinsics.checkNotNullExpressionValue(collection, "readonlyView().all()");
        return collection;
    }

    @Override
    @NotNull
    public Collection<Diagnostic> forElement(@NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter(psiElement, "psiElement");
        Collection<Diagnostic> collection = this.readonlyView().forElement(psiElement);
        Intrinsics.checkNotNullExpressionValue(collection, "readonlyView().forElement(psiElement)");
        return collection;
    }

    @Override
    @NotNull
    public Diagnostics noSuppression() {
        Diagnostics diagnostics2 = this.readonlyView().noSuppression();
        Intrinsics.checkNotNullExpressionValue(diagnostics2, "readonlyView().noSuppression()");
        return diagnostics2;
    }

    @Override
    public boolean setCallbackIfNotSet(@NotNull DiagnosticSink.DiagnosticsCallback callback) {
        boolean bl;
        Intrinsics.checkNotNullParameter(callback, "callback");
        if (this.diagnosticsCallback == null) {
            this.diagnosticsCallback = callback;
            this.delegateDiagnostics.setCallbackIfNotSet(callback);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public void resetCallback() {
        this.diagnosticsCallback = null;
        this.delegateDiagnostics.resetCallback();
    }

    @NotNull
    public final List<Diagnostic> getOwnDiagnostics() {
        return this.diagnosticList;
    }

    public final void report(@NotNull Diagnostic diagnostic) {
        Intrinsics.checkNotNullParameter(diagnostic, "diagnostic");
        DiagnosticSink.DiagnosticsCallback diagnosticsCallback = this.onTheFlyDiagnosticsCallback(diagnostic);
        if (diagnosticsCallback != null) {
            diagnosticsCallback.callback(diagnostic);
        }
        this.diagnosticList.add(diagnostic);
        this.getModificationTracker().incModificationCount();
    }

    private final DiagnosticSink.DiagnosticsCallback onTheFlyDiagnosticsCallback(Diagnostic diagnostic) {
        DiagnosticSink.DiagnosticsCallback diagnosticsCallback;
        DiagnosticSink.DiagnosticsCallback it = diagnosticsCallback = this.diagnosticsCallback;
        boolean bl = false;
        return this.diagnosticsCallback != null && KtStubbedPsiUtil.getPsiOrStubParent(diagnostic.getPsiElement(), KtAnnotated.class, false) == null && this.suppressCache.getFilter().invoke(diagnostic).booleanValue() ? diagnosticsCallback : null;
    }

    public final void clear() {
        this.diagnosticList.clear();
        this.getModificationTracker().incModificationCount();
    }

    @NotNull
    public final DiagnosticsWithSuppression getReadonlyView() {
        return this.readonlyView();
    }

    @Override
    public boolean isEmpty() {
        return Diagnostics.DefaultImpls.isEmpty(this);
    }

    @Override
    @NotNull
    public Iterator<Diagnostic> iterator() {
        return Diagnostics.DefaultImpls.iterator(this);
    }

    @Override
    public void setCallback(@NotNull DiagnosticSink.DiagnosticsCallback callback) {
        Diagnostics.DefaultImpls.setCallback(this, callback);
    }

    private static final CachedValueProvider.Result cache$lambda-0(MutableDiagnosticsWithSuppression this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        List<Diagnostic> allDiagnostics = CollectionsKt.plus(this$0.delegateDiagnostics.noSuppression().all(), (Iterable)this$0.diagnosticList);
        Object[] objectArray = new Object[]{this$0.getModificationTracker()};
        return new CachedValueProvider.Result((Object)new DiagnosticsWithSuppression(this$0.suppressCache, (Collection<Diagnostic>)allDiagnostics), objectArray);
    }
}

