/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.jvm.JavaToKotlinClassMap;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.jvm.checkers.BadInheritedJavaSignaturesCheckerKt;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/BadInheritedJavaSignaturesChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend.java"})
public final class BadInheritedJavaSignaturesChecker
implements DeclarationChecker {
    @NotNull
    public static final BadInheritedJavaSignaturesChecker INSTANCE = new BadInheritedJavaSignaturesChecker();

    private BadInheritedJavaSignaturesChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        DeclarationDescriptor badSignatureOverriddenDescriptor;
        block7: {
            DeclarationDescriptor declarationDescriptor;
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
            Intrinsics.checkNotNullParameter(context, "context");
            if (!(descriptor2 instanceof ClassDescriptor)) {
                return;
            }
            MemberScope memberScope2 = ((ClassDescriptor)descriptor2).getUnsubstitutedMemberScope();
            Intrinsics.checkNotNullExpressionValue(memberScope2, "descriptor.unsubstitutedMemberScope");
            for (DeclarationDescriptor p0 : (Iterable)ResolutionScope.DefaultImpls.getContributedDescriptors$default(memberScope2, null, null, 3, null)) {
                boolean bl = false;
                DeclarationDescriptor declarationDescriptor2 = BadInheritedJavaSignaturesCheckerKt.access$findFirstBadJavaSignatureOverridden(p0);
                if (declarationDescriptor2 == null) continue;
                declarationDescriptor = declarationDescriptor2;
                break block7;
            }
            declarationDescriptor = badSignatureOverriddenDescriptor = null;
        }
        if (badSignatureOverriddenDescriptor != null) {
            PsiElement psiElement;
            Object object;
            KtDeclaration ktDeclaration = declaration;
            if (ktDeclaration instanceof KtClass) {
                object = ((KtClass)declaration).getNameIdentifier();
                if (object == null) {
                    object = ((KtClass)declaration).getClassOrInterfaceKeyword();
                }
            } else {
                object = psiElement = ktDeclaration instanceof KtObjectDeclaration ? ((KtObjectDeclaration)declaration).getObjectKeyword() : null;
            }
            if (object == null) {
                psiElement = declaration;
            }
            PsiElement reportOn = psiElement;
            String renderedDescriptor = DescriptorRenderer.COMPACT_WITH_SHORT_TYPES.render(badSignatureOverriddenDescriptor);
            context.getTrace().report(Errors.UNSUPPORTED.on(reportOn, "Inheritance of a Java member referencing '" + JavaToKotlinClassMap.INSTANCE.getFUNCTION_N_FQ_NAME() + "': " + renderedDescriptor));
        }
    }
}

