/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.build;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.KProperty1;
import kotlin.reflect.full.KClasses;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u001a\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a$\u0010\u0000\u001a\u0004\u0018\u0001H\u0001\"\n\b\u0000\u0010\u0001\u0018\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0086\b\u00a2\u0006\u0002\u0010\u0005\u001a-\u0010\u0000\u001a\u0004\u0018\u0001H\u0001\"\b\b\u0000\u0010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0007\u00a2\u0006\u0002\u0010\b\u001a\"\u0010\t\u001a\u00020\u0004\"\n\b\u0000\u0010\u0001\u0018\u0001*\u00020\u00022\u0006\u0010\n\u001a\u0002H\u0001H\u0086\b\u00a2\u0006\u0002\u0010\u000b\u001a+\u0010\t\u001a\u00020\u0004\"\b\b\u0000\u0010\u0001*\u00020\u00022\u0006\u0010\n\u001a\u0002H\u00012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0007\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"deserializeFromPlainText", "T", "", "str", "", "(Ljava/lang/String;)Ljava/lang/Object;", "klass", "Lkotlin/reflect/KClass;", "(Ljava/lang/String;Lkotlin/reflect/KClass;)Ljava/lang/Object;", "serializeToPlainText", "instance", "(Ljava/lang/Object;)Ljava/lang/String;", "(Ljava/lang/Object;Lkotlin/reflect/KClass;)Ljava/lang/String;", "kotlin-build-common"})
public final class SerializationUtilsKt {
    public static final /* synthetic */ <T> String serializeToPlainText(T instance) {
        Intrinsics.checkNotNullParameter(instance, "instance");
        boolean $i$f$serializeToPlainText = false;
        Intrinsics.reifiedOperationMarker(4, "T");
        return SerializationUtilsKt.serializeToPlainText(instance, Reflection.getOrCreateKotlinClass(Object.class));
    }

    @NotNull
    public static final <T> String serializeToPlainText(@NotNull T instance, @NotNull KClass<T> klass) {
        Intrinsics.checkNotNullParameter(instance, "instance");
        Intrinsics.checkNotNullParameter(klass, "klass");
        ArrayList<String> lines = new ArrayList<String>();
        for (KProperty1<T, ?> property2 : KClasses.getMemberProperties(klass)) {
            Object value2 = property2.get(instance);
            if (value2 == null) continue;
            lines.add(property2.getName() + '=' + value2);
        }
        return CollectionsKt.joinToString$default(lines, "\n", null, null, 0, null, null, 62, null);
    }

    public static final /* synthetic */ <T> T deserializeFromPlainText(String str) {
        Intrinsics.checkNotNullParameter(str, "str");
        boolean $i$f$deserializeFromPlainText = false;
        Intrinsics.reifiedOperationMarker(4, "T");
        return SerializationUtilsKt.deserializeFromPlainText(str, Reflection.getOrCreateKotlinClass(Object.class));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final <T> T deserializeFromPlainText(@NotNull String str, @NotNull KClass<T> klass) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter(str, "str");
        Intrinsics.checkNotNullParameter(klass, "klass");
        ArrayList<Integer> args2 = new ArrayList<Integer>();
        Object object = new String[]{"\n"};
        object = StringsKt.split$default((CharSequence)str, object, false, 0, 6, null);
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String p0 = (String)element$iv$iv;
            boolean bl = false;
            if (!(!StringsKt.isBlank(p0))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv2;
            String it = (String)element$iv$iv;
            boolean bl = false;
            Pair<String, String> pair = TuplesKt.to(StringsKt.substringBefore$default(it, "=", null, 2, null), StringsKt.substringAfter$default(it, "=", null, 2, null));
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map properties2 = destination$iv$iv2;
        KFunction<T> kFunction = KClasses.getPrimaryConstructor(klass);
        if (kFunction == null) {
            throw new IllegalStateException(JvmClassMappingKt.getJavaClass(klass) + " does not have primary constructor");
        }
        KFunction<T> primaryConstructor2 = kFunction;
        Iterable $this$sortedBy$iv = primaryConstructor2.getParameters();
        boolean $i$f$sortedBy = false;
        for (KParameter param : CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                KParameter it = (KParameter)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getIndex());
                it = (KParameter)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.getIndex());
            }
        })) {
            Object object2;
            String argumentString = (String)properties2.get(param.getName());
            if (argumentString == null) {
                if (param.getType().isMarkedNullable()) {
                    args2.add(null);
                    continue;
                }
                return null;
            }
            KClassifier kClassifier = param.getType().getClassifier();
            if (Intrinsics.areEqual(kClassifier, Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
                object2 = Integer.parseInt(argumentString);
            } else if (Intrinsics.areEqual(kClassifier, Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
                object2 = Boolean.parseBoolean(argumentString);
            } else if (Intrinsics.areEqual(kClassifier, Reflection.getOrCreateKotlinClass(String.class))) {
                object2 = argumentString;
            } else {
                throw new IllegalStateException("Unexpected property type: " + param.getType());
            }
            Integer argument2 = object2;
            args2.add(argument2);
        }
        Collection $this$toTypedArray$iv = args2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
        Intrinsics.checkNotNull(objectArray, "null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        Object[] objectArray2 = objectArray;
        return (T)primaryConstructor2.call(Arrays.copyOf(objectArray2, objectArray2.length));
    }
}

