/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.collectors.components;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.CheckersComponentKt;
import org.jetbrains.kotlin.fir.analysis.cfa.FirControlFlowAnalyzer;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationCheckers;
import org.jetbrains.kotlin.fir.analysis.collectors.components.AbstractDiagnosticCollectorComponent;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.references.FirControlFlowGraphReference;
import org.jetbrains.kotlin.fir.resolve.dfa.FirControlFlowGraphReferenceImplKt;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraph;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\"\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u001f\u001a\u00020\f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\"\u001a\u00020\f2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010%\u001a\u00020\f2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/fir/analysis/collectors/components/ControlFlowAnalysisDiagnosticComponent;", "Lorg/jetbrains/kotlin/fir/analysis/collectors/components/AbstractDiagnosticCollectorComponent;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "declarationCheckers", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/DeclarationCheckers;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/DeclarationCheckers;)V", "controlFlowAnalyzer", "Lorg/jetbrains/kotlin/fir/analysis/cfa/FirControlFlowAnalyzer;", "visitAnonymousObject", "", "anonymousObject", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousObject;", "data", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "visitClass", "klass", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "controlFlowGraphReference", "Lorg/jetbrains/kotlin/fir/references/FirControlFlowGraphReference;", "visitConstructor", "constructor", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "visitFunction", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "visitProperty", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "visitPropertyAccessor", "propertyAccessor", "Lorg/jetbrains/kotlin/fir/declarations/FirPropertyAccessor;", "visitRegularClass", "regularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "visitSimpleFunction", "simpleFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "checkers"})
public final class ControlFlowAnalysisDiagnosticComponent
extends AbstractDiagnosticCollectorComponent {
    @NotNull
    private final FirControlFlowAnalyzer controlFlowAnalyzer;

    public ControlFlowAnalysisDiagnosticComponent(@NotNull FirSession session2, @NotNull DiagnosticReporter reporter, @NotNull DeclarationCheckers declarationCheckers) {
        Intrinsics.checkNotNullParameter(session2, "session");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(declarationCheckers, "declarationCheckers");
        super(session2, reporter);
        this.controlFlowAnalyzer = new FirControlFlowAnalyzer(session2, declarationCheckers);
    }

    public /* synthetic */ ControlFlowAnalysisDiagnosticComponent(FirSession firSession, DiagnosticReporter diagnosticReporter, DeclarationCheckers declarationCheckers, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            declarationCheckers = CheckersComponentKt.getCheckersComponent(firSession).getDeclarationCheckers();
        }
        this(firSession, diagnosticReporter, declarationCheckers);
    }

    @Override
    public void visitRegularClass(@NotNull FirRegularClass regularClass, @NotNull CheckerContext data2) {
        Intrinsics.checkNotNullParameter(regularClass, "regularClass");
        Intrinsics.checkNotNullParameter(data2, "data");
        this.visitClass(regularClass, regularClass.getControlFlowGraphReference(), data2);
    }

    @Override
    public void visitAnonymousObject(@NotNull FirAnonymousObject anonymousObject, @NotNull CheckerContext data2) {
        Intrinsics.checkNotNullParameter(anonymousObject, "anonymousObject");
        Intrinsics.checkNotNullParameter(data2, "data");
        this.visitClass(anonymousObject, anonymousObject.getControlFlowGraphReference(), data2);
    }

    private final void visitClass(FirClass klass, FirControlFlowGraphReference controlFlowGraphReference, CheckerContext data2) {
        Object object = controlFlowGraphReference;
        if (object == null || (object = FirControlFlowGraphReferenceImplKt.getControlFlowGraph((FirControlFlowGraphReference)object)) == null) {
            return;
        }
        Object graph2 = object;
        this.controlFlowAnalyzer.analyzeClassInitializer(klass, (ControlFlowGraph)graph2, data2, this.getReporter());
    }

    @Override
    public void visitProperty(@NotNull FirProperty property2, @NotNull CheckerContext data2) {
        Intrinsics.checkNotNullParameter(property2, "property");
        Intrinsics.checkNotNullParameter(data2, "data");
        Object object = property2.getControlFlowGraphReference();
        if (object == null || (object = FirControlFlowGraphReferenceImplKt.getControlFlowGraph((FirControlFlowGraphReference)object)) == null) {
            return;
        }
        Object graph2 = object;
        this.controlFlowAnalyzer.analyzePropertyInitializer(property2, (ControlFlowGraph)graph2, data2, this.getReporter());
    }

    @Override
    public void visitFunction(@NotNull FirFunction function2, @NotNull CheckerContext data2) {
        Intrinsics.checkNotNullParameter(function2, "function");
        Intrinsics.checkNotNullParameter(data2, "data");
        Object object = function2.getControlFlowGraphReference();
        if (object == null || (object = FirControlFlowGraphReferenceImplKt.getControlFlowGraph((FirControlFlowGraphReference)object)) == null) {
            return;
        }
        Object graph2 = object;
        this.controlFlowAnalyzer.analyzeFunction(function2, (ControlFlowGraph)graph2, data2, this.getReporter());
    }

    @Override
    public void visitSimpleFunction(@NotNull FirSimpleFunction simpleFunction, @NotNull CheckerContext data2) {
        Intrinsics.checkNotNullParameter(simpleFunction, "simpleFunction");
        Intrinsics.checkNotNullParameter(data2, "data");
        this.visitFunction((FirFunction)simpleFunction, data2);
    }

    @Override
    public void visitPropertyAccessor(@NotNull FirPropertyAccessor propertyAccessor, @NotNull CheckerContext data2) {
        Intrinsics.checkNotNullParameter(propertyAccessor, "propertyAccessor");
        Intrinsics.checkNotNullParameter(data2, "data");
        Object object = propertyAccessor.getControlFlowGraphReference();
        if (object == null || (object = FirControlFlowGraphReferenceImplKt.getControlFlowGraph((FirControlFlowGraphReference)object)) == null) {
            return;
        }
        Object graph2 = object;
        this.controlFlowAnalyzer.analyzePropertyAccessor(propertyAccessor, (ControlFlowGraph)graph2, data2, this.getReporter());
    }

    @Override
    public void visitConstructor(@NotNull FirConstructor constructor2, @NotNull CheckerContext data2) {
        Intrinsics.checkNotNullParameter(constructor2, "constructor");
        Intrinsics.checkNotNullParameter(data2, "data");
        this.visitFunction((FirFunction)constructor2, data2);
    }
}

