/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.psi.text;

import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.decompiler.psi.text.ByDescriptorIndexer;
import org.jetbrains.kotlin.analysis.decompiler.psi.text.DecompiledText;
import org.jetbrains.kotlin.analysis.decompiler.psi.text.DecompiledTextIndex;
import org.jetbrains.kotlin.analysis.decompiler.psi.text.DecompiledTextIndexer;
import org.jetbrains.kotlin.contracts.description.AbstractContractProvider;
import org.jetbrains.kotlin.contracts.description.ContractProviderKey;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.renderer.DescriptorRendererModifier;
import org.jetbrains.kotlin.renderer.DescriptorRendererOptions;
import org.jetbrains.kotlin.renderer.RenderingUtilsKt;
import org.jetbrains.kotlin.resolve.DataClassDescriptorResolver;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\u001a8\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0012\b\u0002\u0010\u000e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u000f\u001a\n\u0010\u0011\u001a\u00020\u0012*\u00020\u0013\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"DECOMPILED_CODE_COMMENT", "", "DECOMPILED_COMMENT_FOR_PARAMETER", "DECOMPILED_CONTRACT_STUB", "FLEXIBLE_TYPE_COMMENT", "buildDecompiledText", "Lorg/jetbrains/kotlin/analysis/decompiler/psi/text/DecompiledText;", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "descriptors", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "descriptorRenderer", "Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;", "indexers", "", "Lorg/jetbrains/kotlin/analysis/decompiler/psi/text/DecompiledTextIndexer;", "defaultDecompilerRendererOptions", "", "Lorg/jetbrains/kotlin/renderer/DescriptorRendererOptions;", "decompiler-to-psi"})
public final class BuildDecompiledTextKt {
    public static final void defaultDecompilerRendererOptions(@NotNull DescriptorRendererOptions $this$defaultDecompilerRendererOptions) {
        Intrinsics.checkNotNullParameter($this$defaultDecompilerRendererOptions, "<this>");
        $this$defaultDecompilerRendererOptions.setWithDefinedIn(false);
        $this$defaultDecompilerRendererOptions.setClassWithPrimaryConstructor(true);
        $this$defaultDecompilerRendererOptions.setSecondaryConstructorsAsPrimary(false);
        $this$defaultDecompilerRendererOptions.setModifiers(DescriptorRendererModifier.ALL);
        $this$defaultDecompilerRendererOptions.setExcludedTypeAnnotationClasses(SetsKt.emptySet());
        $this$defaultDecompilerRendererOptions.setAlwaysRenderModifiers(true);
        $this$defaultDecompilerRendererOptions.setParameterNamesInFunctionalTypes(false);
    }

    @NotNull
    public static final DecompiledText buildDecompiledText(@NotNull FqName packageFqName, @NotNull List<? extends DeclarationDescriptor> descriptors, @NotNull DescriptorRenderer descriptorRenderer2, @NotNull Collection<? extends DecompiledTextIndexer<?>> indexers) {
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        Intrinsics.checkNotNullParameter(descriptors, "descriptors");
        Intrinsics.checkNotNullParameter(descriptorRenderer2, "descriptorRenderer");
        Intrinsics.checkNotNullParameter(indexers, "indexers");
        StringBuilder builder2 = new StringBuilder();
        DecompiledTextIndex textIndex = new DecompiledTextIndex(indexers);
        BuildDecompiledTextKt.buildDecompiledText$appendDecompiledTextAndPackageName(builder2, packageFqName);
        for (DeclarationDescriptor declarationDescriptor : descriptors) {
            BuildDecompiledTextKt.buildDecompiledText$appendDescriptor$default(builder2, descriptorRenderer2, textIndex, declarationDescriptor, "", null, 32, null);
            builder2.append("\n");
        }
        String string2 = builder2.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "builder.toString()");
        return new DecompiledText(string2, textIndex);
    }

    public static /* synthetic */ DecompiledText buildDecompiledText$default(FqName fqName2, List list2, DescriptorRenderer descriptorRenderer2, Collection collection, int n, Object object) {
        if ((n & 8) != 0) {
            collection = CollectionsKt.listOf(ByDescriptorIndexer.INSTANCE);
        }
        return BuildDecompiledTextKt.buildDecompiledText(fqName2, list2, descriptorRenderer2, collection);
    }

    private static final void buildDecompiledText$appendDecompiledTextAndPackageName(StringBuilder builder2, FqName $packageFqName) {
        builder2.append("// IntelliJ API Decompiler stub source generated from a class file\n// Implementation of methods is not available");
        builder2.append("\n\n");
        if (!$packageFqName.isRoot()) {
            builder2.append("package ").append(RenderingUtilsKt.render($packageFqName)).append("\n\n");
        }
    }

    private static final void buildDecompiledText$indexDescriptor(DecompiledTextIndex textIndex, DeclarationDescriptor descriptor2, int startOffset, int endOffset) {
        textIndex.addToIndex(descriptor2, new TextRange(startOffset, endOffset));
    }

    private static final boolean buildDecompiledText$isConsideredSynthetic(CallableMemberDescriptor $this$buildDecompiledText_u24isConsideredSynthetic) {
        boolean bl;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$buildDecompiledText_u24isConsideredSynthetic.getKind().ordinal()]) {
            case 1: {
                bl = false;
                break;
            }
            case 2: 
            case 3: {
                bl = true;
                break;
            }
            case 4: {
                Name name = $this$buildDecompiledText_u24isConsideredSynthetic.getName();
                Intrinsics.checkNotNullExpressionValue(name, "name");
                if (!DataClassDescriptorResolver.INSTANCE.isComponentLike(name)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    private static final void buildDecompiledText$appendDescriptor$newlineExceptFirst(Ref.BooleanRef firstPassed, StringBuilder builder2) {
        if (firstPassed.element) {
            builder2.append("\n");
        } else {
            firstPassed.element = true;
        }
    }

    private static final void buildDecompiledText$appendDescriptor(StringBuilder builder2, DescriptorRenderer $descriptorRenderer, DecompiledTextIndex textIndex, DeclarationDescriptor descriptor2, String indent, Boolean lastEnumEntry) {
        ClassConstructorDescriptor primaryConstructor2;
        int startOffset = builder2.length();
        if (DescriptorUtils.isEnumEntry(descriptor2)) {
            for (AnnotationDescriptor annotation2 : descriptor2.getAnnotations()) {
                builder2.append(DescriptorRenderer.renderAnnotation$default($descriptorRenderer, annotation2, null, 2, null));
                builder2.append(" ");
            }
            String string2 = descriptor2.getName().asString();
            Intrinsics.checkNotNullExpressionValue(string2, "descriptor.name.asString()");
            builder2.append(KtPsiUtilKt.quoteIfNeeded(string2));
            Boolean bl = lastEnumEntry;
            Intrinsics.checkNotNull(bl);
            builder2.append(bl != false ? ";" : ",");
        } else {
            builder2.append(StringsKt.replace$default($descriptorRenderer.render(descriptor2), "= ...", "/* = compiled code */", false, 4, null));
        }
        int endOffset = builder2.length();
        if (descriptor2 instanceof CallableDescriptor) {
            KotlinType kotlinType = ((CallableDescriptor)descriptor2).getReturnType();
            Intrinsics.checkNotNull(kotlinType);
            if (FlexibleTypesKt.isFlexible(kotlinType)) {
                builder2.append(" ").append("/* platform type */");
            }
        }
        if (descriptor2 instanceof FunctionDescriptor || descriptor2 instanceof PropertyDescriptor) {
            if (((MemberDescriptor)descriptor2).getModality() != Modality.ABSTRACT) {
                if (descriptor2 instanceof FunctionDescriptor) {
                    StringBuilder $this$buildDecompiledText_u24appendDescriptor_u24lambda_u240 = builder2;
                    boolean bl = false;
                    $this$buildDecompiledText_u24appendDescriptor_u24lambda_u240.append(" { ");
                    AbstractContractProvider abstractContractProvider = (AbstractContractProvider)((FunctionDescriptor)descriptor2).getUserData(ContractProviderKey.INSTANCE);
                    if ((abstractContractProvider != null ? abstractContractProvider.getContractDescription() : null) != null) {
                        $this$buildDecompiledText_u24appendDescriptor_u24lambda_u240.append("contract { /* compiled contract */ }").append("; ");
                    }
                    $this$buildDecompiledText_u24appendDescriptor_u24lambda_u240.append("/* compiled code */").append(" }");
                } else {
                    builder2.append(" ").append("/* compiled code */");
                }
                endOffset = builder2.length();
            }
        } else if (descriptor2 instanceof ClassDescriptor && !DescriptorUtils.isEnumEntry(descriptor2)) {
            builder2.append(" {\n");
            String subindent = indent + "    ";
            Ref.BooleanRef firstPassed = new Ref.BooleanRef();
            List allDescriptors2 = CollectionsKt.plus((Collection)DescriptorUtilsKt.getSecondaryConstructors((ClassDescriptor)descriptor2), (Iterable)ResolutionScope.DefaultImpls.getContributedDescriptors$default(((ClassDescriptor)descriptor2).getDefaultType().getMemberScope(), null, null, 3, null));
            Iterable $this$partition$iv = allDescriptors2;
            boolean $i$f$partition = false;
            Object first$iv = new ArrayList();
            ArrayList second$iv = new ArrayList();
            for (Object element$iv : $this$partition$iv) {
                DeclarationDescriptor p0 = (DeclarationDescriptor)element$iv;
                boolean bl = false;
                if (DescriptorUtils.isEnumEntry(p0)) {
                    ((ArrayList)first$iv).add(element$iv);
                    continue;
                }
                second$iv.add(element$iv);
            }
            Pair pair = new Pair(first$iv, second$iv);
            List enumEntries = pair.component1();
            List members2 = pair.component2();
            first$iv = enumEntries.iterator();
            int n = 0;
            while (first$iv.hasNext()) {
                int index2 = n++;
                DeclarationDescriptor enumEntry = (DeclarationDescriptor)first$iv.next();
                BuildDecompiledTextKt.buildDecompiledText$appendDescriptor$newlineExceptFirst(firstPassed, builder2);
                builder2.append(subindent);
                Intrinsics.checkNotNullExpressionValue(enumEntry, "enumEntry");
                BuildDecompiledTextKt.buildDecompiledText$appendDescriptor(builder2, $descriptorRenderer, textIndex, enumEntry, subindent, index2 == CollectionsKt.getLastIndex(enumEntries));
            }
            ClassDescriptor companionObject2 = ((ClassDescriptor)descriptor2).getCompanionObjectDescriptor();
            if (companionObject2 != null) {
                BuildDecompiledTextKt.buildDecompiledText$appendDescriptor$newlineExceptFirst(firstPassed, builder2);
                builder2.append(subindent);
                BuildDecompiledTextKt.buildDecompiledText$appendDescriptor$default(builder2, $descriptorRenderer, textIndex, companionObject2, subindent, null, 32, null);
            }
            for (DeclarationDescriptor member2 : members2) {
                if (!Intrinsics.areEqual(member2.getContainingDeclaration(), descriptor2) || Intrinsics.areEqual(member2, companionObject2) || member2 instanceof CallableMemberDescriptor && BuildDecompiledTextKt.buildDecompiledText$isConsideredSynthetic((CallableMemberDescriptor)member2)) continue;
                BuildDecompiledTextKt.buildDecompiledText$appendDescriptor$newlineExceptFirst(firstPassed, builder2);
                builder2.append(subindent);
                Intrinsics.checkNotNullExpressionValue(member2, "member");
                BuildDecompiledTextKt.buildDecompiledText$appendDescriptor$default(builder2, $descriptorRenderer, textIndex, member2, subindent, null, 32, null);
            }
            builder2.append(indent).append("}");
            endOffset = builder2.length();
        }
        builder2.append("\n");
        BuildDecompiledTextKt.buildDecompiledText$indexDescriptor(textIndex, descriptor2, startOffset, endOffset);
        if (descriptor2 instanceof ClassDescriptor && (primaryConstructor2 = ((ClassDescriptor)descriptor2).getUnsubstitutedPrimaryConstructor()) != null) {
            BuildDecompiledTextKt.buildDecompiledText$indexDescriptor(textIndex, primaryConstructor2, startOffset, endOffset);
        }
    }

    static /* synthetic */ void buildDecompiledText$appendDescriptor$default(StringBuilder stringBuilder2, DescriptorRenderer descriptorRenderer2, DecompiledTextIndex decompiledTextIndex, DeclarationDescriptor declarationDescriptor, String string2, Boolean bl, int n, Object object) {
        if ((n & 0x20) != 0) {
            bl = null;
        }
        BuildDecompiledTextKt.buildDecompiledText$appendDescriptor(stringBuilder2, descriptorRenderer2, decompiledTextIndex, declarationDescriptor, string2, bl);
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CallableMemberDescriptor.Kind.values().length];
            try {
                nArray[CallableMemberDescriptor.Kind.DECLARATION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CallableMemberDescriptor.Kind.FAKE_OVERRIDE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CallableMemberDescriptor.Kind.DELEGATION.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CallableMemberDescriptor.Kind.SYNTHESIZED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

