/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.psi.text;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMember;
import com.intellij.psi.impl.compiled.SignatureParsing;
import com.intellij.util.cls.ClsFormatException;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.decompiler.psi.text.ByJvmSignatureIndexer;
import org.jetbrains.kotlin.analysis.decompiler.psi.text.ByJvmSignatureIndexerKt;
import org.jetbrains.kotlin.analysis.decompiler.psi.text.DecompiledTextIndexer;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002\u001a\f\u0010\n\u001a\u00020\u0005*\u00020\u000bH\u0002\u001a\u0010\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\b*\u00020\u000e\u001a\u0012\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\b*\u00020\u000bH\u0002\"\u0015\u0010\u0000\u001a\u0006\u0012\u0002\b\u00030\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u000f"}, d2={"BySignatureIndexer", "Lorg/jetbrains/kotlin/analysis/decompiler/psi/text/DecompiledTextIndexer;", "getBySignatureIndexer", "()Lorg/jetbrains/kotlin/analysis/decompiler/psi/text/DecompiledTextIndexer;", "excludeParametersFromDescriptor", "", "descriptor", "omittedParameters", "", "", "desc", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "relativeClassName", "Lorg/jetbrains/kotlin/name/Name;", "Lcom/intellij/psi/PsiMember;", "decompiler-to-psi"})
public final class ByJvmSignatureIndexerKt {
    @NotNull
    private static final DecompiledTextIndexer<?> BySignatureIndexer = ByJvmSignatureIndexer.INSTANCE;

    /*
     * WARNING - void declaration
     */
    private static final String excludeParametersFromDescriptor(String descriptor2, List<Integer> omittedParameters) {
        void $this$filterIndexedTo$iv$iv;
        void $this$filterIndexed$iv;
        Pair<List<String>, String> pair = ByJvmSignatureIndexerKt.excludeParametersFromDescriptor$tryParseParametersAndReturnType(descriptor2);
        if (pair == null) {
            return null;
        }
        Pair<List<String>, String> pair2 = pair;
        List<String> parameterTypes = pair2.component1();
        String returnType2 = pair2.component2();
        Iterable iterable = parameterTypes;
        boolean $i$f$filterIndexed = false;
        void var8_7 = $this$filterIndexed$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIndexedTo = false;
        void $this$forEachIndexed$iv$iv$iv = $this$filterIndexedTo$iv$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv$iv = 0;
        for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
            void element$iv$iv;
            int n;
            if ((n = index$iv$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv$iv;
            int index$iv$iv = n;
            boolean bl = false;
            String cfr_ignored_0 = (String)element$iv$iv;
            int index2 = index$iv$iv;
            boolean bl2 = false;
            if (!(!omittedParameters.contains(index2))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        String parametersList = CollectionsKt.joinToString$default((List)destination$iv$iv, "", null, null, 0, null, null, 62, null);
        return '(' + parametersList + ')' + returnType2;
    }

    private static final String desc(ClassDescriptor $this$desc) {
        StringBuilder stringBuilder2 = new StringBuilder().append('L');
        ClassId classId = DescriptorUtilsKt.getClassId((ClassifierDescriptor)$this$desc);
        Intrinsics.checkNotNull(classId);
        return stringBuilder2.append(JvmClassName.byClassId(classId).getInternalName()).append(';').toString();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Name> relativeClassName(@NotNull PsiMember $this$relativeClassName) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$relativeClassName, "<this>");
        Iterable $this$map$iv = CollectionsKt.reversed((Iterable)CollectionsKt.dropLast(SequencesKt.toList(SequencesKt.generateSequence($this$relativeClassName.getContainingClass(), (Function1)relativeClassName.1.INSTANCE)), 1));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PsiClass psiClass = (PsiClass)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = it.getName();
            Intrinsics.checkNotNull(string2);
            collection.add(Name.identifier(string2));
        }
        return (List)destination$iv$iv;
    }

    private static final List<Name> relativeClassName(ClassDescriptor $this$relativeClassName) {
        ClassId classId = DescriptorUtilsKt.getClassId((ClassifierDescriptor)$this$relativeClassName);
        Intrinsics.checkNotNull(classId);
        List<Name> list2 = classId.getRelativeClassName().pathSegments();
        Intrinsics.checkNotNullExpressionValue(list2, "classId!!.relativeClassName.pathSegments()");
        return CollectionsKt.drop((Iterable)list2, 1);
    }

    @NotNull
    public static final DecompiledTextIndexer<?> getBySignatureIndexer() {
        return BySignatureIndexer;
    }

    private static final String excludeParametersFromDescriptor$tryParseParametersAndReturnType$parseTypeString$lambda$0(String it) {
        return it;
    }

    private static final String excludeParametersFromDescriptor$tryParseParametersAndReturnType$parseTypeString(StringCharacterIterator iterator2, String $descriptor) {
        int begin = iterator2.getIndex();
        try {
            SignatureParsing.parseTypeString((CharacterIterator)iterator2, ByJvmSignatureIndexerKt::excludeParametersFromDescriptor$tryParseParametersAndReturnType$parseTypeString$lambda$0);
        }
        catch (ClsFormatException e) {
            return null;
        }
        int end = iterator2.getIndex();
        String string2 = $descriptor.substring(begin, end);
        Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string2;
    }

    private static final Pair<List<String>, String> excludeParametersFromDescriptor$tryParseParametersAndReturnType(String $descriptor) {
        StringCharacterIterator iterator2 = new StringCharacterIterator($descriptor);
        if (iterator2.current() != '(') {
            return null;
        }
        iterator2.next();
        if (iterator2.current() == ')') {
            iterator2.next();
            String string2 = ByJvmSignatureIndexerKt.excludeParametersFromDescriptor$tryParseParametersAndReturnType$parseTypeString(iterator2, $descriptor);
            if (string2 == null) {
                return null;
            }
            String returnType2 = string2;
            return TuplesKt.to(CollectionsKt.emptyList(), returnType2);
        }
        List parameterTypes = new ArrayList();
        while (iterator2.current() != ')' && iterator2.current() != '\uffff') {
            Collection collection = parameterTypes;
            String string3 = ByJvmSignatureIndexerKt.excludeParametersFromDescriptor$tryParseParametersAndReturnType$parseTypeString(iterator2, $descriptor);
            if (string3 == null) {
                return null;
            }
            collection.add(string3);
        }
        if (iterator2.current() != ')') {
            return null;
        }
        iterator2.next();
        String string4 = ByJvmSignatureIndexerKt.excludeParametersFromDescriptor$tryParseParametersAndReturnType$parseTypeString(iterator2, $descriptor);
        if (string4 == null) {
            return null;
        }
        String returnType3 = string4;
        return TuplesKt.to(parameterTypes, returnType3);
    }

    public static final /* synthetic */ String access$desc(ClassDescriptor $receiver) {
        return ByJvmSignatureIndexerKt.desc($receiver);
    }

    public static final /* synthetic */ List access$relativeClassName(ClassDescriptor $receiver) {
        return ByJvmSignatureIndexerKt.relativeClassName($receiver);
    }

    public static final /* synthetic */ String access$excludeParametersFromDescriptor(String descriptor2, List omittedParameters) {
        return ByJvmSignatureIndexerKt.excludeParametersFromDescriptor(descriptor2, omittedParameters);
    }
}

