/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirModifier;
import org.jetbrains.kotlin.fir.analysis.checkers.FirModifierList;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.impl.FirPrimaryConstructor;
import org.jetbrains.kotlin.lexer.KtKeywordToken;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.resolve.Compatibility;
import org.jetbrains.kotlin.resolve.ModifierCheckerHelpersKt;
import org.jetbrains.kotlin.resolve.TargetAllowedPredicate;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016JL\u0010\f\u001a\u00020\u00062\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0010\u0010\u0010\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\tH\u0002J(\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J6\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J@\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\b\u0010!\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\"\u001a\u00020#*\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0002\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirModifierChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkCompatibilityType", "firstModifier", "Lorg/jetbrains/kotlin/fir/analysis/checkers/FirModifier;", "secondModifier", "reportedNodes", "", "owner", "checkModifiers", "list", "Lorg/jetbrains/kotlin/fir/analysis/checkers/FirModifierList;", "checkParent", "", "modifierSource", "Lorg/jetbrains/kotlin/KtSourceElement;", "modifierToken", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "actualParents", "", "Lorg/jetbrains/kotlin/descriptors/annotations/KotlinTarget;", "checkTarget", "actualTargets", "parent", "firstOrThis", "", "checkers"})
public final class FirModifierChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirModifierChecker INSTANCE = new FirModifierChecker();

    private FirModifierChecker() {
    }

    @Override
    public void check(@NotNull FirDeclaration declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        block3: {
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            Intrinsics.checkNotNullParameter(context, "context");
            Intrinsics.checkNotNullParameter(reporter, "reporter");
            if (declaration instanceof FirFile) {
                return;
            }
            KtSourceElement ktSourceElement = declaration.getSource();
            if (ktSourceElement == null) {
                return;
            }
            KtSourceElement source2 = ktSourceElement;
            if (source2.getKind() instanceof KtFakeSourceElementKind) {
                return;
            }
            FirModifierList firModifierList = FirKeywordUtilsKt.getModifierList(source2);
            if (firModifierList == null) break block3;
            FirModifierList it = firModifierList;
            boolean bl = false;
            INSTANCE.checkModifiers(it, declaration, context, reporter);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void checkModifiers(FirModifierList list, FirDeclaration owner, CheckerContext context, DiagnosticReporter reporter) {
        block17: {
            if (list.getModifiers().isEmpty()) {
                return;
            }
            reportedNodes = new HashSet<E>();
            actualTargets = FirHelpersKt.getActualTargetList(owner).getDefaultTargets();
            $this$findClosest$iv = context;
            $i$f$findClosest = false;
            for (FirDeclaration it$iv : CollectionsKt.asReversed($this$findClosest$iv.getContainingDeclarations())) {
                v0 = it$iv;
                if (!(v0 instanceof FirDeclaration)) {
                    v0 = null;
                }
                if ((v1 = (FirElement)v0) == null) continue;
                var12_14 = v1;
                it = (FirDeclaration)var12_14;
                $i$a$-findClosest-FirModifierChecker$checkModifiers$parent$1 = false;
                if (it instanceof FirPrimaryConstructor || it instanceof FirProperty) ** GOTO lbl-1000
                v2 = it.getSource();
                if (!((v2 != null ? v2.getKind() : null) instanceof KtFakeSourceElementKind)) {
                    v3 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v3 = false;
                }
                if ((v1 = v3 != false ? var12_14 : null) == null) {
                    continue;
                }
                break block17;
            }
            v1 = null;
        }
        if (($i$f$findClosest = (parent = (FirDeclaration)v1)) instanceof FirAnonymousObject) {
            v4 = KotlinTarget.Companion.getLOCAL_CLASS_LIST();
        } else if ($i$f$findClosest instanceof FirClass) {
            v5 = ((FirClass)parent).getClassKind();
            v6 = parent instanceof FirMemberDeclaration != false ? (FirMemberDeclaration)parent : null;
            if (v6 != null) {
                $this$isInner$iv = v6;
                $i$f$isInner = false;
                v7 = $this$isInner$iv.getStatus().isInner();
            } else {
                v7 = false;
            }
            v8 = parent instanceof FirRegularClass != false ? (FirRegularClass)parent : null;
            if (v8 != null) {
                $this$isCompanion$iv = v8;
                $i$f$isCompanion = false;
                v9 = $this$isCompanion$iv.getStatus().isCompanion();
            } else {
                v9 = false;
            }
            $this$isLocal$iv = (FirClassLikeDeclaration)parent;
            $i$f$isLocal = false;
            v4 = KotlinTarget.Companion.classActualTargets(v5, v7, v9, $this$isLocal$iv.getSymbol().getClassId().isLocal());
        } else {
            v4 = $i$f$findClosest instanceof FirPropertyAccessor ? (((FirPropertyAccessor)parent).isSetter() ? KotlinTarget.Companion.getPROPERTY_SETTER_LIST() : KotlinTarget.Companion.getPROPERTY_GETTER_LIST()) : ($i$f$findClosest instanceof FirFunction != false ? KotlinTarget.Companion.getFUNCTION_LIST() : ($i$f$findClosest instanceof FirEnumEntry != false ? KotlinTarget.Companion.getENUM_ENTRY_LIST() : KotlinTarget.Companion.getFILE_LIST()));
        }
        actualParents = v4;
        modifiers = list.getModifiers();
        var10_10 = modifiers.iterator();
        var11_13 = 0;
        while (var10_10.hasNext()) {
            secondIndex = var11_13++;
            secondModifier = (FirModifier)var10_10.next();
            for (firstIndex = 0; firstIndex < secondIndex; ++firstIndex) {
                this.checkCompatibilityType(modifiers.get(firstIndex), secondModifier, reporter, (Set)reportedNodes, owner, context);
            }
            if (reportedNodes.contains(secondModifier)) continue;
            modifierSource = secondModifier.getSource();
            modifier = secondModifier.getToken();
            if (!this.checkTarget(modifierSource, modifier, actualTargets, parent, context, reporter)) {
                ((Collection)reportedNodes).add(secondModifier);
                continue;
            }
            if (this.checkParent(modifierSource, modifier, actualParents, context, reporter)) continue;
            ((Collection)reportedNodes).add(secondModifier);
        }
    }

    private final void checkCompatibilityType(FirModifier<?> firstModifier, FirModifier<?> secondModifier, DiagnosticReporter reporter, Set<FirModifier<?>> reportedNodes, FirDeclaration owner, CheckerContext context) {
        KtModifierKeywordToken firstModifierToken = firstModifier.getToken();
        KtModifierKeywordToken secondModifierToken = secondModifier.getToken();
        Compatibility compatibilityType = ModifierCheckerHelpersKt.compatibility(firstModifierToken, secondModifierToken);
        switch (WhenMappings.$EnumSwitchMapping$0[compatibilityType.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                if (!reportedNodes.add(secondModifier)) break;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)secondModifier.getSource(), FirErrors.INSTANCE.getREPEATED_MODIFIER(), (Object)secondModifierToken, (DiagnosticContext)context, null, 16, null);
                break;
            }
            case 3: {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)secondModifier.getSource(), FirErrors.INSTANCE.getREDUNDANT_MODIFIER(), (Object)secondModifierToken, (Object)firstModifierToken, (DiagnosticContext)context, null, 32, null);
                break;
            }
            case 4: {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)firstModifier.getSource(), FirErrors.INSTANCE.getREDUNDANT_MODIFIER(), (Object)firstModifierToken, (Object)secondModifierToken, (DiagnosticContext)context, null, 32, null);
                break;
            }
            case 5: {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)firstModifier.getSource(), FirErrors.INSTANCE.getDEPRECATED_MODIFIER_PAIR(), (Object)firstModifierToken, (Object)secondModifierToken, (DiagnosticContext)context, null, 32, null);
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)secondModifier.getSource(), FirErrors.INSTANCE.getDEPRECATED_MODIFIER_PAIR(), (Object)secondModifierToken, (Object)firstModifierToken, (DiagnosticContext)context, null, 32, null);
                break;
            }
            case 6: 
            case 7: {
                if (compatibilityType == Compatibility.COMPATIBLE_FOR_CLASSES_ONLY && owner instanceof FirClass) {
                    return;
                }
                if (reportedNodes.add(firstModifier)) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)firstModifier.getSource(), FirErrors.INSTANCE.getINCOMPATIBLE_MODIFIERS(), (Object)firstModifierToken, (Object)secondModifierToken, (DiagnosticContext)context, null, 32, null);
                }
                if (!reportedNodes.add(secondModifier)) break;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)secondModifier.getSource(), FirErrors.INSTANCE.getINCOMPATIBLE_MODIFIERS(), (Object)secondModifierToken, (Object)firstModifierToken, (DiagnosticContext)context, null, 32, null);
            }
        }
    }

    private final boolean checkTarget(KtSourceElement modifierSource, KtModifierKeywordToken modifierToken, List<? extends KotlinTarget> actualTargets, FirDeclaration parent2, CheckerContext context, DiagnosticReporter reporter) {
        if (!FirModifierChecker.checkTarget$checkModifier(modifierToken, actualTargets, context, reporter, modifierSource, FirErrors.INSTANCE.getWRONG_MODIFIER_TARGET())) {
            return false;
        }
        if (parent2 instanceof FirRegularClass && (Intrinsics.areEqual((Object)modifierToken, (Object)KtTokens.EXPECT_KEYWORD) || Intrinsics.areEqual((Object)modifierToken, (Object)KtTokens.HEADER_KEYWORD))) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)modifierSource, FirErrors.INSTANCE.getWRONG_MODIFIER_TARGET(), (Object)modifierToken, (Object)"nested class", (DiagnosticContext)context, null, 32, null);
            return false;
        }
        KtModifierKeywordToken deprecatedModifierReplacement = ModifierCheckerHelpersKt.getDeprecatedModifierMap().get((Object)modifierToken);
        if (deprecatedModifierReplacement != null) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)modifierSource, FirErrors.INSTANCE.getDEPRECATED_MODIFIER(), (Object)modifierToken, (Object)deprecatedModifierReplacement, (DiagnosticContext)context, null, 32, null);
        } else if (FirModifierChecker.checkTarget$checkModifier(modifierToken, actualTargets, context, reporter, modifierSource, FirErrors.INSTANCE.getDEPRECATED_MODIFIER_FOR_TARGET())) {
            FirModifierChecker.checkTarget$checkModifier(modifierToken, actualTargets, context, reporter, modifierSource, FirErrors.INSTANCE.getREDUNDANT_MODIFIER_FOR_TARGET());
        }
        return true;
    }

    private final boolean checkParent(KtSourceElement modifierSource, KtModifierKeywordToken modifierToken, List<? extends KotlinTarget> actualParents, CheckerContext context, DiagnosticReporter reporter) {
        boolean bl;
        block11: {
            Set<KotlinTarget> deprecatedParents = ModifierCheckerHelpersKt.getDeprecatedParentTargetMap().get((Object)modifierToken);
            if (deprecatedParents != null) {
                boolean bl2;
                block10: {
                    Iterable $this$any$iv = actualParents;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            KotlinTarget it = (KotlinTarget)((Object)element$iv);
                            boolean bl3 = false;
                            if (!deprecatedParents.contains((Object)it)) continue;
                            bl2 = true;
                            break block10;
                        }
                        bl2 = false;
                    }
                }
                if (bl2) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)modifierSource, FirErrors.INSTANCE.getDEPRECATED_MODIFIER_CONTAINING_DECLARATION(), (Object)modifierToken, (Object)this.firstOrThis(actualParents), (DiagnosticContext)context, null, 32, null);
                    return true;
                }
            }
            TargetAllowedPredicate targetAllowedPredicate = ModifierCheckerHelpersKt.getPossibleParentTargetPredicateMap().get((Object)modifierToken);
            if (targetAllowedPredicate == null) {
                return true;
            }
            TargetAllowedPredicate possibleParentPredicate = targetAllowedPredicate;
            Iterable $this$any$iv = actualParents;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KotlinTarget it = (KotlinTarget)((Object)element$iv);
                    boolean bl4 = false;
                    if (!possibleParentPredicate.isAllowed(it, FirLanguageSettingsComponentKt.getLanguageVersionSettings(context.getSession()))) continue;
                    bl = true;
                    break block11;
                }
                bl = false;
            }
        }
        if (bl) {
            return true;
        }
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)modifierSource, FirErrors.INSTANCE.getWRONG_MODIFIER_CONTAINING_DECLARATION(), (Object)modifierToken, (Object)this.firstOrThis(actualParents), (DiagnosticContext)context, null, 32, null);
        return false;
    }

    private final String firstOrThis(List<? extends KotlinTarget> $this$firstOrThis) {
        Object object = CollectionsKt.firstOrNull($this$firstOrThis);
        if (object == null || (object = object.getDescription()) == null) {
            object = "this";
        }
        return object;
    }

    private static final boolean checkTarget$checkModifier(KtModifierKeywordToken $modifierToken, List<? extends KotlinTarget> $actualTargets, CheckerContext $context, DiagnosticReporter $reporter, KtSourceElement $modifierSource, KtDiagnosticFactory2<KtModifierKeywordToken, String> factory2) {
        boolean checkResult;
        block11: {
            boolean bl;
            KotlinTarget it;
            Set<KotlinTarget> set;
            Map<KtModifierKeywordToken, Set<KotlinTarget>> map;
            KtDiagnosticFactory2<KtModifierKeywordToken, String> ktDiagnosticFactory2 = factory2;
            Map<KtKeywordToken, Set<KotlinTarget>> map2 = map = Intrinsics.areEqual(ktDiagnosticFactory2, FirErrors.INSTANCE.getWRONG_MODIFIER_TARGET()) ? ModifierCheckerHelpersKt.getPossibleTargetMap() : (Intrinsics.areEqual(ktDiagnosticFactory2, FirErrors.INSTANCE.getDEPRECATED_MODIFIER_FOR_TARGET()) ? ModifierCheckerHelpersKt.getDeprecatedTargetMap() : ModifierCheckerHelpersKt.getRedundantTargetMap());
            Set<KotlinTarget> set2 = map.get((Object)$modifierToken);
            if (set2 == null) {
                set2 = set = SetsKt.emptySet();
            }
            if (Intrinsics.areEqual(factory2, FirErrors.INSTANCE.getWRONG_MODIFIER_TARGET())) {
                boolean bl2;
                block10: {
                    Iterable $this$none$iv = $actualTargets;
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl2 = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            it = (KotlinTarget)((Object)element$iv);
                            boolean bl3 = false;
                            if (!set.contains((Object)it)) continue;
                            bl2 = false;
                            break block10;
                        }
                        bl2 = true;
                    }
                }
                bl = bl2 || Intrinsics.areEqual((Object)$modifierToken, (Object)KtTokens.DATA_KEYWORD) && $actualTargets.contains((Object)KotlinTarget.STANDALONE_OBJECT) && !$context.getLanguageVersionSettings().supportsFeature(LanguageFeature.DataObjects);
            } else {
                Iterable $this$any$iv = $actualTargets;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (KotlinTarget)((Object)element$iv);
                        boolean bl4 = false;
                        if (!set.contains((Object)it)) continue;
                        bl = true;
                        break block11;
                    }
                    bl = checkResult = false;
                }
            }
        }
        if (checkResult) {
            KtDiagnosticReportHelpersKt.reportOn$default($reporter, (AbstractKtSourceElement)$modifierSource, factory2, (Object)$modifierToken, (Object)INSTANCE.firstOrThis($actualTargets), (DiagnosticContext)$context, null, 32, null);
            return false;
        }
        return true;
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Compatibility.values().length];
            try {
                nArray[Compatibility.COMPATIBLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Compatibility.REPEATED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Compatibility.REDUNDANT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Compatibility.REVERSE_REDUNDANT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Compatibility.DEPRECATED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Compatibility.INCOMPATIBLE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Compatibility.COMPATIBLE_FOR_CLASSES_ONLY.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

