/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.ConstantArgumentKind;
import org.jetbrains.kotlin.fir.analysis.checkers.FirConstChecksKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import org.jetbrains.kotlin.fir.expressions.FirArrayOfCall;
import org.jetbrains.kotlin.fir.expressions.FirConstExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirNamedArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirVarargArgumentsExpression;
import org.jetbrains.kotlin.fir.references.FirErrorNamedReference;
import org.jetbrains.kotlin.fir.resolve.CallableIdUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.RequireKotlinConstants;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J*\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000e\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0018\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J*\u0010\u0019\u001a\u00020\r2\b\u0010\u001a\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J@\u0010\u001d\u001a\u00020\r2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u00072\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00150!2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\"\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\"\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\u000e\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirAnnotationExpressionChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirAnnotationCallChecker;", "()V", "annotationFqNamesWithVersion", "", "Lorg/jetbrains/kotlin/name/FqName;", "deprecatedSinceKotlinFqName", "sinceKotlinFqName", "versionArgumentName", "Lorg/jetbrains/kotlin/name/Name;", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkAnnotationArgumentWithSubElements", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactory0;", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "checkAnnotationUsedAsAnnotationArgument", "checkAnnotationsWithVersion", "fqName", "annotation", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "checkDeprecatedSinceKotlin", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "argumentMapping", "", "checkNotAClass", "parseVersionExpressionOrReport", "Lorg/jetbrains/kotlin/config/ApiVersion;", "checkers"})
public final class FirAnnotationExpressionChecker
extends FirExpressionChecker<FirAnnotationCall> {
    @NotNull
    public static final FirAnnotationExpressionChecker INSTANCE = new FirAnnotationExpressionChecker();
    @NotNull
    private static final Name versionArgumentName;
    @NotNull
    private static final FqName deprecatedSinceKotlinFqName;
    @NotNull
    private static final FqName sinceKotlinFqName;
    @NotNull
    private static final Set<FqName> annotationFqNamesWithVersion;

    private FirAnnotationExpressionChecker() {
    }

    @Override
    public void check(@NotNull FirAnnotationCall expression2, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Map<Name, FirExpression> argumentMapping = expression2.getArgumentMapping().getMapping();
        FqName fqName2 = CallableIdUtilsKt.fqName(expression2, context.getSession());
        for (FirExpression arg : argumentMapping.values()) {
            FirExpression argExpression;
            KtDiagnosticFactory0 ktDiagnosticFactory0;
            FirExpression firExpression2 = arg instanceof FirNamedArgumentExpression ? (FirNamedArgumentExpression)arg : null;
            if (firExpression2 == null || (firExpression2 = ((FirNamedArgumentExpression)firExpression2).getExpression()) == null) {
                firExpression2 = arg;
            }
            if ((ktDiagnosticFactory0 = this.checkAnnotationArgumentWithSubElements(argExpression = firExpression2, context.getSession(), reporter, context)) == null) continue;
            KtDiagnosticFactory0 it = ktDiagnosticFactory0;
            boolean bl = false;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)argExpression.getSource(), it, (DiagnosticContext)context, null, 8, null);
        }
        this.checkAnnotationsWithVersion(fqName2, expression2, context, reporter);
        this.checkDeprecatedSinceKotlin(expression2.getSource(), fqName2, argumentMapping, context, reporter);
        this.checkAnnotationUsedAsAnnotationArgument(expression2, context, reporter);
        this.checkNotAClass(expression2, context, reporter);
    }

    private final KtDiagnosticFactory0 checkAnnotationArgumentWithSubElements(FirExpression expression2, FirSession session2, DiagnosticReporter reporter, CheckerContext context) {
        FirExpression firExpression2 = expression2;
        if (firExpression2 instanceof FirArrayOfCall) {
            return FirAnnotationExpressionChecker.checkAnnotationArgumentWithSubElements$checkArgumentList(session2, reporter, context, ((FirArrayOfCall)expression2).getArgumentList());
        }
        if (firExpression2 instanceof FirVarargArgumentsExpression) {
            for (FirExpression arg : ((FirVarargArgumentsExpression)expression2).getArguments()) {
                FirExpression unwrappedArg = FirExpressionUtilKt.unwrapArgument(arg);
                KtDiagnosticFactory0 ktDiagnosticFactory0 = this.checkAnnotationArgumentWithSubElements(unwrappedArg, session2, reporter, context);
                if (ktDiagnosticFactory0 == null) continue;
                KtDiagnosticFactory0 it = ktDiagnosticFactory0;
                boolean bl = false;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)unwrappedArg.getSource(), it, (DiagnosticContext)context, null, 8, null);
            }
        } else {
            KtDiagnosticFactory0 ktDiagnosticFactory0;
            ConstantArgumentKind constantArgumentKind = FirConstChecksKt.checkConstantArguments(expression2, session2);
            switch (constantArgumentKind == null ? -1 : WhenMappings.$EnumSwitchMapping$0[constantArgumentKind.ordinal()]) {
                case 1: {
                    ktDiagnosticFactory0 = FirErrors.INSTANCE.getANNOTATION_ARGUMENT_MUST_BE_CONST();
                    break;
                }
                case 2: {
                    ktDiagnosticFactory0 = FirErrors.INSTANCE.getANNOTATION_ARGUMENT_MUST_BE_ENUM_CONST();
                    break;
                }
                case 3: {
                    ktDiagnosticFactory0 = FirErrors.INSTANCE.getANNOTATION_ARGUMENT_MUST_BE_KCLASS_LITERAL();
                    break;
                }
                case 4: {
                    ktDiagnosticFactory0 = FirErrors.INSTANCE.getANNOTATION_ARGUMENT_KCLASS_LITERAL_OF_TYPE_PARAMETER_ERROR();
                    break;
                }
                case 5: {
                    ktDiagnosticFactory0 = FirErrors.INSTANCE.getNON_CONST_VAL_USED_IN_CONSTANT_EXPRESSION();
                    break;
                }
                case -1: {
                    if (expression2 instanceof FirFunctionCall) {
                        ktDiagnosticFactory0 = FirAnnotationExpressionChecker.checkAnnotationArgumentWithSubElements$checkArgumentList(session2, reporter, context, ((FirFunctionCall)expression2).getArgumentList());
                        break;
                    }
                    ktDiagnosticFactory0 = null;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return ktDiagnosticFactory0;
        }
        return null;
    }

    private final ApiVersion parseVersionExpressionOrReport(FirExpression expression2, CheckerContext context, DiagnosticReporter reporter) {
        FirConstExpression constantExpression;
        Object object;
        FirConstExpression firConstExpression = expression2 instanceof FirConstExpression ? (FirConstExpression)expression2 : null;
        if (firConstExpression == null) {
            FirNamedArgumentExpression firNamedArgumentExpression = expression2 instanceof FirNamedArgumentExpression ? (FirNamedArgumentExpression)expression2 : null;
            object = firNamedArgumentExpression != null ? firNamedArgumentExpression.getExpression() : null;
            firConstExpression = object instanceof FirConstExpression ? (FirConstExpression)object : null;
            if (firConstExpression == null) {
                return null;
            }
        }
        String string2 = (object = (constantExpression = firConstExpression).getValue()) instanceof String ? (String)object : null;
        if (string2 == null) {
            return null;
        }
        String stringValue = string2;
        CharSequence charSequence2 = stringValue;
        if (!RequireKotlinConstants.INSTANCE.getVERSION_REGEX().matches(charSequence2)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getILLEGAL_KOTLIN_VERSION_STRING_VALUE(), (DiagnosticContext)context, null, 8, null);
            return null;
        }
        ApiVersion version = ApiVersion.Companion.parse(stringValue);
        if (version == null) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getILLEGAL_KOTLIN_VERSION_STRING_VALUE(), (DiagnosticContext)context, null, 8, null);
        }
        return version;
    }

    private final void checkAnnotationsWithVersion(FqName fqName2, FirAnnotation annotation2, CheckerContext context, DiagnosticReporter reporter) {
        ApiVersion specified;
        if (!CollectionsKt.contains((Iterable)annotationFqNamesWithVersion, fqName2)) {
            return;
        }
        FirExpression firExpression2 = FirAnnotationUtilsKt.findArgumentByName(annotation2, versionArgumentName);
        if (firExpression2 == null) {
            return;
        }
        FirExpression versionExpression = firExpression2;
        ApiVersion apiVersion = this.parseVersionExpressionOrReport(versionExpression, context, reporter);
        if (apiVersion == null) {
            return;
        }
        ApiVersion version = apiVersion;
        if (Intrinsics.areEqual(fqName2, sinceKotlinFqName) && version.compareTo(specified = FirLanguageSettingsComponentKt.getLanguageVersionSettings(context.getSession()).getApiVersion()) > 0) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)versionExpression.getSource(), FirErrors.INSTANCE.getNEWER_VERSION_IN_SINCE_KOTLIN(), (Object)specified.getVersionString(), (DiagnosticContext)context, null, 16, null);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void checkDeprecatedSinceKotlin(KtSourceElement source, FqName fqName, Map<Name, ? extends FirExpression> argumentMapping, CheckerContext context, DiagnosticReporter reporter) {
        if (!Intrinsics.areEqual(fqName, FirAnnotationExpressionChecker.deprecatedSinceKotlinFqName)) {
            return;
        }
        if (argumentMapping.size() == 0) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getDEPRECATED_SINCE_KOTLIN_WITHOUT_ARGUMENTS(), (DiagnosticContext)context, null, 8, null);
        }
        warningSince = null;
        errorSince = null;
        hiddenSince = null;
        for (Map.Entry<Name, ? extends FirExpression> var10_11 : argumentMapping.entrySet()) {
            block28: {
                name = var10_11.getKey();
                argument = var10_11.getValue();
                Intrinsics.checkNotNullExpressionValue(name.getIdentifier(), "name.identifier");
                switch (identifier.hashCode()) {
                    case -855220304: {
                        if (!identifier.equals("hiddenSince")) {
                            break;
                        }
                        ** GOTO lbl23
                    }
                    case -2027506434: {
                        if (!identifier.equals("warningSince")) {
                            break;
                        }
                        ** GOTO lbl23
                    }
                    case 1624782354: {
                        if (!identifier.equals("errorSince")) break;
lbl23:
                        // 3 sources

                        if ((version = this.parseVersionExpressionOrReport(argument, context, reporter)) == null) break;
                        var15_16 = identifier;
                        tmp = -1;
                        switch (var15_16.hashCode()) {
                            case -855220304: {
                                if (var15_16.equals("hiddenSince")) {
                                    tmp = 1;
                                }
                                break;
                            }
                            case -2027506434: {
                                if (var15_16.equals("warningSince")) {
                                    tmp = 2;
                                }
                                break;
                            }
                            case 1624782354: {
                                if (var15_16.equals("errorSince")) {
                                    tmp = 3;
                                }
                                break;
                            }
                        }
                        switch (tmp) {
                            case 2: {
                                warningSince = version;
                                break block28;
                            }
                            case 3: {
                                errorSince = version;
                                break block28;
                            }
                            case 1: {
                                hiddenSince = version;
                            }
                        }
                    }
                }
            }
        }
        isReportDeprecatedSinceKotlinWithUnorderedVersions = false;
        if (warningSince != null) {
            if (errorSince != null) {
                v0 = isReportDeprecatedSinceKotlinWithUnorderedVersions = warningSince.compareTo(errorSince) > 0;
            }
            if (hiddenSince != null && !isReportDeprecatedSinceKotlinWithUnorderedVersions) {
                v1 = isReportDeprecatedSinceKotlinWithUnorderedVersions = warningSince.compareTo(hiddenSince) > 0;
            }
        }
        if (errorSince != null && hiddenSince != null && !isReportDeprecatedSinceKotlinWithUnorderedVersions) {
            v2 = isReportDeprecatedSinceKotlinWithUnorderedVersions = errorSince.compareTo(hiddenSince) > 0;
        }
        if (isReportDeprecatedSinceKotlinWithUnorderedVersions) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getDEPRECATED_SINCE_KOTLIN_WITH_UNORDERED_VERSIONS(), (DiagnosticContext)context, null, 8, null);
        }
    }

    private final void checkAnnotationUsedAsAnnotationArgument(FirAnnotationCall expression2, CheckerContext context, DiagnosticReporter reporter) {
        List<FirExpression> args2 = expression2.getArgumentList().getArguments();
        for (FirExpression arg : args2) {
            for (FirAnnotation ann : FirExpressionUtilKt.unwrapArgument(arg).getAnnotations()) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)ann.getSource(), FirErrors.INSTANCE.getANNOTATION_USED_AS_ANNOTATION_ARGUMENT(), (DiagnosticContext)context, null, 8, null);
            }
        }
    }

    private final void checkNotAClass(FirAnnotationCall expression2, CheckerContext context, DiagnosticReporter reporter) {
        FirTypeRef annotationTypeRef = expression2.getAnnotationTypeRef();
        if (expression2.getCalleeReference() instanceof FirErrorNamedReference && !(annotationTypeRef instanceof FirErrorTypeRef) && !(FirTypeUtilsKt.getConeType(annotationTypeRef) instanceof ConeClassLikeType)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotationTypeRef.getSource(), FirErrors.INSTANCE.getNOT_A_CLASS(), (DiagnosticContext)context, null, 8, null);
        }
    }

    private static final KtDiagnosticFactory0 checkAnnotationArgumentWithSubElements$checkArgumentList(FirSession $session, DiagnosticReporter $reporter, CheckerContext $context, FirArgumentList args2) {
        boolean usedNonConst = false;
        for (FirExpression arg : args2.getArguments()) {
            KtSourceElement sourceForReport = arg.getSource();
            KtDiagnosticFactory0 err = INSTANCE.checkAnnotationArgumentWithSubElements(arg, $session, $reporter, $context);
            if (err == null) continue;
            if (!Intrinsics.areEqual(err, FirErrors.INSTANCE.getANNOTATION_ARGUMENT_MUST_BE_KCLASS_LITERAL())) {
                usedNonConst = true;
            }
            KtDiagnosticReportHelpersKt.reportOn$default($reporter, (AbstractKtSourceElement)sourceForReport, err, (DiagnosticContext)$context, null, 8, null);
        }
        return usedNonConst ? FirErrors.INSTANCE.getNON_CONST_VAL_USED_IN_CONSTANT_EXPRESSION() : null;
    }

    static {
        Name name = Name.identifier("version");
        Intrinsics.checkNotNullExpressionValue(name, "identifier(\"version\")");
        versionArgumentName = name;
        deprecatedSinceKotlinFqName = new FqName("kotlin.DeprecatedSinceKotlin");
        sinceKotlinFqName = new FqName("kotlin.SinceKotlin");
        FqName[] fqNameArray = new FqName[]{RequireKotlinConstants.INSTANCE.getFQ_NAME(), sinceKotlinFqName};
        annotationFqNamesWithVersion = SetsKt.setOf(fqNameArray);
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ConstantArgumentKind.values().length];
            try {
                nArray[ConstantArgumentKind.NOT_CONST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConstantArgumentKind.ENUM_NOT_CONST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConstantArgumentKind.NOT_KCLASS_LITERAL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConstantArgumentKind.KCLASS_LITERAL_OF_TYPE_PARAMETER_ERROR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConstantArgumentKind.NOT_CONST_VAL_IN_CONST_EXPRESSION.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

