/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.scopes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSessionComponent;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.resolve.transformers.ReturnTypeCalculator;
import org.jetbrains.kotlin.fir.scopes.FirOverrideChecker;
import org.jetbrains.kotlin.fir.scopes.MemberWithBaseScope;
import org.jetbrains.kotlin.fir.scopes.impl.AbstractFirOverrideScopeKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirAbstractOverrideCheckerKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.TypeCheckerState;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.utils.SmartSet;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u001f\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JB\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\n0\t0\b0\b\"\f\b\u0000\u0010\n*\u0006\u0012\u0002\b\u00030\u000b2\u0012\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\n0\t0\r2\u0006\u0010\u000e\u001a\u00020\u000fJJ\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\n0\t0\u0011\"\f\b\u0000\u0010\n*\u0006\u0012\u0002\b\u00030\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\n0\t2\u0012\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\n0\t0\u00132\u0006\u0010\u000e\u001a\u00020\u000fJ\u001c\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0017H\u0002J(\u0010\u0019\u001a\u00020\u00152\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u000b2\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J \u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010 \u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020!2\u0006\u0010\u0018\u001a\u00020!H\u0002JD\u0010\"\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\n0\t0\r\"\f\b\u0000\u0010\n*\u0006\u0012\u0002\b\u00030\u000b2\u0012\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\n0\t0\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001bJ6\u0010#\u001a\b\u0012\u0004\u0012\u0002H\n0\t\"\f\b\u0000\u0010\n*\u0006\u0012\u0002\b\u00030\u000b2\u0012\u0010$\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\n0\t0\r2\u0006\u0010\u001a\u001a\u00020\u001bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/fir/scopes/FirOverrideService;", "Lorg/jetbrains/kotlin/fir/FirSessionComponent;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "createOverridableGroups", "", "Lorg/jetbrains/kotlin/fir/scopes/MemberWithBaseScope;", "D", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "members", "", "overrideChecker", "Lorg/jetbrains/kotlin/fir/scopes/FirOverrideChecker;", "extractBothWaysOverridable", "", "overrider", "", "isAccessorMoreSpecific", "", "a", "Lorg/jetbrains/kotlin/fir/declarations/FirPropertyAccessor;", "b", "isMoreSpecific", "returnTypeCalculator", "Lorg/jetbrains/kotlin/fir/resolve/transformers/ReturnTypeCalculator;", "isTypeMoreSpecific", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "typeCheckerState", "Lorg/jetbrains/kotlin/types/TypeCheckerState;", "isVisibilityMoreSpecific", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "selectMostSpecificInEachOverridableGroup", "selectMostSpecificMember", "overridables", "providers"})
public final class FirOverrideService
implements FirSessionComponent {
    @NotNull
    private final FirSession session;

    public FirOverrideService(@NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter(session2, "session");
        this.session = session2;
    }

    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @NotNull
    public final <D extends FirCallableSymbol<?>> Collection<MemberWithBaseScope<D>> selectMostSpecificInEachOverridableGroup(@NotNull Collection<? extends MemberWithBaseScope<? extends D>> members2, @NotNull FirOverrideChecker overrideChecker, @NotNull ReturnTypeCalculator returnTypeCalculator) {
        Intrinsics.checkNotNullParameter(members2, "members");
        Intrinsics.checkNotNullParameter(overrideChecker, "overrideChecker");
        Intrinsics.checkNotNullParameter(returnTypeCalculator, "returnTypeCalculator");
        if (members2.size() <= 1) {
            return members2;
        }
        LinkedList<MemberWithBaseScope<D>> queue = new LinkedList<MemberWithBaseScope<D>>(members2);
        SmartSet<MemberWithBaseScope<D>> result2 = SmartSet.Companion.create();
        while (!((Collection)queue).isEmpty()) {
            MemberWithBaseScope nextHandle = (MemberWithBaseScope)CollectionsKt.first((List)queue);
            SmartSet conflictedHandles = SmartSet.Companion.create();
            Intrinsics.checkNotNullExpressionValue(nextHandle, "nextHandle");
            List<MemberWithBaseScope<D>> overridableGroup2 = this.extractBothWaysOverridable(nextHandle, (Collection)queue, overrideChecker);
            if (overridableGroup2.size() == 1 && conflictedHandles.isEmpty()) {
                result2.add(CollectionsKt.single(overridableGroup2));
                continue;
            }
            MemberWithBaseScope<D> mostSpecific = this.selectMostSpecificMember((Collection)overridableGroup2, returnTypeCalculator);
            Iterable $this$filterNotTo$iv = overridableGroup2;
            boolean $i$f$filterNotTo = false;
            for (Object element$iv : $this$filterNotTo$iv) {
                MemberWithBaseScope it = (MemberWithBaseScope)element$iv;
                boolean bl = false;
                if (this.isMoreSpecific((FirCallableSymbol<?>)mostSpecific.getMember(), (FirCallableSymbol<?>)it.getMember(), returnTypeCalculator)) continue;
                ((Collection)conflictedHandles).add(element$iv);
            }
            if (!((Collection)conflictedHandles).isEmpty()) {
                result2.addAll(conflictedHandles);
            }
            result2.add(mostSpecific);
        }
        return result2;
    }

    @NotNull
    public final <D extends FirCallableSymbol<?>> List<List<MemberWithBaseScope<D>>> createOverridableGroups(@NotNull Collection<? extends MemberWithBaseScope<? extends D>> members2, @NotNull FirOverrideChecker overrideChecker) {
        Intrinsics.checkNotNullParameter(members2, "members");
        Intrinsics.checkNotNullParameter(overrideChecker, "overrideChecker");
        if (members2.size() <= 1) {
            return CollectionsKt.listOf(CollectionsKt.toList((Iterable)members2));
        }
        LinkedList<? extends MemberWithBaseScope<? extends D>> queue = new LinkedList<MemberWithBaseScope<? extends D>>(members2);
        List result2 = new ArrayList();
        while (!((Collection)queue).isEmpty()) {
            MemberWithBaseScope nextHandle = (MemberWithBaseScope)CollectionsKt.first((List)queue);
            Intrinsics.checkNotNullExpressionValue(nextHandle, "nextHandle");
            List<MemberWithBaseScope<D>> overridableGroup2 = this.extractBothWaysOverridable(nextHandle, (Collection)queue, overrideChecker);
            ((Collection)result2).add(overridableGroup2);
        }
        return result2;
    }

    @NotNull
    public final <D extends FirCallableSymbol<?>> List<MemberWithBaseScope<D>> extractBothWaysOverridable(@NotNull MemberWithBaseScope<? extends D> overrider, @NotNull Collection<MemberWithBaseScope<D>> members2, @NotNull FirOverrideChecker overrideChecker) {
        List list2;
        Intrinsics.checkNotNullParameter(overrider, "overrider");
        Intrinsics.checkNotNullParameter(members2, "members");
        Intrinsics.checkNotNullParameter(overrideChecker, "overrideChecker");
        List $this$extractBothWaysOverridable_u24lambda_u241 = list2 = (List)new ArrayList();
        boolean bl = false;
        $this$extractBothWaysOverridable_u24lambda_u241.add(overrider);
        List result2 = list2;
        Iterator<MemberWithBaseScope<D>> iterator2 = members2.iterator();
        FirCallableDeclaration overrideCandidate = (FirCallableDeclaration)((FirBasedSymbol)overrider.getMember()).getFir();
        while (iterator2.hasNext()) {
            MemberWithBaseScope<D> next = iterator2.next();
            if (Intrinsics.areEqual(next, overrider)) {
                iterator2.remove();
                continue;
            }
            if (!AbstractFirOverrideScopeKt.similarFunctionsOrBothProperties(overrideChecker, overrideCandidate, (FirCallableDeclaration)((FirBasedSymbol)next.getMember()).getFir())) continue;
            result2.add(next);
            iterator2.remove();
        }
        return result2;
    }

    @NotNull
    public final <D extends FirCallableSymbol<?>> MemberWithBaseScope<D> selectMostSpecificMember(@NotNull Collection<? extends MemberWithBaseScope<? extends D>> overridables, @NotNull ReturnTypeCalculator returnTypeCalculator) {
        MemberWithBaseScope<D> memberWithBaseScope;
        Intrinsics.checkNotNullParameter(overridables, "overridables");
        Intrinsics.checkNotNullParameter(returnTypeCalculator, "returnTypeCalculator");
        if (!(!overridables.isEmpty())) {
            boolean $i$a$-require-FirOverrideService$selectMostSpecificMember$22 = false;
            String $i$a$-require-FirOverrideService$selectMostSpecificMember$22 = "Should have at least one overridable symbol";
            throw new IllegalArgumentException($i$a$-require-FirOverrideService$selectMostSpecificMember$22.toString());
        }
        if (overridables.size() == 1) {
            return (MemberWithBaseScope)CollectionsKt.first((Iterable)overridables);
        }
        Collection candidates2 = new ArrayList(2);
        MemberWithBaseScope<D> transitivelyMostSpecific = (MemberWithBaseScope<D>)CollectionsKt.first((Iterable)overridables);
        for (MemberWithBaseScope<D> candidate2 : overridables) {
            boolean bl;
            block14: {
                Iterable $this$all$iv = overridables;
                boolean $i$f$all = false;
                if (((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        MemberWithBaseScope it = (MemberWithBaseScope)element$iv;
                        boolean bl2 = false;
                        if (this.isMoreSpecific((FirCallableSymbol<?>)candidate2.getMember(), (FirCallableSymbol<?>)it.getMember(), returnTypeCalculator)) continue;
                        bl = false;
                        break block14;
                    }
                    bl = true;
                }
            }
            if (bl) {
                candidates2.add(candidate2);
            }
            if (!this.isMoreSpecific((FirCallableSymbol<?>)candidate2.getMember(), (FirCallableSymbol<?>)transitivelyMostSpecific.getMember(), returnTypeCalculator) || this.isMoreSpecific((FirCallableSymbol<?>)transitivelyMostSpecific.getMember(), (FirCallableSymbol<?>)candidate2.getMember(), returnTypeCalculator)) continue;
            transitivelyMostSpecific = candidate2;
        }
        if (candidates2.isEmpty()) {
            memberWithBaseScope = transitivelyMostSpecific;
        } else if (candidates2.size() == 1) {
            memberWithBaseScope = (MemberWithBaseScope)CollectionsKt.first(candidates2);
        } else {
            Object v4;
            block15: {
                Iterable $this$firstOrNull$iv = candidates2;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ConeKotlinType type2;
                    MemberWithBaseScope it = (MemberWithBaseScope)element$iv;
                    boolean bl = false;
                    FirTypeRef $this$coneTypeSafe$iv = ((FirCallableDeclaration)((FirBasedSymbol)it.getMember()).getFir()).getReturnTypeRef();
                    boolean $i$f$coneTypeSafe = false;
                    FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
                    ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
                    if (!(coneKotlinType instanceof ConeKotlinType)) {
                        coneKotlinType = null;
                    }
                    if (!((type2 = coneKotlinType) != null && !(type2 instanceof ConeFlexibleType))) continue;
                    v4 = element$iv;
                    break block15;
                }
                v4 = null;
            }
            MemberWithBaseScope memberWithBaseScope2 = v4;
            if (memberWithBaseScope2 != null) {
                MemberWithBaseScope it = memberWithBaseScope2;
                boolean bl = false;
                return it;
            }
            memberWithBaseScope = (MemberWithBaseScope)CollectionsKt.first(candidates2);
        }
        return memberWithBaseScope;
    }

    private final boolean isMoreSpecific(FirCallableSymbol<?> a, FirCallableSymbol<?> b, ReturnTypeCalculator returnTypeCalculator) {
        Object object;
        FirCallableDeclaration bFir;
        FirCallableDeclaration aFir;
        block12: {
            block11: {
                aFir = (FirCallableDeclaration)a.getFir();
                bFir = (FirCallableDeclaration)b.getFir();
                FirMemberDeclaration $this$visibility$iv = aFir;
                boolean $i$f$getVisibility = false;
                Visibility visibility2 = $this$visibility$iv.getStatus().getVisibility();
                $this$visibility$iv = bFir;
                $i$f$getVisibility = false;
                if (!this.isVisibilityMoreSpecific(visibility2, $this$visibility$iv.getStatus().getVisibility())) {
                    return false;
                }
                ConeSubstitutor coneSubstitutor = FirAbstractOverrideCheckerKt.buildSubstitutorForOverridesCheck(aFir, bFir, this.session);
                if (coneSubstitutor == null) {
                    return false;
                }
                ConeSubstitutor substitutor2 = coneSubstitutor;
                object = returnTypeCalculator.tryCalculateReturnTypeOrNull((FirCallableDeclaration)a.getFir());
                if (object == null || (object = ((FirResolvedTypeRef)object).getType()) == null) break block11;
                Object p0 = object;
                boolean bl = false;
                ConeKotlinType coneKotlinType = substitutor2.substituteOrSelf((ConeKotlinType)p0);
                object = coneKotlinType;
                if (coneKotlinType != null) break block12;
            }
            return false;
        }
        Object aReturnType = object;
        Object object2 = returnTypeCalculator.tryCalculateReturnTypeOrNull((FirCallableDeclaration)b.getFir());
        if (object2 == null || (object2 = ((FirResolvedTypeRef)object2).getType()) == null) {
            return false;
        }
        Object bReturnType = object2;
        TypeCheckerState typeCheckerState2 = TypeComponentsKt.getTypeContext(this.session).newTypeCheckerState(false, false);
        if (aFir instanceof FirSimpleFunction) {
            if (!(bFir instanceof FirSimpleFunction)) {
                boolean $i$a$-require-FirOverrideService$isMoreSpecific$32 = false;
                String $i$a$-require-FirOverrideService$isMoreSpecific$32 = "b is " + b.getClass();
                throw new IllegalArgumentException($i$a$-require-FirOverrideService$isMoreSpecific$32.toString());
            }
            return this.isTypeMoreSpecific((ConeKotlinType)aReturnType, (ConeKotlinType)bReturnType, typeCheckerState2);
        }
        if (aFir instanceof FirProperty) {
            if (!(bFir instanceof FirProperty)) {
                boolean bl = false;
                String string2 = "b is " + b.getClass();
                throw new IllegalArgumentException(string2.toString());
            }
            if (!this.isAccessorMoreSpecific(((FirProperty)aFir).getSetter(), ((FirProperty)bFir).getSetter())) {
                return false;
            }
            return ((FirProperty)aFir).isVar() && ((FirProperty)bFir).isVar() ? AbstractTypeChecker.INSTANCE.equalTypes(typeCheckerState2, (KotlinTypeMarker)aReturnType, (KotlinTypeMarker)bReturnType) : (((FirProperty)aFir).isVar() || !((FirProperty)bFir).isVar()) && this.isTypeMoreSpecific((ConeKotlinType)aReturnType, (ConeKotlinType)bReturnType, typeCheckerState2);
        }
        throw new IllegalArgumentException("Unexpected callable: " + a.getClass());
    }

    private final boolean isTypeMoreSpecific(ConeKotlinType a, ConeKotlinType b, TypeCheckerState typeCheckerState2) {
        return AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, typeCheckerState2, (KotlinTypeMarker)a, (KotlinTypeMarker)b, false, 8, null);
    }

    private final boolean isAccessorMoreSpecific(FirPropertyAccessor a, FirPropertyAccessor b) {
        if (a == null || b == null) {
            return true;
        }
        FirMemberDeclaration $this$visibility$iv = a;
        boolean $i$f$getVisibility = false;
        Visibility visibility2 = $this$visibility$iv.getStatus().getVisibility();
        $this$visibility$iv = b;
        $i$f$getVisibility = false;
        return this.isVisibilityMoreSpecific(visibility2, $this$visibility$iv.getStatus().getVisibility());
    }

    private final boolean isVisibilityMoreSpecific(Visibility a, Visibility b) {
        Integer result2 = Visibilities.INSTANCE.compare(a, b);
        return result2 == null || result2 >= 0;
    }
}

