/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.storage;

import com.intellij.util.io.DataExternalizer;
import java.io.DataInput;
import java.io.DataOutput;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.storage.ExternalizersKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/incremental/storage/ConstantExternalizer;", "Lcom/intellij/util/io/DataExternalizer;", "", "()V", "read", "input", "Ljava/io/DataInput;", "save", "", "output", "Ljava/io/DataOutput;", "value", "Kind", "kotlin-build-common"})
public final class ConstantExternalizer
implements DataExternalizer<Object> {
    @NotNull
    public static final ConstantExternalizer INSTANCE = new ConstantExternalizer();

    private ConstantExternalizer() {
    }

    public void save(@NotNull DataOutput output, @NotNull Object value2) {
        Intrinsics.checkNotNullParameter(output, "output");
        Intrinsics.checkNotNullParameter(value2, "value");
        Object object = value2;
        if (object instanceof Integer) {
            output.writeByte(Kind.INT.ordinal());
            output.writeInt(((Number)value2).intValue());
        } else if (object instanceof Float) {
            output.writeByte(Kind.FLOAT.ordinal());
            output.writeFloat(((Number)value2).floatValue());
        } else if (object instanceof Long) {
            output.writeByte(Kind.LONG.ordinal());
            output.writeLong(((Number)value2).longValue());
        } else if (object instanceof Double) {
            output.writeByte(Kind.DOUBLE.ordinal());
            output.writeDouble(((Number)value2).doubleValue());
        } else if (object instanceof String) {
            output.writeByte(Kind.STRING.ordinal());
            ExternalizersKt.writeString(output, (String)value2);
        } else {
            throw new IllegalStateException("Unexpected constant class: " + value2.getClass());
        }
    }

    @NotNull
    public Object read(@NotNull DataInput input) {
        Object object;
        Intrinsics.checkNotNullParameter(input, "input");
        switch (WhenMappings.$EnumSwitchMapping$0[Kind.values()[input.readByte()].ordinal()]) {
            case 1: {
                object = input.readInt();
                break;
            }
            case 2: {
                object = Float.valueOf(input.readFloat());
                break;
            }
            case 3: {
                object = input.readLong();
                break;
            }
            case 4: {
                object = input.readDouble();
                break;
            }
            case 5: {
                object = ExternalizersKt.readString(input);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return object;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/incremental/storage/ConstantExternalizer$Kind;", "", "(Ljava/lang/String;I)V", "INT", "FLOAT", "LONG", "DOUBLE", "STRING", "kotlin-build-common"})
    private static final class Kind
    extends Enum<Kind> {
        public static final /* enum */ Kind INT = new Kind();
        public static final /* enum */ Kind FLOAT = new Kind();
        public static final /* enum */ Kind LONG = new Kind();
        public static final /* enum */ Kind DOUBLE = new Kind();
        public static final /* enum */ Kind STRING = new Kind();
        private static final /* synthetic */ Kind[] $VALUES;

        public static Kind[] values() {
            return (Kind[])$VALUES.clone();
        }

        public static Kind valueOf(String value2) {
            return Enum.valueOf(Kind.class, value2);
        }

        static {
            $VALUES = kindArray = new Kind[]{Kind.INT, Kind.FLOAT, Kind.LONG, Kind.DOUBLE, Kind.STRING};
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Kind.values().length];
            try {
                nArray[Kind.INT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Kind.FLOAT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Kind.LONG.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Kind.DOUBLE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Kind.STRING.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

