/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.UnsignedType;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.interpreter.CallInterceptor;
import org.jetbrains.kotlin.ir.interpreter.CompoundInstruction;
import org.jetbrains.kotlin.ir.interpreter.CustomInstruction;
import org.jetbrains.kotlin.ir.interpreter.DefaultCallInterceptor;
import org.jetbrains.kotlin.ir.interpreter.Instruction;
import org.jetbrains.kotlin.ir.interpreter.InstructionKt;
import org.jetbrains.kotlin.ir.interpreter.InstructionsUnfolderKt;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreterEnvironment;
import org.jetbrains.kotlin.ir.interpreter.IrTreeBuildUtilsKt;
import org.jetbrains.kotlin.ir.interpreter.SimpleInstruction;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.interpreter.exceptions.ExceptionUtilsKt;
import org.jetbrains.kotlin.ir.interpreter.exceptions.InterpreterAssertionError;
import org.jetbrains.kotlin.ir.interpreter.exceptions.InterpreterError;
import org.jetbrains.kotlin.ir.interpreter.exceptions.InterpreterTimeOutError;
import org.jetbrains.kotlin.ir.interpreter.proxy.CommonProxy;
import org.jetbrains.kotlin.ir.interpreter.proxy.Proxy;
import org.jetbrains.kotlin.ir.interpreter.stack.CallStack;
import org.jetbrains.kotlin.ir.interpreter.state.Common;
import org.jetbrains.kotlin.ir.interpreter.state.Complex;
import org.jetbrains.kotlin.ir.interpreter.state.ExceptionState;
import org.jetbrains.kotlin.ir.interpreter.state.Primitive;
import org.jetbrains.kotlin.ir.interpreter.state.State;
import org.jetbrains.kotlin.ir.interpreter.state.StateKt;
import org.jetbrains.kotlin.ir.interpreter.state.StateWithClosure;
import org.jetbrains.kotlin.ir.interpreter.state.Wrapper;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.KClassState;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.KFunctionState;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.KPropertyState;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.KTypeState;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.DeepCopyIrTreeWithSymbols;
import org.jetbrains.kotlin.ir.util.DeepCopySymbolRemapper;
import org.jetbrains.kotlin.ir.util.DeepCopyTypeRemapper;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.util.SymbolRemapper;
import org.jetbrains.kotlin.ir.util.TypeRemapper;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00c8\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bB\u000f\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bB!\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020#H\u0002J\u001a\u0010!\u001a\u00020$2\u0006\u0010%\u001a\u00020$2\n\b\u0002\u0010&\u001a\u0004\u0018\u00010'J\u0010\u0010(\u001a\u00020 2\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020 2\u0006\u0010,\u001a\u00020\u0007H\u0002J\u0010\u0010-\u001a\u00020 2\u0006\u0010.\u001a\u00020/H\u0002J\u0010\u00100\u001a\u00020 2\u0006\u00101\u001a\u000202H\u0002J\u0010\u00103\u001a\u00020 2\u0006\u00104\u001a\u000205H\u0002J\u0014\u00106\u001a\u00020 2\n\u0010%\u001a\u0006\u0012\u0002\b\u000307H\u0002J\u0010\u00108\u001a\u00020 2\u0006\u00109\u001a\u00020:H\u0002J\u0010\u0010;\u001a\u00020 2\u0006\u0010<\u001a\u00020=H\u0002J\u0010\u0010>\u001a\u00020 2\u0006\u0010<\u001a\u00020?H\u0002J\u0010\u0010@\u001a\u00020 2\u0006\u0010A\u001a\u00020BH\u0002J\u0010\u0010C\u001a\u00020 2\u0006\u0010<\u001a\u00020DH\u0002J\u0010\u0010E\u001a\u00020 2\u0006\u0010F\u001a\u00020GH\u0002J\u0010\u0010H\u001a\u00020 2\u0006\u0010I\u001a\u00020JH\u0002J\u0010\u0010K\u001a\u00020 2\u0006\u0010L\u001a\u00020MH\u0002J\u0010\u0010N\u001a\u00020 2\u0006\u0010%\u001a\u00020OH\u0002J\u0010\u0010P\u001a\u00020 2\u0006\u0010Q\u001a\u00020RH\u0002J\u0010\u0010S\u001a\u00020 2\u0006\u0010%\u001a\u00020TH\u0002J\u0010\u0010U\u001a\u00020 2\u0006\u0010%\u001a\u00020VH\u0002J\u0010\u0010W\u001a\u00020 2\u0006\u0010%\u001a\u00020XH\u0002J\u0010\u0010Y\u001a\u00020 2\u0006\u0010%\u001a\u00020ZH\u0002J\u0010\u0010[\u001a\u00020 2\u0006\u0010\\\u001a\u00020]H\u0002J\u0010\u0010^\u001a\u00020 2\u0006\u0010%\u001a\u00020_H\u0002J\u0010\u0010`\u001a\u00020 2\u0006\u0010%\u001a\u00020aH\u0002J\u0010\u0010b\u001a\u00020 2\u0006\u0010%\u001a\u00020cH\u0002J\u0010\u0010d\u001a\u00020 2\u0006\u0010%\u001a\u00020eH\u0002J\u0010\u0010f\u001a\u00020 2\u0006\u0010\"\u001a\u00020gH\u0002J\u0010\u0010h\u001a\u00020 2\u0006\u0010%\u001a\u00020iH\u0002J\u0010\u0010j\u001a\u00020 2\u0006\u0010k\u001a\u00020lH\u0002J\u0010\u0010m\u001a\u00020 2\u0006\u0010%\u001a\u00020nH\u0002J\u0010\u0010o\u001a\u00020 2\u0006\u0010A\u001a\u00020pH\u0002J0\u0010q\u001a\u00020\u001e2\u0006\u00101\u001a\u0002022\u0019\u0010r\u001a\u0015\u0012\u0004\u0012\u00020\u0000\u0012\u0006\u0012\u0004\u0018\u00010\u00010s\u00a2\u0006\u0002\btH\u0000\u00a2\u0006\u0002\buJ\f\u0010v\u001a\u00020 *\u00020wH\u0002J\f\u0010x\u001a\u00020 *\u00020yH\u0002R \u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0002\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006z"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreter;", "", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "bodyMap", "", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "(Lorg/jetbrains/kotlin/ir/IrBuiltIns;Ljava/util/Map;)V", "irModule", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "(Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;)V", "environment", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;", "(Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;Ljava/util/Map;)V", "getBodyMap$ir_interpreter", "()Ljava/util/Map;", "callInterceptor", "Lorg/jetbrains/kotlin/ir/interpreter/CallInterceptor;", "callStack", "Lorg/jetbrains/kotlin/ir/interpreter/stack/CallStack;", "getCallStack", "()Lorg/jetbrains/kotlin/ir/interpreter/stack/CallStack;", "commandCount", "", "getEnvironment$ir_interpreter", "()Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;", "getIrBuiltIns", "()Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "getUnitState", "Lorg/jetbrains/kotlin/ir/interpreter/state/State;", "incrementAndCheckCommands", "", "interpret", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "file", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "interpretBlock", "block", "Lorg/jetbrains/kotlin/ir/expressions/IrBlock;", "interpretBody", "body", "interpretBranch", "branch", "Lorg/jetbrains/kotlin/ir/expressions/IrBranch;", "interpretCall", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "interpretClassReference", "classReference", "Lorg/jetbrains/kotlin/ir/expressions/IrClassReference;", "interpretConst", "Lorg/jetbrains/kotlin/ir/expressions/IrConst;", "interpretConstructor", "constructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "interpretConstructorCall", "constructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "interpretDelegatingConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "interpretDoWhile", "loop", "Lorg/jetbrains/kotlin/ir/expressions/IrDoWhileLoop;", "interpretEnumConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrEnumConstructorCall;", "interpretEnumEntry", "enumEntry", "Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "interpretField", "field", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "interpretFunction", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "interpretFunctionExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionExpression;", "interpretFunctionReference", "reference", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "interpretGetClass", "Lorg/jetbrains/kotlin/ir/expressions/IrGetClass;", "interpretGetEnumValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetEnumValue;", "interpretGetField", "Lorg/jetbrains/kotlin/ir/expressions/IrGetField;", "interpretGetObjectValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetObjectValue;", "interpretPropertyReference", "propertyReference", "Lorg/jetbrains/kotlin/ir/expressions/IrPropertyReference;", "interpretReturn", "Lorg/jetbrains/kotlin/ir/expressions/IrReturn;", "interpretSetField", "Lorg/jetbrains/kotlin/ir/expressions/IrSetField;", "interpretStringConcatenation", "Lorg/jetbrains/kotlin/ir/expressions/IrStringConcatenation;", "interpretThrow", "Lorg/jetbrains/kotlin/ir/expressions/IrThrow;", "interpretTry", "Lorg/jetbrains/kotlin/ir/expressions/IrTry;", "interpretTypeOperatorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrTypeOperatorCall;", "interpretValueParameter", "valueParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "interpretVararg", "Lorg/jetbrains/kotlin/ir/expressions/IrVararg;", "interpretWhile", "Lorg/jetbrains/kotlin/ir/expressions/IrWhileLoop;", "withNewCallStack", "init", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "withNewCallStack$ir_interpreter", "handle", "Lorg/jetbrains/kotlin/ir/interpreter/Instruction;", "tryResetFunctionBody", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "ir.interpreter"})
public final class IrInterpreter {
    @NotNull
    private final IrInterpreterEnvironment environment;
    @NotNull
    private final Map<IdSignature, IrBody> bodyMap;
    @NotNull
    private final CallInterceptor callInterceptor;
    private int commandCount;

    public IrInterpreter(@NotNull IrInterpreterEnvironment environment, @NotNull Map<IdSignature, ? extends IrBody> bodyMap) {
        Intrinsics.checkNotNullParameter(environment, "environment");
        Intrinsics.checkNotNullParameter(bodyMap, "bodyMap");
        this.environment = environment;
        this.bodyMap = bodyMap;
        this.callInterceptor = new DefaultCallInterceptor(this);
    }

    @NotNull
    public final IrInterpreterEnvironment getEnvironment$ir_interpreter() {
        return this.environment;
    }

    @NotNull
    public final Map<IdSignature, IrBody> getBodyMap$ir_interpreter() {
        return this.bodyMap;
    }

    @NotNull
    public final IrBuiltIns getIrBuiltIns() {
        return this.environment.getIrBuiltIns();
    }

    private final CallStack getCallStack() {
        return this.environment.getCallStack$ir_interpreter();
    }

    public IrInterpreter(@NotNull IrBuiltIns irBuiltIns, @NotNull Map<IdSignature, ? extends IrBody> bodyMap) {
        Intrinsics.checkNotNullParameter(irBuiltIns, "irBuiltIns");
        Intrinsics.checkNotNullParameter(bodyMap, "bodyMap");
        this(new IrInterpreterEnvironment(irBuiltIns, null, 2, null), bodyMap);
    }

    public /* synthetic */ IrInterpreter(IrBuiltIns irBuiltIns, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        this(irBuiltIns, map);
    }

    public IrInterpreter(@NotNull IrModuleFragment irModule) {
        Intrinsics.checkNotNullParameter(irModule, "irModule");
        this(new IrInterpreterEnvironment(irModule), MapsKt.emptyMap());
    }

    private final void incrementAndCheckCommands() {
        int n = this.commandCount;
        this.commandCount = n + 1;
        if (this.commandCount >= this.environment.getConfiguration().getMaxCommands()) {
            ExceptionUtilsKt.handleUserException(new InterpreterTimeOutError(), this.environment);
        }
    }

    private final State getUnitState() {
        Complex complex = this.environment.getMapOfObjects$ir_interpreter().get(this.getIrBuiltIns().getUnitClass());
        Intrinsics.checkNotNull(complex);
        return complex;
    }

    private final void handle(Instruction $this$handle) {
        Instruction instruction = $this$handle;
        if (instruction instanceof CompoundInstruction) {
            InstructionsUnfolderKt.unfoldInstruction($this$handle.getElement(), this.environment);
        } else if (instruction instanceof SimpleInstruction) {
            Unit unit2;
            this.interpret(((SimpleInstruction)$this$handle).getElement());
            Unit it = unit2 = Unit.INSTANCE;
            boolean bl = false;
            this.incrementAndCheckCommands();
        } else if (instruction instanceof CustomInstruction) {
            ((CustomInstruction)$this$handle).getEvaluate().invoke();
        }
    }

    @NotNull
    public final IrExpression interpret(@NotNull IrExpression expression2, @Nullable IrFile file2) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        this.commandCount = 0;
        this.getCallStack().newFrame(expression2, file2);
        InstructionKt.pushCompoundInstruction(this.getCallStack(), expression2);
        while (!this.getCallStack().hasNoInstructions()) {
            this.handle(this.getCallStack().popInstruction());
        }
        IrExpression $this$interpret_u24lambda_u241 = irExpression = this.environment.stateToIrExpression$ir_interpreter(this.getCallStack().popState(), expression2);
        boolean bl = false;
        this.getCallStack().dropFrame();
        return irExpression;
    }

    public static /* synthetic */ IrExpression interpret$default(IrInterpreter irInterpreter, IrExpression irExpression, IrFile irFile, int n, Object object) {
        if ((n & 2) != 0) {
            irFile = null;
        }
        return irInterpreter.interpret(irExpression, irFile);
    }

    @NotNull
    public final State withNewCallStack$ir_interpreter(@NotNull IrCall call2, @NotNull Function1<? super IrInterpreter, ? extends Object> init2) {
        State state;
        Intrinsics.checkNotNullParameter(call2, "call");
        Intrinsics.checkNotNullParameter(init2, "init");
        IrInterpreter $this$withNewCallStack_u24lambda_u243 = new IrInterpreter(this.environment.copyWithNewCallStack(), this.bodyMap);
        boolean bl = false;
        $this$withNewCallStack_u24lambda_u243.getCallStack().newFrame((IrFunction)call2.getSymbol().getOwner());
        init2.invoke($this$withNewCallStack_u24lambda_u243);
        while (!$this$withNewCallStack_u24lambda_u243.getCallStack().hasNoInstructions()) {
            $this$withNewCallStack_u24lambda_u243.handle($this$withNewCallStack_u24lambda_u243.getCallStack().popInstruction());
        }
        State $this$withNewCallStack_u24lambda_u243_u24lambda_u242 = state = $this$withNewCallStack_u24lambda_u243.getCallStack().popState();
        boolean bl2 = false;
        $this$withNewCallStack_u24lambda_u243.getCallStack().dropFrame();
        return state;
    }

    private final void interpret(IrElement element) {
        IrElement irElement = element;
        if (irElement instanceof IrSimpleFunction) {
            this.interpretFunction((IrSimpleFunction)element);
        } else if (irElement instanceof IrConstructor) {
            this.interpretConstructor((IrConstructor)element);
        } else if (irElement instanceof IrCall) {
            this.interpretCall((IrCall)element);
        } else if (irElement instanceof IrConstructorCall) {
            this.interpretConstructorCall((IrFunctionAccessExpression)element);
        } else if (irElement instanceof IrEnumConstructorCall) {
            this.interpretEnumConstructorCall((IrEnumConstructorCall)element);
        } else if (irElement instanceof IrDelegatingConstructorCall) {
            this.interpretDelegatingConstructorCall((IrDelegatingConstructorCall)element);
        } else if (irElement instanceof IrValueParameter) {
            this.interpretValueParameter((IrValueParameter)element);
        } else if (irElement instanceof IrField) {
            this.interpretField((IrField)element);
        } else if (irElement instanceof IrBody) {
            this.interpretBody((IrBody)element);
        } else if (irElement instanceof IrBlock) {
            this.interpretBlock((IrBlock)element);
        } else if (irElement instanceof IrReturn) {
            this.interpretReturn((IrReturn)element);
        } else if (irElement instanceof IrSetField) {
            this.interpretSetField((IrSetField)element);
        } else if (irElement instanceof IrGetField) {
            this.interpretGetField((IrGetField)element);
        } else if (irElement instanceof IrGetObjectValue) {
            this.interpretGetObjectValue((IrGetObjectValue)element);
        } else if (irElement instanceof IrGetEnumValue) {
            this.interpretGetEnumValue((IrGetEnumValue)element);
        } else if (irElement instanceof IrEnumEntry) {
            this.interpretEnumEntry((IrEnumEntry)element);
        } else if (irElement instanceof IrConst) {
            this.interpretConst((IrConst)element);
        } else if (irElement instanceof IrVariable) {
            this.getCallStack().storeState((IrSymbol)((IrVariable)element).getSymbol(), this.getCallStack().popState());
        } else if (irElement instanceof IrSetValue) {
            this.getCallStack().rewriteState(((IrSetValue)element).getSymbol(), this.getCallStack().popState());
        } else if (irElement instanceof IrTypeOperatorCall) {
            this.interpretTypeOperatorCall((IrTypeOperatorCall)element);
        } else if (irElement instanceof IrBranch) {
            this.interpretBranch((IrBranch)element);
        } else if (irElement instanceof IrWhileLoop) {
            this.interpretWhile((IrWhileLoop)element);
        } else if (irElement instanceof IrDoWhileLoop) {
            this.interpretDoWhile((IrDoWhileLoop)element);
        } else if (irElement instanceof IrWhen) {
            this.getCallStack().dropSubFrame();
        } else if (irElement instanceof IrVararg) {
            this.interpretVararg((IrVararg)element);
        } else if (irElement instanceof IrTry) {
            this.interpretTry((IrTry)element);
        } else if (irElement instanceof IrThrow) {
            this.interpretThrow((IrThrow)element);
        } else if (irElement instanceof IrStringConcatenation) {
            this.interpretStringConcatenation((IrStringConcatenation)element);
        } else if (irElement instanceof IrFunctionExpression) {
            this.interpretFunctionExpression((IrFunctionExpression)element);
        } else if (irElement instanceof IrFunctionReference) {
            this.interpretFunctionReference((IrFunctionReference)element);
        } else if (irElement instanceof IrPropertyReference) {
            this.interpretPropertyReference((IrPropertyReference)element);
        } else if (irElement instanceof IrClassReference) {
            this.interpretClassReference((IrClassReference)element);
        } else if (irElement instanceof IrGetClass) {
            this.interpretGetClass((IrGetClass)element);
        } else {
            String string2 = element.getClass() + " not supported for interpretation";
            throw new NotImplementedError("An operation is not implemented: " + string2);
        }
    }

    private final void tryResetFunctionBody(IrFunction $this$tryResetFunctionBody) {
        IdSignature idSignature = $this$tryResetFunctionBody.getSymbol().getSignature();
        if (idSignature == null) {
            return;
        }
        IdSignature signature2 = idSignature;
        if (this.bodyMap.get(signature2) != null) {
            $this$tryResetFunctionBody.setBody(null);
        }
    }

    private final void interpretFunction(IrSimpleFunction function2) {
        this.tryResetFunctionBody(function2);
        if (UtilsKt.checkCast(function2, this.environment)) {
            this.getCallStack().dropFrameAndCopyResult();
        }
    }

    private final void interpretValueParameter(IrValueParameter valueParameter2) {
        IrDeclarationParent irDeclarationParent = valueParameter2.getParent();
        Intrinsics.checkNotNull(irDeclarationParent, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrFunction");
        IrFunction irFunction2 = (IrFunction)irDeclarationParent;
        State state = this.getCallStack().popState();
        if (StateKt.checkNullability(state, valueParameter2.getType(), this.environment, (Function0<? extends Throwable>)new Function0<Throwable>(irFunction2, valueParameter2){
            final /* synthetic */ IrFunction $irFunction;
            final /* synthetic */ IrValueParameter $valueParameter;
            {
                this.$irFunction = $irFunction;
                this.$valueParameter = $valueParameter;
                super(0);
            }

            @NotNull
            public final Throwable invoke() {
                if (IrInterpreter.access$interpretValueParameter$isReceiver(this.$irFunction, this.$valueParameter)) {
                    return new NullPointerException();
                }
                String method = UtilsKt.getCapitalizedFileName(this.$irFunction) + '.' + UtilsKt.getFqName(this.$irFunction);
                Name parameter = this.$valueParameter.getName();
                return new IllegalArgumentException("Parameter specified as non-null is null: method " + method + ", parameter " + parameter);
            }
        }) == null) {
            return;
        }
        this.getCallStack().pushState(state);
    }

    /*
     * WARNING - void declaration
     */
    private final void interpretCall(IrCall call2) {
        IrValueParameterSymbol it;
        State dispatchReceiver;
        Object object;
        State state;
        State state2;
        void $this$mapTo$iv$iv;
        IrSimpleFunction owner = (IrSimpleFunction)call2.getSymbol().getOwner();
        Iterable $this$map$iv = owner.getValueParameters();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getCallStack().popState());
        }
        List valueArguments = CollectionsKt.reversed((List)destination$iv$iv);
        IrValueParameterSymbol irValueParameterSymbol = UtilsKt.getExtensionReceiver(owner);
        if (irValueParameterSymbol != null) {
            IrValueParameterSymbol it2 = irValueParameterSymbol;
            boolean bl = false;
            state2 = this.getCallStack().popState();
        } else {
            state2 = null;
        }
        State extensionReceiver = state2;
        IrValueParameterSymbol irValueParameterSymbol2 = UtilsKt.getDispatchReceiver(owner);
        if (irValueParameterSymbol2 != null) {
            IrValueParameterSymbol it3 = irValueParameterSymbol2;
            boolean bl = false;
            state = this.getCallStack().popState();
        } else {
            state = null;
        }
        if ((object = (dispatchReceiver = state)) == null || (object = object.getIrFunctionByIrCall(call2)) == null) {
            object = call2.getSymbol().getOwner();
        }
        Object irFunction2 = object;
        State[] it3 = new State[]{IrInterpreter.interpretCall$getThisOrSuperReceiver(dispatchReceiver, (IrFunction)irFunction2), extensionReceiver};
        List args2 = CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull(it3), (Iterable)valueArguments);
        Map<IrTypeParameterSymbol, KTypeState> reifiedTypeArguments = UtilsKt.loadReifiedTypeArguments(this.environment, call2);
        this.getCallStack().newFrame((IrFunction)irFunction2);
        InstructionKt.pushSimpleInstruction(this.getCallStack(), (IrElement)irFunction2);
        if (dispatchReceiver instanceof StateWithClosure) {
            this.getCallStack().loadUpValues((StateWithClosure)((Object)dispatchReceiver));
        }
        if (extensionReceiver instanceof StateWithClosure) {
            this.getCallStack().loadUpValues((StateWithClosure)((Object)extensionReceiver));
        }
        if (AdditionalIrUtilsKt.isLocal((IrDeclaration)irFunction2)) {
            this.getCallStack().copyUpValuesFromPreviousFrame();
        }
        IrValueParameterSymbol irValueParameterSymbol3 = UtilsKt.getDispatchReceiver((IrFunction)irFunction2);
        if (irValueParameterSymbol3 != null) {
            it = irValueParameterSymbol3;
            boolean bl = false;
            CallStack callStack = this.getCallStack();
            IrSymbol irSymbol2 = it;
            State state3 = dispatchReceiver;
            Intrinsics.checkNotNull(state3);
            callStack.storeState(irSymbol2, state3);
        }
        IrValueParameterSymbol irValueParameterSymbol4 = UtilsKt.getExtensionReceiver((IrFunction)irFunction2);
        if (irValueParameterSymbol4 != null) {
            it = irValueParameterSymbol4;
            boolean bl = false;
            CallStack callStack = this.getCallStack();
            IrSymbol irSymbol3 = it;
            State state4 = extensionReceiver;
            if (state4 == null) {
                state4 = this.getCallStack().loadState(it);
            }
            callStack.storeState(irSymbol3, state4);
        }
        Iterable $this$forEachIndexed$iv = ((IrFunction)irFunction2).getValueParameters();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void param;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrValueParameter irValueParameter = (IrValueParameter)item$iv;
            int i = n;
            boolean bl = false;
            this.getCallStack().storeState((IrSymbol)param.getSymbol(), (State)valueArguments.get(i));
        }
        this.getCallStack().storeState((IrSymbol)((IrFunction)irFunction2).getSymbol(), new KTypeState(call2.getType(), (IrClass)this.environment.getKTypeClass$ir_interpreter().getOwner()));
        Map<IrTypeParameterSymbol, KTypeState> $this$forEach$iv = reifiedTypeArguments;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<IrTypeParameterSymbol, KTypeState>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<IrTypeParameterSymbol, KTypeState> element$iv;
            Map.Entry<IrTypeParameterSymbol, KTypeState> it4 = element$iv = iterator2.next();
            boolean bl = false;
            this.getCallStack().storeState((IrSymbol)it4.getKey(), it4.getValue());
        }
        if (dispatchReceiver instanceof Complex) {
            IrClass irClass2 = IrUtilsKt.getParentClassOrNull((IrDeclaration)irFunction2);
            boolean bl = irClass2 != null ? irClass2.isInner() : false;
            if (bl) {
                Complex.DefaultImpls.loadOuterClassesInto$default((Complex)dispatchReceiver, this.getCallStack(), null, 2, null);
            }
        }
        this.callInterceptor.interceptCall(call2, (IrFunction)irFunction2, args2, new Function0<Unit>(this, (IrFunction)irFunction2){
            final /* synthetic */ IrInterpreter this$0;
            final /* synthetic */ IrFunction $irFunction;
            {
                this.this$0 = $receiver;
                this.$irFunction = $irFunction;
                super(0);
            }

            public final void invoke() {
                InstructionKt.pushCompoundInstruction(IrInterpreter.access$getCallStack(this.this$0), this.$irFunction);
            }
        });
    }

    private final void interpretField(IrField field2) {
        IrClass irClass2 = IrUtilsKt.getParentAsClass(field2);
        IrValueParameter irValueParameter = irClass2.getThisReceiver();
        Intrinsics.checkNotNull(irValueParameter);
        IrValueParameterSymbol receiver = irValueParameter.getSymbol();
        State receiverState = this.getCallStack().loadState(receiver);
        IrPropertySymbol irPropertySymbol = field2.getCorrespondingPropertySymbol();
        Intrinsics.checkNotNull(irPropertySymbol);
        receiverState.setField(irPropertySymbol, this.getCallStack().popState());
    }

    private final void interpretBody(IrBody body2) {
        if (this.getCallStack().peekState() == null) {
            this.getCallStack().pushState(this.getUnitState());
        }
    }

    private final void interpretBlock(IrBlock block) {
        this.getCallStack().dropSubFrame();
        if (this.getCallStack().peekState() == null) {
            this.getCallStack().pushState(this.getUnitState());
        }
    }

    private final void interpretConstructor(IrConstructor constructor2) {
        CallStack callStack = this.getCallStack();
        CallStack callStack2 = this.getCallStack();
        IrValueParameter irValueParameter = IrUtilsKt.getParentAsClass(constructor2).getThisReceiver();
        Intrinsics.checkNotNull(irValueParameter);
        callStack.pushState(callStack2.loadState(irValueParameter.getSymbol()));
        this.getCallStack().dropFrameAndCopyResult();
    }

    /*
     * WARNING - void declaration
     */
    private final void interpretConstructorCall(IrFunctionAccessExpression constructorCall) {
        IrValueSymbol superReceiver;
        IrValueSymbol irValueSymbol;
        IrStatement irStatement;
        State state;
        State objectState;
        State state2;
        IrValueParameterSymbol receiverSymbol;
        void $this$mapTo$iv$iv;
        IrFunction constructor2 = ((IrFunctionSymbol)constructorCall.getSymbol()).getOwner();
        Iterable $this$map$iv = constructor2.getValueParameters();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getCallStack().popState());
        }
        List valueArguments = CollectionsKt.reversed((List)destination$iv$iv);
        IrClass irClass2 = IrUtilsKt.getParentAsClass(constructor2);
        IrValueParameter irValueParameter = constructor2.getDispatchReceiverParameter();
        IrValueParameterSymbol irValueParameterSymbol = receiverSymbol = irValueParameter != null ? irValueParameter.getSymbol() : null;
        if (!(constructorCall instanceof IrConstructorCall)) {
            state2 = this.getCallStack().loadState(UtilsKt.getThisReceiver(constructorCall));
        } else {
            StateWithClosure $this$interpretConstructorCall_u24lambda_u2412 = $i$f$mapTo = UtilsKt.isSubclassOfThrowable(irClass2) ? new ExceptionState(irClass2, this.environment) : new Common(irClass2);
            boolean bl = false;
            if (IrUtilsKt.isObject(irClass2)) {
                this.environment.getMapOfObjects$ir_interpreter().put(irClass2.getSymbol(), (Complex)((Object)$this$interpretConstructorCall_u24lambda_u2412));
            }
            state2 = objectState = (State)((Object)$i$f$mapTo);
        }
        if (AdditionalIrUtilsKt.isLocal(irClass2)) {
            CallStack callStack = this.getCallStack();
            Intrinsics.checkNotNull(objectState, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.StateWithClosure");
            callStack.storeUpValues((StateWithClosure)((Object)objectState));
        }
        IrValueParameterSymbol irValueParameterSymbol2 = receiverSymbol;
        if (irValueParameterSymbol2 != null) {
            IrValueParameterSymbol it = irValueParameterSymbol2;
            boolean bl = false;
            state = this.getCallStack().popState();
        } else {
            state = null;
        }
        State outerClass2 = state;
        IrType returnType2 = UtilsKt.getTypeIfReified(constructorCall.getType(), this.getCallStack());
        this.getCallStack().newFrame(constructor2);
        InstructionKt.pushSimpleInstruction(this.getCallStack(), constructor2);
        if (AdditionalIrUtilsKt.isLocal(irClass2)) {
            CallStack callStack = this.getCallStack();
            Intrinsics.checkNotNull(objectState, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.StateWithClosure");
            callStack.loadUpValues((StateWithClosure)((Object)objectState));
        }
        this.getCallStack().storeState((IrSymbol)UtilsKt.getThisReceiver(constructorCall), objectState);
        Iterable $this$forEachIndexed$iv = constructor2.getValueParameters();
        boolean $i$f$forEachIndexed = false;
        int index$iv2 = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void param;
            int n;
            if ((n = index$iv2++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrValueParameter irValueParameter2 = (IrValueParameter)item$iv;
            int i = n;
            boolean bl = false;
            this.getCallStack().storeState((IrSymbol)param.getSymbol(), (State)valueArguments.get(i));
        }
        this.getCallStack().storeState((IrSymbol)constructor2.getSymbol(), new KTypeState(returnType2, (IrClass)this.environment.getKTypeClass$ir_interpreter().getOwner()));
        Object object = constructor2.getBody();
        IrStatement irStatement2 = object != null && (object = IrUtilsKt.getStatements((IrBody)object)) != null ? (IrStatement)object.get(0) : (irStatement = null);
        if (irStatement == null) {
            irValueSymbol = null;
        } else if (irStatement instanceof IrTypeOperatorCall) {
            IrExpression irExpression = ((IrTypeOperatorCall)irStatement).getArgument();
            Intrinsics.checkNotNull(irExpression, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression");
            irValueSymbol = UtilsKt.getThisReceiver((IrFunctionAccessExpression)irExpression);
        } else if (irStatement instanceof IrFunctionAccessExpression) {
            irValueSymbol = UtilsKt.getThisReceiver((IrFunctionAccessExpression)irStatement);
        } else if (irStatement instanceof IrBlock) {
            IrStatement irStatement3 = CollectionsKt.last(((IrBlock)irStatement).getStatements());
            Intrinsics.checkNotNull(irStatement3, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression");
            irValueSymbol = UtilsKt.getThisReceiver((IrFunctionAccessExpression)irStatement3);
        } else {
            String index$iv2 = irStatement.getClass() + " is not supported as first statement in constructor call";
            throw new NotImplementedError("An operation is not implemented: " + index$iv2);
        }
        IrValueSymbol irValueSymbol2 = superReceiver = irValueSymbol;
        if (irValueSymbol2 != null) {
            IrValueSymbol it = irValueSymbol2;
            boolean bl = false;
            this.getCallStack().storeState((IrSymbol)it, objectState);
        }
        if (outerClass2 != null) {
            IrValueParameter irValueParameter3 = IrUtilsKt.getParentAsClass(irClass2).getThisReceiver();
            Intrinsics.checkNotNull(irValueParameter3);
            Pair<IrValueParameterSymbol, State> outerClassSymbolToState = TuplesKt.to(irValueParameter3.getSymbol(), outerClass2);
            Intrinsics.checkNotNull(objectState, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.Complex");
            ((Complex)objectState).setOuterClass(outerClassSymbolToState);
            Object object2 = superReceiver;
            if (!Intrinsics.areEqual(object2 != null && (object2 = object2.getOwner()) != null ? object2.getType() : null, ((IrValueParameter)receiverSymbol.getOwner()).getType())) {
                this.getCallStack().storeState((IrSymbol)receiverSymbol, outerClass2);
                ((Complex)objectState).loadOuterClassesInto(this.getCallStack(), UtilsKt.getThisReceiver(constructorCall));
            }
        }
        this.callInterceptor.interceptConstructor(constructorCall, valueArguments, new Function0<Unit>(this, constructor2){
            final /* synthetic */ IrInterpreter this$0;
            final /* synthetic */ IrFunction $constructor;
            {
                this.this$0 = $receiver;
                this.$constructor = $constructor;
                super(0);
            }

            public final void invoke() {
                InstructionKt.pushCompoundInstruction(IrInterpreter.access$getCallStack(this.this$0), this.$constructor);
            }
        });
    }

    private final void interpretDelegatingConstructorCall(IrDelegatingConstructorCall constructorCall) {
        if (Intrinsics.areEqual(((IrConstructor)constructorCall.getSymbol().getOwner()).getParent(), this.getIrBuiltIns().getAnyClass().getOwner())) {
            return;
        }
        this.interpretConstructorCall(constructorCall);
    }

    private final void interpretEnumConstructorCall(IrEnumConstructorCall constructorCall) {
        this.interpretConstructorCall(constructorCall);
    }

    private final void interpretConst(IrConst<?> expression2) {
        IrType signedType = IrInterpreter.interpretConst$getSignedType(this, expression2.getType());
        if (signedType != null) {
            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(expression2.getType());
            Intrinsics.checkNotNull(irClassSymbol);
            IrClassSymbol unsignedClass = irClassSymbol;
            IrConstructor constructor2 = (IrConstructor)SequencesKt.single(IrUtilsKt.getConstructors(unsignedClass)).getOwner();
            IrConstructorCallImpl constructorCall = IrConstructorCallImpl.Companion.fromSymbolOwner$default(IrConstructorCallImpl.Companion, constructor2.getReturnType(), constructor2.getSymbol(), null, 4, null);
            constructorCall.putValueArgument(0, IrTreeBuildUtilsKt.toIrConst$default(expression2.getValue(), signedType, 0, 0, 6, null));
            InstructionKt.pushCompoundInstruction(this.getCallStack(), constructorCall);
            return;
        }
        this.getCallStack().pushState(UtilsKt.toPrimitive(expression2));
    }

    private final void interpretReturn(IrReturn expression2) {
        this.getCallStack().returnFromFrameWithResult(expression2);
    }

    private final void interpretWhile(IrWhileLoop loop2) {
        boolean result2 = StateKt.asBoolean(this.getCallStack().popState());
        this.getCallStack().dropSubFrame();
        if (result2) {
            this.getCallStack().newSubFrame(loop2);
            InstructionKt.pushSimpleInstruction(this.getCallStack(), loop2);
            InstructionKt.pushCompoundInstruction(this.getCallStack(), loop2.getCondition());
            InstructionKt.pushCompoundInstruction(this.getCallStack(), loop2.getBody());
        }
    }

    private final void interpretDoWhile(IrDoWhileLoop loop2) {
        boolean result2 = StateKt.asBoolean(this.getCallStack().popState());
        this.getCallStack().dropSubFrame();
        if (result2) {
            this.getCallStack().newSubFrame(loop2);
            InstructionKt.pushSimpleInstruction(this.getCallStack(), loop2);
            InstructionKt.pushCompoundInstruction(this.getCallStack(), loop2.getCondition());
            InstructionKt.pushCompoundInstruction(this.getCallStack(), loop2.getBody());
        }
    }

    private final void interpretBranch(IrBranch branch) {
        boolean result2 = StateKt.asBoolean(this.getCallStack().popState());
        if (result2) {
            this.getCallStack().dropSubFrame();
            InstructionKt.pushCompoundInstruction(this.getCallStack(), branch.getResult());
        }
    }

    private final void interpretSetField(IrSetField expression2) {
        State state;
        IrExpression irExpression = expression2.getReceiver();
        Intrinsics.checkNotNull(irExpression, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrDeclarationReference");
        IrSymbol receiver = ((IrDeclarationReference)irExpression).getSymbol();
        IrPropertySymbol irPropertySymbol = ((IrField)expression2.getSymbol().getOwner()).getCorrespondingPropertySymbol();
        Intrinsics.checkNotNull(irPropertySymbol);
        IrPropertySymbol propertySymbol = irPropertySymbol;
        State $this$interpretSetField_u24lambda_u2416 = state = this.getCallStack().loadState(receiver);
        boolean bl = false;
        $this$interpretSetField_u24lambda_u2416.setField(propertySymbol, this.getCallStack().popState());
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void interpretGetField(IrGetField expression) {
        block6: {
            block8: {
                block7: {
                    block5: {
                        var4_2 = expression.getReceiver();
                        v0 = var4_2 instanceof IrDeclarationReference != false ? (IrDeclarationReference)var4_2 : null;
                        receiver = v0 != null ? v0.getSymbol() : null;
                        field = (IrField)expression.getSymbol().getOwner();
                        if (!Intrinsics.areEqual(field.getOrigin(), IrDeclarationOrigin.IR_EXTERNAL_JAVA_DECLARATION_STUB.INSTANCE) || !field.isStatic()) break block5;
                        v1 = field.getInitializer();
                        v2 = initializerExpression = v1 != null ? v1.getExpression() : null;
                        if (initializerExpression instanceof IrConst) {
                            InstructionKt.pushSimpleInstruction(this.getCallStack(), initializerExpression);
                        } else {
                            this.callInterceptor.interceptJavaStaticField(expression);
                        }
                        break block6;
                    }
                    if (!Intrinsics.areEqual(field.getOrigin(), IrDeclarationOrigin.PROPERTY_BACKING_FIELD.INSTANCE)) break block7;
                    v3 = field.getCorrespondingPropertySymbol();
                    v4 = v3 != null && (v3 = (IrProperty)v3.getOwner()) != null ? v3.isConst() : false;
                    if (!v4) break block7;
                    v5 = field.getInitializer();
                    InstructionKt.pushCompoundInstruction(this.getCallStack(), v5 != null ? v5.getExpression() : null);
                    break block6;
                }
                if (!UtilsKt.accessesTopLevelOrObjectField(expression)) break block8;
                v6 = field.getCorrespondingPropertySymbol();
                v7 = propertyOwner = v6 != null ? (IrProperty)v6.getOwner() : null;
                if ((v7 != null ? v7.isConst() : false) || ((v8 = propertyOwner) != null && (v8 = v8.getBackingField()) != null && (v8 = v8.getInitializer()) != null ? v8.getExpression() : null) instanceof IrConst) ** GOTO lbl-1000
                v9 /* !! */  = propertyOwner;
                v10 = v9 /* !! */  != null && (v9 /* !! */  = IrUtilsKt.getParentClassOrNull(v9 /* !! */ )) != null ? UtilsKt.hasAnnotation(v9 /* !! */ , UtilsKt.getCompileTimeAnnotation()) : false;
                if (v10) lbl-1000:
                // 2 sources

                {
                    v11 = true;
                } else {
                    v11 = false;
                }
                isConst = v11;
                $i$f$verify = false;
                if (!isConst) {
                    $i$a$-verify-IrInterpreter$interpretGetField$1 = false;
                    var8_8 = "Cannot interpret get method on top level non const properties".toString();
                    throw new InterpreterAssertionError(var8_8);
                }
                v12 = field.getInitializer();
                InstructionKt.pushCompoundInstruction(this.getCallStack(), v12 != null ? v12.getExpression() : null);
                break block6;
            }
            v13 = this.getCallStack();
            v14 = receiver;
            Intrinsics.checkNotNull(v14);
            v15 = v13.loadState(v14);
            v16 = field.getCorrespondingPropertySymbol();
            Intrinsics.checkNotNull(v16);
            result = v15.getField(v16);
            v17 = this.getCallStack();
            v18 = result;
            Intrinsics.checkNotNull(v18);
            v17.pushState(v18);
        }
    }

    private final void interpretGetObjectValue(IrGetObjectValue expression2) {
        this.callInterceptor.interceptGetObjectValue(expression2, new Function0<Unit>(expression2, this){
            final /* synthetic */ IrGetObjectValue $expression;
            final /* synthetic */ IrInterpreter this$0;
            {
                this.$expression = $expression;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                boolean buildObject;
                IrClass objectClass = (IrClass)this.$expression.getSymbol().getOwner();
                boolean bl = buildObject = UtilsKt.hasAnnotation(objectClass, UtilsKt.getCompileTimeAnnotation()) || this.this$0.getEnvironment$ir_interpreter().getConfiguration().getCreateNonCompileTimeObjects();
                if (SequencesKt.none(IrUtilsKt.getConstructors(objectClass)) || !buildObject) {
                    Common state = new Common(objectClass);
                    this.this$0.getEnvironment$ir_interpreter().getMapOfObjects$ir_interpreter().put(objectClass.getSymbol(), state);
                    IrInterpreter.access$getCallStack(this.this$0).pushState(state);
                    return;
                }
                IrConstructor constructor2 = SequencesKt.first(IrUtilsKt.getConstructors(objectClass));
                IrConstructorCallImpl constructorCall = IrConstructorCallImpl.Companion.fromSymbolOwner$default(IrConstructorCallImpl.Companion, constructor2.getReturnType(), constructor2.getSymbol(), null, 4, null);
                InstructionKt.pushCompoundInstruction(IrInterpreter.access$getCallStack(this.this$0), constructorCall);
            }
        });
    }

    private final void interpretGetEnumValue(IrGetEnumValue expression2) {
        CallStack callStack = this.getCallStack();
        Complex complex = this.environment.getMapOfEnums$ir_interpreter().get(expression2.getSymbol());
        Intrinsics.checkNotNull(complex);
        callStack.pushState(complex);
    }

    private final void interpretEnumEntry(IrEnumEntry enumEntry) {
        this.callInterceptor.interceptEnumEntry(enumEntry, new Function0<Unit>(enumEntry, this){
            final /* synthetic */ IrEnumEntry $enumEntry;
            final /* synthetic */ IrInterpreter this$0;
            {
                this.$enumEntry = $enumEntry;
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                Common enumClassObject = UtilsKt.toState(this.$enumEntry, this.this$0.getIrBuiltIns());
                this.this$0.getEnvironment$ir_interpreter().getMapOfEnums$ir_interpreter().put(this.$enumEntry.getSymbol(), enumClassObject);
                IrElementBase irElementBase = this.$enumEntry.getInitializerExpression();
                if (irElementBase == null || (irElementBase = irElementBase.getExpression()) == null) {
                    throw new InterpreterError("Initializer at enum entry " + UtilsKt.getFqName(this.$enumEntry) + " is null");
                }
                IrElementBase enumInitializer = irElementBase;
                IrEnumConstructorCall irEnumConstructorCall = enumInitializer instanceof IrEnumConstructorCall ? (IrEnumConstructorCall)enumInitializer : null;
                if (irEnumConstructorCall == null) {
                    void $this$filterIsInstanceTo$iv$iv;
                    Iterable $this$filterIsInstance$iv = ((IrBlock)enumInitializer).getStatements();
                    boolean $i$f$filterIsInstance = false;
                    Iterable iterable = $this$filterIsInstance$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof IrEnumConstructorCall)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    irEnumConstructorCall = (IrEnumConstructorCall)CollectionsKt.single((List)destination$iv$iv);
                }
                IrEnumConstructorCall enumConstructorCall = irEnumConstructorCall;
                IrInterpreter.access$getCallStack(this.this$0).newSubFrame(this.$enumEntry);
                InstructionKt.pushCompoundInstruction(IrInterpreter.access$getCallStack(this.this$0), this.$enumEntry);
                InstructionKt.pushCompoundInstruction(IrInterpreter.access$getCallStack(this.this$0), enumInitializer);
                IrInterpreter.access$getCallStack(this.this$0).storeState((IrSymbol)UtilsKt.getThisReceiver(enumConstructorCall), enumClassObject);
            }
        });
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final void interpretTypeOperatorCall(IrTypeOperatorCall expression2) {
        IrClassifierSymbol typeClassifier = IrTypesKt.getClassifierOrFail(expression2.getTypeOperand());
        IrSymbolOwner irSymbolOwner = typeClassifier.getOwner();
        IrTypeParameter irTypeParameter2 = irSymbolOwner instanceof IrTypeParameter ? (IrTypeParameter)irSymbolOwner : null;
        boolean isReified = irTypeParameter2 != null ? irTypeParameter2.isReified() : false;
        boolean isErased = typeClassifier.getOwner() instanceof IrTypeParameter && !isReified;
        IrType typeOperand = UtilsKt.getTypeIfReified(expression2.getTypeOperand(), this.getCallStack());
        State state = this.getCallStack().popState();
        switch (WhenMappings.$EnumSwitchMapping$1[expression2.getOperator().ordinal()]) {
            case 1: {
                return;
            }
            case 2: 
            case 3: {
                if (StateKt.isNull(state) && !IrTypeUtilsKt.isNullable(typeOperand)) {
                    ExceptionUtilsKt.handleUserException(new NullPointerException(), this.environment);
                    return;
                }
                if (!isErased && !StateKt.isSubtypeOf(state, typeOperand)) {
                    String castedClassName = UtilsKt.getFqName(state.getIrClass());
                    ExceptionUtilsKt.handleUserException(new ClassCastException(castedClassName + " cannot be cast to " + RenderIrElementKt.render(typeOperand)), this.environment);
                    return;
                }
                this.getCallStack().pushState(state);
                return;
            }
            case 4: {
                if (!isErased && !StateKt.isSubtypeOf(state, typeOperand)) {
                    this.getCallStack().pushState(this.environment.convertToState$ir_interpreter(null, this.getIrBuiltIns().getNothingNType()));
                    return;
                }
                this.getCallStack().pushState(state);
                return;
            }
            case 5: {
                boolean isInstance = isErased || StateKt.isSubtypeOf(state, typeOperand);
                this.getCallStack().pushState(this.environment.convertToState$ir_interpreter(isInstance, this.getIrBuiltIns().getBooleanType()));
                return;
            }
            case 6: {
                boolean isInstance = isErased || StateKt.isSubtypeOf(state, typeOperand);
                this.getCallStack().pushState(this.environment.convertToState$ir_interpreter(!isInstance, this.getIrBuiltIns().getBooleanType()));
                return;
            }
            case 7: {
                if (StateKt.isNull(state) && !IrTypeUtilsKt.isNullable(typeOperand)) {
                    ExceptionUtilsKt.handleUserException(new NullPointerException(), this.environment);
                    return;
                }
                this.getCallStack().pushState(state);
                return;
            }
            case 8: {
                State state2;
                if (StateKt.isNull(state)) {
                    state2 = state;
                } else if (state instanceof KFunctionState) {
                    State state3 = state;
                    KFunctionState $this$interpretTypeOperatorCall_u24lambda_u2418 = (KFunctionState)state3;
                    boolean bl = false;
                    $this$interpretTypeOperatorCall_u24lambda_u2418.setFunInterface(typeOperand);
                    state2 = state3;
                } else {
                    DeepCopyTypeRemapper typeRemapper$iv$iv;
                    Object element$iv;
                    IrFunction it;
                    void $this$first$iv;
                    Iterator $this$filterIsInstanceTo$iv$iv;
                    IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(typeOperand);
                    Intrinsics.checkNotNull(irClassSymbol);
                    IrClass samClass = (IrClass)irClassSymbol.getOwner();
                    IrFunction samFunction = UtilsKt.getSingleAbstractMethod(samClass);
                    Iterable $this$filterIsInstance$iv = state.getIrClass().getDeclarations();
                    boolean $i$f$filterIsInstance = false;
                    Iterable iterable = $this$filterIsInstance$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterIsInstanceTo = false;
                    Iterator iterator2 = $this$filterIsInstanceTo$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        Object t = iterator2.next();
                        if (!(t instanceof IrFunction)) continue;
                        destination$iv$iv.add(t);
                    }
                    $this$filterIsInstance$iv = (List)destination$iv$iv;
                    boolean $i$f$first = false;
                    $this$filterIsInstanceTo$iv$iv = $this$first$iv.iterator();
                    do {
                        if (!$this$filterIsInstanceTo$iv$iv.hasNext()) throw new NoSuchElementException("Collection contains no element matching the predicate.");
                        element$iv = $this$filterIsInstanceTo$iv$iv.next();
                        it = (IrFunction)element$iv;
                        boolean bl = false;
                    } while (!(Intrinsics.areEqual(it.getName(), OperatorNameConventions.INVOKE) && it.getValueParameters().size() == samFunction.getValueParameters().size()));
                    IrFunction invokeFunction = (IrFunction)element$iv;
                    IrClass functionClass = IrUtilsKt.getParentAsClass(UtilsKt.getLastOverridden(invokeFunction));
                    IrValueParameter irValueParameter = invokeFunction.getDispatchReceiverParameter();
                    Intrinsics.checkNotNull(irValueParameter);
                    Pair<IrValueParameterSymbol, State> dispatchReceiver = TuplesKt.to(irValueParameter.getSymbol(), state);
                    IrElement $this$deepCopyWithSymbols_u24default$iv = invokeFunction;
                    boolean $i$f$deepCopyWithSymbols = false;
                    IrElement irElement = $this$deepCopyWithSymbols_u24default$iv;
                    DeepCopySymbolRemapper symbolRemapper$iv$iv = new DeepCopySymbolRemapper(null, 1, null);
                    boolean $i$f$deepCopyWithSymbols2 = false;
                    IrVisitorsKt.acceptVoid(irElement, symbolRemapper$iv$iv);
                    DeepCopyTypeRemapper deepCopyTypeRemapper = typeRemapper$iv$iv = new DeepCopyTypeRemapper(symbolRemapper$iv$iv);
                    DeepCopySymbolRemapper deepCopySymbolRemapper = symbolRemapper$iv$iv;
                    IrElement irElement2 = irElement;
                    boolean bl = false;
                    TypeRemapper typeRemapper = deepCopyTypeRemapper;
                    SymbolRemapper p0 = deepCopySymbolRemapper;
                    IrElement irElement3 = PatchDeclarationParentsKt.patchDeclarationParents(irElement2.transform(new DeepCopyIrTreeWithSymbols(p0, typeRemapper), null), samClass);
                    if (irElement3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrFunction");
                    }
                    Object object = (Pair[])((IrFunction)irElement3);
                    IrFunction $this$interpretTypeOperatorCall_u24lambda_u2420 = (IrFunction)object;
                    boolean bl2 = false;
                    $this$interpretTypeOperatorCall_u24lambda_u2420.setDispatchReceiverParameter(null);
                    IrFunction newInvoke = (IrFunction)object;
                    object = new Pair[]{dispatchReceiver};
                    Object $this$interpretTypeOperatorCall_u24lambda_u2421 = object = new KFunctionState(newInvoke, functionClass, this.environment, MapsKt.mutableMapOf(object));
                    boolean bl3 = false;
                    ((KFunctionState)$this$interpretTypeOperatorCall_u24lambda_u2421).setFunInterface(typeOperand);
                    state2 = (State)object;
                }
                State newState = state2;
                this.getCallStack().pushState(newState);
                return;
            }
        }
        ExceptionUtilsKt.stop((Function0<? extends Object>)new Function0<Object>(expression2){
            final /* synthetic */ IrTypeOperatorCall $expression;
            {
                this.$expression = $expression;
                super(0);
            }

            @NotNull
            public final Object invoke() {
                return "Type operator " + (Object)((Object)this.$expression.getOperator()) + " is not supported for interpretation";
            }
        });
        throw null;
    }

    /*
     * WARNING - void declaration
     */
    private final void interpretVararg(IrVararg expression2) {
        State state;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = expression2.getElements();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List<Object> list2;
            IrVarargElement it = (IrVarargElement)element$iv$iv;
            boolean bl = false;
            State result2 = this.getCallStack().popState();
            if (result2 instanceof Wrapper) {
                list2 = CollectionsKt.listOf(((Wrapper)result2).getValue());
            } else if (result2 instanceof Primitive) {
                list2 = IrTypePredicatesKt.isArray(expression2.getVarargElementType()) || UtilsKt.isPrimitiveArray(expression2.getVarargElementType()) ? CollectionsKt.listOf(result2) : IrInterpreter.interpretVararg$arrayToList(((Primitive)result2).getValue());
            } else if (result2 instanceof Common) {
                if (UtilsKt.isUnsignedArray(IrUtilsKt.getDefaultType(result2.getIrClass()))) {
                    Object t = CollectionsKt.single((Iterable)result2.getFields().values());
                    Intrinsics.checkNotNull(t, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.Primitive<*>");
                    list2 = IrInterpreter.interpretVararg$arrayToList(((Primitive)t).getValue());
                } else {
                    list2 = CollectionsKt.listOf(CommonProxy.Companion.asProxy$ir_interpreter$default(CommonProxy.Companion, (Common)result2, this.callInterceptor, null, 2, null));
                }
            } else {
                list2 = CollectionsKt.listOf(result2);
            }
            Iterable list$iv$iv = list2;
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        List args2 = CollectionsKt.reversed((List)destination$iv$iv);
        if (UtilsKt.isUnsignedArray(expression2.getType())) {
            void $this$mapTo$iv$iv;
            Object element$iv2;
            Object object;
            IrClass owner;
            block16: {
                void $this$first$iv;
                Iterator $this$filterIsInstanceTo$iv$iv;
                IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(expression2.getType());
                Intrinsics.checkNotNull(irClassSymbol);
                owner = (IrClass)irClassSymbol.getOwner();
                Iterable $this$filterIsInstance$iv = owner.getDeclarations();
                boolean $i$f$filterIsInstance = false;
                object = $this$filterIsInstance$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                Iterator bl = $this$filterIsInstanceTo$iv$iv.iterator();
                while (bl.hasNext()) {
                    Object element$iv$iv = bl.next();
                    if (!(element$iv$iv instanceof IrProperty)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv2;
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    IrProperty it = (IrProperty)element$iv2;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(it.getName().asString(), "storage")) continue;
                    break block16;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            IrProperty storageProperty = (IrProperty)element$iv2;
            Iterable $this$map$iv = args2;
            boolean $i$f$map = false;
            element$iv2 = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object t;
                void it;
                Object item$iv$iv;
                Object t2 = item$iv$iv = iterator2.next();
                Collection collection = destination$iv$iv3;
                boolean bl = false;
                if (it instanceof Proxy) {
                    Object t3 = CollectionsKt.single((Iterable)((Proxy)it).getState().getFields().values());
                    Intrinsics.checkNotNull(t3, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.Primitive<*>");
                    t = ((Primitive)t3).getValue();
                } else {
                    t = it;
                }
                collection.add(t);
            }
            List primitiveArray = (List)destination$iv$iv3;
            IrField irField = storageProperty.getBackingField();
            Intrinsics.checkNotNull(irField);
            Primitive<?> unsignedArray = UtilsKt.toPrimitiveStateArray(primitiveArray, irField.getType());
            Object $this$interpretVararg_u24lambda_u2425 = object = new Common(owner);
            boolean bl = false;
            ((Common)$this$interpretVararg_u24lambda_u2425).setField(storageProperty.getSymbol(), unsignedArray);
            state = (State)object;
        } else {
            state = UtilsKt.toPrimitiveStateArray(args2, expression2.getType());
        }
        State array2 = state;
        this.getCallStack().pushState(array2);
    }

    private final void interpretTry(IrTry element) {
        block1: {
            State possibleException = this.getCallStack().peekState();
            this.getCallStack().dropSubFrame();
            if (possibleException instanceof ExceptionState) {
                Function0 checkUnhandledException2 = new Function0<Unit>(this, possibleException){
                    final /* synthetic */ IrInterpreter this$0;
                    final /* synthetic */ State $possibleException;
                    {
                        this.this$0 = $receiver;
                        this.$possibleException = $possibleException;
                        super(0);
                    }

                    public final void invoke() {
                        IrInterpreter.access$getCallStack(this.this$0).pushState(this.$possibleException);
                        IrInterpreter.access$getCallStack(this.this$0).dropFramesUntilTryCatch();
                    }
                };
                this.getCallStack().pushInstruction(new CustomInstruction(checkUnhandledException2));
            }
            IrExpression irExpression = element.getFinallyExpression();
            if (irExpression == null) break block1;
            InstructionsUnfolderKt.handleAndDropResult$default(irExpression, this.getCallStack(), false, 2, null);
        }
    }

    private final void interpretThrow(IrThrow expression2) {
        this.getCallStack().dropFramesUntilTryCatch();
    }

    private final void interpretStringConcatenation(IrStringConcatenation expression2) {
        List result2 = new ArrayList();
        int n = expression2.getArguments().size();
        for (int i = 0; i < n; ++i) {
            int it = i;
            boolean bl = false;
            Collection collection = result2;
            State state = this.getCallStack().popState();
            String string2 = state instanceof Primitive ? String.valueOf(((Primitive)state).getValue()) : (state instanceof Wrapper ? ((Wrapper)state).getValue().toString() : state.toString());
            collection.add(string2);
        }
        this.getCallStack().pushState(this.environment.convertToState$ir_interpreter(CollectionsKt.joinToString$default(CollectionsKt.reversed(result2), "", null, null, 0, null, null, 62, null), expression2.getType()));
    }

    private final void interpretFunctionExpression(IrFunctionExpression expression2) {
        IrFunction irFunction2 = expression2.getFunction();
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(expression2.getType());
        Intrinsics.checkNotNull(irClassSymbol);
        KFunctionState function2 = new KFunctionState(irFunction2, (IrClass)irClassSymbol.getOwner(), this.environment, null, 8, null);
        if (AdditionalIrUtilsKt.isLocal(expression2.getFunction())) {
            this.getCallStack().storeUpValues(function2);
        }
        this.getCallStack().pushState(function2);
    }

    private final void interpretFunctionReference(IrFunctionReference reference) {
        Pair<IrValueParameterSymbol, State> pair;
        Pair<IrValueParameterSymbol, State> pair2;
        Pair<IrValueParameterSymbol, State> pair3;
        IrFunctionReference irFunctionReference;
        IrInterpreterEnvironment irInterpreterEnvironment;
        State state;
        State state2;
        IrFunction irFunction2 = ((IrFunctionSymbol)reference.getSymbol()).getOwner();
        IrValueParameterSymbol irValueParameterSymbol = UtilsKt.getDispatchReceiver(irFunction2);
        if (irValueParameterSymbol != null) {
            IrValueParameterSymbol it = irValueParameterSymbol;
            boolean bl = false;
            IrExpression irExpression = reference.getDispatchReceiver();
            if (irExpression != null) {
                IrExpression it2 = irExpression;
                boolean bl2 = false;
                state2 = this.getCallStack().popState();
            } else {
                state2 = null;
            }
        } else {
            state2 = null;
        }
        State dispatchReceiver = state2;
        IrValueParameterSymbol irValueParameterSymbol2 = UtilsKt.getExtensionReceiver(irFunction2);
        if (irValueParameterSymbol2 != null) {
            IrValueParameterSymbol it = irValueParameterSymbol2;
            boolean bl = false;
            IrExpression irExpression = reference.getExtensionReceiver();
            if (irExpression != null) {
                IrExpression it3 = irExpression;
                boolean bl3 = false;
                state = this.getCallStack().popState();
            } else {
                state = null;
            }
        } else {
            state = null;
        }
        State extensionReceiver = state;
        IrFunctionReference irFunctionReference2 = reference;
        IrInterpreterEnvironment irInterpreterEnvironment2 = this.environment;
        State state3 = dispatchReceiver;
        if (state3 != null) {
            State it = state3;
            irInterpreterEnvironment = irInterpreterEnvironment2;
            irFunctionReference = irFunctionReference2;
            boolean bl = false;
            IrValueParameterSymbol irValueParameterSymbol3 = UtilsKt.getDispatchReceiver(irFunction2);
            Intrinsics.checkNotNull(irValueParameterSymbol3);
            pair3 = new Pair<IrValueParameterSymbol, State>(irValueParameterSymbol3, it);
            irFunctionReference2 = irFunctionReference;
            irInterpreterEnvironment2 = irInterpreterEnvironment;
            pair2 = pair3;
        } else {
            pair2 = null;
        }
        State state4 = extensionReceiver;
        if (state4 != null) {
            State it = state4;
            pair3 = pair2;
            irInterpreterEnvironment = irInterpreterEnvironment2;
            irFunctionReference = irFunctionReference2;
            boolean bl = false;
            IrValueParameterSymbol irValueParameterSymbol4 = UtilsKt.getExtensionReceiver(irFunction2);
            Intrinsics.checkNotNull(irValueParameterSymbol4);
            Pair<IrValueParameterSymbol, State> pair4 = new Pair<IrValueParameterSymbol, State>(irValueParameterSymbol4, it);
            irFunctionReference2 = irFunctionReference;
            irInterpreterEnvironment2 = irInterpreterEnvironment;
            pair2 = pair3;
            pair = pair4;
        } else {
            pair = null;
        }
        Pair<IrValueParameterSymbol, State> pair5 = pair;
        Pair<IrValueParameterSymbol, State> pair6 = pair2;
        IrInterpreterEnvironment irInterpreterEnvironment3 = irInterpreterEnvironment2;
        IrFunctionReference irFunctionReference3 = irFunctionReference2;
        KFunctionState function2 = new KFunctionState(irFunctionReference3, irInterpreterEnvironment3, pair6, pair5);
        if (AdditionalIrUtilsKt.isLocal(irFunction2)) {
            this.getCallStack().storeUpValues(function2);
        }
        this.getCallStack().pushState(function2);
    }

    private final void interpretPropertyReference(IrPropertyReference propertyReference) {
        List<IrTypeParameter> list2;
        State state;
        State extensionReceiver;
        State state2;
        Object object;
        State dispatchReceiver;
        State state3;
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = propertyReference.getGetter();
        IrSimpleFunction getter2 = irSimpleFunctionSymbol != null ? (IrSimpleFunction)irSimpleFunctionSymbol.getOwner() : null;
        Object object2 = getter2;
        if (object2 != null && (object2 = UtilsKt.getDispatchReceiver((IrFunction)object2)) != null) {
            Object it = object2;
            boolean bl = false;
            IrExpression irExpression = propertyReference.getDispatchReceiver();
            if (irExpression != null) {
                IrExpression it2 = irExpression;
                boolean bl2 = false;
                state3 = this.getCallStack().popState();
            } else {
                state3 = null;
            }
        } else {
            state3 = dispatchReceiver = null;
        }
        if ((object = getter2) != null && (object = UtilsKt.getExtensionReceiver((IrFunction)object)) != null) {
            Object it = object;
            boolean bl = false;
            IrExpression irExpression = propertyReference.getExtensionReceiver();
            if (irExpression != null) {
                IrExpression it3 = irExpression;
                boolean bl3 = false;
                state2 = this.getCallStack().popState();
            } else {
                state2 = null;
            }
        } else {
            state2 = extensionReceiver = null;
        }
        if ((state = dispatchReceiver) == null) {
            state = extensionReceiver;
        }
        State receiver = state;
        KPropertyState propertyState = new KPropertyState(propertyReference, receiver);
        Object object3 = propertyReference.getGetter();
        if (object3 != null && (object3 = (IrSimpleFunction)object3.getOwner()) != null && (object3 = object3.getTypeParameters()) != null) {
            IrInterpreter.interpretPropertyReference$addToFields(object3, propertyReference, this, propertyState);
        }
        if ((list2 = propertyReference.getSetter()) != null && (list2 = (IrSimpleFunction)list2.getOwner()) != null && (list2 = list2.getTypeParameters()) != null) {
            IrInterpreter.interpretPropertyReference$addToFields(list2, propertyReference, this, propertyState);
        }
        this.getCallStack().pushState(propertyState);
    }

    private final void interpretClassReference(IrClassReference classReference) {
        if (classReference.getSymbol() instanceof IrTypeParameterSymbol) {
            State state = this.getCallStack().loadState(classReference.getSymbol());
            Intrinsics.checkNotNull(state, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.reflection.KTypeState");
            KTypeState kTypeState = (KTypeState)state;
            CallStack callStack = this.getCallStack();
            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(kTypeState.getIrType());
            Intrinsics.checkNotNull(irClassSymbol);
            IrClass irClass2 = (IrClass)irClassSymbol.getOwner();
            IrClassSymbol irClassSymbol2 = IrTypesKt.getClassOrNull(classReference.getType());
            Intrinsics.checkNotNull(irClassSymbol2);
            callStack.pushState(new KClassState(irClass2, (IrClass)irClassSymbol2.getOwner()));
        } else {
            this.getCallStack().pushState(new KClassState(classReference));
        }
    }

    private final void interpretGetClass(IrGetClass expression2) {
        IrClass irClass2 = this.getCallStack().popState().getIrClass();
        CallStack callStack = this.getCallStack();
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(expression2.getType());
        Intrinsics.checkNotNull(irClassSymbol);
        callStack.pushState(new KClassState(irClass2, (IrClass)irClassSymbol.getOwner()));
    }

    private static final boolean interpretValueParameter$isReceiver(IrFunction irFunction2, IrValueParameter $valueParameter) {
        return Intrinsics.areEqual(irFunction2.getDispatchReceiverParameter(), $valueParameter) || Intrinsics.areEqual(irFunction2.getExtensionReceiverParameter(), $valueParameter);
    }

    private static final State interpretCall$getThisOrSuperReceiver(State $this$interpretCall_u24getThisOrSuperReceiver, IrFunction irFunction2) {
        if (!($this$interpretCall_u24getThisOrSuperReceiver instanceof Common) || ((Common)$this$interpretCall_u24getThisOrSuperReceiver).getSuperWrapperClass() == null || !(irFunction2.getParent() instanceof IrClass)) {
            return $this$interpretCall_u24getThisOrSuperReceiver;
        }
        Wrapper wrapper = ((Common)$this$interpretCall_u24getThisOrSuperReceiver).getSuperWrapperClass();
        Intrinsics.checkNotNull(wrapper);
        if (IrUtilsKt.isSubclassOf(wrapper.getIrClass(), IrUtilsKt.getParentAsClass(irFunction2))) {
            return ((Common)$this$interpretCall_u24getThisOrSuperReceiver).getSuperWrapperClass();
        }
        return $this$interpretCall_u24getThisOrSuperReceiver;
    }

    private static final IrType interpretConst$getSignedType(IrInterpreter this$0, IrType unsignedType) {
        IrType irType;
        UnsignedType unsignedType2 = IrTypePredicatesKt.getUnsignedType(unsignedType);
        switch (unsignedType2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[unsignedType2.ordinal()]) {
            case 1: {
                irType = this$0.getIrBuiltIns().getByteType();
                break;
            }
            case 2: {
                irType = this$0.getIrBuiltIns().getShortType();
                break;
            }
            case 3: {
                irType = this$0.getIrBuiltIns().getIntType();
                break;
            }
            case 4: {
                irType = this$0.getIrBuiltIns().getLongType();
                break;
            }
            default: {
                irType = null;
            }
        }
        return irType;
    }

    private static final List<Object> interpretVararg$arrayToList(Object value2) {
        Object object = value2;
        return CollectionsKt.reversed((Iterable)(object instanceof byte[] ? ArraysKt.toList((byte[])value2) : (object instanceof char[] ? ArraysKt.toList((char[])value2) : (object instanceof short[] ? ArraysKt.toList((short[])value2) : (object instanceof int[] ? ArraysKt.toList((int[])value2) : (object instanceof long[] ? ArraysKt.toList((long[])value2) : (object instanceof float[] ? ArraysKt.toList((float[])value2) : (object instanceof double[] ? ArraysKt.toList((double[])value2) : (object instanceof boolean[] ? ArraysKt.toList((boolean[])value2) : (object instanceof Object[] ? ArraysKt.toList((Object[])value2) : CollectionsKt.listOf(value2)))))))))));
    }

    private static final void interpretPropertyReference$addToFields(List<? extends IrTypeParameter> $this$interpretPropertyReference_u24addToFields, IrPropertyReference $propertyReference, IrInterpreter this$0, KPropertyState propertyState) {
        Iterable $this$forEach$iv = RangesKt.until(0, $propertyReference.getTypeArgumentsCount());
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            IrType typeArgument;
            int element$iv;
            int index2 = element$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
            if ($propertyReference.getTypeArgument(index2) == null) continue;
            KTypeState kTypeState = new KTypeState(typeArgument, (IrClass)this$0.environment.getKTypeClass$ir_interpreter().getOwner());
            propertyState.setField($this$interpretPropertyReference_u24addToFields.get(index2).getSymbol(), kTypeState);
        }
    }

    public static final /* synthetic */ boolean access$interpretValueParameter$isReceiver(IrFunction irFunction2, IrValueParameter $valueParameter) {
        return IrInterpreter.interpretValueParameter$isReceiver(irFunction2, $valueParameter);
    }

    public static final /* synthetic */ CallStack access$getCallStack(IrInterpreter $this) {
        return $this.getCallStack();
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[UnsignedType.values().length];
            try {
                nArray[UnsignedType.UBYTE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UnsignedType.USHORT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UnsignedType.UINT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UnsignedType.ULONG.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[IrTypeOperator.values().length];
            try {
                nArray[IrTypeOperator.IMPLICIT_COERCION_TO_UNIT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.CAST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.IMPLICIT_CAST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.SAFE_CAST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.INSTANCEOF.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.NOT_INSTANCEOF.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.IMPLICIT_NOTNULL.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.SAM_CONVERSION.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

