/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FindClassInModuleKt;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsArrayAccess;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBooleanLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsDoWhile;
import org.jetbrains.kotlin.js.backend.ast.JsEmpty;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFor;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsPostfixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsPrefixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.JsWhile;
import org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import org.jetbrains.kotlin.js.translate.context.TemporaryVariable;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.expression.DestructuringDeclarationTranslator;
import org.jetbrains.kotlin.js.translate.expression.RangeLiteral;
import org.jetbrains.kotlin.js.translate.expression.RangeType;
import org.jetbrains.kotlin.js.translate.expression.WithIndexInfo;
import org.jetbrains.kotlin.js.translate.expression.WithIndexReceiverType;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.ArrayFIF;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtWhileExpressionBase;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0012\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"downToFunctionName", "Lorg/jetbrains/kotlin/name/FqName;", "indicesFqName", "intProgressionName", "intRangeName", "rangeToFunctionName", "sequenceFqName", "sequenceWithIndexFqName", "stepFunctionName", "untilFunctionName", "withIndexFqName", "createWhile", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "doWhile", "", "expression", "Lorg/jetbrains/kotlin/psi/KtWhileExpressionBase;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "translateForExpression", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "Lorg/jetbrains/kotlin/psi/KtForExpression;", "js.translator"})
@JvmName(name="LoopTranslator")
public final class LoopTranslator {
    @NotNull
    private static final FqName rangeToFunctionName = new FqName("kotlin.Int.rangeTo");
    @NotNull
    private static final FqName untilFunctionName = new FqName("kotlin.ranges.until");
    @NotNull
    private static final FqName downToFunctionName = new FqName("kotlin.ranges.downTo");
    @NotNull
    private static final FqName stepFunctionName = new FqName("kotlin.ranges.step");
    @NotNull
    private static final FqName intRangeName = new FqName("kotlin.ranges.IntRange");
    @NotNull
    private static final FqName intProgressionName = new FqName("kotlin.ranges.IntProgression");
    @NotNull
    private static final FqName withIndexFqName = new FqName("kotlin.collections.withIndex");
    @NotNull
    private static final FqName sequenceWithIndexFqName = new FqName("kotlin.sequences.withIndex");
    @NotNull
    private static final FqName indicesFqName = new FqName("kotlin.collections.indices");
    @NotNull
    private static final FqName sequenceFqName = new FqName("kotlin.sequences.Sequence");

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final JsNode createWhile(boolean doWhile, @NotNull KtWhileExpressionBase expression2, @NotNull TranslationContext context) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        KtExpression ktExpression = expression2.getCondition();
        if (ktExpression == null) {
            throw new IllegalArgumentException("condition expression should not be null: " + expression2.getText());
        }
        KtExpression conditionExpression = ktExpression;
        JsBlock conditionBlock = new JsBlock();
        JsExpression jsExpression = Translation.translateAsExpression(conditionExpression, context, conditionBlock);
        Intrinsics.checkNotNullExpressionValue(jsExpression, "translateAsExpression(co\u2026 context, conditionBlock)");
        JsExpression jsCondition = jsExpression;
        KtExpression body2 = expression2.getBody();
        JsStatement jsStatement = body2 != null ? Translation.translateAsStatementAndMergeInBlockIfNeeded(body2, context) : (JsStatement)JsEmpty.INSTANCE;
        Intrinsics.checkNotNullExpressionValue(jsStatement, "if (body != null)\n      \u2026 else\n            JsEmpty");
        JsStatement bodyStatement = jsStatement;
        if (!conditionBlock.isEmpty()) {
            void $this$createWhile_u24lambda_u240;
            SourceInfoAwareJsNode sourceInfoAwareJsNode = new JsBreak();
            JsBreak jsBreak = sourceInfoAwareJsNode;
            Object object = JsAstUtils.not(jsCondition);
            boolean bl = false;
            $this$createWhile_u24lambda_u240.setSource(expression2);
            JsStatement jsStatement2 = (JsStatement)((Object)sourceInfoAwareJsNode);
            JsExpression jsExpression2 = object;
            SourceInfoAwareJsNode $this$createWhile_u24lambda_u241 = sourceInfoAwareJsNode = new JsIf(jsExpression2, jsStatement2);
            boolean bl2 = false;
            $this$createWhile_u24lambda_u241.setSource(expression2);
            SourceInfoAwareJsNode breakIfConditionIsFalseStatement = sourceInfoAwareJsNode;
            JsBlock jsBlock = JsAstUtils.convertToBlock(bodyStatement);
            Intrinsics.checkNotNullExpressionValue(jsBlock, "convertToBlock(bodyStatement)");
            JsBlock bodyBlock = jsBlock;
            jsCondition = new JsBooleanLiteral(true);
            if (doWhile) {
                void $this$createWhile_u24lambda_u242;
                JsIf ifStatement;
                JsIf jsIf;
                JsExpression jsExpression3 = context.defineTemporary(new JsBooleanLiteral(false).source(expression2));
                Intrinsics.checkNotNullExpressionValue(jsExpression3, "context.defineTemporary(\u2026alse).source(expression))");
                JsExpression secondRun = jsExpression3;
                conditionBlock.getStatements().add((JsStatement)((Object)breakIfConditionIsFalseStatement));
                JsIf jsIf2 = jsIf = (ifStatement = new JsIf(secondRun, conditionBlock, JsAstUtils.assignment(secondRun, new JsBooleanLiteral(true)).source(expression2).makeStmt()));
                int n = 0;
                List<JsStatement> list2 = bodyBlock.getStatements();
                boolean bl3 = false;
                $this$createWhile_u24lambda_u242.setSource(expression2);
                object = Unit.INSTANCE;
                list2.add(n, jsIf);
            } else {
                conditionBlock.getStatements().add((JsStatement)((Object)breakIfConditionIsFalseStatement));
                List<JsStatement> list3 = bodyBlock.getStatements();
                List<JsStatement> list4 = conditionBlock.getStatements();
                Intrinsics.checkNotNullExpressionValue(list4, "conditionBlock.statements");
                list3.addAll(0, (Collection<JsStatement>)list4);
            }
            bodyStatement = bodyBlock;
        }
        JsWhile result2 = doWhile ? (JsWhile)new JsDoWhile() : new JsWhile();
        result2.setCondition(jsCondition);
        result2.setBody(bodyStatement);
        JsNode jsNode = result2.source(expression2);
        Intrinsics.checkNotNullExpressionValue(jsNode, "result.source(expression)");
        return jsNode;
    }

    @NotNull
    public static final JsStatement translateForExpression(@NotNull KtForExpression expression2, @NotNull TranslationContext context) {
        JsStatement result2;
        JsStatement jsStatement;
        JsStatement jsStatement2;
        block5: {
            JsName parameterName;
            KtDestructuringDeclaration destructuringParameter;
            KtParameter loopParameter;
            KotlinType rangeType;
            KtExpression loopRange;
            block6: {
                WithIndexInfo withIndexCall;
                block4: {
                    Intrinsics.checkNotNullParameter(expression2, "expression");
                    Intrinsics.checkNotNullParameter(context, "context");
                    KtExpression it = PsiUtils.getLoopRange(expression2);
                    boolean bl = false;
                    KtExpression ktExpression = KtPsiUtil.deparenthesize(it);
                    Intrinsics.checkNotNull(ktExpression);
                    KtExpression deparenthesized = ktExpression;
                    KtExpression ktExpression2 = deparenthesized instanceof KtStringTemplateExpression ? it : deparenthesized;
                    Intrinsics.checkNotNullExpressionValue(ktExpression2, "getLoopRange(expression)\u2026lse deparenthesized\n    }");
                    loopRange = ktExpression2;
                    KotlinType kotlinType = BindingUtils.getTypeForExpression(context.bindingContext(), loopRange);
                    Intrinsics.checkNotNullExpressionValue(kotlinType, "getTypeForExpression(con\u2026dingContext(), loopRange)");
                    rangeType = kotlinType;
                    KtParameter ktParameter = expression2.getLoopParameter();
                    Intrinsics.checkNotNull(ktParameter);
                    loopParameter = ktParameter;
                    destructuringParameter = loopParameter.getDestructuringDeclaration();
                    JsName jsName = destructuringParameter == null ? context.getNameForElement(loopParameter) : JsScope.declareTemporary();
                    Intrinsics.checkNotNullExpressionValue(jsName, "if (destructuringParamet\u2026.declareTemporary()\n    }");
                    parameterName = jsName;
                    RangeLiteral rangeLiteral = LoopTranslator.translateForExpression$extractForOverRangeLiteral(rangeType, loopRange, context);
                    withIndexCall = LoopTranslator.translateForExpression$extractWithIndexCall(loopRange, context, destructuringParameter, loopParameter);
                    if (rangeLiteral == null) break block4;
                    jsStatement2 = LoopTranslator.translateForExpression$translateForOverLiteralRange(context, parameterName, expression2, destructuringParameter, loopParameter, rangeLiteral);
                    break block5;
                }
                if (withIndexCall == null) break block6;
                switch (WhenMappings.$EnumSwitchMapping$1[withIndexCall.getReceiverType().ordinal()]) {
                    case 1: {
                        jsStatement2 = LoopTranslator.translateForExpression$translateForOverArrayWithIndex(context, expression2, withIndexCall);
                        break block5;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        jsStatement2 = withIndexCall.getValue() == null && withIndexCall.getReceiverType() == WithIndexReceiverType.COLLECTION ? LoopTranslator.translateForExpression$translateForOverCollectionIndices(context, expression2, withIndexCall) : LoopTranslator.translateForExpression$translateForOverCollectionWithIndex(context, expression2, withIndexCall);
                        break block5;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            jsStatement2 = LoopTranslator.translateForExpression$isForOverRange(rangeType) ? LoopTranslator.translateForExpression$translateForOverRange(context, loopRange, parameterName, expression2, destructuringParameter, loopParameter) : (LoopTranslator.translateForExpression$isForOverArray(rangeType) ? LoopTranslator.translateForExpression$translateForOverArray(context, loopRange, expression2, destructuringParameter, loopParameter, parameterName) : LoopTranslator.translateForExpression$translateForOverIterator(context, loopRange, expression2, destructuringParameter, loopParameter, parameterName));
        }
        JsStatement $this$translateForExpression_u24lambda_u2433 = jsStatement = (result2 = jsStatement2);
        boolean bl = false;
        $this$translateForExpression_u24lambda_u2433.setSource(expression2);
        return jsStatement;
    }

    private static final boolean translateForExpression$isForOverRange(KotlinType rangeType) {
        Object object = rangeType.getConstructor().getDeclarationDescriptor();
        if (object == null || (object = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)object)) == null) {
            return false;
        }
        Object fqn = object;
        return Intrinsics.areEqual(fqn, intRangeName);
    }

    private static final RangeLiteral translateForExpression$extractForOverRangeLiteral(KotlinType rangeType, KtExpression loopRange, TranslationContext $context) {
        RangeType rangeType2;
        ReceiverValue receiverValue;
        Object object;
        ReceiverValue receiverValue2;
        KtExpression step;
        ResolvedCall<? extends CallableDescriptor> resolvedCall2;
        block15: {
            ResolvedCall<? extends CallableDescriptor> resolvedCall3;
            block17: {
                block16: {
                    FqName fqn;
                    ClassifierDescriptor classifierDescriptor = rangeType.getConstructor().getDeclarationDescriptor();
                    FqName fqName2 = fqn = classifierDescriptor != null ? DescriptorUtilsKt.getFqNameSafe(classifierDescriptor) : null;
                    if (!Intrinsics.areEqual(fqn, intRangeName) && !Intrinsics.areEqual(fqn, intProgressionName)) {
                        return null;
                    }
                    KtElement ktElement = loopRange;
                    BindingContext bindingContext = $context.bindingContext();
                    Intrinsics.checkNotNullExpressionValue(bindingContext, "context.bindingContext()");
                    ResolvedCall<? extends CallableDescriptor> resolvedCall4 = CallUtilKt.getResolvedCall(ktElement, bindingContext);
                    if (resolvedCall4 == null) {
                        return null;
                    }
                    resolvedCall2 = resolvedCall4;
                    step = null;
                    if (!Intrinsics.areEqual(DescriptorUtilsKt.getFqNameSafe(resolvedCall2.getResultingDescriptor()), stepFunctionName)) break block15;
                    KtExpression ktExpression = resolvedCall2.getCall().getValueArguments().get(0).getArgumentExpression();
                    if (ktExpression == null) {
                        return null;
                    }
                    step = ktExpression;
                    ReceiverValue receiverValue3 = resolvedCall2.getExtensionReceiver();
                    resolvedCall3 = receiverValue3 instanceof ExpressionReceiver ? (ExpressionReceiver)receiverValue3 : null;
                    if (resolvedCall3 == null || (resolvedCall3 = resolvedCall3.getExpression()) == null) break block16;
                    KtElement ktElement2 = (KtElement)((Object)resolvedCall3);
                    BindingContext bindingContext2 = $context.bindingContext();
                    Intrinsics.checkNotNullExpressionValue(bindingContext2, "context.bindingContext()");
                    resolvedCall3 = CallUtilKt.getResolvedCall(ktElement2, bindingContext2);
                    if (resolvedCall3 != null) break block17;
                }
                return null;
            }
            resolvedCall2 = resolvedCall3;
        }
        if ((receiverValue2 = resolvedCall2.getExtensionReceiver()) == null) {
            receiverValue2 = resolvedCall2.getDispatchReceiver();
        }
        if ((object = (receiverValue = receiverValue2) instanceof ExpressionReceiver ? (ExpressionReceiver)receiverValue : null) == null || (object = object.getExpression()) == null) {
            return null;
        }
        Object first = object;
        List<ResolvedValueArgument> list2 = resolvedCall2.getValueArgumentsByIndex();
        if (list2 == null || (list2 = CollectionsKt.firstOrNull(list2)) == null || (list2 = list2.getArguments()) == null || (list2 = CollectionsKt.firstOrNull(list2)) == null || (list2 = list2.getArgumentExpression()) == null) {
            return null;
        }
        List<ResolvedValueArgument> second = list2;
        FqName fqName3 = DescriptorUtilsKt.getFqNameSafe(resolvedCall2.getResultingDescriptor());
        if (Intrinsics.areEqual(fqName3, rangeToFunctionName)) {
            rangeType2 = RangeType.RANGE_TO;
        } else if (Intrinsics.areEqual(fqName3, untilFunctionName)) {
            rangeType2 = RangeType.UNTIL;
        } else if (Intrinsics.areEqual(fqName3, downToFunctionName)) {
            rangeType2 = RangeType.DOWN_TO;
        } else {
            return null;
        }
        RangeType type2 = rangeType2;
        return new RangeLiteral(type2, (KtExpression)first, (KtExpression)((Object)second), step);
    }

    private static final boolean translateForExpression$isForOverArray(KotlinType rangeType) {
        return KotlinBuiltIns.isArray(rangeType) || KotlinBuiltIns.isPrimitiveArray(rangeType);
    }

    private static final VariableDescriptor translateForExpression$extractDescriptor(KtDeclaration $this$translateForExpression_u24extractDescriptor, TranslationContext $context) {
        VariableDescriptor variableDescriptor;
        VariableDescriptor variableDescriptor2 = (VariableDescriptor)$context.bindingContext().get(BindingContext.VARIABLE, $this$translateForExpression_u24extractDescriptor);
        if (variableDescriptor2 != null) {
            VariableDescriptor variableDescriptor3;
            VariableDescriptor it = variableDescriptor3 = variableDescriptor2;
            boolean bl = false;
            variableDescriptor = !it.getName().isSpecial() ? variableDescriptor3 : null;
        } else {
            variableDescriptor = null;
        }
        return variableDescriptor;
    }

    private static final WithIndexInfo translateForExpression$extractWithIndexCall(KtExpression loopRange, TranslationContext $context, KtDestructuringDeclaration destructuringParameter, KtParameter loopParameter) {
        JsExpression jsExpression;
        WithIndexReceiverType withIndexReceiverType;
        Pair<VariableDescriptor, VariableDescriptor> pair;
        KtElement ktElement = loopRange;
        BindingContext bindingContext = $context.bindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext, "context.bindingContext()");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(ktElement, bindingContext);
        if (resolvedCall2 == null) {
            return null;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        FqName fqName2 = DescriptorUtilsKt.getFqNameSafe(resolvedCall3.getResultingDescriptor());
        FqName fqName3 = fqName2;
        if (Intrinsics.areEqual(fqName3, withIndexFqName) ? true : Intrinsics.areEqual(fqName3, sequenceWithIndexFqName)) {
            if (destructuringParameter == null) {
                return null;
            }
            List<KtDestructuringDeclarationEntry> it = destructuringParameter.getEntries();
            boolean bl = false;
            KtDestructuringDeclarationEntry ktDestructuringDeclarationEntry = it.get(0);
            Intrinsics.checkNotNullExpressionValue(ktDestructuringDeclarationEntry, "it[0]");
            VariableDescriptor variableDescriptor = LoopTranslator.translateForExpression$extractDescriptor(ktDestructuringDeclarationEntry, $context);
            KtDestructuringDeclarationEntry ktDestructuringDeclarationEntry2 = it.get(1);
            Intrinsics.checkNotNullExpressionValue(ktDestructuringDeclarationEntry2, "it[1]");
            pair = new Pair<VariableDescriptor, VariableDescriptor>(variableDescriptor, LoopTranslator.translateForExpression$extractDescriptor(ktDestructuringDeclarationEntry2, $context));
        } else if (Intrinsics.areEqual(fqName3, indicesFqName)) {
            if (destructuringParameter != null) {
                return null;
            }
            DeclarationDescriptor bl = $context.bindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, loopParameter);
            VariableDescriptor variableDescriptor = bl instanceof VariableDescriptor ? (VariableDescriptor)bl : null;
            if (variableDescriptor == null) {
                return null;
            }
            VariableDescriptor varDescriptor = variableDescriptor;
            pair = new Pair<VariableDescriptor, Object>(varDescriptor, null);
        } else {
            return null;
        }
        Pair<VariableDescriptor, VariableDescriptor> pair2 = pair;
        VariableDescriptor indexDescriptor = pair2.component1();
        VariableDescriptor elementDescriptor = pair2.component2();
        Object object = resolvedCall3.getResultingDescriptor().getExtensionReceiverParameter();
        ClassifierDescriptor classifierDescriptor = object != null && (object = object.getType()) != null && (object = ((KotlinType)object).getConstructor()) != null ? object.getDeclarationDescriptor() : null;
        ClassDescriptor classDescriptor = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
        if (classDescriptor == null) {
            return null;
        }
        ClassDescriptor receiverClass = classDescriptor;
        if (KotlinBuiltIns.isArrayOrPrimitiveArray(receiverClass)) {
            withIndexReceiverType = WithIndexReceiverType.ARRAY;
        } else if (KotlinBuiltIns.isCollectionOrNullableCollection(receiverClass.getDefaultType())) {
            withIndexReceiverType = WithIndexReceiverType.COLLECTION;
        } else if (KotlinBuiltIns.isIterableOrNullableIterable(receiverClass.getDefaultType())) {
            withIndexReceiverType = WithIndexReceiverType.ITERABLE;
        } else if (Intrinsics.areEqual(DescriptorUtilsKt.getFqNameSafe(receiverClass), sequenceFqName)) {
            withIndexReceiverType = WithIndexReceiverType.SEQUENCE;
        } else {
            return null;
        }
        WithIndexReceiverType receiverType = withIndexReceiverType;
        ReceiverValue receiverValue = resolvedCall3.getExtensionReceiver();
        if (receiverValue == null) {
            return null;
        }
        ReceiverValue receiver = receiverValue;
        ReceiverValue receiverValue2 = receiver;
        if (receiverValue2 instanceof ExpressionReceiver) {
            jsExpression = Translation.translateAsExpression(((ExpressionReceiver)receiver).getExpression(), $context);
        } else if (receiverValue2 instanceof ImplicitReceiver) {
            jsExpression = $context.getDispatchReceiver(JsDescriptorUtils.getReceiverParameterForReceiver(receiver));
        } else {
            return null;
        }
        JsExpression jsExpression2 = jsExpression;
        Intrinsics.checkNotNullExpressionValue(jsExpression2, "when (receiver) {\n      \u2026 -> return null\n        }");
        JsExpression arrayExpr = jsExpression2;
        return new WithIndexInfo(receiverType, indexDescriptor, elementDescriptor, arrayExpr);
    }

    private static final JsStatement translateForExpression$translateBody(KtForExpression $expression, KtDestructuringDeclaration destructuringParameter, TranslationContext $context, KtParameter loopParameter, JsName parameterName, JsExpression itemValue) {
        List<JsStatement> list2;
        JsVars jsVars;
        JsVars jsVars2;
        JsStatement realBody;
        JsStatement jsStatement;
        KtExpression ktExpression = $expression.getBody();
        if (ktExpression != null) {
            KtExpression it = ktExpression;
            boolean bl = false;
            jsStatement = Translation.translateAsStatementAndMergeInBlockIfNeeded(it, $context);
        } else {
            jsStatement = realBody = null;
        }
        if (itemValue == null && destructuringParameter == null) {
            return realBody;
        }
        JsBlock block = new JsBlock();
        if (destructuringParameter == null) {
            JsExpression jsExpression;
            DeclarationDescriptor declarationDescriptor = BindingUtils.getDescriptorForElement($context.bindingContext(), loopParameter);
            Intrinsics.checkNotNull(declarationDescriptor, "null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.CallableDescriptor");
            CallableDescriptor loopParameterDescriptor = (CallableDescriptor)declarationDescriptor;
            KotlinType kotlinType = loopParameterDescriptor.getReturnType();
            if (kotlinType == null) {
                kotlinType = $context.getCurrentModule().getBuiltIns().getAnyType();
            }
            Intrinsics.checkNotNullExpressionValue(kotlinType, "loopParameterDescriptor.\u2026ntModule.builtIns.anyType");
            KotlinType loopParameterType = kotlinType;
            JsExpression jsExpression2 = itemValue;
            if (jsExpression2 != null) {
                JsExpression it = jsExpression2;
                boolean bl = false;
                jsExpression = TranslationUtils.coerce($context, it, loopParameterType);
            } else {
                jsExpression = null;
            }
            JsExpression coercedItemValue = jsExpression;
            JsVars $this$translateForExpression_u24translateBody_u24lambda_u248 = jsVars2 = JsAstUtils.newVar(parameterName, coercedItemValue);
            boolean bl = false;
            $this$translateForExpression_u24translateBody_u24lambda_u248.setSource($expression.getLoopRange());
            jsVars = jsVars2;
        } else {
            TranslationContext translationContext = $context.innerBlock(block);
            Intrinsics.checkNotNullExpressionValue(translationContext, "context.innerBlock(block)");
            TranslationContext innerBlockContext = translationContext;
            if (itemValue != null) {
                JsVars $this$translateForExpression_u24translateBody_u24lambda_u249 = jsVars2 = JsAstUtils.newVar(parameterName, itemValue);
                boolean bl = false;
                $this$translateForExpression_u24translateBody_u24lambda_u249.setSource($expression.getLoopRange());
                JsVars jsVars3 = jsVars2;
                Intrinsics.checkNotNullExpressionValue(jsVars3, "newVar(parameterName, it\u2026 = expression.loopRange }");
                JsVars parameterStatement = jsVars3;
                innerBlockContext.addStatementToCurrentBlock(parameterStatement);
            }
            jsVars = DestructuringDeclarationTranslator.translate(destructuringParameter, JsAstUtils.pureFqn(parameterName, null), innerBlockContext);
        }
        Iterable<JsVars.JsVar> iterable = jsVars;
        Intrinsics.checkNotNullExpressionValue(iterable, "if (destructuringParamet\u2026ontext)\n                }");
        JsVars currentVarInit = iterable;
        List<JsStatement> list3 = block.getStatements();
        Intrinsics.checkNotNullExpressionValue(list3, "block.statements");
        ((Collection)list3).add(currentVarInit);
        List<JsStatement> list4 = block.getStatements();
        Intrinsics.checkNotNullExpressionValue(list4, "block.statements");
        iterable = list4;
        if (realBody instanceof JsBlock) {
            List<JsStatement> list5 = ((JsBlock)realBody).getStatements();
            list2 = list5;
            Intrinsics.checkNotNullExpressionValue(list5, "realBody.statements");
        } else {
            list2 = CollectionsKt.listOfNotNull(realBody);
        }
        CollectionsKt.addAll(iterable, (Iterable)list2);
        return block;
    }

    private static final JsStatement translateForExpression$translateForOverLiteralRange(TranslationContext $context, JsName parameterName, KtForExpression $expression, KtDestructuringDeclaration destructuringParameter, KtParameter loopParameter, RangeLiteral literal) {
        JsVars jsVars;
        JsExpression jsExpression;
        Enum incrementOperator;
        JsBinaryOperation jsBinaryOperation;
        JsExpression jsExpression2;
        JsExpression jsExpression3;
        JsBlock startBlock = new JsBlock();
        JsExpression jsExpression4 = Translation.translateAsExpression(literal.getFirst(), $context, startBlock);
        Intrinsics.checkNotNullExpressionValue(jsExpression4, "translateAsExpression(li\u2026rst, context, startBlock)");
        JsExpression leftExpression = jsExpression4;
        JsBlock endBlock = new JsBlock();
        JsExpression jsExpression5 = Translation.translateAsExpression(literal.getSecond(), $context, endBlock);
        Intrinsics.checkNotNullExpressionValue(jsExpression5, "translateAsExpression(li\u2026econd, context, endBlock)");
        JsExpression rightExpression = jsExpression5;
        JsBlock stepBlock = new JsBlock();
        KtExpression ktExpression = literal.getStep();
        if (ktExpression != null) {
            KtExpression it = ktExpression;
            boolean bl = false;
            jsExpression3 = Translation.translateAsExpression(it, $context, stepBlock);
        } else {
            jsExpression3 = null;
        }
        JsExpression stepExpression = jsExpression3;
        $context.addStatementsToCurrentBlockFrom(startBlock);
        JsExpression jsExpression6 = $context.cacheExpressionIfNeeded(leftExpression);
        Intrinsics.checkNotNullExpressionValue(jsExpression6, "context.cacheExpressionIfNeeded(leftExpression)");
        JsExpression rangeStart = jsExpression6;
        $context.addStatementsToCurrentBlockFrom(endBlock);
        JsExpression jsExpression7 = $context.defineTemporary(rightExpression);
        Intrinsics.checkNotNullExpressionValue(jsExpression7, "context.defineTemporary(rightExpression)");
        JsExpression rangeEnd = jsExpression7;
        $context.addStatementsToCurrentBlockFrom(stepBlock);
        JsExpression jsExpression8 = stepExpression;
        if (jsExpression8 != null) {
            JsExpression it = jsExpression8;
            boolean bl = false;
            jsExpression2 = $context.defineTemporary(it);
        } else {
            jsExpression2 = null;
        }
        JsExpression step = jsExpression2;
        JsStatement body2 = LoopTranslator.translateForExpression$translateBody($expression, destructuringParameter, $context, loopParameter, parameterName, null);
        switch (WhenMappings.$EnumSwitchMapping$0[literal.getType().ordinal()]) {
            case 1: {
                jsBinaryOperation = JsAstUtils.lessThanEq(parameterName.makeRef(), rangeEnd);
                break;
            }
            case 2: {
                jsBinaryOperation = JsAstUtils.lessThan(parameterName.makeRef(), rangeEnd);
                break;
            }
            case 3: {
                jsBinaryOperation = JsAstUtils.greaterThanEq(parameterName.makeRef(), rangeEnd);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        JsExpression conditionExpression = jsBinaryOperation.source($expression);
        if (step == null) {
            JsUnaryOperator jsUnaryOperator;
            switch (WhenMappings.$EnumSwitchMapping$0[literal.getType().ordinal()]) {
                case 1: 
                case 2: {
                    jsUnaryOperator = JsUnaryOperator.INC;
                    break;
                }
                case 3: {
                    jsUnaryOperator = JsUnaryOperator.DEC;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            incrementOperator = jsUnaryOperator;
            jsExpression = new JsPostfixOperation((JsUnaryOperator)incrementOperator, parameterName.makeRef()).source($expression);
        } else {
            JsBinaryOperator jsBinaryOperator;
            switch (WhenMappings.$EnumSwitchMapping$0[literal.getType().ordinal()]) {
                case 1: 
                case 2: {
                    jsBinaryOperator = JsBinaryOperator.ASG_ADD;
                    break;
                }
                case 3: {
                    jsBinaryOperator = JsBinaryOperator.ASG_SUB;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            incrementOperator = jsBinaryOperator;
            jsExpression = new JsBinaryOperation((JsBinaryOperator)incrementOperator, parameterName.makeRef(), step).source($expression);
        }
        JsExpression incrementExpression = jsExpression;
        JsVars $this$translateForExpression_u24translateForOverLiteralRange_u24lambda_u2412 = jsVars = JsAstUtils.newVar(parameterName, rangeStart);
        boolean bl = false;
        $this$translateForExpression_u24translateForOverLiteralRange_u24lambda_u2412.setSource($expression);
        JsVars jsVars2 = jsVars;
        Intrinsics.checkNotNullExpressionValue(jsVars2, "newVar(parameterName, ra\u2026y { source = expression }");
        JsVars initVars = jsVars2;
        return new JsFor(initVars, conditionExpression, incrementExpression, body2);
    }

    private static final JsExpression translateForExpression$translateForOverRange$getProperty(JsExpression rangeExpression, KtExpression loopRange, String funName) {
        JsExpression jsExpression = new JsNameRef(funName, rangeExpression).source(loopRange);
        Intrinsics.checkNotNullExpressionValue(jsExpression, "JsNameRef(funName, range\u2026ession).source(loopRange)");
        return jsExpression;
    }

    private static final JsStatement translateForExpression$translateForOverRange(TranslationContext $context, KtExpression loopRange, JsName parameterName, KtForExpression $expression, KtDestructuringDeclaration destructuringParameter, KtParameter loopParameter) {
        JsVars jsVars;
        JsExpression jsExpression = $context.defineTemporary(Translation.translateAsExpression(loopRange, $context));
        Intrinsics.checkNotNullExpressionValue(jsExpression, "context.defineTemporary(\u2026sion(loopRange, context))");
        JsExpression rangeExpression = jsExpression;
        JsExpression jsExpression2 = $context.defineTemporary(LoopTranslator.translateForExpression$translateForOverRange$getProperty(rangeExpression, loopRange, "first"));
        Intrinsics.checkNotNullExpressionValue(jsExpression2, "context.defineTemporary(getProperty(\"first\"))");
        JsExpression start = jsExpression2;
        JsExpression jsExpression3 = $context.defineTemporary(LoopTranslator.translateForExpression$translateForOverRange$getProperty(rangeExpression, loopRange, "last"));
        Intrinsics.checkNotNullExpressionValue(jsExpression3, "context.defineTemporary(getProperty(\"last\"))");
        JsExpression end = jsExpression3;
        JsExpression jsExpression4 = $context.defineTemporary(LoopTranslator.translateForExpression$translateForOverRange$getProperty(rangeExpression, loopRange, "step"));
        Intrinsics.checkNotNullExpressionValue(jsExpression4, "context.defineTemporary(getProperty(\"step\"))");
        JsExpression increment = jsExpression4;
        JsStatement body2 = LoopTranslator.translateForExpression$translateBody($expression, destructuringParameter, $context, loopParameter, parameterName, null);
        JsExpression conditionExpression = JsAstUtils.lessThanEq(parameterName.makeRef(), end).source($expression);
        JsExpression incrementExpression = JsAstUtils.addAssign(parameterName.makeRef(), increment).source($expression);
        JsVars $this$translateForExpression_u24translateForOverRange_u24lambda_u2413 = jsVars = JsAstUtils.newVar(parameterName, start);
        boolean bl = false;
        $this$translateForExpression_u24translateForOverRange_u24lambda_u2413.setSource($expression);
        JsVars jsVars2 = jsVars;
        Intrinsics.checkNotNullExpressionValue(jsVars2, "newVar(parameterName, st\u2026y { source = expression }");
        JsVars initVars = jsVars2;
        return new JsFor(initVars, conditionExpression, incrementExpression, body2);
    }

    private static final JsStatement translateForExpression$translateForOverArray(TranslationContext $context, KtExpression loopRange, KtForExpression $expression, KtDestructuringDeclaration destructuringParameter, KtParameter loopParameter, JsName parameterName) {
        JsExpression jsExpression = $context.defineTemporary(Translation.translateAsExpression(loopRange, $context));
        Intrinsics.checkNotNullExpressionValue(jsExpression, "context.defineTemporary(\u2026sion(loopRange, context))");
        JsExpression rangeExpression = jsExpression;
        JsExpression jsExpression2 = ArrayFIF.LENGTH_PROPERTY_INTRINSIC.apply(rangeExpression, CollectionsKt.emptyList(), $context);
        Intrinsics.checkNotNullExpressionValue(jsExpression2, "LENGTH_PROPERTY_INTRINSI\u2026ssion, listOf(), context)");
        JsExpression length = jsExpression2;
        JsExpression jsExpression3 = $context.defineTemporary(length);
        Intrinsics.checkNotNullExpressionValue(jsExpression3, "context.defineTemporary(length)");
        JsExpression end = jsExpression3;
        TemporaryVariable temporaryVariable = $context.declareTemporary(new JsIntLiteral(0), $expression);
        Intrinsics.checkNotNullExpressionValue(temporaryVariable, "context.declareTemporary\u2026ntLiteral(0), expression)");
        TemporaryVariable index2 = temporaryVariable;
        JsExpression arrayAccess = new JsArrayAccess(rangeExpression, index2.reference()).source($expression);
        JsStatement body2 = LoopTranslator.translateForExpression$translateBody($expression, destructuringParameter, $context, loopParameter, parameterName, arrayAccess);
        JsExpression initExpression = JsAstUtils.assignment(index2.reference(), new JsIntLiteral(0)).source($expression);
        JsExpression conditionExpression = JsAstUtils.inequality(index2.reference(), end).source($expression);
        JsExpression incrementExpression = new JsPrefixOperation(JsUnaryOperator.INC, index2.reference()).source($expression);
        return new JsFor(initExpression, conditionExpression, incrementExpression, body2);
    }

    private static final JsStatement translateForExpression$translateForOverArrayWithIndex(TranslationContext $context, KtForExpression $expression, WithIndexInfo info) {
        JsBlock body2;
        JsExpression incrementExpression;
        JsExpression conditionExpression;
        Object initExpression;
        block8: {
            JsName jsName;
            Object it;
            Object object;
            JsExpression range;
            block7: {
                block6: {
                    JsExpression jsExpression = $context.cacheExpressionIfNeeded(info.getRange());
                    Intrinsics.checkNotNullExpressionValue(jsExpression, "context.cacheExpressionIfNeeded(info.range)");
                    range = jsExpression;
                    object = info.getIndex();
                    if (object == null) break block6;
                    VariableDescriptor it2 = object;
                    boolean bl = false;
                    JsName jsName2 = $context.getNameForDescriptor(it2);
                    object = jsName2;
                    if (jsName2 != null) break block7;
                }
                object = JsScope.declareTemporary();
            }
            Intrinsics.checkNotNullExpressionValue(object, "info.index?.let { contex\u2026sScope.declareTemporary()");
            Object indexVar = object;
            VariableDescriptor variableDescriptor = info.getValue();
            if (variableDescriptor != null) {
                it = variableDescriptor;
                boolean bl = false;
                jsName = $context.getNameForDescriptor((DeclarationDescriptor)it);
            } else {
                jsName = null;
            }
            JsName valueVar = jsName;
            Object $this$translateForExpression_u24translateForOverArrayWithIndex_u24lambda_u2416 = it = JsAstUtils.newVar((JsName)indexVar, new JsIntLiteral(0));
            boolean bl = false;
            ((SourceInfoAwareJsNode)$this$translateForExpression_u24translateForOverArrayWithIndex_u24lambda_u2416).setSource($expression);
            Object object2 = it;
            Intrinsics.checkNotNullExpressionValue(object2, "newVar(indexVar, JsIntLi\u2026y { source = expression }");
            initExpression = object2;
            conditionExpression = JsAstUtils.inequality(((JsName)indexVar).makeRef(), new JsNameRef("length", range)).source($expression);
            incrementExpression = new JsPrefixOperation(JsUnaryOperator.INC, ((JsName)indexVar).makeRef()).source($expression);
            body2 = new JsBlock();
            if (valueVar != null) {
                JsVars jsVars;
                List<JsStatement> list2 = body2.getStatements();
                Intrinsics.checkNotNullExpressionValue(list2, "body.statements");
                Collection collection = list2;
                JsVars $this$translateForExpression_u24translateForOverArrayWithIndex_u24lambda_u2417 = jsVars = JsAstUtils.newVar(valueVar, new JsArrayAccess(range, ((JsName)indexVar).makeRef()));
                boolean bl2 = false;
                $this$translateForExpression_u24translateForOverArrayWithIndex_u24lambda_u2417.setSource($expression);
                collection.add(jsVars);
            }
            KtExpression ktExpression = $expression.getBody();
            if (ktExpression == null) break block8;
            KtExpression it3 = ktExpression;
            boolean bl3 = false;
            List<JsStatement> list3 = body2.getStatements();
            Intrinsics.checkNotNullExpressionValue(list3, "body.statements");
            Collection collection = list3;
            collection.add(Translation.translateAsStatement(it3, $context.innerBlock(body2)));
        }
        return new JsFor((JsVars)initExpression, conditionExpression, incrementExpression, (JsStatement)body2);
    }

    private static final ClassDescriptor translateForExpression$findCollection(TranslationContext $context) {
        ModuleDescriptor moduleDescriptor = $context.getCurrentModule();
        Intrinsics.checkNotNullExpressionValue(moduleDescriptor, "context.currentModule");
        ClassId classId = ClassId.topLevel(StandardNames.FqNames.collection);
        Intrinsics.checkNotNullExpressionValue(classId, "topLevel(StandardNames.FqNames.collection)");
        ClassDescriptor classDescriptor = FindClassInModuleKt.findClassAcrossModuleDependencies(moduleDescriptor, classId);
        Intrinsics.checkNotNull(classDescriptor);
        return classDescriptor;
    }

    private static final JsStatement translateForExpression$translateForOverCollectionIndices(TranslationContext $context, KtForExpression $expression, WithIndexInfo info) {
        JsBlock body2;
        JsExpression incrementExpression;
        JsExpression conditionExpression;
        JsVars initExpression;
        block4: {
            JsVars jsVars;
            Object object;
            JsExpression range;
            block3: {
                block2: {
                    JsExpression jsExpression = $context.cacheExpressionIfNeeded(info.getRange());
                    Intrinsics.checkNotNullExpressionValue(jsExpression, "context.cacheExpressionIfNeeded(info.range)");
                    range = jsExpression;
                    object = info.getIndex();
                    if (object == null) break block2;
                    VariableDescriptor it = object;
                    boolean bl = false;
                    JsName jsName = $context.getNameForDescriptor(it);
                    object = jsName;
                    if (jsName != null) break block3;
                }
                object = JsScope.declareTemporary();
            }
            Intrinsics.checkNotNullExpressionValue(object, "info.index?.let { contex\u2026sScope.declareTemporary()");
            Object indexVar = object;
            JsVars $this$translateForExpression_u24translateForOverCollectionIndices_u24lambda_u2420 = jsVars = JsAstUtils.newVar((JsName)indexVar, new JsIntLiteral(0));
            boolean bl = false;
            $this$translateForExpression_u24translateForOverCollectionIndices_u24lambda_u2420.setSource($expression);
            JsVars jsVars2 = jsVars;
            Intrinsics.checkNotNullExpressionValue(jsVars2, "newVar(indexVar, JsIntLi\u2026y { source = expression }");
            initExpression = jsVars2;
            PropertyDescriptor propertyDescriptor = DescriptorUtils.getPropertyByName(LoopTranslator.translateForExpression$findCollection($context).getUnsubstitutedMemberScope(), Name.identifier("size"));
            Intrinsics.checkNotNullExpressionValue(propertyDescriptor, "getPropertyByName(findCo\u2026 Name.identifier(\"size\"))");
            PropertyDescriptor sizeDescriptor = propertyDescriptor;
            JsName jsName = $context.getNameForDescriptor(sizeDescriptor);
            Intrinsics.checkNotNullExpressionValue(jsName, "context.getNameForDescriptor(sizeDescriptor)");
            JsName sizeName = jsName;
            conditionExpression = JsAstUtils.inequality(((JsName)indexVar).makeRef(), new JsNameRef(sizeName, range)).source($expression);
            incrementExpression = new JsPrefixOperation(JsUnaryOperator.INC, ((JsName)indexVar).makeRef()).source($expression);
            body2 = new JsBlock();
            KtExpression ktExpression = $expression.getBody();
            if (ktExpression == null) break block4;
            KtExpression it = ktExpression;
            boolean bl2 = false;
            List<JsStatement> list2 = body2.getStatements();
            Intrinsics.checkNotNullExpressionValue(list2, "body.statements");
            Collection collection = list2;
            collection.add(Translation.translateAsStatement(it, $context.innerBlock(body2)));
        }
        return new JsFor(initExpression, conditionExpression, incrementExpression, (JsStatement)body2);
    }

    private static final ClassDescriptor translateForExpression$findIterable(TranslationContext $context) {
        ModuleDescriptor moduleDescriptor = $context.getCurrentModule();
        Intrinsics.checkNotNullExpressionValue(moduleDescriptor, "context.currentModule");
        ClassId classId = ClassId.topLevel(StandardNames.FqNames.iterable);
        Intrinsics.checkNotNullExpressionValue(classId, "topLevel(StandardNames.FqNames.iterable)");
        ClassDescriptor classDescriptor = FindClassInModuleKt.findClassAcrossModuleDependencies(moduleDescriptor, classId);
        Intrinsics.checkNotNull(classDescriptor);
        return classDescriptor;
    }

    private static final ClassDescriptor translateForExpression$findSequence(TranslationContext $context) {
        ModuleDescriptor moduleDescriptor = $context.getCurrentModule();
        Intrinsics.checkNotNullExpressionValue(moduleDescriptor, "context.currentModule");
        ClassId classId = ClassId.topLevel(sequenceFqName);
        Intrinsics.checkNotNullExpressionValue(classId, "topLevel(sequenceFqName)");
        ClassDescriptor classDescriptor = FindClassInModuleKt.findClassAcrossModuleDependencies(moduleDescriptor, classId);
        Intrinsics.checkNotNull(classDescriptor);
        return classDescriptor;
    }

    /*
     * WARNING - void declaration
     */
    private static final JsStatement translateForExpression$translateForOverCollectionWithIndex(TranslationContext $context, KtForExpression $expression, WithIndexInfo info) {
        JsStatement jsStatement;
        JsStatement jsStatement22;
        JsExpression jsExpression;
        JsVars jsVars3;
        JsName jsName;
        JsName jsName2;
        Object it;
        JsExpression jsExpression2 = $context.cacheExpressionIfNeeded(info.getRange());
        Intrinsics.checkNotNullExpressionValue(jsExpression2, "context.cacheExpressionIfNeeded(info.range)");
        JsExpression range = jsExpression2;
        VariableDescriptor variableDescriptor = info.getIndex();
        if (variableDescriptor != null) {
            it = variableDescriptor;
            boolean bl = false;
            jsName2 = $context.getNameForDescriptor((DeclarationDescriptor)it);
        } else {
            jsName2 = null;
        }
        JsName indexVar = jsName2;
        VariableDescriptor variableDescriptor2 = info.getValue();
        if (variableDescriptor2 != null) {
            VariableDescriptor it2 = variableDescriptor2;
            boolean bl = false;
            jsName = $context.getNameForDescriptor(it2);
        } else {
            jsName = null;
        }
        JsName valueVar = jsName;
        JsName jsName3 = indexVar;
        if (jsName3 != null) {
            void $this$translateForExpression_u24translateForOverCollectionWithIndex_u24lambda_u2425_u24lambda_u2424;
            JsVars bl;
            it = jsName3;
            boolean bl2 = false;
            JsVars jsVars2 = bl = JsAstUtils.newVar((JsName)it, new JsIntLiteral(0));
            TranslationContext translationContext = $context;
            boolean jsVars3 = false;
            $this$translateForExpression_u24translateForOverCollectionWithIndex_u24lambda_u2425_u24lambda_u2424.setSource($expression);
            translationContext.addStatementToCurrentBlock(bl);
        }
        JsName jsName4 = JsScope.declareTemporary();
        Intrinsics.checkNotNullExpressionValue(jsName4, "declareTemporary()");
        JsName iteratorVar = jsName4;
        ClassDescriptor rangeOwner = info.getReceiverType() == WithIndexReceiverType.SEQUENCE ? LoopTranslator.translateForExpression$findSequence($context) : LoopTranslator.translateForExpression$findIterable($context);
        FunctionDescriptor functionDescriptor = DescriptorUtils.getFunctionByName(rangeOwner.getUnsubstitutedMemberScope(), Name.identifier("iterator"));
        Intrinsics.checkNotNullExpressionValue(functionDescriptor, "getFunctionByName(rangeO\u2026e.identifier(\"iterator\"))");
        FunctionDescriptor iteratorDescriptor = functionDescriptor;
        JsName jsName5 = $context.getNameForDescriptor(iteratorDescriptor);
        Intrinsics.checkNotNullExpressionValue(jsName5, "context.getNameForDescriptor(iteratorDescriptor)");
        JsName iteratorName = jsName5;
        JsVars $this$translateForExpression_u24translateForOverCollectionWithIndex_u24lambda_u2426 = jsVars3 = JsAstUtils.newVar(iteratorVar, new JsInvocation((JsExpression)JsAstUtils.pureFqn(iteratorName, range), new JsExpression[0]));
        boolean bl = false;
        $this$translateForExpression_u24translateForOverCollectionWithIndex_u24lambda_u2426.setSource($expression);
        JsVars jsVars4 = jsVars3;
        Intrinsics.checkNotNullExpressionValue(jsVars4, "newVar(iteratorVar, JsIn\u2026y { source = expression }");
        JsVars initExpression = jsVars4;
        KotlinType kotlinType = iteratorDescriptor.getReturnType();
        Intrinsics.checkNotNull(kotlinType);
        ClassifierDescriptor classifierDescriptor = kotlinType.getConstructor().getDeclarationDescriptor();
        Intrinsics.checkNotNull(classifierDescriptor, "null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
        ClassDescriptor iteratorClassDescriptor = (ClassDescriptor)classifierDescriptor;
        FunctionDescriptor functionDescriptor2 = DescriptorUtils.getFunctionByName(iteratorClassDescriptor.getUnsubstitutedMemberScope(), Name.identifier("hasNext"));
        Intrinsics.checkNotNullExpressionValue(functionDescriptor2, "getFunctionByName(iterat\u2026me.identifier(\"hasNext\"))");
        FunctionDescriptor hasNextDescriptor = functionDescriptor2;
        JsName jsName6 = $context.getNameForDescriptor(hasNextDescriptor);
        Intrinsics.checkNotNullExpressionValue(jsName6, "context.getNameForDescriptor(hasNextDescriptor)");
        JsName hasNextName = jsName6;
        JsNode hasNextInvocation = new JsInvocation((JsExpression)JsAstUtils.pureFqn(hasNextName, (JsExpression)iteratorVar.makeRef()), new JsExpression[0]).source($expression);
        FunctionDescriptor functionDescriptor3 = DescriptorUtils.getFunctionByName(iteratorClassDescriptor.getUnsubstitutedMemberScope(), Name.identifier("next"));
        Intrinsics.checkNotNullExpressionValue(functionDescriptor3, "getFunctionByName(iterat\u2026 Name.identifier(\"next\"))");
        FunctionDescriptor nextDescriptor = functionDescriptor3;
        JsName jsName7 = $context.getNameForDescriptor(nextDescriptor);
        Intrinsics.checkNotNullExpressionValue(jsName7, "context.getNameForDescriptor(nextDescriptor)");
        JsName nextName = jsName7;
        JsNode nextInvocation = new JsInvocation((JsExpression)JsAstUtils.pureFqn(nextName, (JsExpression)iteratorVar.makeRef()), new JsExpression[0]).source($expression);
        JsName jsName8 = indexVar;
        if (jsName8 != null) {
            JsName it3 = jsName8;
            boolean jsStatement22 = false;
            jsExpression = new JsPrefixOperation(JsUnaryOperator.INC, it3.makeRef()).source($expression);
        } else {
            jsExpression = null;
        }
        JsExpression incrementExpression = jsExpression;
        JsBlock body2 = new JsBlock();
        List<JsStatement> list2 = body2.getStatements();
        Intrinsics.checkNotNullExpressionValue(list2, "body.statements");
        Object object = list2;
        if (valueVar != null) {
            JsStatement $this$translateForExpression_u24translateForOverCollectionWithIndex_u24lambda_u2428 = jsStatement22 = JsAstUtils.newVar(valueVar, (JsExpression)nextInvocation);
            boolean bl3 = false;
            ((SourceInfoAwareJsNode)((Object)$this$translateForExpression_u24translateForOverCollectionWithIndex_u24lambda_u2428)).setSource($expression);
            jsStatement = jsStatement22;
        } else {
            jsStatement = JsAstUtils.asSyntheticStatement((JsExpression)nextInvocation);
        }
        jsStatement22 = jsStatement;
        object.add(jsStatement22);
        KtExpression ktExpression = $expression.getBody();
        if (ktExpression != null) {
            KtExpression it4 = ktExpression;
            boolean bl4 = false;
            List<JsStatement> list3 = body2.getStatements();
            Intrinsics.checkNotNullExpressionValue(list3, "body.statements");
            Collection collection = list3;
            collection.add(Translation.translateAsStatement(it4, $context.innerBlock(body2)));
        }
        Object it5 = object = new JsFor(initExpression, (JsExpression)hasNextInvocation, incrementExpression);
        boolean bl5 = false;
        ((JsFor)it5).setBody(body2);
        return (JsStatement)object;
    }

    private static final JsExpression translateForExpression$translateForOverIterator$translateMethodInvocation(TranslationContext $context, JsExpression receiver, ResolvedCall<FunctionDescriptor> resolvedCall2, JsBlock block) {
        TranslationContext translationContext = $context.innerBlock(block);
        Intrinsics.checkNotNullExpressionValue(translationContext, "context.innerBlock(block)");
        return CallTranslator.translate(translationContext, resolvedCall2, receiver);
    }

    private static final JsExpression translateForExpression$translateForOverIterator$iteratorMethodInvocation(KtExpression loopRange, TranslationContext $context) {
        JsExpression jsExpression = Translation.translateAsExpression(loopRange, $context);
        Intrinsics.checkNotNullExpressionValue(jsExpression, "translateAsExpression(loopRange, context)");
        JsExpression range = jsExpression;
        ResolvedCall<FunctionDescriptor> resolvedCall2 = BindingUtils.getIteratorFunction($context.bindingContext(), loopRange);
        Intrinsics.checkNotNullExpressionValue(resolvedCall2, "getIteratorFunction(cont\u2026dingContext(), loopRange)");
        ResolvedCall<FunctionDescriptor> resolvedCall3 = resolvedCall2;
        return CallTranslator.translate($context, resolvedCall3, range);
    }

    private static final JsExpression translateForExpression$translateForOverIterator$hasNextMethodInvocation(TranslationContext $context, KtExpression loopRange, JsExpression iteratorVar, JsBlock block) {
        ResolvedCall<FunctionDescriptor> resolvedCall2 = BindingUtils.getHasNextCallable($context.bindingContext(), loopRange);
        Intrinsics.checkNotNullExpressionValue(resolvedCall2, "getHasNextCallable(conte\u2026dingContext(), loopRange)");
        ResolvedCall<FunctionDescriptor> resolvedCall3 = resolvedCall2;
        return LoopTranslator.translateForExpression$translateForOverIterator$translateMethodInvocation($context, iteratorVar, resolvedCall3, block);
    }

    /*
     * WARNING - void declaration
     */
    private static final JsStatement translateForExpression$translateForOverIterator(TranslationContext $context, KtExpression loopRange, KtForExpression $expression, KtDestructuringDeclaration destructuringParameter, KtParameter loopParameter, JsName parameterName) {
        List<JsStatement> list2;
        List<JsStatement> list3;
        Object object;
        Collection collection;
        JsExpression jsExpression;
        JsExpression jsExpression2 = $context.defineTemporary(LoopTranslator.translateForExpression$translateForOverIterator$iteratorMethodInvocation(loopRange, $context));
        Intrinsics.checkNotNullExpressionValue(jsExpression2, "context.defineTemporary(\u2026eratorMethodInvocation())");
        JsExpression iteratorVar = jsExpression2;
        JsBlock hasNextBlock = new JsBlock();
        JsExpression hasNextInvocation = LoopTranslator.translateForExpression$translateForOverIterator$hasNextMethodInvocation($context, loopRange, iteratorVar, hasNextBlock);
        JsBlock nextBlock = new JsBlock();
        ResolvedCall<FunctionDescriptor> resolvedCall2 = BindingUtils.getNextFunction($context.bindingContext(), loopRange);
        Intrinsics.checkNotNullExpressionValue(resolvedCall2, "getNextFunction(context.\u2026dingContext(), loopRange)");
        JsExpression nextInvoke = LoopTranslator.translateForExpression$translateForOverIterator$translateMethodInvocation($context, iteratorVar, resolvedCall2, nextBlock);
        List bodyStatements = new ArrayList();
        if (hasNextBlock.isEmpty()) {
            jsExpression = hasNextInvocation;
        } else {
            void $this$translateForExpression_u24translateForOverIterator_u24lambda_u2431;
            collection = bodyStatements;
            List<JsStatement> list4 = hasNextBlock.getStatements();
            Intrinsics.checkNotNullExpressionValue(list4, "hasNextBlock.statements");
            CollectionsKt.addAll(collection, (Iterable)list4);
            collection = bodyStatements;
            object = new JsBreak();
            JsBreak jsBreak = object;
            JsExpression jsExpression3 = JsAstUtils.notOptimized(hasNextInvocation);
            boolean bl = false;
            $this$translateForExpression_u24translateForOverIterator_u24lambda_u2431.setSource($expression);
            JsStatement jsStatement = (JsStatement)object;
            JsExpression jsExpression4 = jsExpression3;
            Object $this$translateForExpression_u24translateForOverIterator_u24lambda_u2432 = object = new JsIf(jsExpression4, jsStatement);
            boolean bl2 = false;
            ((SourceInfoAwareJsNode)$this$translateForExpression_u24translateForOverIterator_u24lambda_u2432).setSource($expression);
            collection.add(object);
            jsExpression = new JsBooleanLiteral(true);
        }
        JsExpression exitCondition = jsExpression;
        collection = bodyStatements;
        List<JsStatement> list5 = nextBlock.getStatements();
        Intrinsics.checkNotNullExpressionValue(list5, "nextBlock.statements");
        CollectionsKt.addAll(collection, (Iterable)list5);
        collection = bodyStatements;
        JsStatement jsStatement = LoopTranslator.translateForExpression$translateBody($expression, destructuringParameter, $context, loopParameter, parameterName, nextInvoke);
        if (jsStatement != null) {
            JsStatement p0 = jsStatement;
            boolean bl = false;
            list3 = JsAstUtils.flattenStatement(p0);
        } else {
            list3 = list2 = null;
        }
        if (list3 == null) {
            list2 = CollectionsKt.emptyList();
        }
        object = list2;
        CollectionsKt.addAll(collection, object);
        JsStatement jsStatement2 = (JsStatement)CollectionsKt.singleOrNull(bodyStatements);
        if (jsStatement2 == null) {
            jsStatement2 = new JsBlock(bodyStatements);
        }
        return new JsWhile(exitCondition, jsStatement2);
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[RangeType.values().length];
            try {
                nArray[RangeType.RANGE_TO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RangeType.UNTIL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RangeType.DOWN_TO.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[WithIndexReceiverType.values().length];
            try {
                nArray[WithIndexReceiverType.ARRAY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WithIndexReceiverType.ITERABLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WithIndexReceiverType.SEQUENCE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WithIndexReceiverType.COLLECTION.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

