/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.InlineClassRepresentation;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyGetterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.VariableDescriptor;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutor;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InlineClassesUtilsKt {
    @NotNull
    private static final FqName JVM_INLINE_ANNOTATION_FQ_NAME = new FqName("kotlin.jvm.JvmInline");

    public static final boolean isInlineClass(@NotNull DeclarationDescriptor $this$isInlineClass) {
        Intrinsics.checkNotNullParameter($this$isInlineClass, "<this>");
        return $this$isInlineClass instanceof ClassDescriptor && (((ClassDescriptor)$this$isInlineClass).isInline() || ((ClassDescriptor)$this$isInlineClass).isValue());
    }

    @Nullable
    public static final KotlinType unsubstitutedUnderlyingType(@NotNull KotlinType $this$unsubstitutedUnderlyingType) {
        InlineClassRepresentation<SimpleType> inlineClassRepresentation2;
        ClassDescriptor classDescriptor2;
        Intrinsics.checkNotNullParameter($this$unsubstitutedUnderlyingType, "<this>");
        ClassifierDescriptor $this$safeAs$iv = $this$unsubstitutedUnderlyingType.getConstructor().getDeclarationDescriptor();
        boolean $i$f$safeAs = false;
        ClassifierDescriptor classifierDescriptor = $this$safeAs$iv;
        if (!(classifierDescriptor instanceof ClassDescriptor)) {
            classifierDescriptor = null;
        }
        return (classDescriptor2 = (ClassDescriptor)classifierDescriptor) == null ? null : ((inlineClassRepresentation2 = classDescriptor2.getInlineClassRepresentation()) == null ? null : inlineClassRepresentation2.getUnderlyingType());
    }

    public static final boolean isInlineClassType(@NotNull KotlinType $this$isInlineClassType) {
        Intrinsics.checkNotNullParameter($this$isInlineClassType, "<this>");
        ClassifierDescriptor classifierDescriptor = $this$isInlineClassType.getConstructor().getDeclarationDescriptor();
        return classifierDescriptor == null ? false : InlineClassesUtilsKt.isInlineClass(classifierDescriptor);
    }

    @Nullable
    public static final KotlinType substitutedUnderlyingType(@NotNull KotlinType $this$substitutedUnderlyingType) {
        KotlinType kotlinType;
        Intrinsics.checkNotNullParameter($this$substitutedUnderlyingType, "<this>");
        KotlinType kotlinType2 = InlineClassesUtilsKt.unsubstitutedUnderlyingType($this$substitutedUnderlyingType);
        if (kotlinType2 == null) {
            kotlinType = null;
        } else {
            KotlinType kotlinType3;
            KotlinType it = kotlinType3 = kotlinType2;
            boolean bl = false;
            kotlinType = TypeSubstitutor.create($this$substitutedUnderlyingType).substitute(it, Variance.INVARIANT);
        }
        return kotlinType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isGetterOfUnderlyingPropertyOfInlineClass(@NotNull CallableDescriptor $this$isGetterOfUnderlyingPropertyOfInlineClass) {
        Intrinsics.checkNotNullParameter($this$isGetterOfUnderlyingPropertyOfInlineClass, "<this>");
        if (!($this$isGetterOfUnderlyingPropertyOfInlineClass instanceof PropertyGetterDescriptor)) return false;
        PropertyDescriptor propertyDescriptor = ((PropertyGetterDescriptor)$this$isGetterOfUnderlyingPropertyOfInlineClass).getCorrespondingProperty();
        Intrinsics.checkNotNullExpressionValue(propertyDescriptor, "correspondingProperty");
        if (!InlineClassesUtilsKt.isUnderlyingPropertyOfInlineClass(propertyDescriptor)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isUnderlyingPropertyOfInlineClass(@NotNull VariableDescriptor $this$isUnderlyingPropertyOfInlineClass) {
        ClassDescriptor classDescriptor2;
        Intrinsics.checkNotNullParameter($this$isUnderlyingPropertyOfInlineClass, "<this>");
        if ($this$isUnderlyingPropertyOfInlineClass.getExtensionReceiverParameter() != null) return false;
        Object object = $this$isUnderlyingPropertyOfInlineClass.getContainingDeclaration();
        ClassDescriptor classDescriptor3 = classDescriptor2 = object instanceof ClassDescriptor ? (ClassDescriptor)object : null;
        if (!Intrinsics.areEqual(classDescriptor2 == null ? null : ((object = classDescriptor2.getInlineClassRepresentation()) == null ? null : ((InlineClassRepresentation)object).getUnderlyingPropertyName()), $this$isUnderlyingPropertyOfInlineClass.getName())) return false;
        return true;
    }
}

