/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.arguments;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.arguments.ArgumentParseErrors;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\f\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\"\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00010\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00010\u00112\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00010\u00112\u0006\u0010\u0016\u001a\u00020\u0001\u001a \u0010\u0017\u001a\u00020\u0018*\u00020\u00192\n\u0010\u001a\u001a\u00060\u001bj\u0002`\u001c2\u0006\u0010\u001d\u001a\u00020\u0003H\u0002\u001a\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00010\u0011*\u00020\u001f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\u0013\u0010 \u001a\u0004\u0018\u00010\u0003*\u00020\u0019H\u0002\u00a2\u0006\u0002\u0010!\u001a\u000e\u0010\"\u001a\u0004\u0018\u00010\u0001*\u00020\u0019H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0007\u001a\u00020\u0001*\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\"\u0018\u0010\n\u001a\u00020\u0001*\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\t\"\u0018\u0010\f\u001a\u00020\r*\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000e\"\u0018\u0010\u000f\u001a\u00020\r*\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000e\u00a8\u0006#"}, d2={"ARGFILE_ARGUMENT", "", "BACKSLASH", "", "DOUBLE_QUOTE", "EXPERIMENTAL_ARGFILE_ARGUMENT", "SINGLE_QUOTE", "argfilePath", "getArgfilePath", "(Ljava/lang/String;)Ljava/lang/String;", "deprecatedArgfilePath", "getDeprecatedArgfilePath", "isArgfileArgument", "", "(Ljava/lang/String;)Z", "isDeprecatedArgfileArgument", "preprocessCommandLineArguments", "", "args", "errors", "Lorg/jetbrains/kotlin/cli/common/arguments/ArgumentParseErrors;", "readArgumentsFromArgFile", "content", "consumeRestOfQuotedSequence", "", "Ljava/io/Reader;", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "quote", "expand", "Ljava/io/File;", "nextChar", "(Ljava/io/Reader;)Ljava/lang/Character;", "parseNextArgument", "cli-common"})
public final class PreprocessCommandLineArgumentsKt {
    @NotNull
    public static final String ARGFILE_ARGUMENT = "@";

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> preprocessCommandLineArguments(@NotNull List<String> args2, @NotNull ArgumentParseErrors errors) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(args2, "args");
        Intrinsics.checkNotNullParameter(errors, "errors");
        Iterable $this$flatMap$iv = args2;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List<String> list2;
            String arg = (String)element$iv$iv;
            boolean bl = false;
            if (PreprocessCommandLineArgumentsKt.isArgfileArgument(arg)) {
                list2 = PreprocessCommandLineArgumentsKt.expand(new File(PreprocessCommandLineArgumentsKt.getArgfilePath(arg)), errors);
            } else if (PreprocessCommandLineArgumentsKt.isDeprecatedArgfileArgument(arg)) {
                errors.getDeprecatedArguments().put("-Xargfile=", ARGFILE_ARGUMENT);
                list2 = PreprocessCommandLineArgumentsKt.expand(new File(PreprocessCommandLineArgumentsKt.getDeprecatedArgfilePath(arg)), errors);
            } else {
                list2 = CollectionsKt.listOf(arg);
            }
            Iterable list$iv$iv = list2;
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final List<String> readArgumentsFromArgFile(@NotNull String content2) {
        Intrinsics.checkNotNullParameter(content2, "content");
        StringReader reader = new StringReader(content2);
        return SequencesKt.toList(SequencesKt.generateSequence((Function0)new Function0<String>(reader){
            final /* synthetic */ StringReader $reader;
            {
                this.$reader = $reader;
                super(0);
            }

            @Nullable
            public final String invoke() {
                return PreprocessCommandLineArgumentsKt.access$parseNextArgument(this.$reader);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List<String> expand(File $this$expand, ArgumentParseErrors errors) {
        List list2;
        try {
            List list3;
            list2 = $this$expand;
            Object object = Charsets.UTF_8;
            int n = 8192;
            Object object2 = list2;
            object2 = new InputStreamReader((InputStream)new FileInputStream((File)object2), (Charset)object);
            list2 = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
            object = null;
            try {
                BufferedReader it = (BufferedReader)((Object)list2);
                boolean bl = false;
                list3 = SequencesKt.toList(SequencesKt.generateSequence((Function0)new Function0<String>(it){
                    final /* synthetic */ BufferedReader $it;
                    {
                        this.$it = $it;
                        super(0);
                    }

                    @Nullable
                    public final String invoke() {
                        return PreprocessCommandLineArgumentsKt.access$parseNextArgument(this.$it);
                    }
                }));
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)((Object)list2), (Throwable)object);
            }
            list2 = list3;
        }
        catch (FileNotFoundException e) {
            ((Collection)errors.getArgfileErrors()).add("Argfile not found: " + $this$expand.getAbsolutePath());
            list2 = CollectionsKt.emptyList();
        }
        catch (IOException e) {
            ((Collection)errors.getArgfileErrors()).add("Error while reading argfile: " + e);
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    private static final String parseNextArgument(Reader $this$parseNextArgument) {
        String string2;
        StringBuilder sb = new StringBuilder();
        Character r = PreprocessCommandLineArgumentsKt.nextChar($this$parseNextArgument);
        while (r != null && CharsKt.isWhitespace(r.charValue())) {
            r = PreprocessCommandLineArgumentsKt.nextChar($this$parseNextArgument);
        }
        while (r != null && !CharsKt.isWhitespace(r.charValue())) {
            block6: {
                block5: {
                    char c = '\"';
                    if (r.charValue() == c) break block5;
                    c = '\'';
                    if (r.charValue() != c) break block6;
                }
                PreprocessCommandLineArgumentsKt.consumeRestOfQuotedSequence($this$parseNextArgument, sb, r.charValue());
                return sb.toString();
            }
            sb.append(r.charValue());
            r = PreprocessCommandLineArgumentsKt.nextChar($this$parseNextArgument);
        }
        String it = string2 = sb.toString();
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue(it, "it");
        return ((CharSequence)it).length() > 0 ? string2 : null;
    }

    private static final void consumeRestOfQuotedSequence(Reader $this$consumeRestOfQuotedSequence, StringBuilder sb, char quote) {
        Character ch = PreprocessCommandLineArgumentsKt.nextChar($this$consumeRestOfQuotedSequence);
        while (ch != null) {
            char c = quote;
            if (ch.charValue() == c) break;
            c = '\\';
            if (ch.charValue() == c) {
                Character c2 = PreprocessCommandLineArgumentsKt.nextChar($this$consumeRestOfQuotedSequence);
                if (c2 != null) {
                    char it = c2.charValue();
                    boolean bl = false;
                    sb.append(it);
                }
            } else {
                sb.append(ch.charValue());
            }
            ch = PreprocessCommandLineArgumentsKt.nextChar($this$consumeRestOfQuotedSequence);
        }
    }

    private static final Character nextChar(Reader $this$nextChar) {
        Integer n = $this$nextChar.read();
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = !(it == -1) ? n : null;
        return n2 != null ? Character.valueOf((char)n2.intValue()) : null;
    }

    private static final String getArgfilePath(String $this$argfilePath) {
        return StringsKt.removePrefix($this$argfilePath, (CharSequence)ARGFILE_ARGUMENT);
    }

    private static final boolean isArgfileArgument(String $this$isArgfileArgument) {
        return StringsKt.startsWith$default($this$isArgfileArgument, ARGFILE_ARGUMENT, false, 2, null);
    }

    private static final String getDeprecatedArgfilePath(String $this$deprecatedArgfilePath) {
        return StringsKt.removePrefix($this$deprecatedArgfilePath, (CharSequence)"-Xargfile=");
    }

    private static final boolean isDeprecatedArgfileArgument(String $this$isDeprecatedArgfileArgument) {
        return StringsKt.startsWith$default($this$isDeprecatedArgfileArgument, "-Xargfile=", false, 2, null);
    }

    public static final /* synthetic */ String access$parseNextArgument(Reader $receiver) {
        return PreprocessCommandLineArgumentsKt.parseNextArgument($receiver);
    }
}

