/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.util.Ref;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004H\u0000\u001a\u000e\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u0004\u0018\u00010\u0007\u001a\f\u0010\b\u001a\u0004\u0018\u00010\u0006*\u00020\t\u00a8\u0006\n"}, d2={"getChildren", "", "Lcom/intellij/lang/LighterASTNode;", "tree", "Lcom/intellij/util/diff/FlyweightCapableTreeStructure;", "getVisibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "Lorg/jetbrains/kotlin/psi/KtModifierList;", "toVisibilityOrNull", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "checkers"})
public final class SourceHelpersKt {
    @NotNull
    public static final List<LighterASTNode> getChildren(@NotNull LighterASTNode $this$getChildren, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
        List<Object> list2;
        Intrinsics.checkNotNullParameter($this$getChildren, "<this>");
        Intrinsics.checkNotNullParameter(tree, "tree");
        Ref children2 = new Ref();
        int count = tree.getChildren((Object)$this$getChildren, children2);
        if (count > 0) {
            Object object = children2.get();
            Intrinsics.checkNotNullExpressionValue(object, "children.get()");
            list2 = ArraysKt.filterNotNull((Object[])object);
        } else {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    @Nullable
    public static final Visibility getVisibility(@Nullable KtModifierList $this$getVisibility) {
        Object object = $this$getVisibility;
        return object != null && (object = KtPsiUtilKt.visibilityModifierType(object)) != null ? SourceHelpersKt.toVisibilityOrNull((KtModifierKeywordToken)((Object)object)) : null;
    }

    @Nullable
    public static final Visibility toVisibilityOrNull(@NotNull KtModifierKeywordToken $this$toVisibilityOrNull) {
        Intrinsics.checkNotNullParameter((Object)$this$toVisibilityOrNull, "<this>");
        KtModifierKeywordToken ktModifierKeywordToken = $this$toVisibilityOrNull;
        return Intrinsics.areEqual((Object)ktModifierKeywordToken, (Object)KtTokens.PUBLIC_KEYWORD) ? (Visibility)Visibilities.Public.INSTANCE : (Intrinsics.areEqual((Object)ktModifierKeywordToken, (Object)KtTokens.PRIVATE_KEYWORD) ? (Visibility)Visibilities.Private.INSTANCE : (Intrinsics.areEqual((Object)ktModifierKeywordToken, (Object)KtTokens.PROTECTED_KEYWORD) ? (Visibility)Visibilities.Protected.INSTANCE : (Intrinsics.areEqual((Object)ktModifierKeywordToken, (Object)KtTokens.INTERNAL_KEYWORD) ? (Visibility)Visibilities.Internal.INSTANCE : null)));
    }
}

