/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousInitializer;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousFunctionExpression;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousObjectExpression;
import org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirDelegatedConstructorCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirLambdaArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirLoop;
import org.jetbrains.kotlin.fir.expressions.FirLoopJump;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirWhenBranch;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.fir.expressions.FirWrappedExpression;
import org.jetbrains.kotlin.fir.expressions.impl.FirNoReceiverExpression;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\f\u0010\f\u001a\u00020\r*\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirBreakOrContinueJumpsAcrossFunctionBoundaryChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirLoopJump;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirLoopJumpChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "tryInline", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "checkers"})
public final class FirBreakOrContinueJumpsAcrossFunctionBoundaryChecker
extends FirExpressionChecker<FirLoopJump> {
    @NotNull
    public static final FirBreakOrContinueJumpsAcrossFunctionBoundaryChecker INSTANCE = new FirBreakOrContinueJumpsAcrossFunctionBoundaryChecker();

    private FirBreakOrContinueJumpsAcrossFunctionBoundaryChecker() {
    }

    @Override
    public void check(@NotNull FirLoopJump expression2, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        boolean allowInlined = context.getLanguageVersionSettings().supportsFeature(LanguageFeature.BreakContinueInInlineLambdas);
        ArrayDeque<FirElement> errorPathElements = new ArrayDeque<FirElement>();
        FirBreakOrContinueJumpsAcrossFunctionBoundaryChecker.check$findPathAndCheck(expression2, errorPathElements, reporter, context, allowInlined, expression2.getTarget().getLabeledElement().getBlock());
    }

    private final FirExpression tryInline(FirExpression $this$tryInline) {
        FirExpression firExpression2;
        FirAnonymousFunctionExpression anonymousFunctionExpression;
        FirPureAbstractElement firPureAbstractElement;
        FirExpression firExpression3 = $this$tryInline instanceof FirLambdaArgumentExpression ? (FirLambdaArgumentExpression)$this$tryInline : null;
        if (firExpression3 == null || (firExpression3 = firExpression3.getExpression()) == null) {
            firExpression3 = $this$tryInline;
        }
        return (firPureAbstractElement = (anonymousFunctionExpression = (firExpression2 = firExpression3) instanceof FirAnonymousFunctionExpression ? (FirAnonymousFunctionExpression)firExpression2 : null)) != null && (firPureAbstractElement = ((FirAnonymousFunctionExpression)firPureAbstractElement).getAnonymousFunction()) != null && (firPureAbstractElement = ((FirAnonymousFunction)firPureAbstractElement).getBody()) != null ? (FirExpression)firPureAbstractElement : $this$tryInline;
    }

    private static final boolean check$findPathAndCheck$findPathAndCheckWithAddingErrorElement(ArrayDeque<FirElement> errorPathElements, FirLoopJump $expression, DiagnosticReporter $reporter, CheckerContext $context, boolean allowInlined, FirElement errorElement, FirElement checkElement) {
        errorPathElements.addLast(errorElement);
        boolean result2 = FirBreakOrContinueJumpsAcrossFunctionBoundaryChecker.check$findPathAndCheck($expression, errorPathElements, $reporter, $context, allowInlined, checkElement);
        errorPathElements.removeLast();
        return result2;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean check$findPathAndCheck(FirLoopJump $expression, ArrayDeque<FirElement> errorPathElements, DiagnosticReporter $reporter, CheckerContext $context, boolean allowInlined, FirElement element) {
        if (element == null) {
            return false;
        }
        FirElement firElement = element;
        if (Intrinsics.areEqual(firElement, $expression)) {
            if (!CollectionsKt.any((Iterable)errorPathElements)) return true;
            KtDiagnosticReportHelpersKt.reportOn$default($reporter, (AbstractKtSourceElement)$expression.getSource(), FirErrors.INSTANCE.getBREAK_OR_CONTINUE_JUMPS_ACROSS_FUNCTION_BOUNDARY(), (DiagnosticContext)$context, null, 8, null);
            return true;
        }
        if (firElement instanceof FirBlock) {
            FirStatement statement2;
            Iterator<FirStatement> iterator2 = ((FirBlock)element).getStatements().iterator();
            do {
                if (!iterator2.hasNext()) return false;
            } while (!FirBreakOrContinueJumpsAcrossFunctionBoundaryChecker.check$findPathAndCheck($expression, errorPathElements, $reporter, $context, allowInlined, statement2 = iterator2.next()));
            return true;
        }
        if (firElement instanceof FirLoop) {
            if (FirBreakOrContinueJumpsAcrossFunctionBoundaryChecker.check$findPathAndCheck($expression, errorPathElements, $reporter, $context, allowInlined, ((FirLoop)element).getCondition())) return true;
            if (!FirBreakOrContinueJumpsAcrossFunctionBoundaryChecker.check$findPathAndCheck($expression, errorPathElements, $reporter, $context, allowInlined, ((FirLoop)element).getBlock())) return false;
            return true;
        }
        if (firElement instanceof FirWhenExpression) {
            FirWhenBranch branch;
            Iterator<FirWhenBranch> iterator3 = ((FirWhenExpression)element).getBranches().iterator();
            do {
                if (!iterator3.hasNext()) return false;
            } while (!FirBreakOrContinueJumpsAcrossFunctionBoundaryChecker.check$findPathAndCheck($expression, errorPathElements, $reporter, $context, allowInlined, (branch = iterator3.next()).getResult()));
            return true;
        }
        if (firElement instanceof FirVariable) {
            return FirBreakOrContinueJumpsAcrossFunctionBoundaryChecker.check$findPathAndCheck($expression, errorPathElements, $reporter, $context, allowInlined, ((FirVariable)element).getInitializer());
        }
        if (firElement instanceof FirWrappedExpression) {
            return FirBreakOrContinueJumpsAcrossFunctionBoundaryChecker.check$findPathAndCheck($expression, errorPathElements, $reporter, $context, allowInlined, ((FirWrappedExpression)element).getExpression());
        }
        if (firElement instanceof FirNoReceiverExpression) {
            return false;
        }
        if (firElement instanceof FirFunctionCall) {
            FirExpression firExpression2;
            void expressionToCheck;
            void $this$forEachIndexed$iv;
            FirBasedSymbol<?> branch;
            if (FirBreakOrContinueJumpsAcrossFunctionBoundaryChecker.check$findPathAndCheck($expression, errorPathElements, $reporter, $context, allowInlined, ((FirFunctionCall)element).getExtensionReceiver())) return true;
            if (FirBreakOrContinueJumpsAcrossFunctionBoundaryChecker.check$findPathAndCheck($expression, errorPathElements, $reporter, $context, allowInlined, ((FirFunctionCall)element).getDispatchReceiver())) {
                return true;
            }
            FirFunctionSymbol symbol2 = allowInlined ? ((branch = UtilsKt.getResolvedSymbol(((FirFunctionCall)element).getCalleeReference())) instanceof FirFunctionSymbol ? (FirFunctionSymbol)branch : null) : null;
            Object $this$arguments$iv = (FirCall)element;
            boolean $i$f$getArguments = false;
            $this$arguments$iv = $this$arguments$iv.getArgumentList().getArguments();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            Iterator iterator4 = $this$forEachIndexed$iv.iterator();
            do {
                void argument2;
                int n;
                if (!iterator4.hasNext()) return false;
                Object item$iv = iterator4.next();
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                FirExpression firExpression3 = (FirExpression)item$iv;
                int i = n;
                boolean bl = false;
                Object object = symbol2;
                boolean bl2 = object != null && (object = ((FirCallableSymbol)object).getResolvedStatus()) != null ? object.isInline() : false;
                if (bl2) {
                    FirValueParameterSymbol $this$check_u24findPathAndCheck_u24lambda_u241_u24lambda_u240 = symbol2.getValueParameterSymbols().get(i);
                    boolean bl3 = false;
                    if (!($this$check_u24findPathAndCheck_u24lambda_u241_u24lambda_u240.isNoinline() || $this$check_u24findPathAndCheck_u24lambda_u241_u24lambda_u240.isCrossinline())) {
                        firExpression2 = INSTANCE.tryInline((FirExpression)argument2);
                        continue;
                    }
                }
                firExpression2 = argument2;
            } while (!FirBreakOrContinueJumpsAcrossFunctionBoundaryChecker.check$findPathAndCheck($expression, errorPathElements, $reporter, $context, allowInlined, (FirElement)(expressionToCheck = firExpression2)));
            return true;
        }
        if (firElement instanceof FirCall) {
            FirExpression argument3;
            FirCall $this$arguments$iv = (FirCall)element;
            boolean $i$f$getArguments = false;
            Iterator<FirExpression> symbol2 = $this$arguments$iv.getArgumentList().getArguments().iterator();
            do {
                if (!symbol2.hasNext()) return false;
            } while (!FirBreakOrContinueJumpsAcrossFunctionBoundaryChecker.check$findPathAndCheck($expression, errorPathElements, $reporter, $context, allowInlined, argument3 = symbol2.next()));
            return true;
        }
        if (firElement instanceof FirClass) {
            errorPathElements.addLast(element);
            for (FirDeclaration declaration : ((FirClass)element).getDeclarations()) {
                if (!FirBreakOrContinueJumpsAcrossFunctionBoundaryChecker.check$findPathAndCheck($expression, errorPathElements, $reporter, $context, allowInlined, declaration)) continue;
                errorPathElements.removeLast();
                return true;
            }
            errorPathElements.removeLast();
            return false;
        } else if (firElement instanceof FirFunction) {
            if (FirBreakOrContinueJumpsAcrossFunctionBoundaryChecker.check$findPathAndCheck$findPathAndCheckWithAddingErrorElement(errorPathElements, $expression, $reporter, $context, allowInlined, element, ((FirFunction)element).getBody())) {
                return true;
            }
            if (!(element instanceof FirConstructor)) return false;
            FirDelegatedConstructorCall firDelegatedConstructorCall = ((FirConstructor)element).getDelegatedConstructor();
            if (firDelegatedConstructorCall == null) return false;
            FirArgumentList firArgumentList = firDelegatedConstructorCall.getArgumentList();
            FirArgumentList argumentList2 = firArgumentList;
            if (argumentList2 == null) return false;
            errorPathElements.addLast(element);
            for (FirExpression argument4 : argumentList2.getArguments()) {
                if (!FirBreakOrContinueJumpsAcrossFunctionBoundaryChecker.check$findPathAndCheck($expression, errorPathElements, $reporter, $context, allowInlined, argument4)) continue;
                errorPathElements.removeLast();
                return true;
            }
            errorPathElements.removeLast();
            return false;
        } else {
            if (firElement instanceof FirAnonymousInitializer) {
                return FirBreakOrContinueJumpsAcrossFunctionBoundaryChecker.check$findPathAndCheck$findPathAndCheckWithAddingErrorElement(errorPathElements, $expression, $reporter, $context, allowInlined, element, ((FirAnonymousInitializer)element).getBody());
            }
            if (firElement instanceof FirAnonymousObjectExpression) {
                return FirBreakOrContinueJumpsAcrossFunctionBoundaryChecker.check$findPathAndCheck$findPathAndCheckWithAddingErrorElement(errorPathElements, $expression, $reporter, $context, allowInlined, element, ((FirAnonymousObjectExpression)element).getAnonymousObject());
            }
            if (!(firElement instanceof FirAnonymousFunctionExpression)) return false;
            return FirBreakOrContinueJumpsAcrossFunctionBoundaryChecker.check$findPathAndCheck$findPathAndCheckWithAddingErrorElement(errorPathElements, $expression, $reporter, $context, allowInlined, element, ((FirAnonymousFunctionExpression)element).getAnonymousFunction());
        }
    }
}

