/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.collectors.components;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnostic;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.collectors.components.AbstractDiagnosticCollectorComponent;
import org.jetbrains.kotlin.fir.analysis.diagnostics.ConeDiagnosticToFirDiagnosticKt;
import org.jetbrains.kotlin.fir.declarations.FirErrorFunction;
import org.jetbrains.kotlin.fir.declarations.FirErrorImport;
import org.jetbrains.kotlin.fir.diagnostics.ConeAmbiguousSuper;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.ConeSimpleDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirErrorExpression;
import org.jetbrains.kotlin.fir.expressions.FirErrorLoop;
import org.jetbrains.kotlin.fir.expressions.FirErrorResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccess;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.references.FirErrorNamedReference;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeAmbiguityError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeInapplicableCandidateError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeInapplicableWrongReceiver;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeInstanceAccessBeforeSuperCall;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedNameError;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J,\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\fH\u0002J\u0018\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000eH\u0016J\u0018\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u000eH\u0016J\u0018\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u000eH\u0016J\u0018\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u000eH\u0016J\u0018\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0013\u001a\u00020\u000eH\u0016J\u0018\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0013\u001a\u00020\u000eH\u0016J\u0018\u0010#\u001a\u00020\b2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0013\u001a\u00020\u000eH\u0016J\u0018\u0010&\u001a\u00020\b2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u0013\u001a\u00020\u000eH\u0016J\u000e\u0010)\u001a\u00020**\u0004\u0018\u00010+H\u0002\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/collectors/components/ErrorNodeDiagnosticCollectorComponent;", "Lorg/jetbrains/kotlin/fir/analysis/collectors/components/AbstractDiagnosticCollectorComponent;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)V", "reportFirDiagnostic", "", "diagnostic", "Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "qualifiedAccessSource", "visitErrorExpression", "errorExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirErrorExpression;", "data", "visitErrorFunction", "errorFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirErrorFunction;", "visitErrorImport", "errorImport", "Lorg/jetbrains/kotlin/fir/declarations/FirErrorImport;", "visitErrorLoop", "errorLoop", "Lorg/jetbrains/kotlin/fir/expressions/FirErrorLoop;", "visitErrorNamedReference", "errorNamedReference", "Lorg/jetbrains/kotlin/fir/references/FirErrorNamedReference;", "visitErrorResolvedQualifier", "errorResolvedQualifier", "Lorg/jetbrains/kotlin/fir/expressions/FirErrorResolvedQualifier;", "visitErrorTypeRef", "errorTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirErrorTypeRef;", "visitResolvedTypeRef", "resolvedTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "cannotBeResolved", "", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "checkers"})
public final class ErrorNodeDiagnosticCollectorComponent
extends AbstractDiagnosticCollectorComponent {
    public ErrorNodeDiagnosticCollectorComponent(@NotNull FirSession session2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(session2, "session");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        super(session2, reporter);
    }

    @Override
    public void visitErrorLoop(@NotNull FirErrorLoop errorLoop, @NotNull CheckerContext data2) {
        Intrinsics.checkNotNullParameter(errorLoop, "errorLoop");
        Intrinsics.checkNotNullParameter(data2, "data");
        KtSourceElement ktSourceElement = errorLoop.getSource();
        if (ktSourceElement == null) {
            return;
        }
        KtSourceElement source2 = ktSourceElement;
        ErrorNodeDiagnosticCollectorComponent.reportFirDiagnostic$default(this, errorLoop.getDiagnostic(), source2, data2, null, 8, null);
    }

    @Override
    public void visitErrorTypeRef(@NotNull FirErrorTypeRef errorTypeRef, @NotNull CheckerContext data2) {
        Intrinsics.checkNotNullParameter(errorTypeRef, "errorTypeRef");
        Intrinsics.checkNotNullParameter(data2, "data");
        KtSourceElement ktSourceElement = errorTypeRef.getSource();
        if (ktSourceElement == null) {
            return;
        }
        KtSourceElement source2 = ktSourceElement;
        ErrorNodeDiagnosticCollectorComponent.reportFirDiagnostic$default(this, errorTypeRef.getDiagnostic(), source2, data2, null, 8, null);
    }

    @Override
    public void visitResolvedTypeRef(@NotNull FirResolvedTypeRef resolvedTypeRef, @NotNull CheckerContext data2) {
        boolean bl;
        Intrinsics.checkNotNullParameter(resolvedTypeRef, "resolvedTypeRef");
        Intrinsics.checkNotNullParameter(data2, "data");
        boolean bl2 = bl = !(resolvedTypeRef.getType() instanceof ConeErrorType);
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Instead use FirErrorTypeRef for " + ConeTypeUtilsKt.renderForDebugging(resolvedTypeRef.getType());
            throw new AssertionError((Object)string2);
        }
    }

    @Override
    public void visitErrorNamedReference(@NotNull FirErrorNamedReference errorNamedReference, @NotNull CheckerContext data2) {
        FirStatement qualifiedAccessOrAnnotationCall;
        FirStatement firStatement;
        Intrinsics.checkNotNullParameter(errorNamedReference, "errorNamedReference");
        Intrinsics.checkNotNullParameter(data2, "data");
        KtSourceElement ktSourceElement = errorNamedReference.getSource();
        if (ktSourceElement == null) {
            return;
        }
        KtSourceElement source2 = ktSourceElement;
        FirStatement firStatement2 = CollectionsKt.lastOrNull(data2.getQualifiedAccessOrAnnotationCalls());
        if (firStatement2 != null) {
            FirStatement firStatement3;
            FirStatement it = firStatement3 = firStatement2;
            boolean bl = false;
            FirStatement firStatement4 = it;
            firStatement = (firStatement4 instanceof FirQualifiedAccess ? Intrinsics.areEqual(((FirQualifiedAccess)it).getCalleeReference(), errorNamedReference) : (firStatement4 instanceof FirAnnotationCall ? Intrinsics.areEqual(((FirAnnotationCall)it).getCalleeReference(), errorNamedReference) : false)) ? firStatement3 : null;
        } else {
            firStatement = qualifiedAccessOrAnnotationCall = null;
        }
        if (Intrinsics.areEqual(source2.getElementType(), KtNodeTypes.ANNOTATION_ENTRY) && errorNamedReference.getDiagnostic() instanceof ConeUnresolvedNameError) {
            return;
        }
        if (Intrinsics.areEqual(source2.getKind(), KtFakeSourceElementKind.ArrayAccessNameReference.INSTANCE) && errorNamedReference.getDiagnostic() instanceof ConeUnresolvedNameError) {
            return;
        }
        if (qualifiedAccessOrAnnotationCall instanceof FirQualifiedAccess && (this.cannotBeResolved(((FirQualifiedAccess)qualifiedAccessOrAnnotationCall).getDispatchReceiver()) || this.cannotBeResolved(((FirQualifiedAccess)qualifiedAccessOrAnnotationCall).getExtensionReceiver()) || this.cannotBeResolved(((FirQualifiedAccess)qualifiedAccessOrAnnotationCall).getExplicitReceiver()))) {
            return;
        }
        FirStatement firStatement5 = qualifiedAccessOrAnnotationCall;
        this.reportFirDiagnostic(errorNamedReference.getDiagnostic(), source2, data2, firStatement5 != null ? firStatement5.getSource() : null);
    }

    private final boolean cannotBeResolved(FirExpression $this$cannotBeResolved) {
        FirExpression firExpression2 = $this$cannotBeResolved;
        FirTypeRef firTypeRef = firExpression2 != null ? firExpression2.getTypeRef() : null;
        FirErrorTypeRef firErrorTypeRef = firTypeRef instanceof FirErrorTypeRef ? (FirErrorTypeRef)firTypeRef : null;
        ConeDiagnostic diagnostic = firErrorTypeRef != null ? firErrorTypeRef.getDiagnostic() : null;
        return ((diagnostic instanceof ConeUnresolvedNameError ? true : diagnostic instanceof ConeInstanceAccessBeforeSuperCall) ? true : diagnostic instanceof ConeAmbiguousSuper) ? true : (diagnostic instanceof ConeSimpleDiagnostic ? ((ConeSimpleDiagnostic)diagnostic).getKind() == DiagnosticKind.NotASupertype || ((ConeSimpleDiagnostic)diagnostic).getKind() == DiagnosticKind.SuperNotAvailable || ((ConeSimpleDiagnostic)diagnostic).getKind() == DiagnosticKind.UnresolvedLabel : false);
    }

    @Override
    public void visitErrorExpression(@NotNull FirErrorExpression errorExpression, @NotNull CheckerContext data2) {
        Intrinsics.checkNotNullParameter(errorExpression, "errorExpression");
        Intrinsics.checkNotNullParameter(data2, "data");
        KtSourceElement ktSourceElement = errorExpression.getSource();
        if (ktSourceElement == null) {
            return;
        }
        KtSourceElement source2 = ktSourceElement;
        ErrorNodeDiagnosticCollectorComponent.reportFirDiagnostic$default(this, errorExpression.getDiagnostic(), source2, data2, null, 8, null);
    }

    @Override
    public void visitErrorFunction(@NotNull FirErrorFunction errorFunction, @NotNull CheckerContext data2) {
        Intrinsics.checkNotNullParameter(errorFunction, "errorFunction");
        Intrinsics.checkNotNullParameter(data2, "data");
        KtSourceElement ktSourceElement = errorFunction.getSource();
        if (ktSourceElement == null) {
            return;
        }
        KtSourceElement source2 = ktSourceElement;
        ErrorNodeDiagnosticCollectorComponent.reportFirDiagnostic$default(this, errorFunction.getDiagnostic(), source2, data2, null, 8, null);
    }

    @Override
    public void visitErrorResolvedQualifier(@NotNull FirErrorResolvedQualifier errorResolvedQualifier, @NotNull CheckerContext data2) {
        Intrinsics.checkNotNullParameter(errorResolvedQualifier, "errorResolvedQualifier");
        Intrinsics.checkNotNullParameter(data2, "data");
        KtSourceElement ktSourceElement = errorResolvedQualifier.getSource();
        if (ktSourceElement == null) {
            return;
        }
        KtSourceElement source2 = ktSourceElement;
        ErrorNodeDiagnosticCollectorComponent.reportFirDiagnostic$default(this, errorResolvedQualifier.getDiagnostic(), source2, data2, null, 8, null);
    }

    @Override
    public void visitErrorImport(@NotNull FirErrorImport errorImport, @NotNull CheckerContext data2) {
        Intrinsics.checkNotNullParameter(errorImport, "errorImport");
        Intrinsics.checkNotNullParameter(data2, "data");
        KtSourceElement ktSourceElement = errorImport.getSource();
        if (ktSourceElement == null) {
            return;
        }
        KtSourceElement source2 = ktSourceElement;
        ErrorNodeDiagnosticCollectorComponent.reportFirDiagnostic$default(this, errorImport.getDiagnostic(), source2, data2, null, 8, null);
    }

    private final void reportFirDiagnostic(ConeDiagnostic diagnostic, KtSourceElement source2, CheckerContext context, KtSourceElement qualifiedAccessSource) {
        if (Intrinsics.areEqual(source2.getElementType(), KtNodeTypes.DESTRUCTURING_DECLARATION_ENTRY)) {
            return;
        }
        if (Intrinsics.areEqual(source2.getKind(), KtFakeSourceElementKind.DelegatedPropertyAccessor.INSTANCE) && (diagnostic instanceof ConeUnresolvedNameError || diagnostic instanceof ConeAmbiguityError || diagnostic instanceof ConeInapplicableWrongReceiver || diagnostic instanceof ConeInapplicableCandidateError)) {
            return;
        }
        if (Intrinsics.areEqual(source2.getKind(), KtFakeSourceElementKind.ImplicitConstructor.INSTANCE) || Intrinsics.areEqual(source2.getKind(), KtFakeSourceElementKind.DesugaredForLoop.INSTANCE)) {
            return;
        }
        for (KtDiagnostic coneDiagnostic : ConeDiagnosticToFirDiagnosticKt.toFirDiagnostics(diagnostic, this.getSession(), source2, qualifiedAccessSource)) {
            this.getReporter().report(coneDiagnostic, context);
        }
    }

    static /* synthetic */ void reportFirDiagnostic$default(ErrorNodeDiagnosticCollectorComponent errorNodeDiagnosticCollectorComponent, ConeDiagnostic coneDiagnostic, KtSourceElement ktSourceElement, CheckerContext checkerContext, KtSourceElement ktSourceElement2, int n, Object object) {
        if ((n & 8) != 0) {
            ktSourceElement2 = null;
        }
        errorNodeDiagnosticCollectorComponent.reportFirDiagnostic(coneDiagnostic, ktSourceElement, checkerContext, ktSourceElement2);
    }
}

