/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.build.report.ICReporter;
import org.jetbrains.kotlin.build.report.ICReporterKt;
import org.jetbrains.kotlin.build.report.metrics.BuildAttribute;
import org.jetbrains.kotlin.incremental.ChangedFiles;
import org.jetbrains.kotlin.incremental.ChangesEither;
import org.jetbrains.kotlin.incremental.FileUtilsKt;
import org.jetbrains.kotlin.incremental.LookupSymbol;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\b\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u001a\u0010\u0014\u001a\u00020\u0015*\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0018H\u0002R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/incremental/ChangedJavaFilesProcessor;", "", "reporter", "Lorg/jetbrains/kotlin/build/report/ICReporter;", "psiFileFactory", "Lkotlin/Function1;", "Ljava/io/File;", "Lcom/intellij/psi/PsiFile;", "(Lorg/jetbrains/kotlin/build/report/ICReporter;Lkotlin/jvm/functions/Function1;)V", "allChangedSymbols", "", "Lorg/jetbrains/kotlin/incremental/LookupSymbol;", "getAllChangedSymbols", "()Ljava/util/Collection;", "allSymbols", "Ljava/util/HashSet;", "process", "Lorg/jetbrains/kotlin/incremental/ChangesEither;", "filesDiff", "Lorg/jetbrains/kotlin/incremental/ChangedFiles$Known;", "addLookupSymbols", "", "Lcom/intellij/psi/PsiClass;", "symbols", "", "incremental-compilation-impl"})
public final class ChangedJavaFilesProcessor {
    @NotNull
    private final ICReporter reporter;
    @NotNull
    private final Function1<File, PsiFile> psiFileFactory;
    @NotNull
    private final HashSet<LookupSymbol> allSymbols;

    public ChangedJavaFilesProcessor(@NotNull ICReporter reporter, @NotNull Function1<? super File, ? extends PsiFile> psiFileFactory2) {
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(psiFileFactory2, "psiFileFactory");
        this.reporter = reporter;
        this.psiFileFactory = psiFileFactory2;
        this.allSymbols = new HashSet();
    }

    @NotNull
    public final Collection<LookupSymbol> getAllChangedSymbols() {
        return this.allSymbols;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ChangesEither process(@NotNull ChangedFiles.Known filesDiff) {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        Intrinsics.checkNotNullParameter(filesDiff, "filesDiff");
        Iterable $this$filter$iv = filesDiff.getModified();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            File p0 = (File)element$iv$iv;
            boolean bl = false;
            if (!FileUtilsKt.isJavaFile(p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List modifiedJava = (List)destination$iv$iv;
        Iterable $this$filter$iv2 = filesDiff.getRemoved();
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv22 = new ArrayList();
        boolean $i$f$filterTo22 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            File p0 = (File)element$iv$iv;
            boolean bl = false;
            if (!FileUtilsKt.isJavaFile(p0)) continue;
            destination$iv$iv22.add(element$iv$iv);
        }
        List removedJava = (List)destination$iv$iv22;
        if (CollectionsKt.any(removedJava)) {
            ICReporterKt.info(this.reporter, new Function0<String>((List<? extends File>)removedJava){
                final /* synthetic */ List<File> $removedJava;
                {
                    this.$removedJava = $removedJava;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Some java files are removed: [" + CollectionsKt.joinToString$default(this.$removedJava, null, null, null, 0, null, null, 63, null) + ']';
                }
            });
            return new ChangesEither.Unknown(BuildAttribute.JAVA_CHANGE_UNTRACKED_FILE_IS_REMOVED);
        }
        HashSet symbols2 = new HashSet();
        for (File javaFile : modifiedJava) {
            boolean destination$iv$iv22 = StringsKt.equals(FilesKt.getExtension(javaFile), "java", true);
            if (_Assertions.ENABLED && !destination$iv$iv22) {
                String $i$f$filterTo22 = "Assertion failed";
                throw new AssertionError((Object)$i$f$filterTo22);
            }
            PsiFile psiFile = this.psiFileFactory.invoke(javaFile);
            if (!(psiFile instanceof PsiJavaFile)) {
                ICReporterKt.info(this.reporter, new Function0<String>(psiFile){
                    final /* synthetic */ PsiFile $psiFile;
                    {
                        this.$psiFile = $psiFile;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        PsiFile psiFile = this.$psiFile;
                        return "Expected PsiJavaFile, got " + (psiFile != null ? psiFile.getClass() : null);
                    }
                });
                return new ChangesEither.Unknown(BuildAttribute.JAVA_CHANGE_UNEXPECTED_PSI);
            }
            PsiClass[] psiClassArray = ((PsiJavaFile)psiFile).getClasses();
            Intrinsics.checkNotNullExpressionValue(psiClassArray, "psiFile.classes");
            Object[] $this$forEach$iv = psiClassArray;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PsiClass it = (PsiClass)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue(it, "it");
                this.addLookupSymbols(it, symbols2);
            }
        }
        this.allSymbols.addAll(symbols2);
        return new ChangesEither.Known(symbols2, null, 2, null);
    }

    private final void addLookupSymbols(PsiClass $this$addLookupSymbols, Set<LookupSymbol> symbols2) {
        PsiMethod it;
        String string2;
        String string3;
        String fqn;
        String string4 = $this$addLookupSymbols.getQualifiedName();
        if (string4 == null) {
            string4 = fqn = "";
        }
        if ((string3 = $this$addLookupSymbols.getName()) == null) {
            string3 = "";
        }
        if (Intrinsics.areEqual(fqn, $this$addLookupSymbols.getName())) {
            string2 = "";
        } else {
            StringBuilder stringBuilder2 = new StringBuilder().append('.');
            String string5 = $this$addLookupSymbols.getName();
            Intrinsics.checkNotNull(string5);
            string2 = StringsKt.removeSuffix(fqn, (CharSequence)stringBuilder2.append(string5).toString());
        }
        symbols2.add(new LookupSymbol(string3, string2));
        PsiMethod[] psiMethodArray = $this$addLookupSymbols.getMethods();
        Intrinsics.checkNotNullExpressionValue(psiMethodArray, "methods");
        Object[] $this$forEach$iv = psiMethodArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (PsiMethod)element$iv;
            boolean bl = false;
            String string6 = it.getName();
            Intrinsics.checkNotNullExpressionValue(string6, "it.name");
            symbols2.add(new LookupSymbol(string6, fqn));
        }
        PsiField[] psiFieldArray = $this$addLookupSymbols.getFields();
        Intrinsics.checkNotNullExpressionValue(psiFieldArray, "fields");
        $this$forEach$iv = psiFieldArray;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (PsiField)element$iv;
            boolean bl = false;
            String string7 = it.getName();
            if (string7 == null) {
                string7 = "";
            }
            symbols2.add(new LookupSymbol(string7, fqn));
        }
        PsiClass[] psiClassArray = $this$addLookupSymbols.getInnerClasses();
        Intrinsics.checkNotNullExpressionValue(psiClassArray, "innerClasses");
        $this$forEach$iv = psiClassArray;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (PsiClass)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(it, "it");
            this.addLookupSymbols((PsiClass)it, symbols2);
        }
    }
}

