/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.build.GeneratedFile;
import org.jetbrains.kotlin.build.report.ICReporter;
import org.jetbrains.kotlin.build.report.ICReporterKt;
import org.jetbrains.kotlin.incremental.snapshots.FileSnapshotMap;
import org.jetbrains.kotlin.incremental.storage.BasicMap;
import org.jetbrains.kotlin.incremental.storage.BasicMapsOwner;
import org.jetbrains.kotlin.incremental.storage.FileToPathConverter;
import org.jetbrains.kotlin.incremental.storage.SourceToOutputFilesMap;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u0012J\u0014\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0010J\u0014\u0010\u0017\u001a\u00020\u00142\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/incremental/InputsCache;", "Lorg/jetbrains/kotlin/incremental/storage/BasicMapsOwner;", "workingDir", "Ljava/io/File;", "reporter", "Lorg/jetbrains/kotlin/build/report/ICReporter;", "pathConverter", "Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;", "(Ljava/io/File;Lorg/jetbrains/kotlin/build/report/ICReporter;Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;)V", "sourceSnapshotMap", "Lorg/jetbrains/kotlin/incremental/snapshots/FileSnapshotMap;", "getSourceSnapshotMap$incremental_compilation_impl", "()Lorg/jetbrains/kotlin/incremental/snapshots/FileSnapshotMap;", "sourceToOutputMap", "Lorg/jetbrains/kotlin/incremental/storage/SourceToOutputFilesMap;", "getOutputForSourceFiles", "", "sources", "", "registerOutputForSourceFiles", "", "generatedFiles", "Lorg/jetbrains/kotlin/build/GeneratedFile;", "removeOutputForSourceFiles", "Companion", "incremental-compilation-impl"})
public final class InputsCache
extends BasicMapsOwner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ICReporter reporter;
    @NotNull
    private final FileSnapshotMap sourceSnapshotMap;
    @NotNull
    private final SourceToOutputFilesMap sourceToOutputMap;

    public InputsCache(@NotNull File workingDir, @NotNull ICReporter reporter, @NotNull FileToPathConverter pathConverter) {
        Intrinsics.checkNotNullParameter(workingDir, "workingDir");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(pathConverter, "pathConverter");
        super(workingDir);
        this.reporter = reporter;
        this.sourceSnapshotMap = (FileSnapshotMap)this.registerMap((BasicMap)new FileSnapshotMap(this.getStorageFile("source-snapshot"), pathConverter));
        this.sourceToOutputMap = (SourceToOutputFilesMap)this.registerMap((BasicMap)new SourceToOutputFilesMap(this.getStorageFile("source-to-output"), pathConverter));
    }

    @NotNull
    public final FileSnapshotMap getSourceSnapshotMap$incremental_compilation_impl() {
        return this.sourceSnapshotMap;
    }

    public final void removeOutputForSourceFiles(@NotNull Iterable<? extends File> sources2) {
        Intrinsics.checkNotNullParameter(sources2, "sources");
        for (File file2 : sources2) {
            Iterable $this$forEach$iv = this.sourceToOutputMap.remove(file2);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File it = (File)element$iv;
                boolean bl = false;
                ICReporterKt.debug(this.reporter, new Function0<String>(it, file2){
                    final /* synthetic */ File $it;
                    final /* synthetic */ File $sourceFile;
                    {
                        this.$it = $it;
                        this.$sourceFile = $sourceFile;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Deleting " + this.$it + " on clearing cache for " + this.$sourceFile;
                    }
                });
                it.delete();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<File> getOutputForSourceFiles(@NotNull Iterable<? extends File> sources2) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(sources2, "sources");
        Iterable<? extends File> $this$flatMap$iv = sources2;
        boolean $i$f$flatMap = false;
        Iterable<? extends File> iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            File it = (File)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.sourceToOutputMap.get(it);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final void registerOutputForSourceFiles(@NotNull List<? extends GeneratedFile> generatedFiles) {
        Intrinsics.checkNotNullParameter(generatedFiles, "generatedFiles");
        MultiMap sourceToOutput = new MultiMap();
        for (GeneratedFile entry : generatedFiles) {
            for (File source2 : entry.getSourceFiles()) {
                sourceToOutput.putValue((Object)source2, (Object)entry.getOutputFile());
            }
        }
        for (Map.Entry entry : sourceToOutput.entrySet()) {
            Intrinsics.checkNotNullExpressionValue(entry, "sourceToOutput.entrySet()");
            File source3 = (File)entry.getKey();
            Collection outputs2 = (Collection)entry.getValue();
            Intrinsics.checkNotNullExpressionValue(source3, "source");
            Intrinsics.checkNotNullExpressionValue(outputs2, "outputs");
            this.sourceToOutputMap.set(source3, outputs2);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/incremental/InputsCache$Companion;", "", "()V", "SOURCE_SNAPSHOTS", "", "SOURCE_TO_OUTPUT_FILES", "incremental-compilation-impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

