/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import com.google.common.collect.Maps;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.PlatformToKotlinClassMapper;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.IntersectionTypeConstructor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeIntersector;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeReconstructionResult;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUnifier;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.checker.TypeCheckingProcedure;
import org.jetbrains.kotlin.types.expressions.DataFlowAnalyzer;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u001e\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J&\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J \u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J \u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\u0018\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006H\u0002J\u0010\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0006H\u0002J$\u0010 \u001a\u00020\u00042\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00060\"2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u0004J \u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010'\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0006H\u0002J\u0018\u0010(\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006H\u0002J\u001e\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*2\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010#\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010,\u001a\u00020\u0006H\u0002\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/types/CastDiagnosticsUtil;", "", "()V", "allParametersReified", "", "subtype", "Lorg/jetbrains/kotlin/types/KotlinType;", "castIsUseless", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpressionWithTypeRHS;", "context", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "targetType", "actualType", "checkExactTypeForUselessCast", "findStaticallyKnownSubtype", "Lorg/jetbrains/kotlin/types/TypeReconstructionResult;", "supertype", "subtypeConstructor", "Lorg/jetbrains/kotlin/types/TypeConstructor;", "isCastErased", "typeChecker", "Lorg/jetbrains/kotlin/types/checker/KotlinTypeChecker;", "isCastPossible", "lhsType", "rhsType", "platformToKotlinClassMapper", "Lorg/jetbrains/kotlin/builtins/PlatformToKotlinClassMapper;", "isExactTypeCast", "candidateType", "isFinal", "type", "isRefinementUseless", "possibleTypes", "", "shouldCheckForExactType", "isRelated", "a", "b", "isTrait", "isUpcast", "mapToPlatformIndependentClasses", "", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "expectedType", "frontend"})
public final class CastDiagnosticsUtil {
    @NotNull
    public static final CastDiagnosticsUtil INSTANCE = new CastDiagnosticsUtil();

    private CastDiagnosticsUtil() {
    }

    @JvmStatic
    public static final boolean isCastPossible(@NotNull KotlinType lhsType, @NotNull KotlinType rhsType, @NotNull PlatformToKotlinClassMapper platformToKotlinClassMapper) {
        Intrinsics.checkNotNullParameter(lhsType, "lhsType");
        Intrinsics.checkNotNullParameter(rhsType, "rhsType");
        Intrinsics.checkNotNullParameter(platformToKotlinClassMapper, "platformToKotlinClassMapper");
        TypeConstructor typeConstructor2 = lhsType.getConstructor();
        if (typeConstructor2 instanceof IntersectionTypeConstructor) {
            boolean bl;
            block13: {
                Iterable $this$any$iv = ((IntersectionTypeConstructor)typeConstructor2).getSupertypes();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        KotlinType it = (KotlinType)element$iv;
                        boolean bl2 = false;
                        if (!CastDiagnosticsUtil.isCastPossible(it, rhsType, platformToKotlinClassMapper)) continue;
                        bl = true;
                        break block13;
                    }
                    bl = false;
                }
            }
            return bl;
        }
        boolean rhsNullable = TypeUtils.isNullableType(rhsType);
        boolean lhsNullable = TypeUtils.isNullableType(lhsType);
        if (KotlinBuiltIns.isNothing(lhsType)) {
            return true;
        }
        if (KotlinBuiltIns.isNullableNothing(lhsType) && !rhsNullable) {
            return false;
        }
        if (KotlinBuiltIns.isNothing(rhsType)) {
            return false;
        }
        if (KotlinBuiltIns.isNullableNothing(rhsType)) {
            return lhsNullable;
        }
        if (lhsNullable && rhsNullable) {
            return true;
        }
        if (KotlinTypeKt.isError(lhsType)) {
            return true;
        }
        if (INSTANCE.isRelated(lhsType, rhsType, platformToKotlinClassMapper)) {
            return true;
        }
        if (TypeUtils.isTypeParameter(lhsType) || TypeUtils.isTypeParameter(rhsType)) {
            return true;
        }
        if (INSTANCE.isFinal(lhsType) || INSTANCE.isFinal(rhsType)) {
            return false;
        }
        return INSTANCE.isTrait(lhsType) || INSTANCE.isTrait(rhsType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isRelated(KotlinType a, KotlinType b, PlatformToKotlinClassMapper platformToKotlinClassMapper) {
        ClassDescriptor it;
        boolean bl;
        List<ClassDescriptor> aClasses = this.mapToPlatformIndependentClasses(a, platformToKotlinClassMapper);
        List<ClassDescriptor> bClasses = this.mapToPlatformIndependentClasses(b, platformToKotlinClassMapper);
        Iterable $this$any$iv = aClasses;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl = false;
        } else {
            for (Object element$iv : $this$any$iv) {
                it = (ClassDescriptor)element$iv;
                boolean bl2 = false;
                if (!DescriptorUtils.isSubtypeOfClass(b, it)) continue;
                return true;
            }
            bl = false;
        }
        if (bl) return true;
        $this$any$iv = bClasses;
        $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            Object element$iv;
            if (!iterator2.hasNext()) return false;
            element$iv = iterator2.next();
            it = (ClassDescriptor)element$iv;
            boolean bl3 = false;
        } while (!DescriptorUtils.isSubtypeOfClass(a, it));
        return true;
    }

    private final List<ClassDescriptor> mapToPlatformIndependentClasses(KotlinType type2, PlatformToKotlinClassMapper platformToKotlinClassMapper) {
        ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
        ClassDescriptor classDescriptor2 = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
        if (classDescriptor2 == null) {
            return CollectionsKt.emptyList();
        }
        ClassDescriptor descriptor2 = classDescriptor2;
        Collection<ClassDescriptor> collection = platformToKotlinClassMapper.mapPlatformClass(descriptor2);
        Intrinsics.checkNotNullExpressionValue(collection, "platformToKotlinClassMap\u2026PlatformClass(descriptor)");
        return CollectionsKt.plus(collection, descriptor2);
    }

    private final boolean isFinal(KotlinType type2) {
        return !TypeUtils.canHaveSubtypes(KotlinTypeChecker.DEFAULT, type2);
    }

    private final boolean isTrait(KotlinType type2) {
        ClassifierDescriptor it = type2.getConstructor().getDeclarationDescriptor();
        boolean bl = false;
        return it instanceof ClassDescriptor && ((ClassDescriptor)it).getKind() == ClassKind.INTERFACE;
    }

    @JvmStatic
    public static final boolean isCastErased(@NotNull KotlinType supertype2, @NotNull KotlinType subtype, @NotNull KotlinTypeChecker typeChecker) {
        Intrinsics.checkNotNullParameter(supertype2, "supertype");
        Intrinsics.checkNotNullParameter(subtype, "subtype");
        Intrinsics.checkNotNullParameter(typeChecker, "typeChecker");
        boolean isNonReifiedTypeParameter = TypeUtils.isNonReifiedTypeParameter(subtype);
        boolean isUpcast = typeChecker.isSubtypeOf(supertype2, subtype);
        if (isNonReifiedTypeParameter && !isUpcast) {
            boolean nullableToDefinitelyNotNull;
            boolean bl = nullableToDefinitelyNotNull = !TypeUtils.isNullableType(subtype) && Intrinsics.areEqual(TypeUtilsKt.makeNotNullable(supertype2), subtype);
            if (!nullableToDefinitelyNotNull) {
                return true;
            }
        }
        if (supertype2.isMarkedNullable() || subtype.isMarkedNullable()) {
            KotlinType kotlinType = TypeUtils.makeNotNullable(supertype2);
            Intrinsics.checkNotNullExpressionValue(kotlinType, "makeNotNullable(supertype)");
            KotlinType kotlinType2 = TypeUtils.makeNotNullable(subtype);
            Intrinsics.checkNotNullExpressionValue(kotlinType2, "makeNotNullable(subtype)");
            return CastDiagnosticsUtil.isCastErased(kotlinType, kotlinType2, typeChecker);
        }
        if (isUpcast) {
            return false;
        }
        if (isNonReifiedTypeParameter) {
            return true;
        }
        if (INSTANCE.allParametersReified(subtype)) {
            return false;
        }
        KotlinType kotlinType = CastDiagnosticsUtil.findStaticallyKnownSubtype(supertype2, subtype.getConstructor()).getResultingType();
        if (kotlinType == null) {
            return true;
        }
        KotlinType staticallyKnownSubtype = kotlinType;
        return !typeChecker.isSubtypeOf(staticallyKnownSubtype, subtype);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final TypeReconstructionResult findStaticallyKnownSubtype(@NotNull KotlinType supertype2, @NotNull TypeConstructor subtypeConstructor) {
        Map map;
        void $this$mapTo$iv$iv;
        boolean bl;
        Intrinsics.checkNotNullParameter(supertype2, "supertype");
        Intrinsics.checkNotNullParameter(subtypeConstructor, "subtypeConstructor");
        boolean bl2 = bl = !supertype2.isMarkedNullable();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-CastDiagnosticsUtil$findStaticallyKnownSubtype$22 = false;
            String $i$a$-assert-CastDiagnosticsUtil$findStaticallyKnownSubtype$22 = "This method only makes sense for non-nullable types";
            throw new AssertionError((Object)$i$a$-assert-CastDiagnosticsUtil$findStaticallyKnownSubtype$22);
        }
        ClassifierDescriptor classifierDescriptor = subtypeConstructor.getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            throw new IllegalStateException(("Can't create default type for " + subtypeConstructor).toString());
        }
        ClassifierDescriptor descriptor2 = classifierDescriptor;
        SimpleType simpleType2 = descriptor2.getDefaultType();
        Intrinsics.checkNotNullExpressionValue(simpleType2, "descriptor.defaultType");
        SimpleType subtypeWithVariables = simpleType2;
        KotlinType supertypeWithVariables = TypeCheckingProcedure.findCorrespondingSupertype(subtypeWithVariables, supertype2);
        List<TypeParameterDescriptor> list2 = subtypeWithVariables.getConstructor().getParameters();
        Intrinsics.checkNotNullExpressionValue(list2, "subtypeWithVariables.constructor.parameters");
        List<TypeParameterDescriptor> variables = list2;
        Iterable $this$map$iv = variables;
        boolean $i$f$map2 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(p0.getTypeConstructor());
        }
        Set variableConstructors = CollectionsKt.toSet((List)destination$iv$iv);
        if (supertypeWithVariables != null) {
            TypeUnifier.UnificationResult unificationResult = TypeUnifier.unify(new TypeProjectionImpl(supertype2), new TypeProjectionImpl(supertypeWithVariables), variableConstructors::contains);
            Intrinsics.checkNotNullExpressionValue(unificationResult, "unify(\n                T\u2026s::contains\n            )");
            TypeUnifier.UnificationResult solution = unificationResult;
            HashMap<TypeConstructor, TypeProjection> $i$f$map2 = Maps.newHashMap(solution.getSubstitution());
            Intrinsics.checkNotNullExpressionValue($i$f$map2, "{\n            // Now, le\u2026n.substitution)\n        }");
            map = $i$f$map2;
        } else {
            HashMap hashMap = Maps.newHashMapWithExpectedSize(variables.size());
            Intrinsics.checkNotNullExpressionValue(hashMap, "{\n            // If ther\u2026variables.size)\n        }");
            map = hashMap;
        }
        Map substitution = map;
        boolean allArgumentsInferred = true;
        for (TypeParameterDescriptor variable2 : variables) {
            TypeProjection value2 = (TypeProjection)substitution.get(variable2.getTypeConstructor());
            if (value2 != null) continue;
            TypeConstructor typeConstructor2 = variable2.getTypeConstructor();
            Intrinsics.checkNotNullExpressionValue(typeConstructor2, "variable.typeConstructor");
            TypeProjection typeProjection = TypeUtils.makeStarProjection(variable2);
            Intrinsics.checkNotNullExpressionValue(typeProjection, "makeStarProjection(variable)");
            substitution.put(typeConstructor2, typeProjection);
            allArgumentsInferred = false;
        }
        KotlinType substituted = TypeSubstitutor.create(substitution).substitute(subtypeWithVariables, Variance.INVARIANT);
        return new TypeReconstructionResult(substituted, allArgumentsInferred);
    }

    private final boolean allParametersReified(KotlinType subtype) {
        boolean bl;
        block3: {
            List<TypeParameterDescriptor> list2 = subtype.getConstructor().getParameters();
            Intrinsics.checkNotNullExpressionValue(list2, "subtype.constructor.parameters");
            Iterable $this$all$iv = list2;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    TypeParameterDescriptor it = (TypeParameterDescriptor)element$iv;
                    boolean bl2 = false;
                    if (it.isReified()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public final boolean castIsUseless(@NotNull KtBinaryExpressionWithTypeRHS expression2, @NotNull ExpressionTypingContext context, @NotNull KotlinType targetType, @NotNull KotlinType actualType) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(targetType, "targetType");
        Intrinsics.checkNotNullParameter(actualType, "actualType");
        KotlinType kotlinType = KtPsiUtil.isSafeCast(expression2) ? TypeUtils.makeNullable(targetType) : targetType;
        Intrinsics.checkNotNullExpressionValue(kotlinType, "if (KtPsiUtil.isSafeCast\u2026rgetType) else targetType");
        KotlinType refinedTargetType = kotlinType;
        Collection<KotlinType> collection = DataFlowAnalyzer.getAllPossibleTypes(expression2.getLeft(), actualType, context);
        Intrinsics.checkNotNullExpressionValue(collection, "getAllPossibleTypes(expr\u2026eft, actualType, context)");
        Collection<KotlinType> possibleTypes = collection;
        KotlinType kotlinType2 = context.expectedType;
        Intrinsics.checkNotNullExpressionValue(kotlinType2, "context.expectedType");
        return this.isRefinementUseless(possibleTypes, refinedTargetType, this.shouldCheckForExactType(expression2, kotlinType2));
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isRefinementUseless(@NotNull Collection<? extends KotlinType> possibleTypes, @NotNull KotlinType targetType, boolean shouldCheckForExactType) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(possibleTypes, "possibleTypes");
        Intrinsics.checkNotNullParameter(targetType, "targetType");
        Iterable $this$map$iv = possibleTypes;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KotlinType kotlinType = (KotlinType)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(FlexibleTypesKt.upperIfFlexible((KotlinType)it));
        }
        KotlinType kotlinType = TypeIntersector.intersectTypes((List)destination$iv$iv);
        if (kotlinType == null) {
            return false;
        }
        KotlinType intersectedType = kotlinType;
        return shouldCheckForExactType ? this.isExactTypeCast(intersectedType, targetType) : this.isUpcast(intersectedType, targetType);
    }

    private final boolean shouldCheckForExactType(KtBinaryExpressionWithTypeRHS expression2, KotlinType expectedType) {
        if (TypeUtils.noExpectedType(expectedType)) {
            return this.checkExactTypeForUselessCast(expression2);
        }
        return TypeUtils.isDontCarePlaceholder(expectedType);
    }

    private final boolean isExactTypeCast(KotlinType candidateType, KotlinType targetType) {
        return Intrinsics.areEqual(candidateType, targetType) && FunctionTypesKt.isExtensionFunctionType(candidateType) == FunctionTypesKt.isExtensionFunctionType(targetType);
    }

    private final boolean isUpcast(KotlinType candidateType, KotlinType targetType) {
        if (!KotlinTypeChecker.DEFAULT.isSubtypeOf(candidateType, targetType)) {
            return false;
        }
        if (FunctionTypesKt.isFunctionType(candidateType) && FunctionTypesKt.isFunctionType(targetType)) {
            return FunctionTypesKt.isExtensionFunctionType(candidateType) == FunctionTypesKt.isExtensionFunctionType(targetType);
        }
        return true;
    }

    private final boolean checkExactTypeForUselessCast(KtBinaryExpressionWithTypeRHS expression2) {
        boolean bl;
        PsiElement parent2 = expression2.getParent();
        while (parent2 instanceof KtParenthesizedExpression || parent2 instanceof KtLabeledExpression || parent2 instanceof KtAnnotatedExpression) {
            parent2 = parent2.getParent();
        }
        PsiElement psiElement = parent2;
        if (psiElement instanceof KtValueArgument) {
            bl = true;
        } else if (psiElement instanceof KtQualifiedExpression) {
            KtExpression receiver = ((KtQualifiedExpression)parent2).getReceiverExpression();
            bl = PsiTreeUtil.isAncestor((PsiElement)((PsiElement)receiver), (PsiElement)((PsiElement)expression2), (boolean)false);
        } else {
            bl = (psiElement instanceof KtBinaryExpression ? true : psiElement instanceof KtUnaryExpression) ? true : (((psiElement instanceof KtProperty ? true : psiElement instanceof KtPropertyAccessor) ? true : psiElement instanceof KtNamedFunction) ? true : psiElement instanceof KtFunctionLiteral);
        }
        return bl;
    }
}

