/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dokka.allModulesPage.templates;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dokka.DokkaConfiguration;
import org.jetbrains.dokka.allModulesPage.templates.PackageListProcessingStrategy;
import org.jetbrains.dokka.base.renderers.PackageListService;
import org.jetbrains.dokka.base.resolvers.shared.PackageList;
import org.jetbrains.dokka.base.resolvers.shared.RecognizedLinkFormat;
import org.jetbrains.dokka.plugability.DokkaContext;
import org.jetbrains.dokka.templates.TemplateProcessingStrategy;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\rH\u0002J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\rH\u0016J\"\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/dokka/allModulesPage/templates/PackageListProcessingStrategy;", "Lorg/jetbrains/dokka/templates/TemplateProcessingStrategy;", "context", "Lorg/jetbrains/dokka/plugability/DokkaContext;", "(Lorg/jetbrains/dokka/plugability/DokkaContext;)V", "getContext", "()Lorg/jetbrains/dokka/plugability/DokkaContext;", "fragments", "", "Lorg/jetbrains/dokka/base/resolvers/shared/PackageList;", "canProcess", "", "file", "Ljava/io/File;", "moduleContext", "Lorg/jetbrains/dokka/DokkaConfiguration$DokkaModuleDescription;", "fallbackToCopy", "", "input", "output", "finish", "process", "templating"})
@SourceDebugExtension(value={"SMAP\nPackageListProcessingStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PackageListProcessingStrategy.kt\norg/jetbrains/dokka/allModulesPage/templates/PackageListProcessingStrategy\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,52:1\n1#2:53\n1179#3,2:54\n1253#3,4:56\n1726#3,3:60\n1549#3:63\n1620#3,3:64\n1789#3,3:67\n1549#3:70\n1620#3,3:71\n1789#3,3:74\n*E\n*S KotlinDebug\n*F\n+ 1 PackageListProcessingStrategy.kt\norg/jetbrains/dokka/allModulesPage/templates/PackageListProcessingStrategy\n*L\n25#1,2:54\n25#1,4:56\n35#1,3:60\n39#1:63\n39#1,3:64\n39#1,3:67\n40#1:70\n40#1,3:71\n40#1,3:74\n*E\n"})
public final class PackageListProcessingStrategy
implements TemplateProcessingStrategy {
    private final Set<PackageList> fragments;
    @NotNull
    private final DokkaContext context;

    private final boolean canProcess(File file, DokkaConfiguration.DokkaModuleDescription moduleContext) {
        return StringsKt.isBlank((CharSequence)FilesKt.getExtension((File)file)) && Intrinsics.areEqual((Object)FilesKt.getNameWithoutExtension((File)file), (Object)"package-list") && moduleContext != null;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public boolean process(@NotNull File input, @NotNull File output, @Nullable DokkaConfiguration.DokkaModuleDescription moduleContext) {
        PackageList packageList;
        String moduleFilename;
        String string;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        boolean canProcess = this.canProcess(input, moduleContext);
        if (!canProcess) return canProcess;
        URL uRL = input.toURI().toURL();
        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"input.toURI().toURL()");
        PackageList packageList2 = PackageList.Companion.load(uRL, 8, true);
        Object object = moduleContext;
        if (object != null && (object = object.getName()) != null) {
            Object object2;
            Object object3 = object2 = object;
            boolean bl = false;
            string = (String)object3 + '/';
        } else {
            string = moduleFilename = null;
        }
        if ((packageList = packageList2) != null) {
            void $this$associateTo$iv$iv;
            DokkaConfiguration.DokkaModuleDescription dokkaModuleDescription = moduleContext;
            String string2 = dokkaModuleDescription != null ? dokkaModuleDescription.getName() : null;
            String string3 = string2;
            if (string3 == null) {
                string3 = "";
            }
            Iterable iterable = packageList2.getLocations().entrySet();
            Map map = MapsKt.mapOf((Pair)TuplesKt.to((Object)string3, (Object)packageList2.getModules().getOrDefault("", SetsKt.emptySet())));
            RecognizedLinkFormat recognizedLinkFormat = null;
            PackageList packageList3 = packageList;
            boolean bl = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10)), (int)16);
            Iterable iterable2 = iterable;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map2 = destination$iv$iv;
                Map.Entry it = (Map.Entry)element$iv$iv;
                boolean bl2 = false;
                Pair pair = TuplesKt.to(it.getKey(), (Object)(moduleFilename + (String)it.getValue()));
                map2.put(pair.getFirst(), pair.getSecond());
            }
            Map map3 = destination$iv$iv;
            packageList = PackageList.copy$default((PackageList)packageList3, recognizedLinkFormat, (Map)map, (Map)map3, null, (int)9, null);
            if (packageList != null) {
                PackageList packageList4;
                PackageList packageList5 = packageList4 = packageList;
                boolean bl3 = false;
                this.fragments.add(packageList5);
                return canProcess;
            }
        }
        this.fallbackToCopy(input, output);
        return canProcess;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void finish(@NotNull File output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Collection collection = this.fragments;
        if (!collection.isEmpty()) {
            void $this$fold$iv;
            void $this$mapTo$iv$iv;
            void $this$fold$iv2;
            Map map;
            Collection collection2;
            void $this$mapTo$iv$iv2;
            Object element$iv2;
            boolean bl;
            RecognizedLinkFormat linkFormat;
            block9: {
                linkFormat = ((PackageList)CollectionsKt.first((Iterable)this.fragments)).getLinkFormat();
                Iterable $this$all$iv = this.fragments;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv2 : $this$all$iv) {
                        PackageList it = (PackageList)element$iv2;
                        boolean bl2 = false;
                        if (it.getLinkFormat() == linkFormat) continue;
                        bl = false;
                        break block9;
                    }
                    bl = true;
                }
            }
            if (!bl) {
                this.context.getLogger().error("Link format is inconsistent between modules: " + CollectionsKt.joinToString$default((Iterable)this.fragments, null, null, null, (int)0, null, (Function1)finish.2.INSTANCE, (int)31, null));
            }
            Iterable $this$map$iv = this.fragments;
            boolean $i$f$map = false;
            element$iv2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                PackageList packageList = (PackageList)item$iv$iv;
                collection2 = destination$iv$iv;
                boolean bl3 = false;
                map = it.getLocations();
                collection2.add(map);
            }
            $this$map$iv = (List)destination$iv$iv;
            Map initial$iv = MapsKt.emptyMap();
            boolean $i$f$fold = false;
            Object accumulator$iv = initial$iv;
            for (Object element$iv3 : $this$fold$iv2) {
                Iterator el;
                Object item$iv$iv;
                item$iv$iv = (Map)element$iv3;
                Map acc = accumulator$iv;
                boolean bl4 = false;
                accumulator$iv = MapsKt.plus((Map)acc, (Map)((Object)el));
            }
            Map locations = accumulator$iv;
            Iterable $this$map$iv2 = this.fragments;
            boolean $i$f$map2 = false;
            accumulator$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PackageList bl4 = (PackageList)item$iv$iv;
                collection2 = destination$iv$iv2;
                boolean bl5 = false;
                map = it.getModules();
                collection2.add(map);
            }
            $this$map$iv2 = (List)destination$iv$iv2;
            Map initial$iv2 = MapsKt.emptyMap();
            boolean $i$f$fold2 = false;
            Map accumulator$iv2 = initial$iv2;
            for (Object element$iv4 : $this$fold$iv) {
                void el;
                Object item$iv$iv;
                item$iv$iv = (Map)element$iv4;
                Map acc = accumulator$iv2;
                boolean bl6 = false;
                accumulator$iv2 = MapsKt.plus((Map)acc, (Map)el);
            }
            Map modules = accumulator$iv2;
            String mergedPackageList = PackageListService.Companion.renderPackageList(locations, modules, linkFormat.getFormatName(), linkFormat.getLinkExtension());
            output.mkdirs();
            FilesKt.writeText$default((File)FilesKt.resolve((File)output, (String)"package-list"), (String)mergedPackageList, null, (int)2, null);
        }
    }

    private final void fallbackToCopy(File input, File output) {
        this.context.getLogger().warn("Falling back to just copying " + input.getName() + " file even though it should have been processed");
        FilesKt.copyTo$default((File)input, (File)output, (boolean)false, (int)0, (int)6, null);
    }

    @NotNull
    public final DokkaContext getContext() {
        return this.context;
    }

    public PackageListProcessingStrategy(@NotNull DokkaContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.fragments = new LinkedHashSet();
    }
}

