/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.java-time;

import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.ColumnType;
import org.jetbrains.exposed.sql.IDateColumnType;
import org.jetbrains.exposed.sql.javatime.JavaDateColumnTypeKt;
import org.jetbrains.exposed.sql.vendors.DatabaseDialect;
import org.jetbrains.exposed.sql.vendors.DefaultKt;
import org.jetbrains.exposed.sql.vendors.SQLiteDialect;

@Deprecated(message="Use same class from javatime package", replaceWith=@ReplaceWith(expression="JavaLocalDateColumnType", imports={"org.jetbrains.exposed.sql.javatime"}))
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00142\u00020\u00012\u00020\u0002:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u000eH\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/exposed/sql/java-time/JavaLocalDateColumnType;", "Lorg/jetbrains/exposed/sql/ColumnType;", "Lorg/jetbrains/exposed/sql/IDateColumnType;", "()V", "hasTimePart", "", "getHasTimePart", "()Z", "longToLocalDate", "Ljava/time/LocalDate;", "kotlin.jvm.PlatformType", "instant", "", "nonNullValueToString", "", "value", "", "notNullValueToDB", "sqlType", "valueFromDB", "Companion", "exposed-java-time"})
public final class JavaLocalDateColumnType
extends ColumnType
implements IDateColumnType {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean hasTimePart;
    @NotNull
    private static final JavaLocalDateColumnType INSTANCE = new JavaLocalDateColumnType();

    public JavaLocalDateColumnType() {
        super(false, 1, null);
    }

    public boolean getHasTimePart() {
        return this.hasTimePart;
    }

    @NotNull
    public String sqlType() {
        return "DATE";
    }

    @NotNull
    public String nonNullValueToString(@NotNull Object value) {
        Instant instant;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object object = value;
        if (object instanceof String) {
            return (String)value;
        }
        if (object instanceof LocalDate) {
            instant = Instant.from(((LocalDate)value).atStartOfDay(ZoneId.systemDefault()));
        } else if (object instanceof Date) {
            instant = Instant.ofEpochMilli(((Date)value).getTime());
        } else if (object instanceof Timestamp) {
            instant = Instant.ofEpochSecond(((Timestamp)value).getTime() / (long)1000, ((Timestamp)value).getNanos());
        } else {
            String string = "Unexpected value: " + value + " of " + Reflection.getOrCreateKotlinClass(value.getClass()).getQualifiedName();
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Instant instant2 = instant;
        return '\'' + JavaDateColumnTypeKt.getDEFAULT_DATE_STRING_FORMATTER().format(instant2) + '\'';
    }

    @NotNull
    public Object valueFromDB(@NotNull Object value) {
        DatabaseDialect databaseDialect;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object object = value;
        Object object2 = object instanceof LocalDate ? value : (object instanceof Date ? this.longToLocalDate(((Date)value).getTime()) : (object instanceof Timestamp ? this.longToLocalDate(((Timestamp)value).getTime()) : (object instanceof Integer ? this.longToLocalDate(((Number)value).intValue()) : (object instanceof Long ? this.longToLocalDate(((Number)value).longValue()) : (object instanceof String ? ((databaseDialect = DefaultKt.getCurrentDialect()) instanceof SQLiteDialect ? LocalDate.parse((CharSequence)value) : value) : LocalDate.parse(value.toString()))))));
        Object object3 = object2;
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"when (value) {\n        i\u2026e(value.toString())\n    }");
        return object3;
    }

    @NotNull
    public Object notNullValueToDB(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return value instanceof LocalDate ? new Date(JavaDateColumnTypeKt.getMillis((LocalDate)value)) : value;
    }

    private final LocalDate longToLocalDate(long instant) {
        return Instant.ofEpochMilli(instant).atZone(ZoneId.systemDefault()).toLocalDate();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/exposed/sql/java-time/JavaLocalDateColumnType$Companion;", "", "()V", "INSTANCE", "Lorg/jetbrains/exposed/sql/java-time/JavaLocalDateColumnType;", "getINSTANCE$exposed_java_time", "()Lorg/jetbrains/exposed/sql/java-time/JavaLocalDateColumnType;", "exposed-java-time"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JavaLocalDateColumnType getINSTANCE$exposed_java_time() {
            return INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

